/**
 * @brief           DSP Manager
 * @author          AXELL CORPORATION
 * @description     DSP Manager Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history			2019_03_08  [SDK2.2] DOTCLK_LATCHDOTCLK_CHANGE̎gp𐄏 (#1950)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef __DSPMGR_H__
#define __DSPMGR_H__
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

#include "AG903_common.h"

/* 萔` */

/**
 * DSPʐ
 */
#define	AG903_DSP_CH_NUM					(2)
/**
 * F␳e[u
 */
#define	AG903_DSP_LUT_NUM					(64)
/**
 * F̈搔
 */
#define AG903_DSP_DITHAREA_NUM				(4)
/**
 * EBhEő吔
 */
#define	AG903_DSP_WND_MAX					(16)
/**
 * Agr[gő吔
 */
#define	AG903_DSP_ATTR_MAX					(256)


/**
 * \H<p>
 * ֘A\́FAG903_DSPMgrStat
 */
enum AG903_DSP_CTRL_ENUM{
	AG903_DSP_CTRL_OFF						= 0	,	/** ~ */
	AG903_DSP_CTRL_ON							,	/** 쒆 */
};
/**
 * ɐ<p>
 * ֘A\́FAG903_DSPMgrSyncParam, AG903_DSPMgrExSyncParam, 
 *                 AG903_DSPMgrCMOSParam, AG903_DSPMgrLVDSParam
 */
enum AG903_DSP_POLARITY_ENUM{
	AG903_DSP_POLARITY_NEGA					= 0	,	/** _ */
	AG903_DSP_POLARITY_POSI						,	/** _ */
};
/**
 * RGBDE[qo<p>
 * ֘A\́FAG903_DSPMgrSyncParam
 */
enum AG903_DSP_RGBDE_SIGNAL_ENUM{
	AG903_DSP_RGBDE_SIGNAL_DATA				= 0	,	/** f[^LM */
	AG903_DSP_RGBDE_SIGNAL_CSYNC				,	/** CSYNCM */
};
/**
 * EBhEAgr[gApbgǍ݃^C~O<p>
 * ֘A\́FAG903_DSPMgrWindowParam
 */
enum AG903_DSP_ATTR_TIMING_ENUM{
	AG903_DSP_ATTR_END_OF_VSYNC				= 0	,	/** pXI */
	AG903_DSP_ATTR_START_OF_VSYNC				,	/** pXJn */
	AG903_DSP_ATTR_START_OF_VBLANK				,	/** uNJn */
};
/**
 * t[obt@tH[}bg<p>
 * ֘A\́FAG903_DSPMgrWinAttribute
 */
enum AG903_DSP_FFMT_ENUM{
	AG903_DSP_FFMT_A8R8G8B8					= 0	,	/** A8R8G8B8 */
	AG903_DSP_FFMT_X8R8G8B8						,	/** X8R8G8B8 */
	AG903_DSP_FFMT_R8G8B8						,	/** R8G8B8 */
	AG903_DSP_FFMT_R5G6B5						,	/** R5G6B5 */
	AG903_DSP_FFMT_A1R5G5B5						,	/** A1R5G5B5 */
	AG903_DSP_FFMT_X1R5G5B5						,	/** X1R5G5B5 */
	AG903_DSP_FFMT_A4R4G4B4						,	/** A4R4G4B4 */
	AG903_DSP_FFMT_X4R4G4B4						,	/** X4R4G4B4 */
	AG903_DSP_FFMT_YUV422_BT601_LIMIT			,	/** YUV422(BT.601 Limit Range) */
	AG903_DSP_FFMT_YUV422_BT601_FULL			,	/** YUV422(BT.601 Full Range) */
	AG903_DSP_FFMT_YUV422_BT709_LIMIT			,	/** YUV422(BT.709 Limit Range) */
	AG903_DSP_FFMT_YUV422_BT709_FULL			,	/** YUV422(BT.709 Full Range) */
	AG903_DSP_FFMT_256_PALLET0					,	/** 256Fpbg */
	AG903_DSP_FFMT_256_PALLET1					,	/** 256Fpbg */
	AG903_DSP_FFMT_16_PALLET					,	/**  16Fpbg */
	AG903_DSP_FFMT_2_PALLET						,	/**   2Fpbg */
};
/**
 * pbgtH[}bg<p>
 * ֘A\́FAG903_DSPMgrWinAttribute
 */
enum AG903_DSP_PFMT_ENUM{
	AG903_DSP_PFMT_A8R8G8B8					= 0	,	/** A8R8G8B8 */
	AG903_DSP_PFMT_X8R8G8B8						,	/** X8R8G8B8 */
	AG903_DSP_PFMT_R8G8B8						,	/** R8G8B8 */
	AG903_DSP_PFMT_R5G6B5						,	/** R5G6B5 */
	AG903_DSP_PFMT_A1R5G5B5						,	/** A1R5G5B5 */
	AG903_DSP_PFMT_X1R5G5B5						,	/** X1R5G5B5 */
	AG903_DSP_PFMT_A4R4G4B4						,	/** A4R4G4B4 */
	AG903_DSP_PFMT_X4R4G4B4						,	/** X4R4G4B4 */
};
/**
 * obt@ǗjbgNGXg^C~O<p>
 * ֘A\́FAG903_DSPMgrIntParam
 */
enum AG903_DSP_BMU_ENUM{
	AG903_DSP_BMU_WINDATA					= 0	,	/** EBhEf[^ǂݏo */
	AG903_DSP_BMU_WINATTR						,	/** EBhEAgr[gǂݏo */
};
/**
 * rfI[h<p>
 * ֘A\́FAG903_DSPMgrCtrlParam, AG903_DSPMgrExSyncParam
 */
enum AG903_DSP_VMODE_ENUM{
	AG903_DSP_VMODE_NONINTERLACE			= 0	,	/** mC^[[X */
	AG903_DSP_VMODE_INTERLACE					,	/** C^[[X */
};
/**
 * EBhE̊gk<p>
 * ֘A\́FAG903_DSPMgrWinAttribute
 */
enum AG903_DSP_SCALING_ENUM{
	AG903_DSP_SCALING_POINT_SAMPLING		= 0	,	/** |CgTvO */
	AG903_DSP_SCALING_BILINEAR					,	/** oCjA */
};
/**
 * uNݔ^C~O<p>
 * ֘A\́FAG903_DSPMgrIntParam
 */
enum AG903_DSP_INT_BLANK_TIMING_ENUM{
	AG903_DSP_INT_START_OF_VBLANK			= 0	,	/** uNJn */
	AG903_DSP_INT_END_OF_VBLANK					,	/** uNI */
};
/**
 * Cݔ^C~O<p>
 * ֘A\́FAG903_DSPMgrIntParam
 */
enum AG903_DSP_INT_LINE_TIMING_ENUM{
	AG903_DSP_INT_START_OF_LINE				= 0	,	/** w胉CJn */
	AG903_DSP_INT_END_OF_LINE					,	/** w胉CI */
};
/**
 * Cxgo<p>
 * ֘A\́FAG903_DSPMgrIntParam
 */
enum AG903_DSP_EVENT_ENUM{
	AG903_DSP_EVENT_VT						= 0	,	/** Cxg */
	AG903_DSP_EVENT_HRZ							,	/** Cxg */
};
/**
 * Cxg^C~O<p>
 * ֘A\́FAG903_DSPMgrIntParam
 */
enum AG903_DSP_TRG_HRZ_TIMING_ENUM{
	AG903_DSP_TRG_HRZ_START_OF_LINE			= 0	,	/** CJn */
	AG903_DSP_TRG_HRZ_END_OF_LINE				,	/** CI */
};
/**
 * Cxg^C~O<p>
 * ֘A\́FAG903_DSPMgrIntParam
 */
enum AG903_DSP_TRG_VT_TIMING_ENUM{
	AG903_DSP_TRG_VT_START_OF_VBLANK		= 0	,	/** uNJn */
	AG903_DSP_TRG_VT_START_OF_VSYNC				,	/** pXJn */
	AG903_DSP_TRG_VT_END_OF_VSYNC				,	/** pXI */
	AG903_DSP_TRG_VT_END_OF_VBLANK				,	/** uNI */
};
/**
 * OM<p>
 * ֘A\́FAG903_DSPMgrExSyncParam
 */
enum AG903_DSP_EXSYNC_ENUM{
	AG903_DSP_EXSYNC_NONE					= 0	,	/** O܂ */
	AG903_DSP_EXSYNC_OTHER_DSP					,	/** Е̕\HƓ */
	AG903_DSP_EXSYNC_EXTSYNC0				= 4	,	/** O[qEXTSYNC0 */
	AG903_DSP_EXSYNC_EXTSYNC1					,	/** O[qEXTSYNC1 */
	AG903_DSP_EXSYNC_VSYNC0						,	/** O[qVSYNC0 */
	AG903_DSP_EXSYNC_VSYNC1						,	/** O[qVSYNC1 */
	AG903_DSP_EXSYNC_DIGITAL_VSYNC0				,	/** fW^͂VSYNC0 */
	AG903_DSP_EXSYNC_DIGITAL_VSYNC1				,	/** fW^͂VSYNC1 */
	AG903_DSP_EXSYNC_DIGITAL_VSYNC2				,	/** fW^͂VSYNC2 */
	AG903_DSP_EXSYNC_DIGITAL_VSYNC3				,	/** fW^͂VSYNC3 */
	AG903_DSP_EXSYNC_ANALOG_VSYNC0				,	/** AiO͂VSYNC0 */
	AG903_DSP_EXSYNC_ANALOG_VSYNC1				,	/** AiO͂VSYNC1 */
	AG903_DSP_EXSYNC_ANALOG_VSYNC2				,	/** AiO͂VSYNC2 */
	AG903_DSP_EXSYNC_ANALOG_VSYNC3				,	/** AiO͂VSYNC3 */
	AG903_DSP_EXSYNC_TIMR0						,	/** ^C}0̃Cxgo */
	AG903_DSP_EXSYNC_TIMR1						,	/** ^C}1̃Cxgo */
	AG903_DSP_EXSYNC_TIMR2						,	/** ^C}2̃Cxgo */
	AG903_DSP_EXSYNC_TIMR3						,	/** ^C}3̃Cxgo */
	AG903_DSP_EXSYNC_TIMR4						,	/** ^C}4̃Cxgo */
	AG903_DSP_EXSYNC_TIMR5						,	/** ^C}5̃Cxgo */
	AG903_DSP_EXSYNC_TIMR6						,	/** ^C}6̃Cxgo */
	AG903_DSP_EXSYNC_TIMR7						,	/** ^C}7̃Cxgo */
};
/**
 * DMANGXg^C~O<p>
 * ֘A֐FAG903_DSPMgrSetDMAReq
 */
enum AG903_DSP_DMA_ENUM{
	AG903_DSP_DMA_NONE						= 0	,	/** NGXg܂ */
	AG903_DSP_DMA_END_OF_VBLANK1			= 3	,	/** Xgǂݍݐ */
	AG903_DSP_DMA_START_OF_VBLANK				,	/** uNJn */
	AG903_DSP_DMA_START_OF_VSYNC				,	/** pXJn */
	AG903_DSP_DMA_END_OF_VSYNC					,	/** pXI */
	AG903_DSP_DMA_END_OF_VBLANK2				,	/** uNI */
};
/**
 * EH<p>
 * ֘A\́FAG903_DSPMgrStat
 */
enum AG903_DSP_STAT_ENUM{
	AG903_DSP_STAT_STOP						= 0	,	/** ~ */
	AG903_DSP_STAT_RUN							,	/** 쒆 */
};
/**
 * Mʏo͗LI<p>
 * ֘A\́FAG903_DSPMgrCMOSParam, AG903_DSPMgrLVDSParam
 */
enum AG903_DSP_SIGNAL_ENUM{
	AG903_DSP_SIGNAL_ENABLE					= 0	,	/** Mo͗L */
	AG903_DSP_SIGNAL_DISABLE					,	/** Mo͖ */
};
/**
 * ʏo͐:VOD0<p>
 * ֘A֐FAG903_DSPMgrSetPortSel, AG903_DSPMgrGetPortSel
 */
enum AG903_VOD0_PORTSEL_ENUM{
	AG903_VOD0_PORTSEL_LVCMOS24				= 0	,	/** LVCMOS 24bit RGB */
	AG903_VOD0_PORTSEL_LVCMOS16					,	/** LVCMOS 16bit YUV */
	AG903_VOD0_PORTSEL_LVCMOS8					,	/** LVCOMS	8bit YUV */
	AG903_VOD0_PORTSEL_LVDS_SINGLE				,	/** LVDS VON */
};
/**
 * ʏo͐:VOD1<p>
 * ֘A֐FAG903_DSPMgrSetPortSel, AG903_DSPMgrGetPortSel
 */
enum AG903_VOD1_PORTSEL_ENUM{
	AG903_VOD1_PORTSEL_LVDS_DUAL			= 0	,	/** LVDS fAN */
	AG903_VOD1_PORTSEL_LVCMOS8				= 2	,	/** LVCOMS	8bit YUV */
	AG903_VOD1_PORTSEL_LVDS_SINGLE				,	/** LVDS VON */
};
/**
 * hbgNbNɐ<p>
 * ֘A\́FAG903_DSPMgrCMOSParam<p>
 */
enum AG903_VOD_DOTCLK_CHANGE_ENUM{
	AG903_VOD_DOTCLK_CHANGE_RISE			= 0 ,	/** オGbWRGB̕ω_ */
	AG903_VOD_DOTCLK_CHANGE_FALL				,	/** GbWRGB̕ω_ */
};
/**
 * hbgNbNɐ(ێp)<p>
 * ֘A\́FAG903_DSPMgrCMOSParam<p>
 * AG903_VOD_DOTCLK_CHANGE_ENUM Ǝgpӏ͓łB
 * CMOSo͂󂯂̊OtgX~b^̎_Œ`Ă܂B
 * VK̊JłAG903_VOD_DOTCLK_CHANGE_ENUM̕gpĉB
 */
enum AG903_VOD_DOTCLK_LATCH_ENUM{
	AG903_VOD_DOTCLK_LATCH_FALL				= 0 ,	/** GbWRGB̓Ǐo_ */
	AG903_VOD_DOTCLK_LATCH_RISE					,	/** オGbWRGB̓Ǐo_ */
};
/**
 * RGB->YUV ϊ@<p>
 * ֘A\́FAG903_DSPMgrCMOSParam
 */
enum AG903_VOD_MOD_YUV_ENUM{
	AG903_VOD_MOD_YUV_BT601					= 0 ,	/** BT.601 (SDTV) */
	AG903_VOD_MOD_YUV_BT709						,	/** BT.709 (HDTV) */
};
/**
 * LVDS}NFp[[h<p>
 * ֘A\́FAG903_DSPMgrLVDSParam
 */
enum AG903_VOD_PDX_ENUM{
	AG903_VOD_PDX_PWRDOWN					= 0	,	/** p[_E */
	AG903_VOD_PDX_NORMAL						,	/** ʏ퓮 */
};
/**
 * LVDS}NFp[_E<p>
 * ֘A\́FAG903_DSPMgrLVDSParam
 */
enum AG903_VOD_PM_ENUM{
	AG903_VOD_PM_AUTO						= 0	,	/**  */
	AG903_VOD_PM_MANUAL							,	/** 蓮 */
};
/**
 * LVDS}NFhbgNbN<p>
 * ֘A\́FAG903_DSPMgrLVDSParam
 */
enum AG903_VOD_FR_ENUM{
	AG903_VOD_FR_8_16MHZ					= 0	,	/** 8-16(DUAL:16-32)MHz */
	AG903_VOD_FR_16_32MHZ						,	/** 16-32(DUAL:32-64)MHz */
	AG903_VOD_FR_32_54MHZ						,	/** 32-54(DUAL:64-108)MHz */
	AG903_VOD_FR_54_100MHZ						,	/** 54-100(DUAL:108-200)MHz */
};
/**
 * obNCgON/OFFԒP<p>
 * ֘A\́FAG903_DSPMgrBPwrModeParam
 */
enum AG903_VOD_BPWR_UNIT_ENUM{
	AG903_VOD_BPWR_UNIT_FRAME				= 0	,	/** t[P */
	AG903_VOD_BPWR_UNIT_SCLK					,	/** VXeNbNP */
};
/**
 * ʏo͏<p>
 * ֘A֐FAG903_DSPMgrGetVODStat
 */
enum AG903_VOD_VODSTAT_ENUM{
	AG903_VOD_VODSTAT_STOP					= 0	,	/** ~ */
	AG903_VOD_VODSTAT_INIT						,	/** H */
	AG903_VOD_VODSTAT_WAIT_DCLK					,	/** hbgNbNo͑҂ */
	AG903_VOD_VODSTAT_PPWRON					,	/** pld(PPWRON) */
	AG903_VOD_VODSTAT_BPWRON					,	/** pld(BPWRON) */
	AG903_VOD_VODSTAT_BLGTON					,	/** pld(BLGTON) */
	AG903_VOD_VODSTAT_IDLE					= 8	,	/** ʏ퓮쒆 */
	AG903_VOD_VODSTAT_WAIT_SYNC				= 10,	/** t[҂ */
	AG903_VOD_VODSTAT_BLGTOFF					,	/** pld(BLGTOFF) */
	AG903_VOD_VODSTAT_BPWROFF					,	/** pld(BPWROFF) */
	AG903_VOD_VODSTAT_PPWROFF					,	/** pld(PPWROFF) */
	AG903_VOD_VODSTAT_WAIT_FIFO					,	/** FIFOo͑҂ */
	AG903_VOD_VODSTAT_WAIT_DSPSTOP				,	/** \H~҂ */
};


/* f[^\` */

/**
 * DSPnh
 */
typedef uint32_t AG903_DSPMgrHandle;

/**
 * ^C~Op[^\<p>
 * ֘A񋓌^FAG903_DSP_POLARITY_ENUM, AG903_DSP_RGBDE_SIGNAL_ENUM
 */
typedef struct _AG903_DSPMgrSyncParam {

	uint32_t rgbde_sel;					/** RGBDE[q̏o͐ݒ */
	uint32_t vsync_polarity;			/** M̋ɐ */
	uint32_t field_hsync_polarity;		/** tB[h^M̋ɐ */
	uint32_t hrz_pulsewidth;			/** MpX [px] */
	uint32_t hrz_backporch;				/** obN|[` [px] */
	uint32_t hrz_frontporch;			/** tg|[` [px] */
	uint32_t vt_pulsewidth;				/** MpX [px] */
	uint32_t odd_frontporch_plus1;		/** C^[[X[hODDt[tg|[`  [px] */
	uint32_t odd_backporch_plus1;		/** C^[[X[hODDt[obN|[`    [px] */
	uint32_t even_frontporch_plus1;		/** C^[[X[hEVENt[tg|[` [px] */
	uint32_t even_backporch_plus1;		/** C^[[X[hEVENt[obN|[`   [px] */
	uint32_t vt_backporch;				/** obN|[` [px] */
	uint32_t vt_frontporch;				/** tg|[` [px] */

}AG903_DSPMgrSyncParam;

/**
 * \Hp[^\<p>
 * ֘A񋓌^FAG903_DSP_VMODE_ENUM
 */
typedef struct _AG903_DSPMgrCtrlParam {

	uint32_t ip_sel;					/** rfI[h */
	uint32_t hrz_framesize;				/** t[TCY [px] */
	uint32_t vt_framesize;				/** t[TCY [px] */
	AG903_DSPMgrSyncParam *syncparam;	/** p[^̃|C^ */

}AG903_DSPMgrCtrlParam;

/**
 * EBhEp[^\<p>
 * ֘A񋓌^FAG903_DSP_ATTR_TIMING_ENUM
 */
typedef struct _AG903_DSPMgrWindowParam {

	uint32_t update_timing;				/** ǂݏo^C~Ow */
	uint32_t background;				/** wiF */
	uint32_t num_config;				/** gpEBhE */
	uint32_t num_attr;					/** EBhEAgr[gXg */
	uint32_t window_attr_base;			/** EBhEAgr[gXgx[XAhX(LbVs) */
	uint32_t window_attr_update;		/** EBhEAgr[gXVL*/
	uint32_t palette_update;			/** pbgXVL */

}AG903_DSPMgrWindowParam;

/**
 * 荞݃p[^\<p>
 * ֘A񋓌^FAG903_DSP_BMU_ENUM, AG903_DSP_INT_BLANK_TIMING_ENUM, AG903_DSP_INT_LINE_TIMING_ENUM, AG903_DSP_EVENT_ENUM, AG903_DSP_TRG_HRZ_TIMING_ENUM, AG903_DSP_TRG_VT_TIMING_ENUM
 */
typedef struct _AG903_DSPMgrIntParam {

	uint32_t bmureq_timing;				/** BMUNGXg */
	uint32_t int_line_no;				/** CݔCԍ */
	uint32_t int_framecount;			/** t[JE^̍ől */
	uint32_t int_hrz_line;				/** Cݔ^C~O */
	uint32_t int_vt_blank;				/** uNݔ^C~O */
	uint32_t trigger_out;				/** Cxgo͐ݒ */
	uint32_t trigger_hrz;				/** Cxg^C~O */
	uint32_t trigger_vt;				/** Cxg̔^C~O */
	uint32_t mask_vt_blank;				/** uN݃}XN */
	uint32_t mask_hrz_line;				/** C݃}XN */
	uint32_t mask_dspoff;				/** \H~荞݃}XN */
	uint32_t mask_error;				/** G[荞݃}XN */

}AG903_DSPMgrIntParam;

/**
 * ݏԍ\
 */
typedef struct _AG903_DSPMgrIntStat {

	uint32_t int_vt_blank;			/** uNݏ */
	uint32_t int_hrz_line;			/** Cݏ */
	uint32_t int_dspoff;			/** \H~荞ݏ */
	uint32_t dreq;					/** DMANGXg */
	uint32_t clr_vt_blank;			/** uN݃NA */
	uint32_t clr_hrz_line;			/** C݃NA */
	uint32_t clr_dspoff;			/** \H~݃NA */

}AG903_DSPMgrIntStat;

/**
 * \Hԍ\<p>
 * ֘A񋓌^FAG903_DSP_CTRL_ENUM, AG903_DSP_STAT_ENUM
 */
typedef struct _AG903_DSPMgrStat {

	uint32_t ctrl_status;			/** \H */
	uint32_t work_pix;				/** ݏ̃sNZ */
	uint32_t hrz_status;			/** H̏ */
	uint32_t work_line;				/** ݏ̃C */
	uint32_t vt_status;				/** H̏ */
	uint32_t frameconut;			/** ݂̃t[JE^ */
	uint32_t err_line;				/** A_[t[̃Cԍ */
	uint32_t err_ue;				/** A_[t[L */
	uint32_t err_le;				/** EBhEAgr[gXgǂݏoG[L */
	uint32_t err_pe;				/** pbgǂݏõG[L */
	uint32_t errclr_line;			/** A_[t[̃CԍNA */
	uint32_t errclr_ue;				/** A_[t[NA */
	uint32_t errclr_le;				/** EBhEAgr[gXgǂݏoG[NA*/
	uint32_t errclr_pe;				/** pbgǂݏõG[NA */

}AG903_DSPMgrStat;

/**
 * EBhEAgr[g\<p>
 * ֘A񋓌^FAG903_DSP_FFMT_ENUM, AG903_DSP_FFMT_ENUM, AG903_DSP_SCALING_ENUM
 */
typedef struct _AG903_DSPMgrWinAttribute {

	uint16_t position_x;				/** \ʏXW */
	uint16_t position_y;				/** \ʏYW */
	uint16_t destination_width;			/** \ʏ̉ʃf[^ */
	uint16_t destination_height;		/** \ʏ̉ʃf[^c */
	uint32_t framebuffer_base;			/** VRAMf[^̐擪AhX(LbVs) */
	uint16_t source_width;				/** VRAMʃf[^ */
	uint16_t source_height;				/** VRAMʃf[^c */
	uint32_t hrz_size;					/** VRAMt[obt@ */
	uint8_t  transparent_color_b;		/** ߐFij */
	uint8_t  transparent_color_g;		/** ߐFi΁j */
	uint8_t  transparent_color_r;		/** ߐFiԁj */
	uint8_t  transparent_color_a;		/** ߐFij */
	uint32_t pallet_base;				/** VRAMpbgf[^擪AhX(LbVs) */

	/** EBhEݒ̈̒` */
	struct {
		uint32_t valid				:1;		/** \̗LE */
		uint32_t biliner			:1;		/** oCjAE|CgTvO */
		uint32_t hrz_flip			:1;		/** tbv̗LE */
		uint32_t vt_flip			:1;		/** tbv̗LE */
		uint32_t swap_1bit			:1;		/** f[^Xbvi1bitjLE */
		uint32_t swap_4bit			:1;		/** f[^Xbvi4bitjLE */
		uint32_t swap_half			:1;		/** f[^Xbvin[t[hjLE */
		uint32_t swap_word			:1;		/** f[^Xbvi[hjLE */
		uint32_t default_alpha		:8;		/** ȂtH[}bgŎgp郿l */
		uint32_t framebuffer_format	:4;		/** t[obt@tH[}bg */
		uint32_t pallet_format		:3;		/** pbgtH[}bg */
		uint32_t					:1;
		uint32_t transparent_en_b	:1;		/** ߔ̗LE */
		uint32_t transparent_en_g	:1;		/** ΐߔ̗LE */
		uint32_t transparent_en_r	:1;		/** Ԑߔ̗LE */
		uint32_t transparent_en_a	:1;		/** ߔ̗LE */
		uint32_t transparent_en		:1;		/** ߐF̗LE */
	}conf;

}AG903_DSPMgrWinAttribute;

/**
 * Op[^\<p>
 * ֘A񋓌^FAG903_DSP_POLARITY_ENUM, AG903_DSP_VMODE_ENUM, AG903_DSP_EXSYNC_ENUM
 */
typedef struct _AG903_DSPMgrExSyncParam {

	uint32_t sync_sel;					/** 邽߂ɎQƂM */
	uint32_t delay_ctrl_en;				/** x̗LE */
	uint32_t ip_sel;					/** ͐M̃rfI[h */
	uint32_t vsync_polarity;			/** M̋ɐ */
	uint32_t field_hsync_polarity;		/** tB[h^M̋ɐ */
	uint32_t sync_mask_en;				/** }XN̗L */

}AG903_DSPMgrExSyncParam;

/**
 * F␳p[^\
 */
typedef struct _AG903_DSPMgrLutParam {

	/** F␳p[^iԁj */
	struct {
		uint8_t r0;						/** Ԑ0̏ꍇ̕ϊl */
		uint8_t r1;						/** Ԑ1̏ꍇ̕ϊl */
		uint8_t r2;						/** Ԑ2̏ꍇ̕ϊl */
		uint8_t r3;						/** Ԑ3̏ꍇ̕ϊl */
	}LUTR[AG903_DSP_LUT_NUM];
	/** F␳p[^i΁j */
	struct {
		uint8_t g0;						/** Ԑ0̏ꍇ̕ϊl */
		uint8_t g1;						/** Ԑ1̏ꍇ̕ϊl */
		uint8_t g2;						/** Ԑ2̏ꍇ̕ϊl */
		uint8_t g3;						/** Ԑ3̏ꍇ̕ϊl */
	}LUTG[AG903_DSP_LUT_NUM];
	/** F␳p[^ij */
	struct {
		uint8_t b0;						/** Ԑ0̏ꍇ̕ϊl */
		uint8_t b1;						/** Ԑ1̏ꍇ̕ϊl */
		uint8_t b2;						/** Ԑ2̏ꍇ̕ϊl */
		uint8_t b3;						/** Ԑ3̏ꍇ̕ϊl */
	}LUTB[AG903_DSP_LUT_NUM];

}AG903_DSPMgrLutParam;

/**
 * Fp[^\
 */
typedef struct _AG903_DSPMgrDithParam {

	/** Fp[^ */
	struct {
		uint32_t x0;					/** Fs̍XW */
		uint32_t y0;					/** Fs̍YW */
		uint32_t x1;					/** Fs̉EXW */
		uint32_t y1;					/** Fs̉EYW */
	}DITHAREA[AG903_DSP_DITHAREA_NUM];

}AG903_DSPMgrDithParam;

/**
 * Fop[^\
 */
typedef struct _AG903_DSPMgrCDParam {

	uint32_t colordetect_en_b;			/** rLtO 0:v 1:r */
	uint32_t colordetect_en_g;			/** ΔrLtO 0:v 1:r */
	uint32_t colordetect_en_r;			/** ԔrLtO 0:v 1:r */
	uint32_t colordetect_en_a;			/** rLtO 0:v 1:r */
	uint32_t colordetect_color_b;		/** ̔rl */
	uint32_t colordetect_color_g;		/** ΂̔rl */
	uint32_t colordetect_color_r;		/** Ԃ̔rl */
	uint32_t colordetect_color_a;		/** ̔rl */

}AG903_DSPMgrCDParam;

/**
 * CMOSp[^\<p>
 * ֘A񋓌^FAG903_DSP_POLARITY_ENUM, AG903_DSP_POLARITY_ENUM, AG903_VOD_DOTCLK_LATCH_ENUM, AG903_VOD_DOTCLK_CHANGE_ENUM, AG903_VOD_MOD_YUV_ENUM
 */
typedef struct _AG903_DSPMgrCMOSParam {

	uint32_t rgbde_polarity;			/** RGBDE̋ɐ */
	uint32_t vsync_polarity;			/** VSYNC̋ɐ */
	uint32_t hsync_polarity;			/** HSYNC̋ɐ */
	uint32_t field_polarity;			/** tB[hM̋ɐ */
	uint32_t colordetect_polarity;		/** FoM̋ɐ */
	uint32_t rgbde_en;					/** RGBDE̗LE */
	uint32_t vsync_en;					/** VSYNC̗LE */
	uint32_t hsync_en;					/** HSYNC̗LE */
	uint32_t field_en;					/** tB[hM̗LE */
	uint32_t colordetect_en;			/** FoM̗LE */
	uint32_t pixeldata_en;				/** sNZf[^̗LE */
	uint32_t dotclk_polarity;			/** hbgNbN̋ɐ */
	uint32_t code_en;					/** f[^SAVAEAVR[h߂ݗL */
	uint32_t yuv_mode;					/** RGBYUVϊ@ */

}AG903_DSPMgrCMOSParam;

/**
 * LVDSp[^\<p>
 * ֘A񋓌^FAG903_DSP_POLARITY_ENUM, AG903_DSP_SIGNAL_ENUM, AG903_VOD_PDX_ENUM, AG903_VOD_PM_ENUM, AG903_VOD_FR_ENUM
 */
typedef struct _AG903_DSPMgrLVDSParam {

	uint32_t rgbde_polarity;			/** RGBDE̋ɐ */
	uint32_t vsync_polarity;			/** VSYNC̋ɐ */
	uint32_t hsync_polarity;			/** HSYNC̋ɐ */
	uint32_t field_polarity;			/** tB[hM̋ɐ */
	uint32_t colordetect_polarity;		/** FoM̋ɐ */
	uint32_t rgbde_en;					/** RGBDE̗LE */
	uint32_t vsync_en;					/** VSYNC̗LE */
	uint32_t hsync_en;					/** HSYNC̗LE */
	uint32_t field_en;					/** tB[hM̗LE */
	uint32_t colordetect_en;			/** FoM̗LE */
	uint32_t pixeldata_en;				/** sNZf[^̗LE */
	uint32_t format;					/** LVDSo̓tH[}bg */
	uint32_t ctrl0;						/** 1st LinkCTRLMo͒l */
	uint32_t ctrl1;						/** 2nd LinkCTRLMo͒l */
	uint32_t freq_range;				/** LVDS}N̎gW */
	uint32_t auto_powermanage;			/** LVDS}Ñp[_E */
	uint32_t macro_power;				/** LVDS}Ñp[[h */

}AG903_DSPMgrLVDSParam;

/**
 * obNCgp[^\<p>
 * ֘A񋓌^FAG903_VOD_BPWR_UNIT_ENUM
 */
typedef struct _AG903_DSPMgrBPwrModeParam {

	uint32_t backlight_en;				/** obNCg̗LE */
	uint32_t cnt_unit;					/** ONԁAOFFԂ̃p[^P */
	uint32_t panel_pwroncnt;			/** pldON */
	uint32_t backlight_pwroncnt;		/** obNCgdON */
	uint32_t backlight_oncnt;			/** obNCgLON */
	uint32_t panel_pwroffcnt;			/** pldOFF */
	uint32_t backlight_pwroffcnt;		/** obNCgdOFF */
	uint32_t backlight_offcnt;			/** obNCgLOFF */
	uint32_t pwm_period;				/** PWM */
	uint32_t pwm_cnt;					/** PWMJEg */

}AG903_DSPMgrBPwrModeParam;

/* vg^Cv` */
int32_t AG903_DSPMgrInit(void);
int32_t AG903_DSPMgrGetHandle(uint8_t ch, AG903_DSPMgrHandle **handle);
int32_t AG903_DSPMgrReleaseHandle(AG903_DSPMgrHandle *handle);
int32_t AG903_DSPMgrCheckStopped(AG903_DSPMgrHandle *handle);
int32_t AG903_DSPMgrEnable(AG903_DSPMgrHandle *handle);
int32_t AG903_DSPMgrDisable(AG903_DSPMgrHandle *handle);
int32_t AG903_DSPMgrGetCtrlParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrCtrlParam *param);
int32_t AG903_DSPMgrSetWindowParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrWindowParam *param);
int32_t AG903_DSPMgrSetAttributeList(AG903_DSPMgrHandle *handle, AG903_DSPMgrWindowParam *param);
int32_t AG903_DSPMgrSetIntParam(AG903_DSPMgrHandle *handle,AG903_DSPMgrIntParam *param);
int32_t AG903_DSPMgrSetIntMask(AG903_DSPMgrHandle *handle, AG903_DSPMgrIntParam *param);
int32_t AG903_DSPMgrGetIntStat(AG903_DSPMgrHandle *handle, AG903_DSPMgrIntStat *stat);
int32_t AG903_DSPMgrClearIntStat(AG903_DSPMgrHandle *handle, AG903_DSPMgrIntStat *stat);
int32_t AG903_DSPMgrGetStat(AG903_DSPMgrHandle *handle, AG903_DSPMgrStat *stat);
int32_t AG903_DSPMgrClearStat(AG903_DSPMgrHandle *handle, AG903_DSPMgrStat *stat);
/*
 * EBhEAgr[g
 */
int32_t AG903_DSPMgrGetAttribute(AG903_DSPMgrHandle *handle, uint8_t listno, AG903_DSPMgrWinAttribute **attr);
int32_t AG903_DSPMgrSetAttribute(AG903_DSPMgrHandle *handle, uint8_t listno);
/*
 * IvV
 */
int32_t AG903_DSPMgrSetExSyncParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrExSyncParam *param);
int32_t AG903_DSPMgrSetLutParam(AG903_DSPMgrHandle *handle, _Bool en, AG903_DSPMgrLutParam *param);
int32_t AG903_DSPMgrSetDithParam(AG903_DSPMgrHandle *handle, _Bool en, AG903_DSPMgrDithParam *param);
int32_t AG903_DSPMgrSetCDParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrCDParam *param);
int32_t AG903_DSPMgrSetDMAReq(AG903_DSPMgrHandle *handle, uint8_t req);
/*
 * ʏo
 */
int32_t AG903_DSPMgrGetPortSel(AG903_DSPMgrHandle *handle, uint8_t *sel);
int32_t AG903_DSPMgrSetPortSel(AG903_DSPMgrHandle *handle, uint8_t sel);
int32_t AG903_DSPMgrSetCMOSParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrCtrlParam *ctrl, AG903_DSPMgrCMOSParam *param);
int32_t AG903_DSPMgrSetLVDSParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrCtrlParam *ctrl, AG903_DSPMgrLVDSParam *param);
int32_t AG903_DSPMgrSetBPwrModeParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrBPwrModeParam *param);
int32_t AG903_DSPMgrGetBPwrModeParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrBPwrModeParam *param);



#ifdef __cplusplus
}
#endif

#endif/* __DSPMGR_H__ */
