/**
 * @brief           DSP Primitive
 * @author          AXELL CORPORATION
 * @description     DSP Primitive Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __DSPPRM_H__
#define __DSPPRM_H__
/* DOM-IGNORE-END */

#include "register/AG903_dspreg.h"

#ifdef __cplusplus
extern "C" {
#endif

/** DSPnMODWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamMOD {
	uint32_t de;        /** [0]     de rbg̒l */
	uint32_t ip;        /** [8]     ip rbg̒l */
	uint32_t upd;       /** [17:16] upd rbg̒l */
	uint32_t bmr;       /** [18]    bmr rbg̒l */
	uint32_t lut;       /** [24]    lut rbg̒l */
	uint32_t dith;      /** [25]    dith rbg̒l */
}DSPPrmParamMOD;

/** DSPnSYNCWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamSYNC {
	uint32_t sel;       /** [4:0]   sel rbg̒l */
	uint32_t dly;       /** [8]     dly rbg̒l */
	uint32_t ip;        /** [16]    ip rbg̒l */
	uint32_t vp;        /** [17]    vp rbg̒l */
	uint32_t fp;        /** [18]    fp rbg̒l */
	uint32_t msk;       /** [24]    msk rbg̒l */
}DSPPrmParamSYNC;

/** DSPnVTPRM0WX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamVTPRM0 {
	uint32_t vpw;       /** [10:0]  vpw rbg̒l */
	uint32_t ofp;       /** [16]    ofp rbg̒l */
	uint32_t obp;       /** [17]    obp rbg̒l */
	uint32_t efp;       /** [18]    efp rbg̒l */
	uint32_t ebp;       /** [19]    ebp rbg̒l */
}DSPPrmParamVTPRM0;

/** DSPnCDCTRLWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamCDCTRL {
	uint32_t be;        /** [0]     be rbg̒l */
	uint32_t ge;        /** [8]     ge rbg̒l */
	uint32_t re;        /** [16]    re rbg̒l */
	uint32_t ae;        /** [24]    ae rbg̒l */
}DSPPrmParamCDCTRL;

/** DSPnCOLDETWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamCOLDET {
	uint32_t b;         /** [7:0]   b rbg̒l */
	uint32_t g;         /** [15:8]  g rbg̒l */
	uint32_t r;         /** [23:16] r rbg̒l */
	uint32_t a;         /** [31:24] a rbg̒l */
}DSPPrmParamCOLDET;

/** DSPnERRSTATWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamERRSTAT {
	uint32_t line;      /** [10:0]  line rbg̒l */
	uint32_t ue;        /** [16]    ue rbg̒l */
	uint32_t le;        /** [24]    le rbg̒l */
	uint32_t pe;        /** [25]    pe rbg̒l */
}DSPPrmParamERRSTAT;

/** DSPnERRCLRWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamERRCLR {
	uint32_t line;      /** [0]     line rbg̒l */
	uint32_t ue;        /** [16]    ue rbg̒l */
	uint32_t le;        /** [24]    le rbg̒l */
	uint32_t pe;        /** [25]    pe rbg̒l */
}DSPPrmParamERRCLR;

/** DSPnINTWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamINT {
	uint32_t line;      /** [10:0]  line rbg̒l */
	uint32_t fcnt;      /** [19:16] fcnt rbg̒l */
	uint32_t hline;     /** [24]    hline rbg̒l */
	uint32_t vblk;      /** [25]    vblk rbg̒l */
}DSPPrmParamINT;

/** DSPnINTSTATWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamINTSTAT {
	uint32_t vblk;      /** [0]     vblk rbg̒l */
	uint32_t hline;     /** [8]     hline rbg̒l */
	uint32_t doff;      /** [16]    doff rbg̒l */
	uint32_t dreq;      /** [24]    dreq rbg̒l */
}DSPPrmParamINTSTAT;

/** DSPnINTMASKWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamINTMASK {
	uint32_t vblk;      /** [0]     vblk rbg̒l */
	uint32_t hline;     /** [8]     hline rbg̒l */
	uint32_t doff;      /** [16]    doff rbg̒l */
	uint32_t err;       /** [24]    err rbg̒l */
}DSPPrmParamINTMASK;

/** DSPnLUTRWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamLUTR {
	uint32_t r0;        /** [7:0]   r0 rbg̒l */
	uint32_t r1;        /** [15:8]  r1 rbg̒l */
	uint32_t r2;        /** [23:16] r2 rbg̒l */
	uint32_t r3;        /** [31:24] r3 rbg̒l */
}DSPPrmParamLUTR;

/** DSPnLUTGWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamLUTG {
	uint32_t g0;        /** [7:0]   g0 rbg̒l */
	uint32_t g1;        /** [15:8]  g1 rbg̒l */
	uint32_t g2;        /** [23:16] g2 rbg̒l */
	uint32_t g3;        /** [31:24] g3 rbg̒l */
}DSPPrmParamLUTG;

/** DSPnLUTBWX^̐ݒl󂯓np\ */
typedef struct _DSPPrmParamLUTB {
	uint32_t b0;        /** [7:0]   b0 rbg̒l */
	uint32_t b1;        /** [15:8]  b1 rbg̒l */
	uint32_t b2;        /** [23:16] b2 rbg̒l */
	uint32_t b3;        /** [31:24] b3 rbg̒l */
}DSPPrmParamLUTB;

/* ֐vg^Cv */
void AG903_DSPPrmGetCTRL(uint8_t ch, uint32_t *don);
void AG903_DSPPrmSetCTRL(uint8_t ch, uint32_t don);
void AG903_DSPPrmGetMOD(uint8_t ch, DSPPrmParamMOD *mod);
void AG903_DSPPrmSetMOD(uint8_t ch, DSPPrmParamMOD *mod);
void AG903_DSPPrmGetSYNC(uint8_t ch, DSPPrmParamSYNC *sync);
void AG903_DSPPrmSetSYNC(uint8_t ch, DSPPrmParamSYNC *sync);
void AG903_DSPPrmGetBGCOL(uint8_t ch, uint32_t *bgcol);
void AG903_DSPPrmSetBGCOL(uint8_t ch, uint32_t bgcol);
void AG903_DSPPrmGetWINNUM(uint8_t ch, uint32_t *act, uint32_t *conf);
void AG903_DSPPrmSetWINNUM(uint8_t ch, uint32_t conf);
void AG903_DSPPrmGetWATNUM(uint8_t ch, uint32_t *num);
void AG903_DSPPrmSetWATNUM(uint8_t ch, uint32_t num);
void AG903_DSPPrmGetWATBASE(uint8_t ch, uint32_t *addr);
void AG903_DSPPrmSetWATBASE(uint8_t ch, uint32_t addr);
void AG903_DSPPrmGetLSTCTRL(uint8_t ch, uint32_t *pal, uint32_t *wat);
void AG903_DSPPrmSetLSTCTRL(uint8_t ch, uint32_t pal, uint32_t wat);
void AG903_DSPPrmGetHRZPRM0(uint8_t ch, uint32_t *hpw);
void AG903_DSPPrmSetHRZPRM0(uint8_t ch, uint32_t hpw);
void AG903_DSPPrmGetHRZPRM1(uint8_t ch, uint32_t *hfp, uint32_t *hbp);
void AG903_DSPPrmSetHRZPRM1(uint8_t ch, uint32_t hfp, uint32_t hbp);
void AG903_DSPPrmGetVTPRM0(uint8_t ch, DSPPrmParamVTPRM0 *vtprm0);
void AG903_DSPPrmSetVTPRM0(uint8_t ch, DSPPrmParamVTPRM0 *vtprm0);
void AG903_DSPPrmGetVTPRM1(uint8_t ch, uint32_t *vfp, uint32_t *vbp);
void AG903_DSPPrmSetVTPRM1(uint8_t ch, uint32_t vfp, uint32_t vbp);
void AG903_DSPPrmGetFRMSIZE(uint8_t ch, uint32_t *vfs, uint32_t *hfs);
void AG903_DSPPrmSetFRMSIZE(uint8_t ch, uint32_t vfs, uint32_t hfs);
void AG903_DSPPrmGetCDCTRL(uint8_t ch, DSPPrmParamCDCTRL *cdctrl);
void AG903_DSPPrmSetCDCTRL(uint8_t ch, DSPPrmParamCDCTRL *cdctrl);
void AG903_DSPPrmGetCOLDET(uint8_t ch, DSPPrmParamCOLDET *coldet);
void AG903_DSPPrmSetCOLDET(uint8_t ch, DSPPrmParamCOLDET *coldet);
void AG903_DSPPrmGetDITHAREA0A(uint8_t ch, uint32_t *x0, uint32_t *y0);
void AG903_DSPPrmSetDITHAREA0A(uint8_t ch, uint32_t x0, uint32_t y0);
void AG903_DSPPrmGetDITHAREA0B(uint8_t ch, uint32_t *x1, uint32_t *y1);
void AG903_DSPPrmSetDITHAREA0B(uint8_t ch, uint32_t x1, uint32_t y1);
void AG903_DSPPrmGetDITHAREA1A(uint8_t ch, uint32_t *x0, uint32_t *y0);
void AG903_DSPPrmSetDITHAREA1A(uint8_t ch, uint32_t x0, uint32_t y0);
void AG903_DSPPrmGetDITHAREA1B(uint8_t ch, uint32_t *x1, uint32_t *y1);
void AG903_DSPPrmSetDITHAREA1B(uint8_t ch, uint32_t x1, uint32_t y1);
void AG903_DSPPrmGetDITHAREA2A(uint8_t ch, uint32_t *x0, uint32_t *y0);
void AG903_DSPPrmSetDITHAREA2A(uint8_t ch, uint32_t x0, uint32_t y0);
void AG903_DSPPrmGetDITHAREA2B(uint8_t ch, uint32_t *x1, uint32_t *y1);
void AG903_DSPPrmSetDITHAREA2B(uint8_t ch, uint32_t x1, uint32_t y1);
void AG903_DSPPrmGetDITHAREA3A(uint8_t ch, uint32_t *x0, uint32_t *y0);
void AG903_DSPPrmSetDITHAREA3A(uint8_t ch, uint32_t x0, uint32_t y0);
void AG903_DSPPrmGetDITHAREA3B(uint8_t ch, uint32_t *x1, uint32_t *y1);
void AG903_DSPPrmSetDITHAREA3B(uint8_t ch, uint32_t x1, uint32_t y1);
void AG903_DSPPrmGetERRSTAT(uint8_t ch, DSPPrmParamERRSTAT *errstat);
void AG903_DSPPrmSetERRCLR(uint8_t ch, DSPPrmParamERRCLR *errclr);
void AG903_DSPPrmGetINT(uint8_t ch, DSPPrmParamINT *intprm);
void AG903_DSPPrmSetINT(uint8_t ch, DSPPrmParamINT *intprm);
void AG903_DSPPrmGetTRIGGER(uint8_t ch, uint32_t *out, uint32_t *hrz, uint32_t *vt);
void AG903_DSPPrmSetTRIGGER(uint8_t ch, uint32_t out, uint32_t hrz, uint32_t vt);
void AG903_DSPPrmGetINTSTAT(uint8_t ch, DSPPrmParamINTSTAT *intstat);
void AG903_DSPPrmSetINTCLR(uint8_t ch, uint32_t vblk, uint32_t hline, uint32_t doff);
void AG903_DSPPrmGetINTMASK(uint8_t ch, DSPPrmParamINTMASK *intmask);
void AG903_DSPPrmSetINTMASK(uint8_t ch, DSPPrmParamINTMASK *intmask);
void AG903_DSPPrmGetDMAREQ(uint8_t ch, uint32_t *req);
void AG903_DSPPrmSetDMAREQ(uint8_t ch, uint32_t req);
void AG903_DSPPrmGetHRZSTAT(uint8_t ch, uint32_t *pix, uint32_t *stat);
void AG903_DSPPrmGetVTSTAT(uint8_t ch, uint32_t *line, uint32_t *stat, uint32_t *fcnt);
void AG903_DSPPrmGetLUTR(uint8_t ch, uint8_t table_no, DSPPrmParamLUTR *lutr);
void AG903_DSPPrmSetLUTR(uint8_t ch, uint8_t table_no, DSPPrmParamLUTR *lutr);
void AG903_DSPPrmGetLUTG(uint8_t ch, uint8_t table_no, DSPPrmParamLUTG *lutg);
void AG903_DSPPrmSetLUTG(uint8_t ch, uint8_t table_no, DSPPrmParamLUTG *lutg);
void AG903_DSPPrmGetLUTB(uint8_t ch, uint8_t table_no, DSPPrmParamLUTB *lutb);
void AG903_DSPPrmSetLUTB(uint8_t ch, uint8_t table_no, DSPPrmParamLUTB *lutb);

#ifdef __cplusplus
}
#endif

#endif/* __DSPPRM_H__ */
