/**
 * @brief           GPIO Primitive Header
 * @author          AXELL CORPORATION
 * @description     GPIO Primitive񋟃wb_B<p>GPIO PrimitivegpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _GPIOPRM_H_
#define _GPIOPRM_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** GPIO `l */
#define AG903_GPIO_CH_NUM			(4)

/** Port̃rbg */
#define AG903_GPIO_PORTBIT_NUM		(32)

/** SPort̃rbg */
#define AG903_GPIO_PORTBIT_TORTAL	(AG903_GPIO_CH_NUM*AG903_GPIO_PORTBIT_NUM)

/** 8rbgPʂ̃ubN */
#define AG903_GPIO_PORTBLK_TORTAL	(AG903_GPIO_PORTBIT_TORTAL/8)


void AG903_GPIOPrmSetByteData(uint8_t ch, uint8_t offset, uint8_t data);
void AG903_GPIOPrmGetByteData(uint8_t ch, uint8_t offset, uint8_t* data);
void AG903_GPIOPrmModifyBit(uint8_t ch, uint32_t set, uint32_t clr, _Bool ext);
void AG903_GPIOPrmGetPortData(uint8_t ch, uint32_t* data);
void AG903_GPIOPrmSetDirection(uint8_t ch, uint32_t dir);
void AG903_GPIOPrmGetDirection(uint8_t ch, uint32_t* dir);
void AG903_GPIOPrmSetType(uint8_t ch, uint32_t type);
void AG903_GPIOPrmGetType(uint8_t ch, uint32_t* type);
void AG903_GPIOPrmSetPosEdgeDetect(uint8_t ch, uint32_t enable);
void AG903_GPIOPrmGetPosEdgeDetect(uint8_t ch, uint32_t* enable);
void AG903_GPIOPrmSetNegEdgeDetect(uint8_t ch, uint32_t enable);
void AG903_GPIOPrmGetNegEdgeDetect(uint8_t ch, uint32_t* enable);
void AG903_GPIOPrmSetMask(uint8_t ch, uint32_t mask);
void AG903_GPIOPrmGetMask(uint8_t ch, uint32_t* mask);
void AG903_GPIOPrmGetEdgeDetect(uint8_t ch, uint32_t* status);
void AG903_GPIOPrmClearEdgeDetect(uint8_t ch, uint32_t clrbit);


#ifdef __cplusplus
}
#endif
#endif /* _GPIOPRM_H_ */
