/**
 * @brief           I2C Manager Header
 * @author          AXELL CORPORATION
 * @description     I2C Manager񋟃wb_B<p>I2C ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _I2CMGR_H_
#define _I2CMGR_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** CLK_FTP̎g [Hz] */
#define AG903_I2C_CLK				(100000000)

/** SCLݒl [Hz] */
#define AG903_I2C_DFLT_SCL			(100000)

/** IICnTGSR GSRݒl */
#define AG903_I2C_DFLT_GSR			(8)

/** IICnTGSR TSRݒl */
#define AG903_I2C_DFLT_TSR			(64)

/** nh */
#define AG903_I2C_HANDLE_NUM		(4)

/** L[ */
#define AG903_I2C_QUENUM			(6)

/** Cxgorbg iReadG[j*/
#define AG903_I2C_EVENT_READ_ERR			(1<<11)
/** Cxgorbg iWriteG[j*/
#define AG903_I2C_EVENT_WRITE_ERR			(1<<10)
/** Cxgorbg iʐMG[j*/
#define AG903_I2C_EVENT_SEQUENCE_ERR		(1<<9)
/** Cxgorbg iA[rg[Vj*/
#define AG903_I2C_EVENT_LOSES_ARBITRATION	(1<<8)
/** Cxgorbg iReadj*/
#define AG903_I2C_EVENT_READ_END			(1<<1)
/** Cxgorbg iWritej*/
#define AG903_I2C_EVENT_WRITE_END			(1<<0)

/** I2Cnh */
typedef uint32_t	AG903_I2CMgrHandle;

/** R[obN֐̌^B<p>
	handleI2CnhAevent̓Cxgorbg(\Q)B<p>
    <table>
    <tr><th>bit</th><th>e</th></tr>
    <tr><td>31:12</td><td>reserve</td></tr>
    <tr><td>11</td><td>ReadG[</td></tr>
    <tr><td>10</td><td>WriteG[</td></tr>
    <tr><td>9</td><td>ʐMG[</td></tr>
    <tr><td>8</td><td>A[rg[V</td></tr>
    <tr><td>7:2</td><td>reserve</td></tr>
    <tr><td>1</td><td>Read</td></tr>
    <tr><td>0</td><td>Write</td></tr>
    </table> */
typedef void (*AG903_I2CMgrClbk)(AG903_I2CMgrHandle* handle, uint32_t event);

/** Writep[^ */
typedef struct _AG903_I2CMgrWriteParam {
	uint8_t*	buf;			/* obt@ */
	uint32_t	size;			/* f[^TCY */
	uint16_t	addr;			/* Slave Address */
	uint8_t		stop;			/* Stop ConditionL */
	uint8_t		reserve; 		/* \ */
} AG903_I2CMgrWriteParam;

/** Readp[^ */
typedef struct _AG903_I2CMgrReadParam {
	uint8_t*	buf;			/* obt@ */
	uint32_t	size;			/* f[^TCY */
	uint16_t	addr;			/* Slave Address */
	uint8_t		reserve[2]; 	/* \ */
} AG903_I2CMgrReadParam;

/** NbNp[^ */
typedef struct _AG903_I2CMgrClkPrm {
	uint32_t	cdr_val;		/* IICnCDR ݒl */
	uint16_t	tsr_val;		/* IICnTGSR TSRݒl */
	uint8_t		gsr_val;		/* IICnTGSR GSRݒl */
	uint8_t		reserve;		/* \ */
} AG903_I2CMgrClkPrm;


int32_t	AG903_I2CMgrInit(uint8_t ch);
int32_t AG903_I2CMgrSetClock(uint8_t ch, AG903_I2CMgrClkPrm* param);
int32_t AG903_I2CMgrSetSlaveAddress(uint8_t ch, uint16_t saddr);
int32_t	AG903_I2CMgrGetHandle(uint8_t ch,  AG903_I2CMgrHandle** handle);
int32_t	AG903_I2CMgrReleaseHandle(AG903_I2CMgrHandle* handle);
int32_t AG903_I2CMgrSetCallback(AG903_I2CMgrHandle* handle, AG903_I2CMgrClbk clbk);
int32_t AG903_I2CMgrMasterWrite(AG903_I2CMgrHandle* handle, AG903_I2CMgrWriteParam* param);
int32_t AG903_I2CMgrMasterRead(AG903_I2CMgrHandle* handle, AG903_I2CMgrReadParam* param);
int32_t AG903_I2CMgrSlaveWrite(AG903_I2CMgrHandle* handle, uint8_t* buf, uint32_t size);
int32_t AG903_I2CMgrSlaveRead(AG903_I2CMgrHandle* handle, uint8_t* buf, uint32_t size);
int32_t AG903_I2CMgrReset(AG903_I2CMgrHandle* handle);
int32_t AG903_I2CMgrGetQueCount(AG903_I2CMgrHandle* handle, uint32_t* count);

#ifdef __cplusplus
}
#endif
#endif /* _I2CMGR_H_ */
