/**
 * @brief           OSP Manager Header
 * @author          AXELL CORPORATION
 * @description     OSP Manager񋟃wb_B<p>OSP ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __OSPMGR_H__
#define __OSPMGR_H__
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

/** OSP`l */
#define	AG903_OSP_CH_NUM					(4)

/** Dx */
enum _AG903_OSPMgrPri{
	AG903_OSP_PRI_LOWEST					= 0	,	/** Dx()		*/
	AG903_OSP_PRI_LOW							,	/** Dx(b)		*/
	AG903_OSP_PRI_HIGH							,	/** Dx(b)		*/
	AG903_OSP_PRI_HIGHEST						,	/** Dx()		*/
	AG903_OSP_PRI_NUM							,	/** Dxő吔	*/
};

/** R}hobt@[h */
typedef enum _AG903_OSPMgrBufMode{
	AG903_OSP_BUFMODE_FIFO = 0,		/** FIFOobt@[h	*/
	AG903_OSP_BUFMODE_RING,			/** RINGobt@[h	*/
	AG903_OSP_BUFMODE_NUM,			/** R}hobt@[h */
} AG903_OSPMgrBufMode;

/** R}h */
typedef enum _AG903_OSPMgrCmd {
	AG903_OSP_CMD_BUS_SINGLE = 0,	/** Bus Access Single [BAS] */
	AG903_OSP_CMD_BUS_BURST_FIX,	/** Bus Access Burst (Address Fixed) [BAB] */
	AG903_OSP_CMD_BUS_BURST_INC,	/** Bus Access Burst (Address Increment) [BAB] */
	AG903_OSP_CMD_BUS_ADDR,			/** Bus Access Address */
	AG903_OSP_CMD_BUS_DATA,			/** Bus Access Data */
	AG903_OSP_CMD_BUS_WAIT,			/** Bus Access Wait [BAW] */
	AG903_OSP_CMD_INTR_WAIT,		/** Wait Interrupt [INTR] */
	AG903_OSP_CMD_EVNT_WAIT,		/** Wait Event [EVENT] */
	AG903_OSP_CMD_EVNT_DEC,			/** Event Decrement [EVENTD] */
	AG903_OSP_CMD_EVNT_CLR,			/** Event Clear [EVENTC] */
	AG903_OSP_CMD_FLAG_SET,			/** Set Flag [SETF] */
	AG903_OSP_CMD_FLAG_CLR,			/** Clear Flag [CLRF] */
	AG903_OSP_CMD_NOP,				/** No Operation [NOP] */
	AG903_OSP_CMD_NUM,				/** R}h` */
} AG903_OSPMgrCmd;

/** Cxgő吔 */
#define	AG903_OSP_EVENT_NUM					(64)

/** FIFOőTCY(Byte) */
#define	AG903_OSP_FIFO_SIZE					(512)

/** FIFO ői */
#define	AG903_OSP_FIFO_NUM					(AG903_OSP_FIFO_SIZE / sizeof(uint32_t))

/** BAS R}h(6rbg) yA */
#define	AG903_OSP_CMD_BAS_SIZE				(63)

/** BAB R}h(6rbg) f[^ */
#define	AG903_OSP_CMD_BAB_SIZE				(63)

/** R}ho^̃R}htH[}bg<p>
	0:p[XȂ 1:p[Xs */
#define	AG903_OSP_CMD_PARSE					(0)

/** OSPnh */
typedef uint32_t	AG903_OSPMgrHandle;

/** R}hobt@ */
typedef struct _AG903_OSPCmdBuf {

	uint32_t			*addr;	/** obt@|C^ */
	uint32_t			size;	/** obt@TCY	 */
	AG903_OSPMgrBufMode	mode;	/** obt@[h	 */

}	AG903_OSPCmdBuf;


/*************************************************************************************
 * vg^Cv`
 ************************************************************************************/
int32_t AG903_OSPMgrInit(void);
int32_t AG903_OSPMgrGetHandle(AG903_OSPMgrHandle **handle);
int32_t AG903_OSPMgrReleaseHandle(AG903_OSPMgrHandle *handle);
int32_t AG903_OSPMgrEnable(AG903_OSPMgrHandle *handle);
int32_t AG903_OSPMgrDisable(AG903_OSPMgrHandle *handle);
int32_t AG903_OSPMgrSetPriority(AG903_OSPMgrHandle *handle, uint8_t priority);
int32_t AG903_OSPMgrGetStat(AG903_OSPMgrHandle *handle, uint8_t *stat, uint8_t *cnt);
int32_t AG903_OSPMgrGetFIFOStat(AG903_OSPMgrHandle *handle, uint8_t *ovf, uint8_t *siz);
int32_t AG903_OSPMgrSetFlag(uint32_t flag);
int32_t AG903_OSPMgrClearFlag(uint32_t flag);
int32_t AG903_OSPMgrGetFlagStat(uint32_t *flag);
int32_t AG903_OSPMgrSetEventCntEnable(uint32_t evt, uint8_t enable, uint8_t cnt);
int32_t AG903_OSPMgrGetEventStat(uint32_t evt, uint8_t *ovf, uint8_t *cnt);
int32_t AG903_OSPMgrSetFIFO(AG903_OSPMgrHandle *handle, uint32_t setcnt);
int32_t AG903_OSPMgrClearFIFO(AG903_OSPMgrHandle *handle);
int32_t AG903_OSPMgrGetCommandCnt(AG903_OSPMgrHandle *handle, uint32_t *cnt);
int32_t AG903_OSPMgrClearCommand(AG903_OSPMgrHandle *handle);
int32_t AG903_OSPMgrSetCommandBuf(AG903_OSPMgrHandle *handle, AG903_OSPCmdBuf *param, bool init);
int32_t AG903_OSPMgrSetCommand(AG903_OSPMgrHandle *handle, AG903_OSPMgrCmd cmd, uint32_t param);


#ifdef __cplusplus
}
#endif

#endif/* __OSPMGR_H__ */
