/**
 * @brief           OS Wrapper Header
 * @author          AXELL CORPORATION
 * @description     OS Wrapper񋟃wb_B
 * @note            OS WrappergpincludeĉB
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef _OSWRAPPER_H_
#define _OSWRAPPER_H_
/* DOM-IGNORE-END */

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/** LbVy[WTCYi=MMUX[y[WTCYj */
#define AG903_OSW_CACHE_PAGESIZE	(4096)	/** y[WTCY(ύXs) */

/** ݗDxl(0:High`31:Low) */
#define AG903_OSW_DEFAULT_INTRPRI	(20)

/** ݃nh */
#define AG903_OSW_HLNG				(0)

/** ݁iIRQj */
#define AG903_OSW_IRQ_NUM_MAX		(64)

/** ݁iIRQjDx */
#define AG903_OSW_IRQ_PRI_MAX		(32)

/** VRAM */
enum _AG903_OswAttribute {
	AG903_OSW_ATRFIFO=0,		/** IuWFNgiFIFOj */
	AG903_OSW_ATRPRI,			/** IuWFNgiDxj */
	AG903_OSW_ATRNUM,			/** IuWFNg L */
};

/** ^Cvw */
enum _AG903_OswMemType {
	AG903_OSW_NORMAL_CACHE_OFF=0,	/** ^CvwiCACHE OFFj */
	AG903_OSW_NORMAL_CACHE_ON,		/** ^CvwiCACHE ONj */
	AG903_OSW_STRONGLY_ORDERED,		/** ^CvwiSTRONGLY ORDEREDj */
};

/** ϒp[^<p>
    mplatr ͉Ew肵܂B _AG903_OswAttribute<p>
    mpl NULLw肵ꍇ̓J[lmۂ܂B
    ̎ memtype ̐ݒ͖ɂȂ܂BiJ[lgp̈̐ݒɈˑj<p>
    memtype ͉Ew肵܂B _AG903_OswMemType<p>
    Fmpl ŃAhXw莞Ał4KBPʂŃv[쐬܂Bi[؂グj*/
typedef struct _AG903_OSWCMpl {
    uint32_t mplatr;     /**  */
    uint32_t mplsz;      /** v[̃TCY[oCg] */
    void*	 mpl;        /** v[̈̐擪Ԓn */
    int8_t   memtype;    /** ^Cv */
	int8_t   reserve[3]; /** \ */
} AG903_OSWCMpl;

/** ϒXe[^X */
typedef struct _AG903_OSWRMpl {
    int32_t  wtskid;    /** l҂擪^XNID (gp) */
    uint32_t fmplsz;    /** v[̋󂫃TCY[oCg] */
    uint32_t fblksz;	/** l\ȍő僁ubNTCY[oCg] */
} AG903_OSWRMpl;

/** Œ蒷p[^<p>
    mplatr ͉Ew肵܂B _AG903_OswAttribute<p>
    mpf NULLw肵ꍇ̓J[lmۂ܂B
    ̎ memtype ̐ݒ͖ɂȂ܂BiJ[lgp̈̐ݒɈˑj<p>
    memtype ͉Ew肵܂B _AG903_OswMemType<p>
    Fmpf ŃAhXw莞blkcnt~blksz4KB̔{ɂȂ悤Ɏw肵ĉB*/
typedef struct _AG903_OSWCMpf {
	uint32_t mpfatr;		/**  */
	uint32_t blkcnt;		/** lł郁ubN̐ */
	uint32_t blksz;			/** ubÑTCY[oCg] */
	void*	 mpf;			/** v[̈̐擪Ԓn(4KBAC) */
    int8_t   memtype;		/** ^Cv */
	int8_t   reserve[3];	/** \ */
} AG903_OSWCMpf;

/** Œ蒷Xe[^X */
typedef struct _AG903_OSWRMpf {
    int32_t  wtskid;    /** l҂擪^XNID */
    uint32_t fblkcnt;   /** 󂫃ubN */
} AG903_OSWRMpf;

/** ݃nhp[^<p>
    atr ͉Ew肵܂B AG903_OSW_HLNG<p>
    exinf ͊݃T[rX[`ւ̈ɂȂ܂B*/
typedef struct _AG903_OSWCIsr {
	uint32_t  atr;	    /**  */
	void*     exinf;	/** g(荞݃T[rX[`ւ̈ƂĎgp T-Kernelł͏NULL) */
	uint32_t  intno;    /** ݔԍ(0-63) */
    void*     func;     /** ݃T[rX[`̋NԒn([`̌^void(*func)(void *extinf) ) */
} AG903_OSWCIsr;

/** ݃nhXe[^X */
typedef struct _AG903_OSWRIsr {
	uint32_t intno;     /** ݔԍ */
	void*    isr;       /** ݃nh֐̋NԒn */
} AG903_OSWRIsr;


int32_t AG903_OSWprInitMemory(uintptr_t vramtop, uint32_t vramsize);
int32_t AG903_OSWprCreMpl(int32_t mplid, AG903_OSWCMpl* pk_cmpl);
int32_t AG903_OSWprCreMplAuto(AG903_OSWCMpl* pk_cmpl);
int32_t AG903_OSWprDelMpl(int32_t mplid);
int32_t AG903_OSWprGetMpl(int32_t mplid, uint32_t blksz, void** p_blk);
int32_t AG903_OSWprGetMplAlign(int32_t mplid, uint32_t align, uint32_t blksz, void** p_blk);
int32_t AG903_OSWprRelMpl(int32_t mplid, void* blk);
int32_t AG903_OSWprRefMpl(int32_t mplid, AG903_OSWRMpl* pk_rmpl);
int32_t AG903_OSWprCreMpf(int32_t mpfid, AG903_OSWCMpf* pk_cmpf);
int32_t AG903_OSWprCreMpfAuto(AG903_OSWCMpf* pk_cmpf);
int32_t AG903_OSWprDelMpf(int32_t mpfid);
int32_t AG903_OSWprGetMpf(int32_t mpfid, void** p_blk);
int32_t AG903_OSWprRelMpf(int32_t mpfid, void* blk);
int32_t AG903_OSWprRefMpf(int32_t mpfid, AG903_OSWRMpf* pk_rmpf);
int32_t AG903_OSWprIniInt(void);
int32_t AG903_OSWprCreIsrAuto(AG903_OSWCIsr* pk_cisr);
int32_t AG903_OSWprDelIsr(int32_t isrid);
int32_t AG903_OSWprRefIsr(int32_t isrid, AG903_OSWRIsr* pk_risr);
int32_t AG903_OSWprDisInt(uint32_t intno);
int32_t AG903_OSWprEnaInt(uint32_t intno);
int32_t AG903_OSWprChgIms(uint32_t imask);
int32_t AG903_OSWprGetIms(uint32_t* p_imask);
int32_t AG903_OSWprSetIpri(uint32_t intno, uint8_t intpri);

#ifdef __cplusplus
}
#endif
#endif /* _OSWRAPPER_H_ */
