/**
 * @brief           OSP Register Definition
 * @author          AXELL CORPORATION
 * @description     OSP Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_OSP_REGMAP_H_
#define _AG903_OSP_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** OSPn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CTRL;

        struct {
            __IO uint32_t  EN                             :  1;
        } CTRL_bits;
    };

    union {
        __IO uint32_t  PRIOR;

        struct {
            __IO uint32_t  PRIOR                          :  2;
        } PRIOR_bits;
    };

    union {
        __I  uint32_t  FIFOSTAT;

        struct {
            __I  uint32_t  SIZE                           :  8;
                 uint32_t                                 :  8;
            __I  uint32_t  OVF                            :  1;
        } FIFOSTAT_bits;
    };

    union {
        __O  uint32_t  FIFOCTRL;

        struct {
            __O  uint32_t  CLR                            :  1;
        } FIFOCTRL_bits;
    };

    union {
        __O  uint32_t  FIFODT;
    };

    __I  uint32_t  RESERVED1[1];

    union {
        __I  uint32_t  STAT;

        struct {
            __I  uint32_t  COUNT                          :  6;
                 uint32_t                                 : 10;
            __I  uint32_t  STAT                           :  4;
        } STAT_bits;
    };

/* DOM-IGNORE-END */
}AG903_OSPn_Type;

/** OSP Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  EVENT0;

        struct {
            __IO uint32_t  VAL0                           :  4;
            __IO uint32_t  OVF0                           :  1;
            __IO uint32_t  EN0                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL1                           :  4;
            __IO uint32_t  OVF1                           :  1;
            __IO uint32_t  EN1                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL2                           :  4;
            __IO uint32_t  OVF2                           :  1;
            __IO uint32_t  EN2                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL3                           :  4;
            __IO uint32_t  OVF3                           :  1;
            __IO uint32_t  EN3                            :  1;
        } EVENT0_bits;
    };

    union {
        __IO uint32_t  EVENT1;

        struct {
            __IO uint32_t  VAL4                           :  4;
            __IO uint32_t  OVF4                           :  1;
            __IO uint32_t  EN4                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL5                           :  4;
            __IO uint32_t  OVF5                           :  1;
            __IO uint32_t  EN5                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL6                           :  4;
            __IO uint32_t  OVF6                           :  1;
            __IO uint32_t  EN6                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL7                           :  4;
            __IO uint32_t  OVF7                           :  1;
            __IO uint32_t  EN7                            :  1;
        } EVENT1_bits;
    };

    union {
        __IO uint32_t  EVENT2;

        struct {
            __IO uint32_t  VAL8                           :  4;
            __IO uint32_t  OVF8                           :  1;
            __IO uint32_t  EN8                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL9                           :  4;
            __IO uint32_t  OVF9                           :  1;
            __IO uint32_t  EN9                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL10                          :  4;
            __IO uint32_t  OVF10                          :  1;
            __IO uint32_t  EN10                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL11                          :  4;
            __IO uint32_t  OVF11                          :  1;
            __IO uint32_t  EN11                           :  1;
        } EVENT2_bits;
    };

    union {
        __IO uint32_t  EVENT3;

        struct {
            __IO uint32_t  VAL12                          :  4;
            __IO uint32_t  OVF12                          :  1;
            __IO uint32_t  EN12                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL13                          :  4;
            __IO uint32_t  OVF13                          :  1;
            __IO uint32_t  EN13                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL14                          :  4;
            __IO uint32_t  OVF14                          :  1;
            __IO uint32_t  EN14                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL15                          :  4;
            __IO uint32_t  OVF15                          :  1;
            __IO uint32_t  EN15                           :  1;
        } EVENT3_bits;
    };

    union {
        __IO uint32_t  EVENT4;

        struct {
            __IO uint32_t  VAL16                          :  4;
            __IO uint32_t  OVF16                          :  1;
            __IO uint32_t  EN16                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL17                          :  4;
            __IO uint32_t  OVF17                          :  1;
            __IO uint32_t  EN17                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL18                          :  4;
            __IO uint32_t  OVF18                          :  1;
            __IO uint32_t  EN18                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL19                          :  4;
            __IO uint32_t  OVF19                          :  1;
            __IO uint32_t  EN19                           :  1;
        } EVENT4_bits;
    };

    union {
        __IO uint32_t  EVENT5;

        struct {
            __IO uint32_t  VAL20                          :  4;
            __IO uint32_t  OVF20                          :  1;
            __IO uint32_t  EN20                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL21                          :  4;
            __IO uint32_t  OVF21                          :  1;
            __IO uint32_t  EN21                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL22                          :  4;
            __IO uint32_t  OVF22                          :  1;
            __IO uint32_t  EN22                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL23                          :  4;
            __IO uint32_t  OVF23                          :  1;
            __IO uint32_t  EN23                           :  1;
        } EVENT5_bits;
    };

    union {
        __IO uint32_t  EVENT6;

        struct {
            __IO uint32_t  VAL24                          :  4;
            __IO uint32_t  OVF24                          :  1;
            __IO uint32_t  EN24                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL25                          :  4;
            __IO uint32_t  OVF25                          :  1;
            __IO uint32_t  EN25                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL26                          :  4;
            __IO uint32_t  OVF26                          :  1;
            __IO uint32_t  EN26                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL27                          :  4;
            __IO uint32_t  OVF27                          :  1;
            __IO uint32_t  EN27                           :  1;
        } EVENT6_bits;
    };

    union {
        __IO uint32_t  EVENT7;

        struct {
            __IO uint32_t  VAL28                          :  4;
            __IO uint32_t  OVF28                          :  1;
            __IO uint32_t  EN28                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL29                          :  4;
            __IO uint32_t  OVF29                          :  1;
            __IO uint32_t  EN29                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL30                          :  4;
            __IO uint32_t  OVF30                          :  1;
            __IO uint32_t  EN30                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL31                          :  4;
            __IO uint32_t  OVF31                          :  1;
            __IO uint32_t  EN31                           :  1;
        } EVENT7_bits;
    };

    union {
        __IO uint32_t  EVENT8;

        struct {
            __IO uint32_t  VAL32                          :  4;
            __IO uint32_t  OVF32                          :  1;
            __IO uint32_t  EN32                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL33                          :  4;
            __IO uint32_t  OVF33                          :  1;
            __IO uint32_t  EN33                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL34                          :  4;
            __IO uint32_t  OVF34                          :  1;
            __IO uint32_t  EN34                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL35                          :  4;
            __IO uint32_t  OVF35                          :  1;
            __IO uint32_t  EN35                           :  1;
        } EVENT8_bits;
    };

    union {
        __IO uint32_t  EVENT9;

        struct {
            __IO uint32_t  VAL36                          :  4;
            __IO uint32_t  OVF36                          :  1;
            __IO uint32_t  EN36                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL37                          :  4;
            __IO uint32_t  OVF37                          :  1;
            __IO uint32_t  EN37                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL38                          :  4;
            __IO uint32_t  OVF38                          :  1;
            __IO uint32_t  EN38                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL39                          :  4;
            __IO uint32_t  OVF39                          :  1;
            __IO uint32_t  EN39                           :  1;
        } EVENT9_bits;
    };

    union {
        __IO uint32_t  EVENT10;

        struct {
            __IO uint32_t  VAL40                          :  4;
            __IO uint32_t  OVF40                          :  1;
            __IO uint32_t  EN40                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL41                          :  4;
            __IO uint32_t  OVF41                          :  1;
            __IO uint32_t  EN41                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL42                          :  4;
            __IO uint32_t  OVF42                          :  1;
            __IO uint32_t  EN42                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL43                          :  4;
            __IO uint32_t  OVF43                          :  1;
            __IO uint32_t  EN43                           :  1;
        } EVENT10_bits;
    };

    union {
        __IO uint32_t  EVENT11;

        struct {
            __IO uint32_t  VAL44                          :  4;
            __IO uint32_t  OVF44                          :  1;
            __IO uint32_t  EN44                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL45                          :  4;
            __IO uint32_t  OVF45                          :  1;
            __IO uint32_t  EN45                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL46                          :  4;
            __IO uint32_t  OVF46                          :  1;
            __IO uint32_t  EN46                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL47                          :  4;
            __IO uint32_t  OVF47                          :  1;
            __IO uint32_t  EN47                           :  1;
        } EVENT11_bits;
    };

    union {
        __IO uint32_t  EVENT12;

        struct {
            __IO uint32_t  VAL48                          :  4;
            __IO uint32_t  OVF48                          :  1;
            __IO uint32_t  EN48                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL49                          :  4;
            __IO uint32_t  OVF49                          :  1;
            __IO uint32_t  EN49                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL50                          :  4;
            __IO uint32_t  OVF50                          :  1;
            __IO uint32_t  EN50                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL51                          :  4;
            __IO uint32_t  OVF51                          :  1;
            __IO uint32_t  EN51                           :  1;
        } EVENT12_bits;
    };

    union {
        __IO uint32_t  EVENT13;

        struct {
            __IO uint32_t  VAL52                          :  4;
            __IO uint32_t  OVF52                          :  1;
            __IO uint32_t  EN52                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL53                          :  4;
            __IO uint32_t  OVF53                          :  1;
            __IO uint32_t  EN53                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL54                          :  4;
            __IO uint32_t  OVF54                          :  1;
            __IO uint32_t  EN54                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL55                          :  4;
            __IO uint32_t  OVF55                          :  1;
            __IO uint32_t  EN55                           :  1;
        } EVENT13_bits;
    };

    union {
        __IO uint32_t  EVENT14;

        struct {
            __IO uint32_t  VAL56                          :  4;
            __IO uint32_t  OVF56                          :  1;
            __IO uint32_t  EN56                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL57                          :  4;
            __IO uint32_t  OVF57                          :  1;
            __IO uint32_t  EN57                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL58                          :  4;
            __IO uint32_t  OVF58                          :  1;
            __IO uint32_t  EN58                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL59                          :  4;
            __IO uint32_t  OVF59                          :  1;
            __IO uint32_t  EN59                           :  1;
        } EVENT14_bits;
    };

    union {
        __IO uint32_t  EVENT15;

        struct {
            __IO uint32_t  VAL60                          :  4;
            __IO uint32_t  OVF60                          :  1;
            __IO uint32_t  EN60                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL61                          :  4;
            __IO uint32_t  OVF61                          :  1;
            __IO uint32_t  EN61                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL62                          :  4;
            __IO uint32_t  OVF62                          :  1;
            __IO uint32_t  EN62                           :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VAL63                          :  4;
            __IO uint32_t  OVF63                          :  1;
            __IO uint32_t  EN63                           :  1;
        } EVENT15_bits;
    };

    union {
        __O  uint32_t  FLAGSET;

        struct {
            __O  uint32_t  F                              : 28;
        } FLAGSET_bits;
    };

    union {
        __O  uint32_t  FLAGCLR;

        struct {
            __O  uint32_t  F                              : 28;
        } FLAGCLR_bits;
    };

    union {
        __I  uint32_t  FLAGSTAT;

        struct {
            __I  uint32_t  F                              : 28;
        } FLAGSTAT_bits;
    };

/* DOM-IGNORE-END */
}AG903_OSP_Type;

#define AG903_OSPn(ch)                           ((volatile AG903_OSPn_Type *)(AG903_OSP0_BASE + 0x20 * ch))             /** OSPn Base Address (n=0..3) */
#define AG903_OSPn_CTRL(ch)                      AG903_OSPn(ch)->CTRL                                                    /** OSPnCTRL Address (n=0..3) */
#define AG903_OSPn_PRIOR(ch)                     AG903_OSPn(ch)->PRIOR                                                   /** OSPnPRIOR Address (n=0..3) */
#define AG903_OSPn_FIFOSTAT(ch)                  AG903_OSPn(ch)->FIFOSTAT                                                /** OSPnFIFOSTAT Address (n=0..3) */
#define AG903_OSPn_FIFOCTRL(ch)                  AG903_OSPn(ch)->FIFOCTRL                                                /** OSPnFIFOCTRL Address (n=0..3) */
#define AG903_OSPn_FIFODT(ch)                    AG903_OSPn(ch)->FIFODT                                                  /** OSPnFIFODT Address (n=0..3) */
#define AG903_OSPn_STAT(ch)                      AG903_OSPn(ch)->STAT                                                    /** OSPnSTAT Address (n=0..3) */

#define AG903_OSP0                               ((volatile AG903_OSPn_Type *) AG903_OSP0_BASE)                          /** OSPn Base Address */
#define AG903_OSP1                               ((volatile AG903_OSPn_Type *) AG903_OSP1_BASE)                          /** OSPn Base Address */
#define AG903_OSP2                               ((volatile AG903_OSPn_Type *) AG903_OSP2_BASE)                          /** OSPn Base Address */
#define AG903_OSP3                               ((volatile AG903_OSPn_Type *) AG903_OSP3_BASE)                          /** OSPn Base Address */
#define AG903_OSP                                ((volatile AG903_OSP_Type *) AG903_OSP_BASE)                            /** OSP Base Address */


#define AG903_OSPn_CTRL_EN_POS                             0                                                             /** OSPnCTRL EN-bit position */
#define AG903_OSPn_CTRL_EN_MSK                             (0x1UL << AG903_OSPn_CTRL_EN_POS)                             /** OSPnCTRL EN-bit mask */

#define AG903_OSPn_PRIOR_PRIOR_POS                         0                                                             /** OSPnPRIOR PRIOR-bit position */
#define AG903_OSPn_PRIOR_PRIOR_MSK                         (0x3UL << AG903_OSPn_PRIOR_PRIOR_POS)                         /** OSPnPRIOR PRIOR-bit mask */

#define AG903_OSPn_FIFOSTAT_SIZE_POS                       0                                                             /** OSPnFIFOSTAT SIZE-bit position */
#define AG903_OSPn_FIFOSTAT_SIZE_MSK                       (0xffUL << AG903_OSPn_FIFOSTAT_SIZE_POS)                      /** OSPnFIFOSTAT SIZE-bit mask */
#define AG903_OSPn_FIFOSTAT_OVF_POS                        16                                                            /** OSPnFIFOSTAT OVF-bit position */
#define AG903_OSPn_FIFOSTAT_OVF_MSK                        (0x1UL << AG903_OSPn_FIFOSTAT_OVF_POS)                        /** OSPnFIFOSTAT OVF-bit mask */

#define AG903_OSPn_FIFOCTRL_CLR_POS                        0                                                             /** OSPnFIFOCTRL CLR-bit position */
#define AG903_OSPn_FIFOCTRL_CLR_MSK                        (0x1UL << AG903_OSPn_FIFOCTRL_CLR_POS)                        /** OSPnFIFOCTRL CLR-bit mask */

#define AG903_OSPn_FIFODT_DATA_POS                         0                                                             /** OSPnFIFODT DATA-bit position */
#define AG903_OSPn_FIFODT_DATA_MSK                         (0xffffffffUL << AG903_OSPn_FIFODT_DATA_POS)                  /** OSPnFIFODT DATA-bit mask */

#define AG903_OSPn_STAT_COUNT_POS                          0                                                             /** OSPnSTAT COUNT-bit position */
#define AG903_OSPn_STAT_COUNT_MSK                          (0x3fUL << AG903_OSPn_STAT_COUNT_POS)                         /** OSPnSTAT COUNT-bit mask */
#define AG903_OSPn_STAT_STAT_POS                           16                                                            /** OSPnSTAT STAT-bit position */
#define AG903_OSPn_STAT_STAT_MSK                           (0xfUL << AG903_OSPn_STAT_STAT_POS)                           /** OSPnSTAT STAT-bit mask */


#define AG903_OSP_EVENT0_VAL0_POS                          0                                                             /** OSPEVENT0 VAL0-bit position */
#define AG903_OSP_EVENT0_VAL0_MSK                          (0xfUL << AG903_OSP_EVENT0_VAL0_POS)                          /** OSPEVENT0 VAL0-bit mask */
#define AG903_OSP_EVENT0_OVF0_POS                          4                                                             /** OSPEVENT0 OVF0-bit position */
#define AG903_OSP_EVENT0_OVF0_MSK                          (0x1UL << AG903_OSP_EVENT0_OVF0_POS)                          /** OSPEVENT0 OVF0-bit mask */
#define AG903_OSP_EVENT0_EN0_POS                           5                                                             /** OSPEVENT0 EN0-bit position */
#define AG903_OSP_EVENT0_EN0_MSK                           (0x1UL << AG903_OSP_EVENT0_EN0_POS)                           /** OSPEVENT0 EN0-bit mask */
#define AG903_OSP_EVENT0_VAL1_POS                          8                                                             /** OSPEVENT0 VAL1-bit position */
#define AG903_OSP_EVENT0_VAL1_MSK                          (0xfUL << AG903_OSP_EVENT0_VAL1_POS)                          /** OSPEVENT0 VAL1-bit mask */
#define AG903_OSP_EVENT0_OVF1_POS                          12                                                            /** OSPEVENT0 OVF1-bit position */
#define AG903_OSP_EVENT0_OVF1_MSK                          (0x1UL << AG903_OSP_EVENT0_OVF1_POS)                          /** OSPEVENT0 OVF1-bit mask */
#define AG903_OSP_EVENT0_EN1_POS                           13                                                            /** OSPEVENT0 EN1-bit position */
#define AG903_OSP_EVENT0_EN1_MSK                           (0x1UL << AG903_OSP_EVENT0_EN1_POS)                           /** OSPEVENT0 EN1-bit mask */
#define AG903_OSP_EVENT0_VAL2_POS                          16                                                            /** OSPEVENT0 VAL2-bit position */
#define AG903_OSP_EVENT0_VAL2_MSK                          (0xfUL << AG903_OSP_EVENT0_VAL2_POS)                          /** OSPEVENT0 VAL2-bit mask */
#define AG903_OSP_EVENT0_OVF2_POS                          20                                                            /** OSPEVENT0 OVF2-bit position */
#define AG903_OSP_EVENT0_OVF2_MSK                          (0x1UL << AG903_OSP_EVENT0_OVF2_POS)                          /** OSPEVENT0 OVF2-bit mask */
#define AG903_OSP_EVENT0_EN2_POS                           21                                                            /** OSPEVENT0 EN2-bit position */
#define AG903_OSP_EVENT0_EN2_MSK                           (0x1UL << AG903_OSP_EVENT0_EN2_POS)                           /** OSPEVENT0 EN2-bit mask */
#define AG903_OSP_EVENT0_VAL3_POS                          24                                                            /** OSPEVENT0 VAL3-bit position */
#define AG903_OSP_EVENT0_VAL3_MSK                          (0xfUL << AG903_OSP_EVENT0_VAL3_POS)                          /** OSPEVENT0 VAL3-bit mask */
#define AG903_OSP_EVENT0_OVF3_POS                          28                                                            /** OSPEVENT0 OVF3-bit position */
#define AG903_OSP_EVENT0_OVF3_MSK                          (0x1UL << AG903_OSP_EVENT0_OVF3_POS)                          /** OSPEVENT0 OVF3-bit mask */
#define AG903_OSP_EVENT0_EN3_POS                           29                                                            /** OSPEVENT0 EN3-bit position */
#define AG903_OSP_EVENT0_EN3_MSK                           (0x1UL << AG903_OSP_EVENT0_EN3_POS)                           /** OSPEVENT0 EN3-bit mask */

#define AG903_OSP_EVENT1_VAL4_POS                          0                                                             /** OSPEVENT1 VAL4-bit position */
#define AG903_OSP_EVENT1_VAL4_MSK                          (0xfUL << AG903_OSP_EVENT1_VAL4_POS)                          /** OSPEVENT1 VAL4-bit mask */
#define AG903_OSP_EVENT1_OVF4_POS                          4                                                             /** OSPEVENT1 OVF4-bit position */
#define AG903_OSP_EVENT1_OVF4_MSK                          (0x1UL << AG903_OSP_EVENT1_OVF4_POS)                          /** OSPEVENT1 OVF4-bit mask */
#define AG903_OSP_EVENT1_EN4_POS                           5                                                             /** OSPEVENT1 EN4-bit position */
#define AG903_OSP_EVENT1_EN4_MSK                           (0x1UL << AG903_OSP_EVENT1_EN4_POS)                           /** OSPEVENT1 EN4-bit mask */
#define AG903_OSP_EVENT1_VAL5_POS                          8                                                             /** OSPEVENT1 VAL5-bit position */
#define AG903_OSP_EVENT1_VAL5_MSK                          (0xfUL << AG903_OSP_EVENT1_VAL5_POS)                          /** OSPEVENT1 VAL5-bit mask */
#define AG903_OSP_EVENT1_OVF5_POS                          12                                                            /** OSPEVENT1 OVF5-bit position */
#define AG903_OSP_EVENT1_OVF5_MSK                          (0x1UL << AG903_OSP_EVENT1_OVF5_POS)                          /** OSPEVENT1 OVF5-bit mask */
#define AG903_OSP_EVENT1_EN5_POS                           13                                                            /** OSPEVENT1 EN5-bit position */
#define AG903_OSP_EVENT1_EN5_MSK                           (0x1UL << AG903_OSP_EVENT1_EN5_POS)                           /** OSPEVENT1 EN5-bit mask */
#define AG903_OSP_EVENT1_VAL6_POS                          16                                                            /** OSPEVENT1 VAL6-bit position */
#define AG903_OSP_EVENT1_VAL6_MSK                          (0xfUL << AG903_OSP_EVENT1_VAL6_POS)                          /** OSPEVENT1 VAL6-bit mask */
#define AG903_OSP_EVENT1_OVF6_POS                          20                                                            /** OSPEVENT1 OVF6-bit position */
#define AG903_OSP_EVENT1_OVF6_MSK                          (0x1UL << AG903_OSP_EVENT1_OVF6_POS)                          /** OSPEVENT1 OVF6-bit mask */
#define AG903_OSP_EVENT1_EN6_POS                           21                                                            /** OSPEVENT1 EN6-bit position */
#define AG903_OSP_EVENT1_EN6_MSK                           (0x1UL << AG903_OSP_EVENT1_EN6_POS)                           /** OSPEVENT1 EN6-bit mask */
#define AG903_OSP_EVENT1_VAL7_POS                          24                                                            /** OSPEVENT1 VAL7-bit position */
#define AG903_OSP_EVENT1_VAL7_MSK                          (0xfUL << AG903_OSP_EVENT1_VAL7_POS)                          /** OSPEVENT1 VAL7-bit mask */
#define AG903_OSP_EVENT1_OVF7_POS                          28                                                            /** OSPEVENT1 OVF7-bit position */
#define AG903_OSP_EVENT1_OVF7_MSK                          (0x1UL << AG903_OSP_EVENT1_OVF7_POS)                          /** OSPEVENT1 OVF7-bit mask */
#define AG903_OSP_EVENT1_EN7_POS                           29                                                            /** OSPEVENT1 EN7-bit position */
#define AG903_OSP_EVENT1_EN7_MSK                           (0x1UL << AG903_OSP_EVENT1_EN7_POS)                           /** OSPEVENT1 EN7-bit mask */

#define AG903_OSP_EVENT2_VAL8_POS                          0                                                             /** OSPEVENT2 VAL8-bit position */
#define AG903_OSP_EVENT2_VAL8_MSK                          (0xfUL << AG903_OSP_EVENT2_VAL8_POS)                          /** OSPEVENT2 VAL8-bit mask */
#define AG903_OSP_EVENT2_OVF8_POS                          4                                                             /** OSPEVENT2 OVF8-bit position */
#define AG903_OSP_EVENT2_OVF8_MSK                          (0x1UL << AG903_OSP_EVENT2_OVF8_POS)                          /** OSPEVENT2 OVF8-bit mask */
#define AG903_OSP_EVENT2_EN8_POS                           5                                                             /** OSPEVENT2 EN8-bit position */
#define AG903_OSP_EVENT2_EN8_MSK                           (0x1UL << AG903_OSP_EVENT2_EN8_POS)                           /** OSPEVENT2 EN8-bit mask */
#define AG903_OSP_EVENT2_VAL9_POS                          8                                                             /** OSPEVENT2 VAL9-bit position */
#define AG903_OSP_EVENT2_VAL9_MSK                          (0xfUL << AG903_OSP_EVENT2_VAL9_POS)                          /** OSPEVENT2 VAL9-bit mask */
#define AG903_OSP_EVENT2_OVF9_POS                          12                                                            /** OSPEVENT2 OVF9-bit position */
#define AG903_OSP_EVENT2_OVF9_MSK                          (0x1UL << AG903_OSP_EVENT2_OVF9_POS)                          /** OSPEVENT2 OVF9-bit mask */
#define AG903_OSP_EVENT2_EN9_POS                           13                                                            /** OSPEVENT2 EN9-bit position */
#define AG903_OSP_EVENT2_EN9_MSK                           (0x1UL << AG903_OSP_EVENT2_EN9_POS)                           /** OSPEVENT2 EN9-bit mask */
#define AG903_OSP_EVENT2_VAL10_POS                         16                                                            /** OSPEVENT2 VAL10-bit position */
#define AG903_OSP_EVENT2_VAL10_MSK                         (0xfUL << AG903_OSP_EVENT2_VAL10_POS)                         /** OSPEVENT2 VAL10-bit mask */
#define AG903_OSP_EVENT2_OVF10_POS                         20                                                            /** OSPEVENT2 OVF10-bit position */
#define AG903_OSP_EVENT2_OVF10_MSK                         (0x1UL << AG903_OSP_EVENT2_OVF10_POS)                         /** OSPEVENT2 OVF10-bit mask */
#define AG903_OSP_EVENT2_EN10_POS                          21                                                            /** OSPEVENT2 EN10-bit position */
#define AG903_OSP_EVENT2_EN10_MSK                          (0x1UL << AG903_OSP_EVENT2_EN10_POS)                          /** OSPEVENT2 EN10-bit mask */
#define AG903_OSP_EVENT2_VAL11_POS                         24                                                            /** OSPEVENT2 VAL11-bit position */
#define AG903_OSP_EVENT2_VAL11_MSK                         (0xfUL << AG903_OSP_EVENT2_VAL11_POS)                         /** OSPEVENT2 VAL11-bit mask */
#define AG903_OSP_EVENT2_OVF11_POS                         28                                                            /** OSPEVENT2 OVF11-bit position */
#define AG903_OSP_EVENT2_OVF11_MSK                         (0x1UL << AG903_OSP_EVENT2_OVF11_POS)                         /** OSPEVENT2 OVF11-bit mask */
#define AG903_OSP_EVENT2_EN11_POS                          29                                                            /** OSPEVENT2 EN11-bit position */
#define AG903_OSP_EVENT2_EN11_MSK                          (0x1UL << AG903_OSP_EVENT2_EN11_POS)                          /** OSPEVENT2 EN11-bit mask */

#define AG903_OSP_EVENT3_VAL12_POS                         0                                                             /** OSPEVENT3 VAL12-bit position */
#define AG903_OSP_EVENT3_VAL12_MSK                         (0xfUL << AG903_OSP_EVENT3_VAL12_POS)                         /** OSPEVENT3 VAL12-bit mask */
#define AG903_OSP_EVENT3_OVF12_POS                         4                                                             /** OSPEVENT3 OVF12-bit position */
#define AG903_OSP_EVENT3_OVF12_MSK                         (0x1UL << AG903_OSP_EVENT3_OVF12_POS)                         /** OSPEVENT3 OVF12-bit mask */
#define AG903_OSP_EVENT3_EN12_POS                          5                                                             /** OSPEVENT3 EN12-bit position */
#define AG903_OSP_EVENT3_EN12_MSK                          (0x1UL << AG903_OSP_EVENT3_EN12_POS)                          /** OSPEVENT3 EN12-bit mask */
#define AG903_OSP_EVENT3_VAL13_POS                         8                                                             /** OSPEVENT3 VAL13-bit position */
#define AG903_OSP_EVENT3_VAL13_MSK                         (0xfUL << AG903_OSP_EVENT3_VAL13_POS)                         /** OSPEVENT3 VAL13-bit mask */
#define AG903_OSP_EVENT3_OVF13_POS                         12                                                            /** OSPEVENT3 OVF13-bit position */
#define AG903_OSP_EVENT3_OVF13_MSK                         (0x1UL << AG903_OSP_EVENT3_OVF13_POS)                         /** OSPEVENT3 OVF13-bit mask */
#define AG903_OSP_EVENT3_EN13_POS                          13                                                            /** OSPEVENT3 EN13-bit position */
#define AG903_OSP_EVENT3_EN13_MSK                          (0x1UL << AG903_OSP_EVENT3_EN13_POS)                          /** OSPEVENT3 EN13-bit mask */
#define AG903_OSP_EVENT3_VAL14_POS                         16                                                            /** OSPEVENT3 VAL14-bit position */
#define AG903_OSP_EVENT3_VAL14_MSK                         (0xfUL << AG903_OSP_EVENT3_VAL14_POS)                         /** OSPEVENT3 VAL14-bit mask */
#define AG903_OSP_EVENT3_OVF14_POS                         20                                                            /** OSPEVENT3 OVF14-bit position */
#define AG903_OSP_EVENT3_OVF14_MSK                         (0x1UL << AG903_OSP_EVENT3_OVF14_POS)                         /** OSPEVENT3 OVF14-bit mask */
#define AG903_OSP_EVENT3_EN14_POS                          21                                                            /** OSPEVENT3 EN14-bit position */
#define AG903_OSP_EVENT3_EN14_MSK                          (0x1UL << AG903_OSP_EVENT3_EN14_POS)                          /** OSPEVENT3 EN14-bit mask */
#define AG903_OSP_EVENT3_VAL15_POS                         24                                                            /** OSPEVENT3 VAL15-bit position */
#define AG903_OSP_EVENT3_VAL15_MSK                         (0xfUL << AG903_OSP_EVENT3_VAL15_POS)                         /** OSPEVENT3 VAL15-bit mask */
#define AG903_OSP_EVENT3_OVF15_POS                         28                                                            /** OSPEVENT3 OVF15-bit position */
#define AG903_OSP_EVENT3_OVF15_MSK                         (0x1UL << AG903_OSP_EVENT3_OVF15_POS)                         /** OSPEVENT3 OVF15-bit mask */
#define AG903_OSP_EVENT3_EN15_POS                          29                                                            /** OSPEVENT3 EN15-bit position */
#define AG903_OSP_EVENT3_EN15_MSK                          (0x1UL << AG903_OSP_EVENT3_EN15_POS)                          /** OSPEVENT3 EN15-bit mask */

#define AG903_OSP_EVENT4_VAL16_POS                         0                                                             /** OSPEVENT4 VAL16-bit position */
#define AG903_OSP_EVENT4_VAL16_MSK                         (0xfUL << AG903_OSP_EVENT4_VAL16_POS)                         /** OSPEVENT4 VAL16-bit mask */
#define AG903_OSP_EVENT4_OVF16_POS                         4                                                             /** OSPEVENT4 OVF16-bit position */
#define AG903_OSP_EVENT4_OVF16_MSK                         (0x1UL << AG903_OSP_EVENT4_OVF16_POS)                         /** OSPEVENT4 OVF16-bit mask */
#define AG903_OSP_EVENT4_EN16_POS                          5                                                             /** OSPEVENT4 EN16-bit position */
#define AG903_OSP_EVENT4_EN16_MSK                          (0x1UL << AG903_OSP_EVENT4_EN16_POS)                          /** OSPEVENT4 EN16-bit mask */
#define AG903_OSP_EVENT4_VAL17_POS                         8                                                             /** OSPEVENT4 VAL17-bit position */
#define AG903_OSP_EVENT4_VAL17_MSK                         (0xfUL << AG903_OSP_EVENT4_VAL17_POS)                         /** OSPEVENT4 VAL17-bit mask */
#define AG903_OSP_EVENT4_OVF17_POS                         12                                                            /** OSPEVENT4 OVF17-bit position */
#define AG903_OSP_EVENT4_OVF17_MSK                         (0x1UL << AG903_OSP_EVENT4_OVF17_POS)                         /** OSPEVENT4 OVF17-bit mask */
#define AG903_OSP_EVENT4_EN17_POS                          13                                                            /** OSPEVENT4 EN17-bit position */
#define AG903_OSP_EVENT4_EN17_MSK                          (0x1UL << AG903_OSP_EVENT4_EN17_POS)                          /** OSPEVENT4 EN17-bit mask */
#define AG903_OSP_EVENT4_VAL18_POS                         16                                                            /** OSPEVENT4 VAL18-bit position */
#define AG903_OSP_EVENT4_VAL18_MSK                         (0xfUL << AG903_OSP_EVENT4_VAL18_POS)                         /** OSPEVENT4 VAL18-bit mask */
#define AG903_OSP_EVENT4_OVF18_POS                         20                                                            /** OSPEVENT4 OVF18-bit position */
#define AG903_OSP_EVENT4_OVF18_MSK                         (0x1UL << AG903_OSP_EVENT4_OVF18_POS)                         /** OSPEVENT4 OVF18-bit mask */
#define AG903_OSP_EVENT4_EN18_POS                          21                                                            /** OSPEVENT4 EN18-bit position */
#define AG903_OSP_EVENT4_EN18_MSK                          (0x1UL << AG903_OSP_EVENT4_EN18_POS)                          /** OSPEVENT4 EN18-bit mask */
#define AG903_OSP_EVENT4_VAL19_POS                         24                                                            /** OSPEVENT4 VAL19-bit position */
#define AG903_OSP_EVENT4_VAL19_MSK                         (0xfUL << AG903_OSP_EVENT4_VAL19_POS)                         /** OSPEVENT4 VAL19-bit mask */
#define AG903_OSP_EVENT4_OVF19_POS                         28                                                            /** OSPEVENT4 OVF19-bit position */
#define AG903_OSP_EVENT4_OVF19_MSK                         (0x1UL << AG903_OSP_EVENT4_OVF19_POS)                         /** OSPEVENT4 OVF19-bit mask */
#define AG903_OSP_EVENT4_EN19_POS                          29                                                            /** OSPEVENT4 EN19-bit position */
#define AG903_OSP_EVENT4_EN19_MSK                          (0x1UL << AG903_OSP_EVENT4_EN19_POS)                          /** OSPEVENT4 EN19-bit mask */

#define AG903_OSP_EVENT5_VAL20_POS                         0                                                             /** OSPEVENT5 VAL20-bit position */
#define AG903_OSP_EVENT5_VAL20_MSK                         (0xfUL << AG903_OSP_EVENT5_VAL20_POS)                         /** OSPEVENT5 VAL20-bit mask */
#define AG903_OSP_EVENT5_OVF20_POS                         4                                                             /** OSPEVENT5 OVF20-bit position */
#define AG903_OSP_EVENT5_OVF20_MSK                         (0x1UL << AG903_OSP_EVENT5_OVF20_POS)                         /** OSPEVENT5 OVF20-bit mask */
#define AG903_OSP_EVENT5_EN20_POS                          5                                                             /** OSPEVENT5 EN20-bit position */
#define AG903_OSP_EVENT5_EN20_MSK                          (0x1UL << AG903_OSP_EVENT5_EN20_POS)                          /** OSPEVENT5 EN20-bit mask */
#define AG903_OSP_EVENT5_VAL21_POS                         8                                                             /** OSPEVENT5 VAL21-bit position */
#define AG903_OSP_EVENT5_VAL21_MSK                         (0xfUL << AG903_OSP_EVENT5_VAL21_POS)                         /** OSPEVENT5 VAL21-bit mask */
#define AG903_OSP_EVENT5_OVF21_POS                         12                                                            /** OSPEVENT5 OVF21-bit position */
#define AG903_OSP_EVENT5_OVF21_MSK                         (0x1UL << AG903_OSP_EVENT5_OVF21_POS)                         /** OSPEVENT5 OVF21-bit mask */
#define AG903_OSP_EVENT5_EN21_POS                          13                                                            /** OSPEVENT5 EN21-bit position */
#define AG903_OSP_EVENT5_EN21_MSK                          (0x1UL << AG903_OSP_EVENT5_EN21_POS)                          /** OSPEVENT5 EN21-bit mask */
#define AG903_OSP_EVENT5_VAL22_POS                         16                                                            /** OSPEVENT5 VAL22-bit position */
#define AG903_OSP_EVENT5_VAL22_MSK                         (0xfUL << AG903_OSP_EVENT5_VAL22_POS)                         /** OSPEVENT5 VAL22-bit mask */
#define AG903_OSP_EVENT5_OVF22_POS                         20                                                            /** OSPEVENT5 OVF22-bit position */
#define AG903_OSP_EVENT5_OVF22_MSK                         (0x1UL << AG903_OSP_EVENT5_OVF22_POS)                         /** OSPEVENT5 OVF22-bit mask */
#define AG903_OSP_EVENT5_EN22_POS                          21                                                            /** OSPEVENT5 EN22-bit position */
#define AG903_OSP_EVENT5_EN22_MSK                          (0x1UL << AG903_OSP_EVENT5_EN22_POS)                          /** OSPEVENT5 EN22-bit mask */
#define AG903_OSP_EVENT5_VAL23_POS                         24                                                            /** OSPEVENT5 VAL23-bit position */
#define AG903_OSP_EVENT5_VAL23_MSK                         (0xfUL << AG903_OSP_EVENT5_VAL23_POS)                         /** OSPEVENT5 VAL23-bit mask */
#define AG903_OSP_EVENT5_OVF23_POS                         28                                                            /** OSPEVENT5 OVF23-bit position */
#define AG903_OSP_EVENT5_OVF23_MSK                         (0x1UL << AG903_OSP_EVENT5_OVF23_POS)                         /** OSPEVENT5 OVF23-bit mask */
#define AG903_OSP_EVENT5_EN23_POS                          29                                                            /** OSPEVENT5 EN23-bit position */
#define AG903_OSP_EVENT5_EN23_MSK                          (0x1UL << AG903_OSP_EVENT5_EN23_POS)                          /** OSPEVENT5 EN23-bit mask */

#define AG903_OSP_EVENT6_VAL24_POS                         0                                                             /** OSPEVENT6 VAL24-bit position */
#define AG903_OSP_EVENT6_VAL24_MSK                         (0xfUL << AG903_OSP_EVENT6_VAL24_POS)                         /** OSPEVENT6 VAL24-bit mask */
#define AG903_OSP_EVENT6_OVF24_POS                         4                                                             /** OSPEVENT6 OVF24-bit position */
#define AG903_OSP_EVENT6_OVF24_MSK                         (0x1UL << AG903_OSP_EVENT6_OVF24_POS)                         /** OSPEVENT6 OVF24-bit mask */
#define AG903_OSP_EVENT6_EN24_POS                          5                                                             /** OSPEVENT6 EN24-bit position */
#define AG903_OSP_EVENT6_EN24_MSK                          (0x1UL << AG903_OSP_EVENT6_EN24_POS)                          /** OSPEVENT6 EN24-bit mask */
#define AG903_OSP_EVENT6_VAL25_POS                         8                                                             /** OSPEVENT6 VAL25-bit position */
#define AG903_OSP_EVENT6_VAL25_MSK                         (0xfUL << AG903_OSP_EVENT6_VAL25_POS)                         /** OSPEVENT6 VAL25-bit mask */
#define AG903_OSP_EVENT6_OVF25_POS                         12                                                            /** OSPEVENT6 OVF25-bit position */
#define AG903_OSP_EVENT6_OVF25_MSK                         (0x1UL << AG903_OSP_EVENT6_OVF25_POS)                         /** OSPEVENT6 OVF25-bit mask */
#define AG903_OSP_EVENT6_EN25_POS                          13                                                            /** OSPEVENT6 EN25-bit position */
#define AG903_OSP_EVENT6_EN25_MSK                          (0x1UL << AG903_OSP_EVENT6_EN25_POS)                          /** OSPEVENT6 EN25-bit mask */
#define AG903_OSP_EVENT6_VAL26_POS                         16                                                            /** OSPEVENT6 VAL26-bit position */
#define AG903_OSP_EVENT6_VAL26_MSK                         (0xfUL << AG903_OSP_EVENT6_VAL26_POS)                         /** OSPEVENT6 VAL26-bit mask */
#define AG903_OSP_EVENT6_OVF26_POS                         20                                                            /** OSPEVENT6 OVF26-bit position */
#define AG903_OSP_EVENT6_OVF26_MSK                         (0x1UL << AG903_OSP_EVENT6_OVF26_POS)                         /** OSPEVENT6 OVF26-bit mask */
#define AG903_OSP_EVENT6_EN26_POS                          21                                                            /** OSPEVENT6 EN26-bit position */
#define AG903_OSP_EVENT6_EN26_MSK                          (0x1UL << AG903_OSP_EVENT6_EN26_POS)                          /** OSPEVENT6 EN26-bit mask */
#define AG903_OSP_EVENT6_VAL27_POS                         24                                                            /** OSPEVENT6 VAL27-bit position */
#define AG903_OSP_EVENT6_VAL27_MSK                         (0xfUL << AG903_OSP_EVENT6_VAL27_POS)                         /** OSPEVENT6 VAL27-bit mask */
#define AG903_OSP_EVENT6_OVF27_POS                         28                                                            /** OSPEVENT6 OVF27-bit position */
#define AG903_OSP_EVENT6_OVF27_MSK                         (0x1UL << AG903_OSP_EVENT6_OVF27_POS)                         /** OSPEVENT6 OVF27-bit mask */
#define AG903_OSP_EVENT6_EN27_POS                          29                                                            /** OSPEVENT6 EN27-bit position */
#define AG903_OSP_EVENT6_EN27_MSK                          (0x1UL << AG903_OSP_EVENT6_EN27_POS)                          /** OSPEVENT6 EN27-bit mask */

#define AG903_OSP_EVENT7_VAL28_POS                         0                                                             /** OSPEVENT7 VAL28-bit position */
#define AG903_OSP_EVENT7_VAL28_MSK                         (0xfUL << AG903_OSP_EVENT7_VAL28_POS)                         /** OSPEVENT7 VAL28-bit mask */
#define AG903_OSP_EVENT7_OVF28_POS                         4                                                             /** OSPEVENT7 OVF28-bit position */
#define AG903_OSP_EVENT7_OVF28_MSK                         (0x1UL << AG903_OSP_EVENT7_OVF28_POS)                         /** OSPEVENT7 OVF28-bit mask */
#define AG903_OSP_EVENT7_EN28_POS                          5                                                             /** OSPEVENT7 EN28-bit position */
#define AG903_OSP_EVENT7_EN28_MSK                          (0x1UL << AG903_OSP_EVENT7_EN28_POS)                          /** OSPEVENT7 EN28-bit mask */
#define AG903_OSP_EVENT7_VAL29_POS                         8                                                             /** OSPEVENT7 VAL29-bit position */
#define AG903_OSP_EVENT7_VAL29_MSK                         (0xfUL << AG903_OSP_EVENT7_VAL29_POS)                         /** OSPEVENT7 VAL29-bit mask */
#define AG903_OSP_EVENT7_OVF29_POS                         12                                                            /** OSPEVENT7 OVF29-bit position */
#define AG903_OSP_EVENT7_OVF29_MSK                         (0x1UL << AG903_OSP_EVENT7_OVF29_POS)                         /** OSPEVENT7 OVF29-bit mask */
#define AG903_OSP_EVENT7_EN29_POS                          13                                                            /** OSPEVENT7 EN29-bit position */
#define AG903_OSP_EVENT7_EN29_MSK                          (0x1UL << AG903_OSP_EVENT7_EN29_POS)                          /** OSPEVENT7 EN29-bit mask */
#define AG903_OSP_EVENT7_VAL30_POS                         16                                                            /** OSPEVENT7 VAL30-bit position */
#define AG903_OSP_EVENT7_VAL30_MSK                         (0xfUL << AG903_OSP_EVENT7_VAL30_POS)                         /** OSPEVENT7 VAL30-bit mask */
#define AG903_OSP_EVENT7_OVF30_POS                         20                                                            /** OSPEVENT7 OVF30-bit position */
#define AG903_OSP_EVENT7_OVF30_MSK                         (0x1UL << AG903_OSP_EVENT7_OVF30_POS)                         /** OSPEVENT7 OVF30-bit mask */
#define AG903_OSP_EVENT7_EN30_POS                          21                                                            /** OSPEVENT7 EN30-bit position */
#define AG903_OSP_EVENT7_EN30_MSK                          (0x1UL << AG903_OSP_EVENT7_EN30_POS)                          /** OSPEVENT7 EN30-bit mask */
#define AG903_OSP_EVENT7_VAL31_POS                         24                                                            /** OSPEVENT7 VAL31-bit position */
#define AG903_OSP_EVENT7_VAL31_MSK                         (0xfUL << AG903_OSP_EVENT7_VAL31_POS)                         /** OSPEVENT7 VAL31-bit mask */
#define AG903_OSP_EVENT7_OVF31_POS                         28                                                            /** OSPEVENT7 OVF31-bit position */
#define AG903_OSP_EVENT7_OVF31_MSK                         (0x1UL << AG903_OSP_EVENT7_OVF31_POS)                         /** OSPEVENT7 OVF31-bit mask */
#define AG903_OSP_EVENT7_EN31_POS                          29                                                            /** OSPEVENT7 EN31-bit position */
#define AG903_OSP_EVENT7_EN31_MSK                          (0x1UL << AG903_OSP_EVENT7_EN31_POS)                          /** OSPEVENT7 EN31-bit mask */

#define AG903_OSP_EVENT8_VAL32_POS                         0                                                             /** OSPEVENT8 VAL32-bit position */
#define AG903_OSP_EVENT8_VAL32_MSK                         (0xfUL << AG903_OSP_EVENT8_VAL32_POS)                         /** OSPEVENT8 VAL32-bit mask */
#define AG903_OSP_EVENT8_OVF32_POS                         4                                                             /** OSPEVENT8 OVF32-bit position */
#define AG903_OSP_EVENT8_OVF32_MSK                         (0x1UL << AG903_OSP_EVENT8_OVF32_POS)                         /** OSPEVENT8 OVF32-bit mask */
#define AG903_OSP_EVENT8_EN32_POS                          5                                                             /** OSPEVENT8 EN32-bit position */
#define AG903_OSP_EVENT8_EN32_MSK                          (0x1UL << AG903_OSP_EVENT8_EN32_POS)                          /** OSPEVENT8 EN32-bit mask */
#define AG903_OSP_EVENT8_VAL33_POS                         8                                                             /** OSPEVENT8 VAL33-bit position */
#define AG903_OSP_EVENT8_VAL33_MSK                         (0xfUL << AG903_OSP_EVENT8_VAL33_POS)                         /** OSPEVENT8 VAL33-bit mask */
#define AG903_OSP_EVENT8_OVF33_POS                         12                                                            /** OSPEVENT8 OVF33-bit position */
#define AG903_OSP_EVENT8_OVF33_MSK                         (0x1UL << AG903_OSP_EVENT8_OVF33_POS)                         /** OSPEVENT8 OVF33-bit mask */
#define AG903_OSP_EVENT8_EN33_POS                          13                                                            /** OSPEVENT8 EN33-bit position */
#define AG903_OSP_EVENT8_EN33_MSK                          (0x1UL << AG903_OSP_EVENT8_EN33_POS)                          /** OSPEVENT8 EN33-bit mask */
#define AG903_OSP_EVENT8_VAL34_POS                         16                                                            /** OSPEVENT8 VAL34-bit position */
#define AG903_OSP_EVENT8_VAL34_MSK                         (0xfUL << AG903_OSP_EVENT8_VAL34_POS)                         /** OSPEVENT8 VAL34-bit mask */
#define AG903_OSP_EVENT8_OVF34_POS                         20                                                            /** OSPEVENT8 OVF34-bit position */
#define AG903_OSP_EVENT8_OVF34_MSK                         (0x1UL << AG903_OSP_EVENT8_OVF34_POS)                         /** OSPEVENT8 OVF34-bit mask */
#define AG903_OSP_EVENT8_EN34_POS                          21                                                            /** OSPEVENT8 EN34-bit position */
#define AG903_OSP_EVENT8_EN34_MSK                          (0x1UL << AG903_OSP_EVENT8_EN34_POS)                          /** OSPEVENT8 EN34-bit mask */
#define AG903_OSP_EVENT8_VAL35_POS                         24                                                            /** OSPEVENT8 VAL35-bit position */
#define AG903_OSP_EVENT8_VAL35_MSK                         (0xfUL << AG903_OSP_EVENT8_VAL35_POS)                         /** OSPEVENT8 VAL35-bit mask */
#define AG903_OSP_EVENT8_OVF35_POS                         28                                                            /** OSPEVENT8 OVF35-bit position */
#define AG903_OSP_EVENT8_OVF35_MSK                         (0x1UL << AG903_OSP_EVENT8_OVF35_POS)                         /** OSPEVENT8 OVF35-bit mask */
#define AG903_OSP_EVENT8_EN35_POS                          29                                                            /** OSPEVENT8 EN35-bit position */
#define AG903_OSP_EVENT8_EN35_MSK                          (0x1UL << AG903_OSP_EVENT8_EN35_POS)                          /** OSPEVENT8 EN35-bit mask */

#define AG903_OSP_EVENT9_VAL36_POS                         0                                                             /** OSPEVENT9 VAL36-bit position */
#define AG903_OSP_EVENT9_VAL36_MSK                         (0xfUL << AG903_OSP_EVENT9_VAL36_POS)                         /** OSPEVENT9 VAL36-bit mask */
#define AG903_OSP_EVENT9_OVF36_POS                         4                                                             /** OSPEVENT9 OVF36-bit position */
#define AG903_OSP_EVENT9_OVF36_MSK                         (0x1UL << AG903_OSP_EVENT9_OVF36_POS)                         /** OSPEVENT9 OVF36-bit mask */
#define AG903_OSP_EVENT9_EN36_POS                          5                                                             /** OSPEVENT9 EN36-bit position */
#define AG903_OSP_EVENT9_EN36_MSK                          (0x1UL << AG903_OSP_EVENT9_EN36_POS)                          /** OSPEVENT9 EN36-bit mask */
#define AG903_OSP_EVENT9_VAL37_POS                         8                                                             /** OSPEVENT9 VAL37-bit position */
#define AG903_OSP_EVENT9_VAL37_MSK                         (0xfUL << AG903_OSP_EVENT9_VAL37_POS)                         /** OSPEVENT9 VAL37-bit mask */
#define AG903_OSP_EVENT9_OVF37_POS                         12                                                            /** OSPEVENT9 OVF37-bit position */
#define AG903_OSP_EVENT9_OVF37_MSK                         (0x1UL << AG903_OSP_EVENT9_OVF37_POS)                         /** OSPEVENT9 OVF37-bit mask */
#define AG903_OSP_EVENT9_EN37_POS                          13                                                            /** OSPEVENT9 EN37-bit position */
#define AG903_OSP_EVENT9_EN37_MSK                          (0x1UL << AG903_OSP_EVENT9_EN37_POS)                          /** OSPEVENT9 EN37-bit mask */
#define AG903_OSP_EVENT9_VAL38_POS                         16                                                            /** OSPEVENT9 VAL38-bit position */
#define AG903_OSP_EVENT9_VAL38_MSK                         (0xfUL << AG903_OSP_EVENT9_VAL38_POS)                         /** OSPEVENT9 VAL38-bit mask */
#define AG903_OSP_EVENT9_OVF38_POS                         20                                                            /** OSPEVENT9 OVF38-bit position */
#define AG903_OSP_EVENT9_OVF38_MSK                         (0x1UL << AG903_OSP_EVENT9_OVF38_POS)                         /** OSPEVENT9 OVF38-bit mask */
#define AG903_OSP_EVENT9_EN38_POS                          21                                                            /** OSPEVENT9 EN38-bit position */
#define AG903_OSP_EVENT9_EN38_MSK                          (0x1UL << AG903_OSP_EVENT9_EN38_POS)                          /** OSPEVENT9 EN38-bit mask */
#define AG903_OSP_EVENT9_VAL39_POS                         24                                                            /** OSPEVENT9 VAL39-bit position */
#define AG903_OSP_EVENT9_VAL39_MSK                         (0xfUL << AG903_OSP_EVENT9_VAL39_POS)                         /** OSPEVENT9 VAL39-bit mask */
#define AG903_OSP_EVENT9_OVF39_POS                         28                                                            /** OSPEVENT9 OVF39-bit position */
#define AG903_OSP_EVENT9_OVF39_MSK                         (0x1UL << AG903_OSP_EVENT9_OVF39_POS)                         /** OSPEVENT9 OVF39-bit mask */
#define AG903_OSP_EVENT9_EN39_POS                          29                                                            /** OSPEVENT9 EN39-bit position */
#define AG903_OSP_EVENT9_EN39_MSK                          (0x1UL << AG903_OSP_EVENT9_EN39_POS)                          /** OSPEVENT9 EN39-bit mask */

#define AG903_OSP_EVENT10_VAL40_POS                        0                                                             /** OSPEVENT10 VAL40-bit position */
#define AG903_OSP_EVENT10_VAL40_MSK                        (0xfUL << AG903_OSP_EVENT10_VAL40_POS)                        /** OSPEVENT10 VAL40-bit mask */
#define AG903_OSP_EVENT10_OVF40_POS                        4                                                             /** OSPEVENT10 OVF40-bit position */
#define AG903_OSP_EVENT10_OVF40_MSK                        (0x1UL << AG903_OSP_EVENT10_OVF40_POS)                        /** OSPEVENT10 OVF40-bit mask */
#define AG903_OSP_EVENT10_EN40_POS                         5                                                             /** OSPEVENT10 EN40-bit position */
#define AG903_OSP_EVENT10_EN40_MSK                         (0x1UL << AG903_OSP_EVENT10_EN40_POS)                         /** OSPEVENT10 EN40-bit mask */
#define AG903_OSP_EVENT10_VAL41_POS                        8                                                             /** OSPEVENT10 VAL41-bit position */
#define AG903_OSP_EVENT10_VAL41_MSK                        (0xfUL << AG903_OSP_EVENT10_VAL41_POS)                        /** OSPEVENT10 VAL41-bit mask */
#define AG903_OSP_EVENT10_OVF41_POS                        12                                                            /** OSPEVENT10 OVF41-bit position */
#define AG903_OSP_EVENT10_OVF41_MSK                        (0x1UL << AG903_OSP_EVENT10_OVF41_POS)                        /** OSPEVENT10 OVF41-bit mask */
#define AG903_OSP_EVENT10_EN41_POS                         13                                                            /** OSPEVENT10 EN41-bit position */
#define AG903_OSP_EVENT10_EN41_MSK                         (0x1UL << AG903_OSP_EVENT10_EN41_POS)                         /** OSPEVENT10 EN41-bit mask */
#define AG903_OSP_EVENT10_VAL42_POS                        16                                                            /** OSPEVENT10 VAL42-bit position */
#define AG903_OSP_EVENT10_VAL42_MSK                        (0xfUL << AG903_OSP_EVENT10_VAL42_POS)                        /** OSPEVENT10 VAL42-bit mask */
#define AG903_OSP_EVENT10_OVF42_POS                        20                                                            /** OSPEVENT10 OVF42-bit position */
#define AG903_OSP_EVENT10_OVF42_MSK                        (0x1UL << AG903_OSP_EVENT10_OVF42_POS)                        /** OSPEVENT10 OVF42-bit mask */
#define AG903_OSP_EVENT10_EN42_POS                         21                                                            /** OSPEVENT10 EN42-bit position */
#define AG903_OSP_EVENT10_EN42_MSK                         (0x1UL << AG903_OSP_EVENT10_EN42_POS)                         /** OSPEVENT10 EN42-bit mask */
#define AG903_OSP_EVENT10_VAL43_POS                        24                                                            /** OSPEVENT10 VAL43-bit position */
#define AG903_OSP_EVENT10_VAL43_MSK                        (0xfUL << AG903_OSP_EVENT10_VAL43_POS)                        /** OSPEVENT10 VAL43-bit mask */
#define AG903_OSP_EVENT10_OVF43_POS                        28                                                            /** OSPEVENT10 OVF43-bit position */
#define AG903_OSP_EVENT10_OVF43_MSK                        (0x1UL << AG903_OSP_EVENT10_OVF43_POS)                        /** OSPEVENT10 OVF43-bit mask */
#define AG903_OSP_EVENT10_EN43_POS                         29                                                            /** OSPEVENT10 EN43-bit position */
#define AG903_OSP_EVENT10_EN43_MSK                         (0x1UL << AG903_OSP_EVENT10_EN43_POS)                         /** OSPEVENT10 EN43-bit mask */

#define AG903_OSP_EVENT11_VAL44_POS                        0                                                             /** OSPEVENT11 VAL44-bit position */
#define AG903_OSP_EVENT11_VAL44_MSK                        (0xfUL << AG903_OSP_EVENT11_VAL44_POS)                        /** OSPEVENT11 VAL44-bit mask */
#define AG903_OSP_EVENT11_OVF44_POS                        4                                                             /** OSPEVENT11 OVF44-bit position */
#define AG903_OSP_EVENT11_OVF44_MSK                        (0x1UL << AG903_OSP_EVENT11_OVF44_POS)                        /** OSPEVENT11 OVF44-bit mask */
#define AG903_OSP_EVENT11_EN44_POS                         5                                                             /** OSPEVENT11 EN44-bit position */
#define AG903_OSP_EVENT11_EN44_MSK                         (0x1UL << AG903_OSP_EVENT11_EN44_POS)                         /** OSPEVENT11 EN44-bit mask */
#define AG903_OSP_EVENT11_VAL45_POS                        8                                                             /** OSPEVENT11 VAL45-bit position */
#define AG903_OSP_EVENT11_VAL45_MSK                        (0xfUL << AG903_OSP_EVENT11_VAL45_POS)                        /** OSPEVENT11 VAL45-bit mask */
#define AG903_OSP_EVENT11_OVF45_POS                        12                                                            /** OSPEVENT11 OVF45-bit position */
#define AG903_OSP_EVENT11_OVF45_MSK                        (0x1UL << AG903_OSP_EVENT11_OVF45_POS)                        /** OSPEVENT11 OVF45-bit mask */
#define AG903_OSP_EVENT11_EN45_POS                         13                                                            /** OSPEVENT11 EN45-bit position */
#define AG903_OSP_EVENT11_EN45_MSK                         (0x1UL << AG903_OSP_EVENT11_EN45_POS)                         /** OSPEVENT11 EN45-bit mask */
#define AG903_OSP_EVENT11_VAL46_POS                        16                                                            /** OSPEVENT11 VAL46-bit position */
#define AG903_OSP_EVENT11_VAL46_MSK                        (0xfUL << AG903_OSP_EVENT11_VAL46_POS)                        /** OSPEVENT11 VAL46-bit mask */
#define AG903_OSP_EVENT11_OVF46_POS                        20                                                            /** OSPEVENT11 OVF46-bit position */
#define AG903_OSP_EVENT11_OVF46_MSK                        (0x1UL << AG903_OSP_EVENT11_OVF46_POS)                        /** OSPEVENT11 OVF46-bit mask */
#define AG903_OSP_EVENT11_EN46_POS                         21                                                            /** OSPEVENT11 EN46-bit position */
#define AG903_OSP_EVENT11_EN46_MSK                         (0x1UL << AG903_OSP_EVENT11_EN46_POS)                         /** OSPEVENT11 EN46-bit mask */
#define AG903_OSP_EVENT11_VAL47_POS                        24                                                            /** OSPEVENT11 VAL47-bit position */
#define AG903_OSP_EVENT11_VAL47_MSK                        (0xfUL << AG903_OSP_EVENT11_VAL47_POS)                        /** OSPEVENT11 VAL47-bit mask */
#define AG903_OSP_EVENT11_OVF47_POS                        28                                                            /** OSPEVENT11 OVF47-bit position */
#define AG903_OSP_EVENT11_OVF47_MSK                        (0x1UL << AG903_OSP_EVENT11_OVF47_POS)                        /** OSPEVENT11 OVF47-bit mask */
#define AG903_OSP_EVENT11_EN47_POS                         29                                                            /** OSPEVENT11 EN47-bit position */
#define AG903_OSP_EVENT11_EN47_MSK                         (0x1UL << AG903_OSP_EVENT11_EN47_POS)                         /** OSPEVENT11 EN47-bit mask */

#define AG903_OSP_EVENT12_VAL48_POS                        0                                                             /** OSPEVENT12 VAL48-bit position */
#define AG903_OSP_EVENT12_VAL48_MSK                        (0xfUL << AG903_OSP_EVENT12_VAL48_POS)                        /** OSPEVENT12 VAL48-bit mask */
#define AG903_OSP_EVENT12_OVF48_POS                        4                                                             /** OSPEVENT12 OVF48-bit position */
#define AG903_OSP_EVENT12_OVF48_MSK                        (0x1UL << AG903_OSP_EVENT12_OVF48_POS)                        /** OSPEVENT12 OVF48-bit mask */
#define AG903_OSP_EVENT12_EN48_POS                         5                                                             /** OSPEVENT12 EN48-bit position */
#define AG903_OSP_EVENT12_EN48_MSK                         (0x1UL << AG903_OSP_EVENT12_EN48_POS)                         /** OSPEVENT12 EN48-bit mask */
#define AG903_OSP_EVENT12_VAL49_POS                        8                                                             /** OSPEVENT12 VAL49-bit position */
#define AG903_OSP_EVENT12_VAL49_MSK                        (0xfUL << AG903_OSP_EVENT12_VAL49_POS)                        /** OSPEVENT12 VAL49-bit mask */
#define AG903_OSP_EVENT12_OVF49_POS                        12                                                            /** OSPEVENT12 OVF49-bit position */
#define AG903_OSP_EVENT12_OVF49_MSK                        (0x1UL << AG903_OSP_EVENT12_OVF49_POS)                        /** OSPEVENT12 OVF49-bit mask */
#define AG903_OSP_EVENT12_EN49_POS                         13                                                            /** OSPEVENT12 EN49-bit position */
#define AG903_OSP_EVENT12_EN49_MSK                         (0x1UL << AG903_OSP_EVENT12_EN49_POS)                         /** OSPEVENT12 EN49-bit mask */
#define AG903_OSP_EVENT12_VAL50_POS                        16                                                            /** OSPEVENT12 VAL50-bit position */
#define AG903_OSP_EVENT12_VAL50_MSK                        (0xfUL << AG903_OSP_EVENT12_VAL50_POS)                        /** OSPEVENT12 VAL50-bit mask */
#define AG903_OSP_EVENT12_OVF50_POS                        20                                                            /** OSPEVENT12 OVF50-bit position */
#define AG903_OSP_EVENT12_OVF50_MSK                        (0x1UL << AG903_OSP_EVENT12_OVF50_POS)                        /** OSPEVENT12 OVF50-bit mask */
#define AG903_OSP_EVENT12_EN50_POS                         21                                                            /** OSPEVENT12 EN50-bit position */
#define AG903_OSP_EVENT12_EN50_MSK                         (0x1UL << AG903_OSP_EVENT12_EN50_POS)                         /** OSPEVENT12 EN50-bit mask */
#define AG903_OSP_EVENT12_VAL51_POS                        24                                                            /** OSPEVENT12 VAL51-bit position */
#define AG903_OSP_EVENT12_VAL51_MSK                        (0xfUL << AG903_OSP_EVENT12_VAL51_POS)                        /** OSPEVENT12 VAL51-bit mask */
#define AG903_OSP_EVENT12_OVF51_POS                        28                                                            /** OSPEVENT12 OVF51-bit position */
#define AG903_OSP_EVENT12_OVF51_MSK                        (0x1UL << AG903_OSP_EVENT12_OVF51_POS)                        /** OSPEVENT12 OVF51-bit mask */
#define AG903_OSP_EVENT12_EN51_POS                         29                                                            /** OSPEVENT12 EN51-bit position */
#define AG903_OSP_EVENT12_EN51_MSK                         (0x1UL << AG903_OSP_EVENT12_EN51_POS)                         /** OSPEVENT12 EN51-bit mask */

#define AG903_OSP_EVENT13_VAL52_POS                        0                                                             /** OSPEVENT13 VAL52-bit position */
#define AG903_OSP_EVENT13_VAL52_MSK                        (0xfUL << AG903_OSP_EVENT13_VAL52_POS)                        /** OSPEVENT13 VAL52-bit mask */
#define AG903_OSP_EVENT13_OVF52_POS                        4                                                             /** OSPEVENT13 OVF52-bit position */
#define AG903_OSP_EVENT13_OVF52_MSK                        (0x1UL << AG903_OSP_EVENT13_OVF52_POS)                        /** OSPEVENT13 OVF52-bit mask */
#define AG903_OSP_EVENT13_EN52_POS                         5                                                             /** OSPEVENT13 EN52-bit position */
#define AG903_OSP_EVENT13_EN52_MSK                         (0x1UL << AG903_OSP_EVENT13_EN52_POS)                         /** OSPEVENT13 EN52-bit mask */
#define AG903_OSP_EVENT13_VAL53_POS                        8                                                             /** OSPEVENT13 VAL53-bit position */
#define AG903_OSP_EVENT13_VAL53_MSK                        (0xfUL << AG903_OSP_EVENT13_VAL53_POS)                        /** OSPEVENT13 VAL53-bit mask */
#define AG903_OSP_EVENT13_OVF53_POS                        12                                                            /** OSPEVENT13 OVF53-bit position */
#define AG903_OSP_EVENT13_OVF53_MSK                        (0x1UL << AG903_OSP_EVENT13_OVF53_POS)                        /** OSPEVENT13 OVF53-bit mask */
#define AG903_OSP_EVENT13_EN53_POS                         13                                                            /** OSPEVENT13 EN53-bit position */
#define AG903_OSP_EVENT13_EN53_MSK                         (0x1UL << AG903_OSP_EVENT13_EN53_POS)                         /** OSPEVENT13 EN53-bit mask */
#define AG903_OSP_EVENT13_VAL54_POS                        16                                                            /** OSPEVENT13 VAL54-bit position */
#define AG903_OSP_EVENT13_VAL54_MSK                        (0xfUL << AG903_OSP_EVENT13_VAL54_POS)                        /** OSPEVENT13 VAL54-bit mask */
#define AG903_OSP_EVENT13_OVF54_POS                        20                                                            /** OSPEVENT13 OVF54-bit position */
#define AG903_OSP_EVENT13_OVF54_MSK                        (0x1UL << AG903_OSP_EVENT13_OVF54_POS)                        /** OSPEVENT13 OVF54-bit mask */
#define AG903_OSP_EVENT13_EN54_POS                         21                                                            /** OSPEVENT13 EN54-bit position */
#define AG903_OSP_EVENT13_EN54_MSK                         (0x1UL << AG903_OSP_EVENT13_EN54_POS)                         /** OSPEVENT13 EN54-bit mask */
#define AG903_OSP_EVENT13_VAL55_POS                        24                                                            /** OSPEVENT13 VAL55-bit position */
#define AG903_OSP_EVENT13_VAL55_MSK                        (0xfUL << AG903_OSP_EVENT13_VAL55_POS)                        /** OSPEVENT13 VAL55-bit mask */
#define AG903_OSP_EVENT13_OVF55_POS                        28                                                            /** OSPEVENT13 OVF55-bit position */
#define AG903_OSP_EVENT13_OVF55_MSK                        (0x1UL << AG903_OSP_EVENT13_OVF55_POS)                        /** OSPEVENT13 OVF55-bit mask */
#define AG903_OSP_EVENT13_EN55_POS                         29                                                            /** OSPEVENT13 EN55-bit position */
#define AG903_OSP_EVENT13_EN55_MSK                         (0x1UL << AG903_OSP_EVENT13_EN55_POS)                         /** OSPEVENT13 EN55-bit mask */

#define AG903_OSP_EVENT14_VAL56_POS                        0                                                             /** OSPEVENT14 VAL56-bit position */
#define AG903_OSP_EVENT14_VAL56_MSK                        (0xfUL << AG903_OSP_EVENT14_VAL56_POS)                        /** OSPEVENT14 VAL56-bit mask */
#define AG903_OSP_EVENT14_OVF56_POS                        4                                                             /** OSPEVENT14 OVF56-bit position */
#define AG903_OSP_EVENT14_OVF56_MSK                        (0x1UL << AG903_OSP_EVENT14_OVF56_POS)                        /** OSPEVENT14 OVF56-bit mask */
#define AG903_OSP_EVENT14_EN56_POS                         5                                                             /** OSPEVENT14 EN56-bit position */
#define AG903_OSP_EVENT14_EN56_MSK                         (0x1UL << AG903_OSP_EVENT14_EN56_POS)                         /** OSPEVENT14 EN56-bit mask */
#define AG903_OSP_EVENT14_VAL57_POS                        8                                                             /** OSPEVENT14 VAL57-bit position */
#define AG903_OSP_EVENT14_VAL57_MSK                        (0xfUL << AG903_OSP_EVENT14_VAL57_POS)                        /** OSPEVENT14 VAL57-bit mask */
#define AG903_OSP_EVENT14_OVF57_POS                        12                                                            /** OSPEVENT14 OVF57-bit position */
#define AG903_OSP_EVENT14_OVF57_MSK                        (0x1UL << AG903_OSP_EVENT14_OVF57_POS)                        /** OSPEVENT14 OVF57-bit mask */
#define AG903_OSP_EVENT14_EN57_POS                         13                                                            /** OSPEVENT14 EN57-bit position */
#define AG903_OSP_EVENT14_EN57_MSK                         (0x1UL << AG903_OSP_EVENT14_EN57_POS)                         /** OSPEVENT14 EN57-bit mask */
#define AG903_OSP_EVENT14_VAL58_POS                        16                                                            /** OSPEVENT14 VAL58-bit position */
#define AG903_OSP_EVENT14_VAL58_MSK                        (0xfUL << AG903_OSP_EVENT14_VAL58_POS)                        /** OSPEVENT14 VAL58-bit mask */
#define AG903_OSP_EVENT14_OVF58_POS                        20                                                            /** OSPEVENT14 OVF58-bit position */
#define AG903_OSP_EVENT14_OVF58_MSK                        (0x1UL << AG903_OSP_EVENT14_OVF58_POS)                        /** OSPEVENT14 OVF58-bit mask */
#define AG903_OSP_EVENT14_EN58_POS                         21                                                            /** OSPEVENT14 EN58-bit position */
#define AG903_OSP_EVENT14_EN58_MSK                         (0x1UL << AG903_OSP_EVENT14_EN58_POS)                         /** OSPEVENT14 EN58-bit mask */
#define AG903_OSP_EVENT14_VAL59_POS                        24                                                            /** OSPEVENT14 VAL59-bit position */
#define AG903_OSP_EVENT14_VAL59_MSK                        (0xfUL << AG903_OSP_EVENT14_VAL59_POS)                        /** OSPEVENT14 VAL59-bit mask */
#define AG903_OSP_EVENT14_OVF59_POS                        28                                                            /** OSPEVENT14 OVF59-bit position */
#define AG903_OSP_EVENT14_OVF59_MSK                        (0x1UL << AG903_OSP_EVENT14_OVF59_POS)                        /** OSPEVENT14 OVF59-bit mask */
#define AG903_OSP_EVENT14_EN59_POS                         29                                                            /** OSPEVENT14 EN59-bit position */
#define AG903_OSP_EVENT14_EN59_MSK                         (0x1UL << AG903_OSP_EVENT14_EN59_POS)                         /** OSPEVENT14 EN59-bit mask */

#define AG903_OSP_EVENT15_VAL60_POS                        0                                                             /** OSPEVENT15 VAL60-bit position */
#define AG903_OSP_EVENT15_VAL60_MSK                        (0xfUL << AG903_OSP_EVENT15_VAL60_POS)                        /** OSPEVENT15 VAL60-bit mask */
#define AG903_OSP_EVENT15_OVF60_POS                        4                                                             /** OSPEVENT15 OVF60-bit position */
#define AG903_OSP_EVENT15_OVF60_MSK                        (0x1UL << AG903_OSP_EVENT15_OVF60_POS)                        /** OSPEVENT15 OVF60-bit mask */
#define AG903_OSP_EVENT15_EN60_POS                         5                                                             /** OSPEVENT15 EN60-bit position */
#define AG903_OSP_EVENT15_EN60_MSK                         (0x1UL << AG903_OSP_EVENT15_EN60_POS)                         /** OSPEVENT15 EN60-bit mask */
#define AG903_OSP_EVENT15_VAL61_POS                        8                                                             /** OSPEVENT15 VAL61-bit position */
#define AG903_OSP_EVENT15_VAL61_MSK                        (0xfUL << AG903_OSP_EVENT15_VAL61_POS)                        /** OSPEVENT15 VAL61-bit mask */
#define AG903_OSP_EVENT15_OVF61_POS                        12                                                            /** OSPEVENT15 OVF61-bit position */
#define AG903_OSP_EVENT15_OVF61_MSK                        (0x1UL << AG903_OSP_EVENT15_OVF61_POS)                        /** OSPEVENT15 OVF61-bit mask */
#define AG903_OSP_EVENT15_EN61_POS                         13                                                            /** OSPEVENT15 EN61-bit position */
#define AG903_OSP_EVENT15_EN61_MSK                         (0x1UL << AG903_OSP_EVENT15_EN61_POS)                         /** OSPEVENT15 EN61-bit mask */
#define AG903_OSP_EVENT15_VAL62_POS                        16                                                            /** OSPEVENT15 VAL62-bit position */
#define AG903_OSP_EVENT15_VAL62_MSK                        (0xfUL << AG903_OSP_EVENT15_VAL62_POS)                        /** OSPEVENT15 VAL62-bit mask */
#define AG903_OSP_EVENT15_OVF62_POS                        20                                                            /** OSPEVENT15 OVF62-bit position */
#define AG903_OSP_EVENT15_OVF62_MSK                        (0x1UL << AG903_OSP_EVENT15_OVF62_POS)                        /** OSPEVENT15 OVF62-bit mask */
#define AG903_OSP_EVENT15_EN62_POS                         21                                                            /** OSPEVENT15 EN62-bit position */
#define AG903_OSP_EVENT15_EN62_MSK                         (0x1UL << AG903_OSP_EVENT15_EN62_POS)                         /** OSPEVENT15 EN62-bit mask */
#define AG903_OSP_EVENT15_VAL63_POS                        24                                                            /** OSPEVENT15 VAL63-bit position */
#define AG903_OSP_EVENT15_VAL63_MSK                        (0xfUL << AG903_OSP_EVENT15_VAL63_POS)                        /** OSPEVENT15 VAL63-bit mask */
#define AG903_OSP_EVENT15_OVF63_POS                        28                                                            /** OSPEVENT15 OVF63-bit position */
#define AG903_OSP_EVENT15_OVF63_MSK                        (0x1UL << AG903_OSP_EVENT15_OVF63_POS)                        /** OSPEVENT15 OVF63-bit mask */
#define AG903_OSP_EVENT15_EN63_POS                         29                                                            /** OSPEVENT15 EN63-bit position */
#define AG903_OSP_EVENT15_EN63_MSK                         (0x1UL << AG903_OSP_EVENT15_EN63_POS)                         /** OSPEVENT15 EN63-bit mask */

#define AG903_OSP_FLAGSET_F_POS                            0                                                             /** OSPFLAGSET F-bit position */
#define AG903_OSP_FLAGSET_F_MSK                            (0xfffffffUL << AG903_OSP_FLAGSET_F_POS)                      /** OSPFLAGSET F-bit mask */

#define AG903_OSP_FLAGCLR_F_POS                            0                                                             /** OSPFLAGCLR F-bit position */
#define AG903_OSP_FLAGCLR_F_MSK                            (0xfffffffUL << AG903_OSP_FLAGCLR_F_POS)                      /** OSPFLAGCLR F-bit mask */

#define AG903_OSP_FLAGSTAT_F_POS                           0                                                             /** OSPFLAGSTAT F-bit position */
#define AG903_OSP_FLAGSTAT_F_MSK                           (0xfffffffUL << AG903_OSP_FLAGSTAT_F_POS)                     /** OSPFLAGSTAT F-bit mask */

#endif /* _AG903_OSP_REGMAP_H_ */

