/**
 * @brief           VRAM Manager Header
 * @author          AXELL CORPORATION
 * @description     VRAM Manager񋟃wb_B<p>VRAM ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _VRAMMGR_H_
#define _VRAMMGR_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "osw/oswrapper.h"
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** VRAMiFIFOj */
#define AG903_VRAM_ATRFIFO				AG903_OSW_ATRFIFO

/** VRAMiDxj */
#define AG903_VRAM_ATRPRI				AG903_OSW_ATRPRI

/** ^CvwiCACHE OFFj */
#define AG903_VRAM_NORMAL_CACHE_OFF		AG903_OSW_NORMAL_CACHE_OFF

/** ^CvwiCACHE ONj */
#define AG903_VRAM_NORMAL_CACHE_ON		AG903_OSW_NORMAL_CACHE_ON

/** ^CvwiSTRONGLY ORDEREDj */
#define AG903_VRAM_STRONGLY_ORDERED		AG903_OSW_STRONGLY_ORDERED

/** ϒp[^ */
typedef AG903_OSWCMpl	AG903_VRAMMgrMplPrm;

/** ϒXe[^X */
typedef AG903_OSWRMpl	AG903_VRAMMgrMplStat;

/** Œ蒷p[^ */
typedef AG903_OSWCMpf	AG903_VRAMMgrMpfPrm;

/** Œ蒷Xe[^X */
typedef AG903_OSWRMpf	AG903_VRAMMgrMpfStat;


int32_t AG903_VRAMMgrInit(uintptr_t vramtop, uint32_t vramsize);
int32_t AG903_VRAMMgrCreateMpl(AG903_VRAMMgrMplPrm* mplprm);
int32_t AG903_VRAMMgrCreateMplFixedId(int32_t mplid, AG903_VRAMMgrMplPrm* mplprm);
int32_t AG903_VRAMMgrDeleteMpl(int32_t mplid);
void* AG903_VRAMMgrMalloc(int32_t mplid, uint32_t blksz);
void* AG903_VRAMMgrMallocAlign(int32_t mplid, uint32_t align, uint32_t blksz);
int32_t AG903_VRAMMgrFree(int32_t mplid, void* blk);
int32_t AG903_VRAMMgrMrefer(int32_t mplid, AG903_VRAMMgrMplStat* mplsta);
int32_t AG903_VRAMMgrCreateMpf(AG903_VRAMMgrMpfPrm* mpfprm);
int32_t AG903_VRAMMgrCreateMpfFixedId(int32_t mplid, AG903_VRAMMgrMpfPrm* mpfprm);
int32_t AG903_VRAMMgrDeleteMpf(int32_t mplid);
void* AG903_VRAMMgrFmalloc(int32_t mplid);
int32_t AG903_VRAMMgrFmfree(int32_t mplid, void* blk);
int32_t AG903_VRAMMgrFmrefer(int32_t mplid, AG903_VRAMMgrMpfStat* mplsta);


#ifdef __cplusplus
}
#endif
#endif/* __VRAMMGR_H__ */
