/*
* This program was created by AXELL CORPORATION.
* Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#ifndef __GVD_SAMPLE_H__
#define __GVD_SAMPLE_H__

#include "com.h"

#include "timr/timrmgr.h"
#include "int/intmgr.h"
#include "dsp/dspmgr.h"
#include "gvd/gvd.h"

#define GVD_ALIGNn(a,x) ((x+(a-1))&~(a-1))

#define GVD_Printf(FMT, ...)	sys_print(0, FMT,##__VA_ARGS__)
#define GVD_ErrPrintf(FMT, ...)	sys_print(1, FMT,##__VA_ARGS__)


#define GVD_MAX_STREAM		2

#define GVD_INBUF_SIZE		(1<<20)
#define GVD_INBUF_COUNT		4
#define GVD_INBUF_ALIGNMENT	32

#define GVD_HEAP_SIZE		(10<<20)

#define GVD_OUTBUF_COUNT	3

#define GVD_SAMPLE_HELP		0
#define GVD_SAMPLE_INTERNAL	1
#define GVD_SAMPLE_EXTERNAL	2

#define GVD_MAX_FILENAME_LEN 64

typedef struct _GVDFlags {
	bool	paused;		/* ꎞ~tO */
	bool	playdone;	/* ĐtO */
	bool	quit;		/* ItO */
	bool	connect;	/* fR[_ڑtO */
}GVDFlags;

/* obt@^` */
typedef struct _buf_t {
	void		*addr;
	uint32_t	size;
}buf_t;

/* ƃobt@ */
typedef struct _GVDBuffers {
	buf_t work;
	buf_t heap;
}GVDBuffers;

/* o̓obt@\ */
typedef struct _DecodedBufferInfo{
    gvdContext *ctx;
    gvdOutBufInfo buf;
    gvdTimeStamp ts;
}DecodedBufferInfo;

int32_t GVD_cbGVDFatalerror(void *param_gvd, void *param_user, gvdError error);
uint32_t GVD_getCID(gvdContext *ctx);
bool GVD_isAllQuit();


#endif/* __GVD_SAMPLE_H__ */
