#ifndef __MTX_GFX_H__
#define __MTX_GFX_H__

#include <stdint.h>

#include "sample_common.h"
#include "mtx_movie.h"
#include "mtx_sample.h"

#define MTX_GFX_HEAP_SIZE		(20<<20)

#define MTX_GFX_TEXTURE_WIDTH	MTX_MOV_STREAM_WIDTH
#define MTX_GFX_TEXTURE_HEIGHT	MTX_MOV_STREAM_HEIGHT

#define MTX_GFX_TEXTURE_DEPTH	(16>>3)
#define MTX_GFX_TEXTURE_SIZE	(MTX_GFX_TEXTURE_WIDTH*MTX_GFX_TEXTURE_HEIGHT*MTX_GFX_TEXTURE_DEPTH)

#define MTX_GFX_CANBUS_WIDTH	640
#define MTX_GFX_CANBUS_HEIGHT	480

int32_t gfx_init(void);
void gfx_run(void);
void gfx_start(void);
void gfx_final(void);

#endif /* __MTX_GFX_H__ */
