/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

/* VGImageIuWFNg */
static VGImage image;

static void *image_data;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {0.0F, 0.0F, 0.0F, 1.0F};

    /* 摜Ǎ */
    image_data = GfxGetFreeArea(IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_BPP<<3);
    GfxFsRead((int8_t*)IMAGE_NAME1, IMAGE_STRIDE * IMAGE_HEIGHT, (void*)image_data);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGImageIuWFNg̐ */
    image = vgCreateImage(VG_sRGBA_8888, IMAGE_WIDTH, IMAGE_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED | VG_IMAGE_QUALITY_FASTER | VG_IMAGE_QUALITY_BETTER);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(image, image_data, IMAGE_STRIDE, VG_sRGBA_8888, 0, 0, IMAGE_WIDTH, IMAGE_HEIGHT);

    /* IMAGE_USER_TO_SURFACEPʍsɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);
    vgLoadIdentity();
    vgTranslate(0, 360);
}


static void DrawWithColorTransform(void)
{
    VGfloat colorTrans[8] = {1, 1, 1, 1, 0, 0, 0, 0};
    VGfloat scale = 0.05F;

    /* J[gXtH[L */
    vgSeti(VG_COLOR_TRANSFORM, VG_TRUE);

    while (scale < 1.1) {
        /* J[gXtH[̐ݒiR/G/Bvf̃XP[lύXj */
        colorTrans[0] = colorTrans[1] = colorTrans[2] = scale;
        vgSetfv(VG_COLOR_TRANSFORM_VALUES, 8, colorTrans);
        /* ړ */
        vgTranslate(40, -30);
        /* ` */
        vgDrawImage(image);
        scale += 0.1F;
    }

    /* J[gXtH[ */
    vgSeti(VG_COLOR_TRANSFORM, VG_FALSE);
}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data);

    /* IuWFNg̔j */
    vgDestroyImage(image);
}

void ColorTransformMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* J[gXtH[ */
    DrawWithColorTransform();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
