/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

void *image_data1, *image_data2, *image_data3, *image_data4;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* 摜Ǎ */
    image_data1 = GfxGetFreeArea(RGB_WIDTH, RGB_HEIGHT, RGB_BPP<<3);
    GfxFsRead((int8_t*)RGB_NAME, RGB_STRIDE * RGB_HEIGHT, (void*)image_data1);
    image_data2 = GfxGetFreeArea(YUV_WIDTH, YUV_HEIGHT, YUV_BPP<<3);
    GfxFsRead((int8_t*)YUV_NAME, YUV_STRIDE * YUV_HEIGHT, (void*)image_data2);
    image_data3 = GfxGetFreeArea(LUT_WIDTH, LUT_HEIGHT, LUT_BPP<<3);
    GfxFsRead((int8_t*)LUT_NAME, LUT_STRIDE * LUT_HEIGHT, (void*)image_data3);
    image_data4 = GfxGetFreeArea(PLT_WIDTH, PLT_HEIGHT, PLT_BPP<<3);
    GfxFsRead((int8_t*)PLT_NAME, PLT_STRIDE * PLT_HEIGHT, (void*)image_data4);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);
}

static void DrawExtImage(void)
{
    VGImage extImage;
    VGPalette palette;
VGint yuvconv = VG_EXT_RGB2YUV_B3_Y1 |
                VG_EXT_RGB2YUV_B2_V |
                VG_EXT_RGB2YUV_B1_Y0 |
                VG_EXT_RGB2YUV_B0_U |
                VG_EXT_YUV2RGB_Y0_B1 |
                VG_EXT_YUV2RGB_Y1_B3 |
                VG_EXT_YUV2RGB_V_B2 |
                VG_EXT_YUV2RGB_U_B0 |
                VG_EXT_YUV_YPM;
VGint yuvcoef[9] ={
    0x12a, 0x000, 0x199,
    0x12a, 0x79c, 0x730,
    0x12a, 0x204, 0x000
};

    /* gC[WIuWFNg̐ iRGB24j */
    extImage = vgCreateImageEXT(VG_EXT_sRGB_888,
                                RGB_WIDTH,
                                RGB_HEIGHT,
                                VG_IMAGE_QUALITY_NONANTIALIASED,
                                image_data1);
    /* ʍɕ` */
    vgSetPixels(50, 10, extImage, 0, 0, RGB_WIDTH, RGB_HEIGHT);
    /* IuWFNgj */
    vgDestroyImage(extImage);

    /* gC[WIuWFNg̐ iYUV422j */
    extImage = vgCreateImageEXT(VG_EXT_YUV422,
                                YUV_WIDTH,
                                YUV_HEIGHT,
                                VG_IMAGE_QUALITY_NONANTIALIASED,
                                image_data2);
    /* YUV->RGBϊW̐ݒ */
    vgSetiEXT(VG_EXT_YUV_RGB_CONVERSION, yuvconv);
    vgSetivEXT(VG_EXT_YUV_RGB_COEFFICIENT, 9, yuvcoef);
    /* ʉEɕ` */
    vgSetPixels(336, 10, extImage, 0, 0, YUV_WIDTH, YUV_HEIGHT);
    /* IuWFNgj */
    vgDestroyImage(extImage);

    /* gC[WIuWFNg̐ iPalettej */
    extImage = vgCreateImageEXT(VG_EXT_PALETTE8,
                                LUT_WIDTH,
                                LUT_HEIGHT,
                                VG_IMAGE_QUALITY_NONANTIALIASED,
                                image_data3);
    /* pbgIuWFNg𐶐 */
    palette = vgCreatePaletteEXT(VG_sRGBA_8888, 256, image_data4);
    /* pbgƃC[W֘At */
    vgBindPaletteEXT(extImage, palette);
    /* ʍɕ` */
    vgSetPixels(50, 245, extImage, 0, 0, LUT_WIDTH, LUT_HEIGHT);
    /* IuWFNgj */
    vgDestroyPaletteEXT(palette);
    vgDestroyImage(extImage);
}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data1);
    GfxReleaseFreeArea(image_data2);
    GfxReleaseFreeArea(image_data3);
    GfxReleaseFreeArea(image_data4);
}

void ExtImageMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* gC[WtH[}bg` */
    DrawExtImage();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
