/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

static void *image_data;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* 摜Ǎ */
    image_data = GfxGetFreeArea(VGA_WIDTH, VGA_HEIGHT, VGA_BPP<<3);
    GfxFsRead((int8_t*)VGA_NAME, VGA_STRIDE * VGA_HEIGHT, (void*)image_data);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* ݂̃}gNXIMAGE_USER_TO_SURFACEɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);

    /* s񏉊 */
    vgLoadIdentity();
}

static void CreateImage(VGImageFormat format, VGint width, VGint height, void *data)
{
    VGImage image;

    /* VGImageIuWFNg̐ */
    image = vgCreateImage(format, width, height,
                          VG_IMAGE_QUALITY_NONANTIALIASED |
                          VG_IMAGE_QUALITY_FASTER |
                          VG_IMAGE_QUALITY_BETTER);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(image, data, width * 4, format, 0, 0, width, height);

    /* VGImage` */
    vgDrawImage(image);

    /* VGImageIuWFNgj */
    vgDestroyImage(image);
}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data);
}

void ImageMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* C[W`揈 */
    CreateImage(VG_sRGBA_8888, VGA_WIDTH, VGA_HEIGHT, image_data);

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
