/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

/* `f[^ */
static VGubyte cmd[] = {
    VG_MOVE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS
};
static VGint coord[] = {
    0, 100, 0, 0, 200, 0
};

/* _bVp^ */
static VGint DashPattern0[] = {40, 30};
static VGint DashPattern1[] = {0, 20};

static VGPath path;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGPathIuWFNg̐ */
    path = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_S_32, 1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);

    /* VGPathIuWFNgɌ`f[^o^ */
    vgAppendPathData(path, sizeof(cmd), cmd, coord);

    /* ݂̃}gNXpXϊ}gNXɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);
}

static void TestDraw(VGPath path, VGint lineWidth, VGCapStyle cap,
                     VGJoinStyle join, VGint dashCount,
                     VGint *dashPattern, VGint x, VGint y)
{
    /* Xg[N̕ݒ */
    vgSeti(VG_STROKE_LINE_WIDTH, lineWidth);

    /* GhLbv`̐ݒ */
    vgSeti(VG_STROKE_CAP_STYLE, cap);

    /* WC`̐ݒ */
    vgSeti(VG_STROKE_JOIN_STYLE, join);

    /* _bVp^̐ݒ */
    vgSetiv(VG_STROKE_DASH_PATTERN, dashCount, dashPattern);

    /* w肵ʒuɃXg[N` */
    vgLoadIdentity();
    vgTranslate(x, y);
    vgDrawPath(path, VG_STROKE_PATH);
}

static void TestTerm(void)
{
    /* VGPathIuWFNgj */
    vgDestroyPath(path);
}

void StrokeMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* P[XPF15pixelALbv=BUTTAWC=MITERA_bVȂ */
    TestDraw(path, 15, VG_CAP_BUTT, VG_JOIN_MITER, 0, 0, 50, 50);
    /* P[XQF15pixelALbv=BUTTAWC=MITERA_bV */
    TestDraw(path, 15, VG_CAP_BUTT, VG_JOIN_MITER, sizeof(DashPattern0)/sizeof(DashPattern0[0]), DashPattern0, 100, 100);
    /* P[XRF15pixelALbv=ROUNDAWC=ROUNDA_bVȂ */
    TestDraw(path, 15, VG_CAP_ROUND, VG_JOIN_ROUND, 0, 0, 150, 150);
    /* P[XSF15pixelALbv=ROUNDAWC=ROUNDA_bV */
    TestDraw(path, 15, VG_CAP_ROUND, VG_JOIN_ROUND, sizeof(DashPattern0)/sizeof(DashPattern0[0]), DashPattern0, 200, 200);
    /* P[XTF15pixelALbv=SQUAREAWC=BEVELA_bVȂ */
    TestDraw(path, 15, VG_CAP_SQUARE, VG_JOIN_BEVEL, 0, 0, 250, 250);
    /* P[XUF15pixelALbv=SQUAREAWC=BEVELA_bV */
    TestDraw(path, 15, VG_CAP_SQUARE, VG_JOIN_BEVEL, sizeof(DashPattern0)/sizeof(DashPattern0[0]), DashPattern0, 300, 300);
    /* P[XVF15pixelALbv=ROUNDAWC=ROUNDA_bV */
    TestDraw(path, 15, VG_CAP_ROUND, VG_JOIN_ROUND, sizeof(DashPattern1)/sizeof(DashPattern1[1]), DashPattern1, 350, 350);

    /* obt@[Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
