/*
* This program was created by AXELL CORPORATION.
* Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "sample_common.h"
#include "com.h"
#include "wdt/wdtctl.h"

/* vg^Cv */
static int32_t Wdt_init_module(void);
static int32_t Wdt_term_module(void);
static void Wdt_SampleHelp(void);
static void Wdt_GenerateIntr(void);
static void Wdt_GenerateReset(void);

/* Macro */
#define	EPRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define	PRINT(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)
#define WDT_ERROR(str)			sys_print(1, " ERROR:%s[%d] *%s*\r\n",__FUNCTION__, __LINE__, str)

static void (*func[])() = {
	Wdt_SampleHelp,
	Wdt_GenerateIntr,
	Wdt_GenerateReset,
};

#define WDT_SMP_CLK		(100000000)	/* WDTNbNg [Hz] */

static volatile _Bool WdtIntrFlag=false;
static volatile _Bool WdtGetCharaFlag=false;

static void Wdt_IntHandler(void* param);
static void Wdt_GetCharaClbk(void);


/**
 * @brief	C
 * @param	param [in] p[^
 * @return	none
 * @note	none
*/
void WDT_main(uint8_t param)
{
	uint8_t		mode = 0;
	char		input[2+2];

	((void)param);

	Wdt_SampleHelp();	/* Help\ */

	Wdt_init_module();

	while (mode != 0xFF) {
		EPRINT(" -- Choose sample number (00h<HELP> to FFh): ");
		COM_GetNum_Wait(input, sizeof(input));
		mode = (ASCtoBIN(input[0]) << 4)
			 | (ASCtoBIN(input[1]) << 0);
		if(0xFF == mode) {
			break;
		}
		if(mode >= (sizeof(func)/sizeof(void*))) {
			func[0](); /* Help */
		}
		else {
			func[mode]();	/* Sample funcs */
		}
	}

	Wdt_term_module();

	return;
}

/**
 * @brief	Tu
 * @param	param [in] p[^
 * @return	none
 * @note	none
*/
void WDT_sub(uint32_t param)
{
	((void)param);
	/* Ȃ */
	return;
}

/**
 * @brief	W[
 * @param	none
 * @retval	G[R[h
 * @note	none
*/
static int32_t Wdt_init_module(void)
{
	/* Ȃ */
	return AG903_ENONE;
}

/**
 * @brief	W[I
 * @param	none
 * @retval	G[R[h
 * @note	none
*/
static int32_t Wdt_term_module(void)
{
	/* Ȃ */
	return AG903_ENONE;
}

/**
 * @brief	wv\
 * @param	none
 * @return	none
 * @note	none
*/
static void Wdt_SampleHelp(void)
{
	PRINT("\t# 00 ... Help");
	PRINT("\t# 01 ... WDT Interrupt");
	PRINT("\t# 02 ... WDT Reset");
	PRINT("\t# FF ... Exit Sample");
	
	return;
}

/**
 * @brief	WDTݐ
 * @param	none
 * @return	none
 * @note	none
*/
static void Wdt_GenerateIntr(void)
{
	AG903_WDTCtlParam	pram;
	int32_t 	result;
	uint32_t	period;
	uint32_t	status;
	char		chara[4];

	PRINT(" Generate Reset");
	PRINT(" input period time. [s]");
	EPRINT(" ");

	COM_GetNum_Wait(chara, 3);  /* 3 = 1(period time)+CRLF */
	period  = ASCtoBIN(chara[0]);
	period *= 100000000;

	pram.count   = period;
	pram.intrlen = 0xFF;
	pram.enable  = AG903_WDT_SYSINTR_ENABLE;
	result = AG903_WDTCtlInit(&pram);
	if(AG903_ENONE != result) {
		WDT_ERROR("Init");
	}

	result = AG903_WDTCtlSetIntHandler((void*)Wdt_IntHandler,NULL);
	if(AG903_ENONE != result) {
		WDT_ERROR("SetIntHandler");
	}

	AG903_WDTCtlEnable();

	PRINT(" Press enter key to restart: ");
	EPRINT(" ");
	COM_GetChara(chara,2,(void*)Wdt_GetCharaClbk);  /* 2 = CRLF */

	while(1) {
		if(true==WdtIntrFlag) {
			WdtIntrFlag = false;
			break;
		}
		if(true==WdtGetCharaFlag) {
			WdtGetCharaFlag = false;
			AG903_WDTCtlRestart();
			COM_GetChara(chara,2,(void*)Wdt_GetCharaClbk);
		}
	}

    AG903_WDTCtlDisable();
	AG903_WDTCtlGetStatus(&status);
	PRINT(" Interrupt occurs. status:0x%02x", status);
	AG903_WDTCtlClearStatus();
	AG903_WDTCtlDeleteIntHandler();
	PRINT(" Press enter key to exit: ");
	while(1) {
		if(true==WdtGetCharaFlag) {
			WdtGetCharaFlag = false;
			break;
		}
	}

	return;
}

/**
 * @brief	WDTZbg
 * @param	none
 * @return	none
 * @note	none
*/
static void Wdt_GenerateReset(void)
{
	AG903_WDTCtlParam	pram;
	int32_t 	result;
	uint32_t	period;
	char		chara[4];
	

	PRINT(" Generate Reset");
	PRINT(" input period time. [s]");
	EPRINT(" ");

	COM_GetNum_Wait(chara, 3);  /* 3 = 1(period time)+CRLF */
	period  = ASCtoBIN(chara[0]);
	period *= 100000000;

	pram.count   = period;
	pram.intrlen = 0xFF;
	pram.enable  = AG903_WDT_SYSRESET_ENABLE;
	result = AG903_WDTCtlInit(&pram);
	if(AG903_ENONE != result) {
		WDT_ERROR("Init");
	}

	AG903_WDTCtlEnable();

	PRINT(" Press enter key to exit restart: ");
	EPRINT(" ");

	while(1) {
		COM_GetChara_Wait(chara, 2);  /* 2 = CRLF */
		AG903_WDTCtlRestart();
	}
}

/**
 * WDT
*/
static void Wdt_IntHandler(void* param)
{
	((void)param);

	WdtIntrFlag = true;
	return;
}

/**
 * GetCharaR[obN
*/
static void Wdt_GetCharaClbk(void)
{
	WdtGetCharaFlag = true;
	return;
}

