/**
 * @brief       DSP Manager
 * @author      AXELL CORPORATION
 * @description DSP Manager
 * @note        none
 * @history     2017_09_04  
 * @history     2017_10_26  Ver2.0
 * @history     2019_03_08  [SDK2.2] DSPł̃nh擾σ`lĎ擾ꍇ̕sC (#2201)
 * @history     2019_12_27  [SDK3.0] DSP}l[WŃAgr[gbNĂȂsC (#2034)
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_common.h"

#include "dsp/dspprm.h"
#include "dsp/vodprm.h"
#include "dsp/dspmgr.h"

/* f[^\` */

/**
 * DSP`lǗ
 */
typedef struct _DSPChBlock {
	uint32_t channel;					/** `l */
	uint32_t *lock[AG903_DSP_ATTR_MAX];	/** Agr[ggptO (NULL:gp ADDR:gp) */
}DSPChBlock;

/* O[oϐ` */

/**
 * DSPǗubN
 */
static struct {
	bool 				init;						/** ς false: */
	DSPChBlock 			ch[AG903_DSP_CH_NUM];		/** DSP`lǗ */
	AG903_DSPMgrHandle 	*lock[AG903_DSP_CH_NUM];	/** f[^gptO (NULL:gp ADDR:gp) */
}gDSP;												/** DSPǗf[^ */

/* vg^Cv` */
static void AG903_DSPMgrInitDSP(uint8_t ch);
static void AG903_DSPMgrInitVOD(uint8_t ch);
static int32_t DSPMgrCheckHandle(AG903_DSPMgrHandle *handle, uint8_t *ch);

/**
 * @brief           DSP
 * @param           ch [in] `l
 * @return          void
 * @description     w肵`lDSPW[܂.
 * @note            eWX^ɏlZbgAs蕔0ŃNA܂.
*/
static void AG903_DSPMgrInitDSP(uint8_t ch) {
	if (ch > AG903_DSP_CH_NUM) return;

	DSPPrmParamMOD mod = {
		.de   = AG903_DSP_RGBDE_SIGNAL_DATA,
		.ip   = AG903_DSP_VMODE_NONINTERLACE,
		.upd  = AG903_DSP_ATTR_END_OF_VSYNC,
		.bmr  = AG903_DSP_BMU_WINDATA,
		.lut  = false,
		.dith = false,
	};
	DSPPrmParamSYNC sync = {
		.sel = AG903_DSP_EXSYNC_NONE,
		.dly = false,
		.ip  = AG903_DSP_VMODE_NONINTERLACE,
		.vp  = AG903_DSP_POLARITY_NEGA,
		.fp  = AG903_DSP_POLARITY_NEGA,
		.msk = true,
	};
	DSPPrmParamVTPRM0 vtprm0 = {
		.vpw = 2,
		.ofp = false,
		.obp = false,
		.efp = false,
		.ebp = false,
	};
	DSPPrmParamCDCTRL cdctrl = {
		.be = false,
		.ge = false,
		.re = false,
		.ae = false,
	};
	DSPPrmParamCOLDET coldet = {
		.b = 0x00000000,
		.g = 0x00000000,
		.r = 0x00000000,
		.a = 0x00000000,
	};
	DSPPrmParamERRCLR errclr = {
		.line = true,
		.ue   = true,
		.le   = true,
		.pe   = true,
	};
	DSPPrmParamINT intprm = {
		.line  = 0,
		.fcnt  = 0,
		.hline = AG903_DSP_INT_START_OF_LINE,
		.vblk  = AG903_DSP_INT_START_OF_VBLANK,
	};
	DSPPrmParamINTMASK intmask = {
		.vblk  = true,
		.hline = true,
		.doff  = true,
		.err   = true,
	};
	DSPPrmParamLUTR lutr = {
		.r0 = 0x00,
		.r1 = 0x00,
		.r2 = 0x00,
		.r3 = 0x00,
	};
	DSPPrmParamLUTG lutg = {
		.g0 = 0x00,
		.g1 = 0x00,
		.g2 = 0x00,
		.g3 = 0x00,
	};
	DSPPrmParamLUTB lutb = {
		.b0 = 0x00,
		.b1 = 0x00,
		.b2 = 0x00,
		.b3 = 0x00,
	};

	AG903_DSPPrmSetCTRL(ch, AG903_DSP_CTRL_OFF);
	AG903_DSPPrmSetMOD(ch, &mod);
	AG903_DSPPrmSetSYNC(ch, &sync);
	AG903_DSPPrmSetBGCOL(ch, 0x00000000);
	AG903_DSPPrmSetWINNUM(ch, 1);
	AG903_DSPPrmSetWATNUM(ch, 1);
	AG903_DSPPrmSetWATBASE(ch, 0x00000000);
	AG903_DSPPrmSetLSTCTRL(ch, false, false);
	AG903_DSPPrmSetHRZPRM0(ch, 0x060);
	AG903_DSPPrmSetHRZPRM1(ch, 0x010, 0x030);
	AG903_DSPPrmSetVTPRM0(ch, &vtprm0);
	AG903_DSPPrmSetVTPRM1(ch, 0x00A, 0x021);
	AG903_DSPPrmSetFRMSIZE(ch, 0x1E0, 0x280);
	AG903_DSPPrmSetCDCTRL(ch, &cdctrl);
	AG903_DSPPrmSetCOLDET(ch, &coldet);
	AG903_DSPPrmSetDITHAREA0A(ch, 0x7FF, 0x7FF);
	AG903_DSPPrmSetDITHAREA0B(ch, 0x000, 0x000);
	AG903_DSPPrmSetDITHAREA1A(ch, 0x7FF, 0x7FF);
	AG903_DSPPrmSetDITHAREA1B(ch, 0x000, 0x000);
	AG903_DSPPrmSetDITHAREA2A(ch, 0x7FF, 0x7FF);
	AG903_DSPPrmSetDITHAREA2B(ch, 0x000, 0x000);
	AG903_DSPPrmSetDITHAREA3A(ch, 0x7FF, 0x7FF);
	AG903_DSPPrmSetDITHAREA3B(ch, 0x000, 0x000);
	AG903_DSPPrmSetERRCLR(ch, &errclr);
	AG903_DSPPrmSetINT(ch, &intprm);
	AG903_DSPPrmSetTRIGGER(ch, AG903_DSP_EVENT_VT,
						   AG903_DSP_TRG_HRZ_START_OF_LINE,
						   AG903_DSP_TRG_VT_START_OF_VBLANK);
	AG903_DSPPrmSetINTCLR(ch, true,
						  true,
						  true);
	AG903_DSPPrmSetINTMASK(ch, &intmask);
	AG903_DSPPrmSetDMAREQ(ch, AG903_DSP_DMA_NONE);
	int32_t tnum;
	for(tnum=0; tnum<AG903_DSP_LUT_NUM; tnum++)
	{
		AG903_DSPPrmSetLUTR(ch, tnum, &lutr);
		AG903_DSPPrmSetLUTG(ch, tnum, &lutg);
		AG903_DSPPrmSetLUTB(ch, tnum, &lutb);
	}

	int listno;
	for (listno=0; listno<AG903_DSP_ATTR_MAX; listno++)
	{
		gDSP.ch[ch].lock[listno] = NULL;
	}
}

/**
 * @brief           VOD
 * @param           ch [in] `l
 * @return          void
 * @description     w肵`lDSPW[܂.
 * @note            eWX^ɏlZbg܂.
 */
static void AG903_DSPMgrInitVOD(uint8_t ch) {
	if (ch > AG903_DSP_CH_NUM) return;

	VODPrmParamMOD mod = {
		.dp   = AG903_DSP_POLARITY_POSI,
		.vp	  = AG903_DSP_POLARITY_NEGA,
		.hp	  = AG903_DSP_POLARITY_NEGA,
		.fp	  = AG903_DSP_POLARITY_NEGA,
		.cdp  = AG903_DSP_POLARITY_POSI,
		.dex  = AG903_DSP_SIGNAL_ENABLE,
		.vex  = AG903_DSP_SIGNAL_ENABLE,
		.hex  = AG903_DSP_SIGNAL_ENABLE,
		.fex  = AG903_DSP_SIGNAL_ENABLE,
		.cdex = AG903_DSP_SIGNAL_ENABLE,
		.pex  = AG903_DSP_SIGNAL_ENABLE,
		.cp   = AG903_VOD_DOTCLK_LATCH_RISE,
		.code = false,
		.yuv  = AG903_VOD_MOD_YUV_BT601,
		.fmt  = 0,
		.ct0  = 0,
		.ct1  = 0,
	};

	if (ch == 0) {
		AG903_VODPrmSetPORTSEL(ch, AG903_VOD0_PORTSEL_LVCMOS24);
	} else {
		AG903_VODPrmSetPORTSEL(ch, AG903_VOD1_PORTSEL_LVDS_DUAL);
	}
	AG903_VODPrmSetMOD(ch, &mod);
	AG903_VODPrmSetBPWRMOD(ch, false, AG903_VOD_BPWR_UNIT_FRAME);
	AG903_VODPrmSetPPWRONCNT(ch, 0x00000000);
	AG903_VODPrmSetBPWRONCNT(ch, 0x00000000);
	AG903_VODPrmSetBLGTONCNT(ch, 0x00000000);
	AG903_VODPrmSetPPWROFFCNT(ch, 0x00000000);
	AG903_VODPrmSetBPWROFFCNT(ch, 0x00000000);
	AG903_VODPrmSetBLGTOFFCNT(ch, 0x00000000);
	AG903_VODPrmSetPWMPERIOD(ch, 0x00000000);
	AG903_VODPrmSetPWMCNT(ch, 0x00000000);
	AG903_VODPrmSetMACRO0(AG903_VOD_FR_8_16MHZ,
						  AG903_VOD_PM_AUTO, AG903_VOD_PDX_PWRDOWN);
	AG903_VODPrmSetMACRO1(AG903_VOD_FR_8_16MHZ,
						  AG903_VOD_PM_AUTO, AG903_VOD_PDX_PWRDOWN);
}

/**
 * @brief           DSPMgrS
 * @param           void
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @description     SĂDSPW[ADSPMgr܂.
 */
int32_t AG903_DSPMgrInit(void)
{
	uint8_t ch;
	uint32_t attr;

	for (ch=0; ch<AG903_DSP_CH_NUM; ch++) {
		if (gDSP.init == false) {
			/* DSP,VODSWX^ */
			AG903_DSPMgrInitDSP(ch);
			AG903_DSPMgrInitVOD(ch);
		}
		/* f[^ */
		gDSP.ch[ch].channel = ch;
		for (attr=0; attr<AG903_DSP_ATTR_MAX; attr++) {
			gDSP.ch[ch].lock[attr] = NULL;
		}
		gDSP.lock[ch] = NULL;
	}

	gDSP.init = true; /* ςݐݒ */

	return AG903_ENONE;
}

/**
 * @brief           DSPnh擾
 * @param           ch [in] `l(0-1)
 * @param           handle [out] DSPnh
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @retval          -AG903_EBUSY nhgp
 * @description     w肵`lDSPnh擾܂.
 */
int32_t AG903_DSPMgrGetHandle(uint8_t ch, AG903_DSPMgrHandle **handle)
{
	int32_t	rc = AG903_ENONE;

	if ((ch > AG903_DSP_CH_NUM) || (handle == NULL)) {
		rc = -AG903_EINVAL;
	}

	if (rc == AG903_ENONE) {
		if (gDSP.init == false) {
			AG903_DSPMgrInit();					/* DSPW[ */
		} else {
			if (gDSP.lock[ch] != NULL) {
				rc = -AG903_EBUSY;
			} else {
				AG903_DSPMgrInitDSP(ch);
				AG903_DSPMgrInitVOD(ch);
			}
		}
	}

	if (rc == AG903_ENONE) {
		(*handle) = (AG903_DSPMgrHandle *)&gDSP.ch[ch];
		gDSP.lock[ch] = (AG903_DSPMgrHandle *)(*handle);
	}

	return rc;
}

/**
 * @brief           DSPnh
 * @param           handle [in] DSPnh
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     DSPnhԋp܂.
 */
int32_t AG903_DSPMgrReleaseHandle(AG903_DSPMgrHandle *handle)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		rc = AG903_DSPMgrCheckStopped(handle);
	}

	if (rc == AG903_ENONE) {
		AG903_DSPMgrIntStat stat;
		AG903_DSPMgrGetIntStat(handle, &stat);
		stat.clr_vt_blank	= stat.int_vt_blank;
		stat.clr_hrz_line	= stat.int_hrz_line;
		stat.clr_dspoff		= stat.int_dspoff;
		rc = AG903_DSPMgrClearIntStat(handle, &stat);
	}

	if (rc == AG903_ENONE) {
		gDSP.lock[ch] = NULL;
	}

	return rc;
}

/**
 * @brief           \HON
 * @param           handle [in] DSPnh
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @retval          -AG903_EBUSY H쒆
 * @description     \HLɂ܂.
 */
int32_t AG903_DSPMgrEnable(AG903_DSPMgrHandle *handle)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		uint32_t dspon;
		AG903_DSPPrmGetCTRL(ch, &dspon);
		if (dspon == AG903_DSP_CTRL_OFF) {
			AG903_DSPPrmSetCTRL(ch, AG903_DSP_CTRL_ON);
		} else {
			rc = -AG903_EBUSY;
		}
	}

	return rc;
}

/**
 * @brief           \HOFF
 * @param           handle [in] DSPnh
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     \H𖳌ɂ܂.
 */
int32_t AG903_DSPMgrDisable(AG903_DSPMgrHandle *handle)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;				/* ʔԍ */

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_DSPPrmSetCTRL(ch, false);
	}

	return rc;
}

/**
 * @brief           \Hp[^擾
 * @param           handle [in] DSPnh
 * @param           param [in] \Hp[^
 * @return          G[R[h
 * @retval          AG903_ENONE  I
 * @retval          -AG903_EINVAL  p[^ُ
 * @description     ݒ肳Ă\Hp[^擾܂.
 */
int32_t AG903_DSPMgrGetCtrlParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrCtrlParam *param)
{
	int32_t			rc = AG903_ENONE;
	uint8_t			ch;				/* ʔԍ */

	if ((handle == NULL) || (param == NULL))
		return -AG903_EINVAL;
	if (param->syncparam == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		DSPPrmParamMOD mod;
		DSPPrmParamSYNC sync;
		DSPPrmParamVTPRM0 vtprm0;

		AG903_DSPPrmGetMOD(ch, &mod);
		AG903_DSPPrmGetSYNC(ch, &sync);
		AG903_DSPPrmGetVTPRM0(ch, &vtprm0);

		param->ip_sel = mod.ip;
		AG903_DSPPrmGetFRMSIZE(ch,
							   &param->vt_framesize,
							   &param->hrz_framesize);

		param->syncparam->rgbde_sel				 = mod.de;
		param->syncparam->vsync_polarity		 = sync.vp;
		param->syncparam->field_hsync_polarity	 = sync.fp;
		param->syncparam->vt_pulsewidth			 = vtprm0.vpw;
		param->syncparam->odd_frontporch_plus1	 = vtprm0.ofp;
		param->syncparam->odd_backporch_plus1	 = vtprm0.obp;
		param->syncparam->even_frontporch_plus1	 = vtprm0.efp;
		param->syncparam->even_backporch_plus1	 = vtprm0.ebp;
		AG903_DSPPrmGetHRZPRM0(ch, &param->syncparam->hrz_pulsewidth);
		AG903_DSPPrmGetHRZPRM1(ch,
							   &param->syncparam->hrz_frontporch,
							   &param->syncparam->hrz_backporch);
		AG903_DSPPrmGetVTPRM1(ch,
							  &param->syncparam->vt_frontporch,
							  &param->syncparam->vt_backporch);
	}

	return rc;
}

/**
 * @brief           EBhEp[^ݒ
 * @param           handle [in] DSPnh
 * @param           param [in] EBhEp[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ, Eᔽ
 * @retval          -AG903_EBUSY \H쒆
 * @retval          -AG903_ECHRNG őEBhE
 * @description     EBhEp[^̐ݒύX܂.
 * @note            \H쒆ɂ͐ݒł܂.
 * @note            EBhEAgr[gXg8ByteEɔzuKv܂.
 * @note            EBhEAgr[gXg̗̈̃̓LbVsƂĉ.
 * @note            EBhEAgr[gXg̃EChE̒lsŃG[ɂȂꍇ͊֘Ap^[܂߂ĊmFĂB
 * @note            [XrhPrimitivewNDEBUG`ăRpCĂꍇAEBhEAgr[gXg̒l̑Ó̓`FbN܂B
 */
int32_t AG903_DSPMgrSetWindowParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrWindowParam *param)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (param == NULL))
		return -AG903_EINVAL;
	if (param->window_attr_base & ~0xFFFFFFF8)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		rc = AG903_DSPMgrCheckStopped(handle);
	}

	if (rc == AG903_ENONE) {
		DSPPrmParamMOD mod;
		uint32_t act, conf;

		AG903_DSPPrmGetMOD(ch, &mod);
		mod.upd = param->update_timing;
		AG903_DSPPrmSetMOD(ch, &mod);

		AG903_DSPPrmSetBGCOL(ch, param->background);			/* EBhEwiFݒ */
		AG903_DSPPrmSetWINNUM(ch, param->num_config);			/* EBhEݒ */
		AG903_DSPPrmSetWATNUM(ch, param->num_attr);				/* Agr[gw */
		AG903_DSPPrmSetWATBASE(ch, param->window_attr_base);	/* Agr[gAhXݒ */
		AG903_DSPPrmSetLSTCTRL(ch,
							   param->palette_update,			/* pbgXVݒ */
							   param->window_attr_update);		/* EBhEAgr[gXVݒ */
		AG903_DSPPrmGetWINNUM(ch, &act, &conf);					/* EBhEmF */
		if (param->num_config != act) {
			rc = -AG903_ECHRNG;
		}
	}

	return rc;
}

/**
 * @brief           Agr[gXgύX
 * @param           handle [in] DSPnh
 * @param           param [in] EBhEp[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     EBhEAgr[gXg̐ݒύX܂.
 * @note            EBhEAgr[gXg8ByteEɔzuKv܂.
 * @note            EBhEAgr[gXg̗̈̃̓LbVsƂĉ.
 */
int32_t AG903_DSPMgrSetAttributeList(AG903_DSPMgrHandle *handle, AG903_DSPMgrWindowParam *param)
{
	int32_t			rc = AG903_ENONE;
	uint8_t			ch;								/* ʔԍ */

	if ((handle == NULL) || (param == NULL))
		return -AG903_EINVAL;
	if (param->window_attr_base & ~0xFFFFFFF8)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_DSPPrmSetWATNUM(ch, param->num_attr);
		AG903_DSPPrmSetWATBASE(ch, param->window_attr_base);
	}

	return rc;
}

/**
 * @brief           荞ݐݒ
 * @param           handle [in] DSPnh
 * @param           param [in] ݃p[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @retval          -AG903_EBUSY \H쒆
 * @description     \荞݂̐ݒύX܂.
 * @note            EBhEAgr[gXg8ByteEɔzuKv܂.
 */
int32_t AG903_DSPMgrSetIntParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrIntParam *param)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (param == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		rc = AG903_DSPMgrCheckStopped(handle);
	}

	if (rc == AG903_ENONE) {
		DSPPrmParamMOD mod;
		AG903_DSPPrmGetMOD(ch, &mod);
		mod.bmr = param->bmureq_timing;
		AG903_DSPPrmSetMOD(ch, &mod);

		DSPPrmParamINT intprm = {
			.line  = param->int_line_no,
			.fcnt  = param->int_framecount,
			.hline = param->int_hrz_line,
			.vblk  = param->int_vt_blank,
		};
		AG903_DSPPrmSetINT(ch, &intprm);

		DSPPrmParamINTMASK intmask = {
			.vblk  = param->mask_vt_blank,
			.hline = param->mask_hrz_line,
			.doff  = param->mask_dspoff,
			.err   = param->mask_error,
		};
		AG903_DSPPrmSetINTMASK(ch, &intmask);

		AG903_DSPPrmSetTRIGGER(ch,
							   param->trigger_out,
							   param->trigger_hrz,
							   param->trigger_vt);
	}

	return rc;
}

/**
 * @brief           荞݃}XNݒ
 * @param           handle [in] DSPnh
 * @param           param [in] ݃p[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     \荞݃}XNݒύX܂.
 * @description     param̎̃oׂĐݒ肵ĉ.
 *                  * mask_vt_blank
 *                  * mask_hrz_line
 *                  * mask_dspoff
 *                  * mask_error
 */
int32_t AG903_DSPMgrSetIntMask(AG903_DSPMgrHandle *handle, AG903_DSPMgrIntParam *param)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (param == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		DSPPrmParamINTMASK intmask = {
			.vblk  = param->mask_vt_blank,
			.hline = param->mask_hrz_line,
			.doff  = param->mask_dspoff,
			.err   = param->mask_error,
		};
		AG903_DSPPrmSetINTMASK(ch, &intmask);
	}

	return rc;
}

/**
 * @brief           ݏԎ擾
 * @param           handle [in] DSPnh
 * @param           stat [in] ݏ
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     \荞݂̏Ԃ擾܂.
 */
int32_t AG903_DSPMgrGetIntStat(AG903_DSPMgrHandle *handle, AG903_DSPMgrIntStat *stat)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (stat == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		DSPPrmParamINTSTAT intstat;
		AG903_DSPPrmGetINTSTAT(ch, &intstat);
		stat->int_vt_blank = intstat.vblk;			/** uNݏ */
		stat->int_hrz_line = intstat.hline;			/** Cݏ */
		stat->int_dspoff   = intstat.doff;			/** \H~荞ݏ */
		stat->dreq         = intstat.dreq;			/** DMANGXg */
	}

	return rc;
}

/**
 * @brief           荞ݗvNA
 * @param           handle [in] DSPnh
 * @param           stat [in] ݏ
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     \荞ݗvNA܂.
 * @note            stat̃NA֘Aoɏ]ăNA܂.
 * @note            ̊֐͔^XNReLXgs邱Ƃł܂.
 */
int32_t AG903_DSPMgrClearIntStat(AG903_DSPMgrHandle *handle, AG903_DSPMgrIntStat *stat)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (stat == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_DSPPrmSetINTCLR(ch,
							  stat->clr_vt_blank,
							  stat->clr_hrz_line,
							  stat->clr_dspoff);
	}

	return rc;
}

/**
 * @brief           HԎ擾
 * @param           handle [in] DSPnh
 * @param           stat [out] H
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     \H̓Ԃ擾܂.
 * @description     stat̎̃o擾܂.
 *                  * work_line
 *                  * vt_status
 *                  * framecount
 *                  * work_pix
 *                  * hrz_status
 */
int32_t AG903_DSPMgrGetStat(AG903_DSPMgrHandle *handle, AG903_DSPMgrStat *stat)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (stat == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		DSPPrmParamERRSTAT errstat;
		AG903_DSPPrmGetERRSTAT(ch, &errstat);
		stat->err_line = errstat.line;
		stat->err_ue = errstat.ue;
		stat->err_le = errstat.le;
		stat->err_pe = errstat.pe;
		AG903_DSPPrmGetVTSTAT(ch, &stat->work_line, &stat->vt_status, &stat->frameconut);
		AG903_DSPPrmGetHRZSTAT(ch, &stat->work_pix, &stat->hrz_status);

		uint32_t state;
		AG903_VODPrmGetSTAT(ch, &state);
		if (state == 0)
			stat->ctrl_status = AG903_DSP_CTRL_OFF;
		else
			stat->ctrl_status = AG903_DSP_CTRL_ON;
	}

	return rc;
}

/**
 * @brief           HG[ԃNA
 * @param           handle [in] DSPnh
 * @param           stat [out] H
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     eG[vNA܂.
 * @description     stat̎̃oׂĐݒ肵ĉ.
 *                  * errclr_line
 *                  * errclr_ue
 *                  * errclr_le
 *                  * errclr_pe
 */
int32_t AG903_DSPMgrClearStat(AG903_DSPMgrHandle *handle, AG903_DSPMgrStat *stat)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (stat == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		DSPPrmParamERRCLR errclr;
		errclr.line = stat->errclr_line;
		errclr.ue = stat->errclr_ue;
		errclr.le = stat->errclr_le;
		errclr.pe = stat->errclr_pe;
		AG903_DSPPrmSetERRCLR(ch, &errclr);
	}

	return rc;
}

/**
 * @brief           EBhEAgr[g̕ύXJn
 * @param           handle [in] DSPnh
 * @param           listno [in] Agr[gXgԍ
 * @param           attr [out] EBhEAgr[gi[obt@
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EBUSY EBhEAgr[ggp
 * @retval          -AG903_EINVAL p[^ُ
 * @description     w肳ꂽXgԍ̃EBhEAgr[g̕ύXJn܂.
 * @description     擾|C^ɑ΂ăEChEAgr[gύXĉ.
 * @note            AG903_DSPMgrSetAttributeƑ΂Ŏgpĉ.
 * @note            ύXɐVɕύXJn邱Ƃ͂ł܂.
 */
int32_t AG903_DSPMgrGetAttribute(AG903_DSPMgrHandle *handle, uint8_t listno, AG903_DSPMgrWinAttribute **attr)
{
	int32_t				rc = AG903_ENONE;
	uint32_t			addr;						/* Agr[gx[XAhX */
	uint8_t				ch;							/* ʔԍ */
	uint32_t			watnum;						/* Agr[g */

	if ((handle == NULL) || (attr == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_DSPPrmGetWATNUM(ch, &watnum);

		if (listno >= watnum) {
			rc = -AG903_EINVAL;
		}
	}

	if (rc == AG903_ENONE) {
		if (gDSP.ch[ch].lock[listno] != NULL) {
			rc = -AG903_EBUSY;
		}
	}

	if (rc == AG903_ENONE) {
		AG903_DSPPrmGetWATBASE(ch, &addr);
		(*attr) = ((AG903_DSPMgrWinAttribute *)addr + listno);
		gDSP.ch[ch].lock[listno] = (uint32_t *)(*attr);
	}

	return rc;
}

/**
 * @brief           EBhEAgr[g̕ύXI
 * @param           handle [in] DSPnh
 * @param           listno [in] Agr[gXgԍ
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     w肳ꂽXgԍ̃EBhEAgr[g̕ύXI܂.
 * @note            AG903_DSPMgrGetAttributeƑ΂Ŏgpĉ.
 */
int32_t AG903_DSPMgrSetAttribute(AG903_DSPMgrHandle *handle, uint8_t listno)
{
	int32_t  rc = AG903_ENONE;
	uint8_t  ch;				/* ʔԍ */
	uint32_t watnum;			/* Agr[g */

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_DSPPrmGetWATNUM(ch, &watnum);

		if ((listno >= watnum)
			||  (gDSP.ch[ch].lock[listno] == NULL)) {
			rc = -AG903_EINVAL;
		}
	}

	if (rc == AG903_ENONE) {
		gDSP.ch[ch].lock[listno] = NULL;
	}

	return rc;
}

/**
 * @brief           Op[^ݒ
 * @param           handle [in] DSPnh
 * @param           param [in] Op[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @retval          -AG903_EBUSY \H쒆
 * @description     Op[^̐ݒύX܂.
 * @note            \H쒆ɂ͐ݒł܂.
 */
int32_t AG903_DSPMgrSetExSyncParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrExSyncParam *param)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (param == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		rc = AG903_DSPMgrCheckStopped(handle);
	}

	if (rc == AG903_ENONE) {
		DSPPrmParamSYNC sync;
		sync.sel = param->sync_sel;
		sync.dly = param->delay_ctrl_en;
		sync.ip = param->ip_sel;
		sync.vp = param->vsync_polarity;
		sync.fp = param->field_hsync_polarity;
		sync.msk = param->sync_mask_en;
		AG903_DSPPrmSetSYNC(ch, &sync); /* Op[^ݒ */
	}

	return rc;
}

/**
 * @brief           F␳p[^ݒ
 * @param           handle [in] DSPnh
 * @param           en [in] @\L
 * @param           param [in] F␳p[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     F␳p[^̐ݒύX܂.
 * @note            OparamNULLnꍇALݒ݂̂ύX܂.
 */
int32_t AG903_DSPMgrSetLutParam(AG903_DSPMgrHandle *handle, _Bool en, AG903_DSPMgrLutParam *param)
{
	int32_t  rc = AG903_ENONE;
	uint8_t  ch;				/* ʔԍ */
	uint32_t cnt;
	DSPPrmParamMOD mod;

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		if (param != NULL) {
			DSPPrmParamLUTR lutr = {0};
			DSPPrmParamLUTG lutg = {0};
			DSPPrmParamLUTB lutb = {0};
			for (cnt = 0;cnt < AG903_DSP_LUT_NUM;cnt++) {
				lutr.r0 = param->LUTR[cnt].r0;
				lutr.r1 = param->LUTR[cnt].r1;
				lutr.r2 = param->LUTR[cnt].r2;
				lutr.r3 = param->LUTR[cnt].r3;
				lutg.g0 = param->LUTG[cnt].g0;
				lutg.g1 = param->LUTG[cnt].g1;
				lutg.g2 = param->LUTG[cnt].g2;
				lutg.g3 = param->LUTG[cnt].g3;
				lutb.b0 = param->LUTB[cnt].b0;
				lutb.b1 = param->LUTB[cnt].b1;
				lutb.b2 = param->LUTB[cnt].b2;
				lutb.b3 = param->LUTB[cnt].b3;
				AG903_DSPPrmSetLUTR(ch, cnt, &lutr);
				AG903_DSPPrmSetLUTG(ch, cnt, &lutg);
				AG903_DSPPrmSetLUTB(ch, cnt, &lutb);
			}
		}
		AG903_DSPPrmGetMOD(ch, &mod);
		mod.lut = en ? true : false;
		AG903_DSPPrmSetMOD(ch, &mod);
	}

	return rc;
}

/**
 * @brief           Fp[^ݒ
 * @param           handle [in] DSPnh
 * @param           en [in] @\L
 * @param           param [in] Fp[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     Fp[^̐ݒύX܂.
 * @note            OparamNULLnꍇALݒ݂̂ύX܂.
 */
int32_t AG903_DSPMgrSetDithParam(AG903_DSPMgrHandle *handle, _Bool en, AG903_DSPMgrDithParam *param)
{
	int32_t			rc = AG903_ENONE;
	uint8_t			ch;								/* ʔԍ */
	DSPPrmParamMOD	mod;

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		if (param != NULL) {
			AG903_DSPPrmSetDITHAREA0A(ch, param->DITHAREA[0].x0, param->DITHAREA[0].y0);
			AG903_DSPPrmSetDITHAREA0B(ch, param->DITHAREA[0].x1, param->DITHAREA[0].y1);
			AG903_DSPPrmSetDITHAREA1A(ch, param->DITHAREA[1].x0, param->DITHAREA[1].y0);
			AG903_DSPPrmSetDITHAREA1B(ch, param->DITHAREA[1].x1, param->DITHAREA[1].y1);
			AG903_DSPPrmSetDITHAREA2A(ch, param->DITHAREA[2].x0, param->DITHAREA[2].y0);
			AG903_DSPPrmSetDITHAREA2B(ch, param->DITHAREA[2].x1, param->DITHAREA[2].y1);
			AG903_DSPPrmSetDITHAREA3A(ch, param->DITHAREA[3].x0, param->DITHAREA[3].y0);
			AG903_DSPPrmSetDITHAREA3B(ch, param->DITHAREA[3].x1, param->DITHAREA[3].y1);
		}
		AG903_DSPPrmGetMOD(ch, &mod);
		mod.dith = en ? true : false;
		AG903_DSPPrmSetMOD(ch, &mod);
	}

	return rc;
}

/**
 * @brief           Fop[^ݒ
 * @param           handle [in] DSPnh
 * @param           param [in] Fop[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     Fop[^̐ݒύX܂.
 * @note            OparamNULLnꍇAForSĖɐݒ肵܂.
 */
int32_t AG903_DSPMgrSetCDParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrCDParam *param)
{
	int32_t			rc = AG903_ENONE;
	uint8_t			ch;								/* ʔԍ */

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		DSPPrmParamCOLDET coldet;
		DSPPrmParamCDCTRL cdctrl;
		if (param == NULL) {
			AG903_DSPPrmGetCDCTRL(ch, &cdctrl);
			cdctrl.be = false;
			cdctrl.ge = false;
			cdctrl.re = false;
			cdctrl.ae = false;
			AG903_DSPPrmSetCDCTRL(ch, &cdctrl);
		} else {
			cdctrl.be = param->colordetect_en_b;
			cdctrl.ge = param->colordetect_en_g;
			cdctrl.re = param->colordetect_en_r;
			cdctrl.ae = param->colordetect_en_a;
			coldet.b  = param->colordetect_color_b;
			coldet.g  = param->colordetect_color_g;
			coldet.r  = param->colordetect_color_r;
			coldet.a  = param->colordetect_color_a;
			AG903_DSPPrmSetCOLDET(ch, &coldet); /* Forlݒ */
			AG903_DSPPrmSetCDCTRL(ch, &cdctrl); /* FoLݒ */
		}
	}

	return rc;
}

/**
 * @brief           DMANGXgݒ
 * @param           handle [in] DSPnh
 * @param           req [in] DMANGXg^C~O
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     DMANGXg̐ݒύX܂.
 */
int32_t AG903_DSPMgrSetDMAReq(AG903_DSPMgrHandle *handle, uint8_t req)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_DSPPrmSetDMAREQ(ch, req);
	}

	return rc;
}

/**
 * @brief           CMOSo̓p[^ݒ
 * @param           handle [in] DSPnh
 * @param           ctrl [in] \Hp[^
 * @param           param [in] CMOSo̓p[^
 * @return          G[R[h
 * @retval          AG903_ENONE  I
 * @retval          -AG903_EINVAL  p[^ُ
 * @retval          -AG903_EILLEGAL hbgNbNpPLLݒ
 * @description     CMOSo̓p[^̐ݒύX܂.
 */
int32_t AG903_DSPMgrSetCMOSParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrCtrlParam *ctrl, AG903_DSPMgrCMOSParam *param)
{
	int32_t				rc = AG903_ENONE;
	uint8_t				ch;							/* ʔԍ */

	if ((handle == NULL) || (ctrl == NULL) || (param == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		rc = AG903_DSPMgrCheckStopped(handle);
	}

	if (rc == AG903_ENONE) {
		DSPPrmParamMOD mod;
		DSPPrmParamSYNC sync;
		DSPPrmParamVTPRM0 vtprm0;

		AG903_DSPPrmGetMOD(ch, &mod);
		if (NULL != ctrl->syncparam) {
			mod.de   = ctrl->syncparam->rgbde_sel;
		}
		mod.ip   = ctrl->ip_sel;
		AG903_DSPPrmSetMOD(ch, &mod);

		if (NULL != ctrl->syncparam) {
			AG903_DSPPrmGetSYNC(ch, &sync);
			sync.vp = ctrl->syncparam->vsync_polarity;
			sync.fp = ctrl->syncparam->field_hsync_polarity;
			AG903_DSPPrmSetSYNC(ch, &sync);

			vtprm0.vpw = ctrl->syncparam->vt_pulsewidth;
			vtprm0.ofp = ctrl->syncparam->odd_frontporch_plus1;
			vtprm0.obp = ctrl->syncparam->odd_backporch_plus1;
			vtprm0.efp = ctrl->syncparam->even_frontporch_plus1;
			vtprm0.ebp = ctrl->syncparam->even_backporch_plus1;
			AG903_DSPPrmSetVTPRM0(ch, &vtprm0);

			AG903_DSPPrmSetHRZPRM0(ch, ctrl->syncparam->hrz_pulsewidth);
			AG903_DSPPrmSetHRZPRM1(ch, ctrl->syncparam->hrz_frontporch,
								   ctrl->syncparam->hrz_backporch);
			AG903_DSPPrmSetVTPRM1(ch, ctrl->syncparam->vt_frontporch,
								  ctrl->syncparam->vt_backporch);
		}
		AG903_DSPPrmSetFRMSIZE(ch, ctrl->vt_framesize, ctrl->hrz_framesize);

		if (rc == AG903_ENONE) {
			VODPrmParamMOD mod;
			AG903_VODPrmGetMOD(ch, &mod);
			mod.dp   = param->rgbde_polarity;
			mod.vp   = param->vsync_polarity;
			mod.hp   = param->hsync_polarity;
			mod.fp   = param->field_polarity;
			mod.cdp  = param->colordetect_polarity;
			mod.dex  = param->rgbde_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
			mod.vex  = param->vsync_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
			mod.hex  = param->hsync_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
			mod.fex  = param->field_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
			mod.cdex = param->colordetect_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
			mod.pex  = param->pixeldata_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
			mod.cp   = param->dotclk_polarity;
			mod.code = param->code_en;
			mod.yuv  = param->yuv_mode;
			AG903_VODPrmSetMOD(ch, &mod);
		}
	}

	return rc;
}

/**
 * @brief           LVDSo̓p[^ݒ
 * @param           handle [in] DSPnh
 * @param           ctrl [in] \Hp[^
 * @param           param [in] LVDSo̓p[^
 * @return          G[R[h
 * @retval          AG903_ENONE  I
 * @retval          -AG903_EINVAL  p[^ُ
 * @retval          -AG903_EILLEGAL hbgNbNpPLLݒ
 * @description     LVDSo̓p[^̐ݒύX܂.
 * @note            LVDSfAN̏ꍇCh1̃nh擾ɑ΂Đݒ肵ĉ.
 */
int32_t AG903_DSPMgrSetLVDSParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrCtrlParam *ctrl, AG903_DSPMgrLVDSParam *param)
{
	int32_t				rc = AG903_ENONE;
	uint8_t				ch;							/* ʔԍ */

	if ((handle == NULL) || (ctrl == NULL) || (param == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		rc = AG903_DSPMgrCheckStopped(handle);
	}

	if (rc == AG903_ENONE) {
		DSPPrmParamMOD mod;
		DSPPrmParamSYNC sync;
		DSPPrmParamVTPRM0 vtprm0;

		AG903_DSPPrmGetMOD(ch, &mod);
		if (NULL != ctrl->syncparam) {
			mod.de   = ctrl->syncparam->rgbde_sel;
		}
		mod.ip   = ctrl->ip_sel;
		AG903_DSPPrmSetMOD(ch, &mod);

		if (NULL != ctrl->syncparam) {
			AG903_DSPPrmGetSYNC(ch, &sync);
			sync.vp = ctrl->syncparam->vsync_polarity;
			sync.fp = ctrl->syncparam->field_hsync_polarity;
			AG903_DSPPrmSetSYNC(ch, &sync);

			vtprm0.vpw = ctrl->syncparam->vt_pulsewidth;
			vtprm0.ofp = ctrl->syncparam->odd_frontporch_plus1;
			vtprm0.obp = ctrl->syncparam->odd_backporch_plus1;
			vtprm0.efp = ctrl->syncparam->even_frontporch_plus1;
			vtprm0.ebp = ctrl->syncparam->even_backporch_plus1;
			AG903_DSPPrmSetVTPRM0(ch, &vtprm0);

			AG903_DSPPrmSetHRZPRM0(ch, ctrl->syncparam->hrz_pulsewidth);
			AG903_DSPPrmSetHRZPRM1(ch, ctrl->syncparam->hrz_frontporch,
								   ctrl->syncparam->hrz_backporch);
			AG903_DSPPrmSetVTPRM1(ch, ctrl->syncparam->vt_frontporch,
								  ctrl->syncparam->vt_backporch);
		}
		AG903_DSPPrmSetFRMSIZE(ch, ctrl->vt_framesize, ctrl->hrz_framesize);
	}

	if (rc == AG903_ENONE) {
		VODPrmParamMOD mod;
		uint32_t portsel;
		AG903_VODPrmGetMOD(ch, &mod);
		mod.dp   = param->rgbde_polarity;
		mod.vp   = param->vsync_polarity;
		mod.hp   = param->hsync_polarity;
		mod.fp   = param->field_polarity;
		mod.cdp  = param->colordetect_polarity;
		mod.dex  = param->rgbde_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
		mod.vex  = param->vsync_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
		mod.hex  = param->hsync_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
		mod.fex  = param->field_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
		mod.cdex = param->colordetect_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
		mod.pex  = param->pixeldata_en ? AG903_DSP_SIGNAL_ENABLE : AG903_DSP_SIGNAL_DISABLE;
		mod.fmt  = param->format;
		mod.ct0  = param->ctrl0;
		mod.ct1  = param->ctrl1;
		AG903_VODPrmSetMOD(ch, &mod);
		AG903_VODPrmGetPORTSEL(1, &portsel);
		if (portsel == 0 || ch == 0) {
			AG903_VODPrmSetMACRO0(param->freq_range,
								  param->auto_powermanage,
								  param->macro_power);
		}
		if (ch == 1) {
			AG903_VODPrmSetMACRO1(param->freq_range,
								  param->auto_powermanage,
								  param->macro_power);
		}
	}

	return rc;
}

/**
 * @brief           obNCgp[^擾
 * @param           handle [in] DSPnh
 * @param           param [out] obNCgp[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     obNCgp[^̐ݒ擾܂.
 */
int32_t AG903_DSPMgrGetBPwrModeParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrBPwrModeParam *param)
{
	int32_t			rc = AG903_ENONE;
	uint8_t			ch;								/* ʔԍ */

	if ((handle == NULL) || (param == NULL)) {
		rc = -AG903_EINVAL;
	}

	if (rc == AG903_ENONE) {
		rc = DSPMgrCheckHandle(handle, &ch);
	}

	if (rc == AG903_ENONE) {
		AG903_VODPrmGetBPWRMOD(ch, &param->backlight_en, &param->cnt_unit);
		AG903_VODPrmGetPPWRONCNT(ch, &param->panel_pwroncnt);
		AG903_VODPrmGetBPWRONCNT(ch, &param->backlight_pwroncnt);
		AG903_VODPrmGetBLGTONCNT(ch, &param->backlight_oncnt);
		AG903_VODPrmGetPPWROFFCNT(ch, &param->panel_pwroffcnt);
		AG903_VODPrmGetBPWROFFCNT(ch, &param->backlight_pwroffcnt);
		AG903_VODPrmGetBLGTOFFCNT(ch, &param->backlight_offcnt);
		AG903_VODPrmGetPWMPERIOD(ch, &param->pwm_period);
		AG903_VODPrmGetPWMCNT(ch, &param->pwm_cnt);
	}

	return rc;
}

/**
 * @brief           obNCgp[^ݒ
 * @param           handle [in] DSPnh
 * @param           param [in] obNCgp[^
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     obNCgp[^̐ݒύX܂.
 */
int32_t AG903_DSPMgrSetBPwrModeParam(AG903_DSPMgrHandle *handle, AG903_DSPMgrBPwrModeParam *param)
{
	int32_t			rc = AG903_ENONE;
	uint8_t			ch;								/* ʔԍ */

	if ((handle == NULL) || (param == NULL)) {
		rc = -AG903_EINVAL;
	}

	if (rc == AG903_ENONE) {
		rc = DSPMgrCheckHandle(handle, &ch);
	}

	if (rc == AG903_ENONE) {
		AG903_VODPrmSetBPWRMOD(ch, param->backlight_en, param->cnt_unit);
		AG903_VODPrmSetPPWRONCNT(ch, param->panel_pwroncnt);
		AG903_VODPrmSetBPWRONCNT(ch, param->backlight_pwroncnt);
		AG903_VODPrmSetBLGTONCNT(ch, param->backlight_oncnt);
		AG903_VODPrmSetPPWROFFCNT(ch, param->panel_pwroffcnt);
		AG903_VODPrmSetBPWROFFCNT(ch, param->backlight_pwroffcnt);
		AG903_VODPrmSetBLGTOFFCNT(ch, param->backlight_offcnt);
		AG903_VODPrmSetPWMPERIOD(ch, param->pwm_period);
		AG903_VODPrmSetPWMCNT(ch, param->pwm_cnt);
	}

	return rc;
}

/**
 * @brief           ʏo͏Ԏ擾
 * @param           handle [in] DSPnh
 * @param           stat [out] ʏo͏<
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     ʏo͂̓Ԃ擾܂.
 */
int32_t AG903_DSPMgrGetVODStat(AG903_DSPMgrHandle *handle, uint32_t *stat)
{
	int32_t rc = AG903_ENONE;
	uint8_t ch;					/* ʔԍ */

	if ((handle == NULL) || (stat == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_VODPrmGetSTAT(ch, stat);				/* ʏo͏Ԏ擾 */
	}

	return rc;
}

/**
 * @brief           ʏo̓|[gݒ擾
 * @param           handle [in] DSPnh
 * @param           sel [out] ʏo͐
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @description     ݒ肳Ăʏo̓|[g擾܂.
 */
int32_t AG903_DSPMgrGetPortSel(AG903_DSPMgrHandle *handle, uint8_t *sel)
{
	int32_t  rc = AG903_ENONE;
	uint8_t  ch;					/* ʔԍ */
	uint32_t portsel;

	if ((handle == NULL) || (sel == NULL))
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_VODPrmGetPORTSEL(ch, &portsel);
		*sel = portsel & 0xFF;
	}

	return rc;
}

/**
 * @brief           ʏo̓|[gݒ
 * @param           handle [in] DSPnh
 * @param           sel [in] ʏo͐
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @description     ʏo̓|[g̐ݒύX܂.
 */
int32_t AG903_DSPMgrSetPortSel(AG903_DSPMgrHandle *handle, uint8_t sel)
{
	int32_t  rc = AG903_ENONE;
	uint8_t  ch;					/* ʔԍ */

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (ch == 0) {
		if (sel > AG903_VOD0_PORTSEL_LVDS_SINGLE)
			rc = -AG903_EINVAL;
	} else {
		if (sel > AG903_VOD1_PORTSEL_LVDS_SINGLE)
			rc = -AG903_EINVAL;
	}

	if (rc == AG903_ENONE) {
		AG903_VODPrmSetPORTSEL(ch, sel);
	}

	return rc;
}

/**
 * @brief           nh`FbN
 * @param           handle [in] DSPnh
 * @param           ch  [out] `lԍ
 * @return          G[R[h
 * @retval          AG903_ENONE I
 * @retval          -AG903_EINVAL p[^ُ
 * @description     nhlA`l̐`FbN܂.
 */
static int32_t DSPMgrCheckHandle(AG903_DSPMgrHandle *handle, uint8_t *ch)
{
	uint32_t channel = ((uint32_t)handle - (uint32_t)gDSP.ch) / sizeof(DSPChBlock);

	if ((channel >= AG903_DSP_CH_NUM) ||
		(gDSP.lock[channel] != handle)) {
		return -AG903_EINVAL;
	}

	*ch = (uint8_t)channel;

	return AG903_ENONE;
}

/**
 * @brief           \H~`FbN
 * @param           ch [in] `l(0-1)
 * @return          G[R[h
 * @retval          AG903_ENONE \H~
 * @retval          -AG903_EBUSY \H쒆
 * @description     \H~Ă邩𔻒肵܂.<p>
 *                  obNCg̐ݒȂǂɂẮA<p>
 *                  ~ݒƎۂɉH~^C~OقȂꍇ܂.<p>
 *                  \H~Ă邱Ƃ𔻒肷邽߂ɁA{֐gpĂ.
 */
int32_t AG903_DSPMgrCheckStopped(AG903_DSPMgrHandle *handle)
{
	int32_t  rc = AG903_ENONE;
	uint8_t  ch;					/* ʔԍ */
	uint32_t stat;

	if (handle == NULL)
		return -AG903_EINVAL;

	rc = DSPMgrCheckHandle(handle, &ch);

	if (rc == AG903_ENONE) {
		AG903_VODPrmGetSTAT(ch, &stat);
		if (stat != 0)
			rc = -AG903_EBUSY;
	}

	return rc;
}

