/**
 * @brief           I2C Primitive
 * @author          AXELL CORPORATION
 * @description     I2C Primitive Layer
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "AG903_common.h"
#include "i2c/i2cprm.h"
#include "register/AG903_i2creg.h"

#define    AG903_I2C_READ_REG(CH,REG)            (AG903_IICn(CH)->REG)
#define    AG903_I2C_WRITE_REG(CH,REG,VAL)        (AG903_IICn(CH)->REG  = (uint32_t)(VAL))
#define    AG903_I2C_CLR_REG(CH,REG,VAL)        (AG903_IICn(CH)->REG &= (uint32_t)(~VAL))
#define    AG903_I2C_SET_REG(CH,REG,VAL)        (AG903_IICn(CH)->REG |= (uint32_t)(VAL))

/**
 * @brief           IICnCRWX^I2C_RSTrbgSet
 * @param           ch [in] I2C`l
 * @return          void
 * @description     IICnCRWX^I2C_RSTrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_I2CPrmResetController(uint8_t ch)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    AG903_I2C_SET_REG(ch,CR,(1<<AG903_IICn_CR_I2C_RST_POS));
    return;
}

/**
 * @brief           IICnCRWX^I2C_RSTrbgRead
 * @param           ch [in] I2C`l
 * @param           status [out] ԁiI2C_RSTlj
 * @return          void
 * @description     IICnCRWX^I2C_RSTrbgRead
*/
void AG903_I2CPrmGetResetStatus(uint8_t ch, uint8_t* status)
{
    uint32_t val;

    ASSERT(AG903_I2C_CH_NUM > ch);
    val = AG903_I2C_READ_REG(ch,CR);
    (*status) = (uint8_t)(val&AG903_IICn_CR_I2C_RST_MSK);
    return;
}

/**
 * @brief           IICnCR̃WX^Write(wrbgSet)
 * @param           ch [in] I2C`l
 * @param           ctrlbit [in] wirbgwj
 * @return          void
 * @description     IICnCR̃WX^Write(wrbgSet)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_I2CPrmSetControl(uint8_t ch, uint32_t setbit)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    AG903_I2C_SET_REG(ch,CR,setbit);
    return;
}

/**
 * @brief           IICnCR̃WX^Write(wrbgClear)
 * @param           ch [in] I2C`l
 * @param           ctrlbit [in] wirbgwj
 * @return          void
 * @description     IICnCR̃WX^Write(wrbgClear)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_I2CPrmClearControl(uint8_t ch, uint32_t clrbit)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    AG903_I2C_CLR_REG(ch,CR,clrbit);
    return;
}

/**
 * @brief           IICnSR̃WX^Read
 * @param           ch [in] I2C`l
 * @param           status [out] ԁiSRlj
 * @return          void
 * @description     IICnSR̃WX^Read
*/
void AG903_I2CPrmGetStatus(uint8_t ch, uint32_t* status)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    (*status) = AG903_I2C_READ_REG(ch,SR);
    return;
}

/**
 * @brief           IICnDR̃WX^Write
 * @param           ch [in] I2C`l
 * @param           data [in] ݃f[^
 * @return          void
 * @description     IICnDR̃WX^Write
*/
void AG903_I2CPrmWriteData(uint8_t ch, uint8_t data)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    AG903_I2C_WRITE_REG(ch,DR,data);
    return;
}

/**
 * @brief           IICnDR̃WX^Read
 * @param           ch [in] I2C`l
 * @param           data [out] Ǎ݃f[^
 * @return          void
 * @description     IICnDR̃WX^Read
*/
void AG903_I2CPrmReadData(uint8_t ch, uint8_t* data)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    (*data) = AG903_I2C_READ_REG(ch,DR);
    return;
}

/**
 * @brief           IICnCDR̃WX^Write
 * @param           ch [in] I2C`l
 * @param           cdr [in] CDRݒl
 * @return          void
 * @description     IICnCDR̃WX^Write
*/
void AG903_I2CPrmSetClockDivision(uint8_t ch, uint32_t cdr)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    AG903_I2C_WRITE_REG(ch,CDR,cdr);
    return;
}

/**
 * @brief           IICnTGSR̃WX^Write
 * @param           ch [in] I2C`l
 * @param           tsr [in] TSRl
 * @param           gsr [in] GSRl
 * @return          void
 * @description     IICnTGSR̃WX^Write
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_I2CPrmSetGlitchSuppression(uint8_t ch, uint16_t tsr, uint8_t gsr)
{
    
    ASSERT(AG903_I2C_CH_NUM > ch);
    
    AG903_I2C_CLR_REG(ch,TGSR,AG903_IICn_TGSR_TSR_MSK);
    AG903_I2C_CLR_REG(ch,TGSR,AG903_IICn_TGSR_GSR_MSK);
    AG903_I2C_SET_REG(ch,TGSR,(tsr<<AG903_IICn_TGSR_TSR_POS));
    AG903_I2C_SET_REG(ch,TGSR,(gsr<<AG903_IICn_TGSR_GSR_POS));
    return;
}

/**
 * @brief           IICnSARWX^EN10rbgSet
 * @param           ch [in] I2C`l
 * @return          void
 * @description     IICnSARWX^EN10rbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_I2CPrmSetExtAddrMode(uint8_t ch)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    AG903_I2C_SET_REG(ch,SAR,(1<<AG903_IICn_SAR_EN10_POS));
    return;
}

/**
 * @brief           IICnSARWX^EN10rbgClear
 * @param           ch [in] I2C`l
 * @return          void
 * @description     IICnSARWX^EN10rbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_I2CPrmClearExtAddrMode(uint8_t ch)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    AG903_I2C_CLR_REG(ch,SAR,AG903_IICn_SAR_EN10_MSK);
    return;
}

/**
 * @brief           IICnSAR̃WX^Write
 * @param           ch [in] I2C`l
 * @param           saddr [in] X[uAhX
 * @return          void
 * @description     IICnSAR̃WX^Write
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_I2CPrmSetSlaveAddr(uint8_t ch, uint16_t saddr)
{
    ASSERT(AG903_I2C_CH_NUM > ch);
    
    if(0x0380 & saddr) {
        AG903_I2C_SET_REG(ch,SAR,(1<<AG903_IICn_SAR_EN10_POS));
        AG903_I2C_CLR_REG(ch,SAR,AG903_IICn_SAR_SAR_MSK);
        AG903_I2C_SET_REG(ch,SAR,(saddr<<AG903_IICn_SAR_SAR_POS));
    }
    else {
        AG903_I2C_CLR_REG(ch,SAR,AG903_IICn_SAR_EN10_MSK);
        AG903_I2C_CLR_REG(ch,SAR,AG903_IICn_SAR_SAR_MSK);
        AG903_I2C_SET_REG(ch,SAR,(saddr<<AG903_IICn_SAR_SAR_POS));
    }
    return;
}

