/**
 * @brief       TIMR Primitive
 * @author      AXELL CORPORATION
 * @description TIMR Primitive Layer
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
 * @history     2019_03_08  [SDK2.2] Timr̊荞݃NǍyȏC (#2187)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "AG903_common.h"
#include "timr/timrprm.h"
#include "register/AG903_timreg.h"


#define	AG903_TIMR_READ_REGn(CH,REG)			(AG903_TIMn(CH)->REG)
#define	AG903_TIMR_READ_FLDn(CH,REG,POS,MSK)	( ( (AG903_TIMn(CH)->REG) & MSK ) >> POS )
#define	AG903_TIMR_WRITE_REGn(CH,REG,VAL)		(AG903_TIMn(CH)->REG  = (uint32_t)(VAL))
#define	AG903_TIMR_CLR_REGn(CH,REG,VAL)			(AG903_TIMn(CH)->REG &= (uint32_t)(~VAL))
#define	AG903_TIMR_SET_REGn(CH,REG,VAL)			(AG903_TIMn(CH)->REG |= (uint32_t)(VAL))
#define	AG903_TIMR_WRITE_REG(REG,VAL)			(AG903_TIM->REG  = (uint32_t)(VAL))


/**
 * @brief           TIMnINMOD̃WX^Write
 * @param           ch [in] TIMR`l
 * @param           param [in] ݒp[^
 * @return          void
 * @description     TIMnINMOD̃WX^Write
*/
void AG903_TIMRPrmSetInMode(uint8_t ch, AG903_TIMRPrmInModeParam* param)
{
	uint32_t	val=0;
	
	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != param);
	
	val |= (param->eve&0x3F);	/* Lbit [5:0] */
	val <<= 6;
	val |= (param->lo&0x01);	/* Lbit [0] */
	val <<= 2;
	val |= (param->ch&0x03);	/* Lbit [1:0] */
	val <<= 8;
	val |= (param->pol&0x01);	/* Lbit [0] */
	val <<= 8;
	val |= (param->res&0x03);	/* Lbit [1:0] */
	
	AG903_TIMR_WRITE_REGn(ch,INMOD,val);
	
	return;
}

/**
 * @brief           TIMnOUTMOD̃WX^Write
 * @param           ch [in] TIMR`l
 * @param           param [in] ݒp[^
 * @return          void
 * @description     TIMnOUTMOD̃WX^Write
*/
void AG903_TIMRPrmSetOutMode(uint8_t ch, AG903_TIMRPrmOutModeParam* param)
{
	uint32_t	val=0;
	
	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != param);
	
	val |= (param->cm&0x01);	/* Lbit [0] */
	val <<= 1;
	val |= (param->ovf&0x01);	/* Lbit [0] */
	val <<= 8;
	val |= (param->ch&0x03);	/* Lbit [1:0] */
	val <<= 8;
	val |= (param->pol&0x01);	/* Lbit [0] */
	val <<= 8;
	val |= (param->mod&0x03);	/* Lbit [1:0] */
	
	AG903_TIMR_WRITE_REGn(ch,OUTMOD,val);
	
	return;
}

/**
 * @brief           TIMnRSTTRG̃WX^Write
 * @param           ch [in] TIMR`l
 * @param           param [in] ݒp[^
 * @return          void
 * @description     TIMnRSTTRG̃WX^Write
*/
void AG903_TIMRPrmSetResetTrigger(uint8_t ch, AG903_TIMRPrmResetTriggerParam* param)
{
	uint32_t	val=0;

	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != param);
	
	val |= (param->eve&0x3F);	/* Lbit [5:0] */
	val <<= 6;
	val |= (param->lo&0x01);	/* Lbit [0] */
	val <<= 2;
	val |= (param->ch&0x03);	/* Lbit [1:0] */
	val <<= 8;
	val |= (param->pol&0x01);	/* Lbit [0] */
	val <<= 4;
	val |= (param->res&0x03);	/* Lbit [1:0] */
	val <<= 2;
	val |= (param->boot&0x03);	/* Lbit [1:0] */
	val <<= 2;
	val |= (param->en&0x03);	/* Lbit [1:0] */
	
	AG903_TIMR_WRITE_REGn(ch,RSTTRG,val);
	
	return;
}

/**
 * @brief           TIMnCTRLWX^OSrbgSet
 * @param           ch [in] TIMR`l
 * @return          void
 * @description     TIMnCTRLWX^OSrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmEnableOneshot(uint8_t ch)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_SET_REGn(ch,CTRL,(1<<AG903_TIMn_CTRL_OS_POS));
	return;
}

/**
 * @brief           TIMnCTRLWX^OSrbgClear
 * @param           ch [in] TIMR`l
 * @return          void
 * @description     TIMnCTRLWX^OSrbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmDisableOneshot(uint8_t ch)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_CLR_REGn(ch,CTRL,(1<<AG903_TIMn_CTRL_OS_POS));
	return;
}

/**
 * @brief           TIMnCTRLWX^MODtB[hWrite
 * @param           ch [in] TIMR`l
 * @param           mode [in] JEg[h
 * @return          void
 * @description     TIMnCTRLWX^MODtB[hWrite
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmSetCntMode(uint8_t ch, uint8_t mode)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_CLR_REGn(ch,CTRL,AG903_TIMn_CTRL_MOD_MSK);
	AG903_TIMR_SET_REGn(ch,CTRL,(mode<<AG903_TIMn_CTRL_MOD_POS));
	return;
}

/**
 * @brief           TIMnCTRLWX^MODtB[hRead
 * @param           ch [in] TIMR`l
 * @param           mode [out] JEg[h
 * @return          void
 * @description     TIMnCTRLWX^MODtB[hRead
*/
void AG903_TIMRPrmGetCntMode(uint8_t ch, uint8_t* mode)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != mode);
	(*mode) = AG903_TIMR_READ_FLDn(ch,CTRL,AG903_TIMn_CTRL_MOD_POS,AG903_TIMn_CTRL_MOD_MSK);
	return;
}

/**
 * @brief           TIMnCNT̃WX^Write
 * @param           ch [in] TIMR`l
 * @param           count [in] JEgl
 * @return          void
 * @description     TIMnCNT̃WX^Write
 * @note            쒆ɏ񂾏ꍇ͕̓słB
*/
void AG903_TIMRPrmSetCount(uint8_t ch, uint32_t count)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_WRITE_REGn(ch,CNT,count);
	return;
}

/**
 * @brief           TIMnCNT̃WX^Read
 * @param           ch [in] TIMR`l
 * @param           count [out] JEgl
 * @return          void
 * @description     TIMnCNT̃WX^Read
*/
void AG903_TIMRPrmGetCount(uint8_t ch, uint32_t* count)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != count);
	(*count) = AG903_TIMR_READ_REGn(ch,CNT);
	return;
}

/**
 * @brief           TIMnPERIOD̃WX^Write
 * @param           ch [in] TIMR`l
 * @param           period [in] l
 * @return          void
 * @description     TIMnPERIOD̃WX^Write
*/
void AG903_TIMRPrmSetPeriod(uint8_t ch, uint32_t period)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_WRITE_REGn(ch,PERIOD,period);
	return;
}

/**
 * @brief           TIMnPERIOD̃WX^Read
 * @param           ch [in] TIMR`l
 * @param           period [out] l
 * @return          void
 * @description     TIMnPERIOD̃WX^Read
*/
void AG903_TIMRPrmGetPeriod(uint8_t ch, uint32_t* period)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != period);
	(*period) = AG903_TIMR_READ_REGn(ch,PERIOD);
	return;
}

/**
 * @brief           TIMnMATCH̃WX^Write
 * @param           ch [in] TIMR`l
 * @param           match [in] rl
 * @return          void
 * @description     TIMnMATCH̃WX^Write
*/
void AG903_TIMRPrmSetMatch(uint8_t ch, uint32_t match)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_WRITE_REGn(ch,MATCH,match);
	return;
}

/**
 * @brief           TIMnMATCH̃WX^Raed
 * @param           ch [in] TIMR`l
 * @param           match [out] l
 * @return          void
 * @description     TIMnMATCH̃WX^Raed
*/
void AG903_TIMRPrmGetMatch(uint8_t ch, uint32_t* match)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != match);
	(*match) = AG903_TIMR_READ_REGn(ch,MATCH);
	return;
}

/**
 * @brief           TIMnPULWID̃WX^Write
 * @param           ch [in] TIMR`l
 * @param           width [in] pX
 * @return          void
 * @description     TIMnPULWID̃WX^Write
*/
void AG903_TIMRPrmSetPluseWidth(uint8_t ch, uint32_t width)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_WRITE_REGn(ch,PULWID,(width&AG903_TIMn_PULWID_VAL_MSK));
	return;
}

/**
 * @brief           TIMnPULWID̃WX^Read
 * @param           ch [in] TIMR`l
 * @param           width [out] pX
 * @return          void
 * @description     TIMnPULWID̃WX^Read
*/
void AG903_TIMRPrmGetPluseWidth(uint8_t ch, uint32_t* width)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != width);
	(*width) = AG903_TIMR_READ_FLDn(ch,PULWID,AG903_TIMn_PULWID_VAL_POS,AG903_TIMn_PULWID_VAL_MSK);
	return;
}

/**
 * @brief           TIMnINTMASK̃WX^Write(wrbgSet)
 * @param           ch [in] TIMR`l
 * @param           target [in] Ώ (rbgw)
 * @return          void
 * @description     TIMnINTMASK̃WX^Write(wrbgSet)<p>
 *                  (w\rbg: 1\<\<AG903_TIMn_INTMASK_OVF_POS, 1\<\<AG903_TIMn_INTMASK_CM_POS)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmEnableMask(uint8_t ch, uint32_t setbit)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_SET_REGn(ch,INTMASK,setbit);
	return;
}

/**
 * @brief           TIMnINTMASK̃WX^Write(wrbgClear)
 * @param           ch [in] TIMR`l
 * @param           target [in] Ώ (rbgw)
 * @return          void
 * @description     TIMnINTMASK̃WX^Write(wrbgClear)<p>
 *                  (w\rbg: 1\<\<AG903_TIMn_INTMASK_OVF_POS, 1\<\<AG903_TIMn_INTMASK_CM_POS)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmDisableMask(uint8_t ch, uint32_t clrbit)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_CLR_REGn(ch,INTMASK,clrbit);
	return;
}

/**
 * @brief           TIMnTRIGGER̃WX^Write(wrbgSet)
 * @param           ch [in] TIMR`l
 * @param           target [in] Ώ (rbgw)
 * @return          void
 * @description     TIMnTRIGGER̃WX^Write(wrbgSet)<p>
 *                  (w\rbg: 1\<\<AG903_TIMn_TRIGGER_OVF_POS, 1\<\<AG903_TIMn_TRIGGER_CM_POS)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmEnableEventTrigger(uint8_t ch, uint32_t setbit)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_SET_REGn(ch,TRIGGER,setbit);
	return;
}

/**
 * @brief           TIMnTRIGGER̃WX^Write(wrbgClear)
 * @param           ch [in] TIMR`l
 * @param           target [in] Ώ (rbgw)
 * @return          void
 * @description     TIMnTRIGGER̃WX^Write(wrbgClear)<p>
 *                  (w\rbg: 1\<\<AG903_TIMn_TRIGGER_OVF_POS, 1\<\<AG903_TIMn_TRIGGER_CM_POS)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmDisableEventTrigger(uint8_t ch, uint32_t clrbit)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_CLR_REGn(ch,TRIGGER,clrbit);
	return;
}

/**
 * @brief           TIMnDMAREQ̃WX^Write(wrbgSet)
 * @param           ch [in] TIMR`l
 * @param           target [in] Ώ (rbgw)
 * @return          void
 * @description     TIMnDMAREQ̃WX^Write(wrbgSet)<p>
 *                  (w\rbg: 1\<\<AG903_TIMn_DMAREQ_OVF_POS, 1\<\<AG903_TIMn_DMAREQ_CM_POS)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmEnableDmaRequest(uint8_t ch, uint32_t setbit)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_SET_REGn(ch,DMAREQ,setbit);
	return;
}

/**
 * @brief           TIMnDMAREQ̃WX^Write(wrbgClear)
 * @param           ch [in] TIMR`l
 * @param           target [in] Ώ (rbgw)
 * @return          void
 * @description     TIMnDMAREQ̃WX^Write(wrbgClear)<p>
 *                  (w\rbg: 1\<\<AG903_TIMn_DMAREQ_OVF_POS, 1\<\<AG903_TIMn_DMAREQ_CM_POS)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmDisableDmaRequest(uint8_t ch, uint32_t clrbit)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_CLR_REGn(ch,DMAREQ,clrbit);
	return;
}

/**
 * @brief           TIMnSTAT̃WX^Read
 * @param           ch [in] TIMR`l
 * @param           status [out] Xe[^X
 * @return          void
 * @description     TIMnSTAT̃WX^Read
*/
void AG903_TIMRPrmGetStatus(uint8_t ch, uint32_t* status)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	ASSERT(NULL != status);
	(*status) = AG903_TIMR_READ_REGn(ch,STAT);
	return;
}

/**
 * @brief           TIMnCLR̃WX^Write(wrbgSet)
 * @param           ch [in] TIMR`l
 * @param           target [in] Ώ (rbgw)
 * @return          void
 * @description     TIMnCLR̃WX^Write(wrbgSet)<p>
 *                  (w\rbg: 1\<\<AG903_TIMn_STAT_OVF_POS, 1\<\<AG903_TIMn_STAT_CM_POS,
 *                  1\<\<AG903_TIMn_STAT_DR_POS)
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_TIMRPrmClearStatus(uint8_t ch, uint32_t setbit)
{
	ASSERT(AG903_TIMR_CH_NUM > ch);
	AG903_TIMR_WRITE_REGn(ch,CLR,setbit);
	return;
}

/**
 * @brief           TIMBOOTTRG̃WX^Write
 * @param           chbit [in] TIMR`l (rbgw)
 * @return          void
 * @description     TIMBOOTTRG̃WX^Write<p>
 *                  (w\rbg: <p>
 *                  1\<\<AG903_TIM_BOOTTRG_CH0_POS,<p>
 *                  ...
 *                  1\<\<AG903_TIM_BOOTTRG_CH7_POS)<p>
 */
void AG903_TIMRPrmSetBootTrigger(uint8_t chbit)
{
	AG903_TIMR_WRITE_REG(BOOTTRG,chbit);
	return;
}
