/** 
 * @brief           USBH MSC Log Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC Log Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_MSC_LOG_H__
#define __USB_MSC_LOG_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "uhs_type.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
/* Ol */
#define USB_BOT_ERROR (0x0200)
#define USB_SCSI_ERROR (0x0300)

typedef enum {
    USB_BOT_NORMAL = 0,

    USB_BOT_USB_HALT_PIPE = USB_BOT_ERROR,
    USB_BOT_USB_FAILED_BULK_MSG,

    USB_BOT_FAILED_STDREQ_MSG,
    USB_BOT_FAILED_CLSREQ_MSG,
    USB_BOT_FAILED_BULK_MSG,
    USB_BOT_FAILED_CBW,
    USB_BOT_FAILED_DATA,
    USB_BOT_FAILED_CSW,
    USB_BOT_ILLIGAL_CSW,
    USB_BOT_FAILED_EXEC_CB,
    USB_BOT_PHASE_ERROR,
    USB_BOT_INTERNAL_FAILED_CORE,
    USB_BOT_INTERNAL_FAILED_MSC,
    USB_BOT_SYS_SYSTEM_ERROR,
    USB_BOT_SYS_OUT_OF_RESOURCE,
	USB_BOT_NOT_SUPPORT_MULTI_LUN
} USB_BOT_STATUS;

typedef enum {
    USB_SCSI_NORMAL = 0,
    USB_SCSI_MEDIUM_NOT_PRESENT = USB_SCSI_ERROR,
    USB_SCSI_WRITE_PROTECT,
    USB_SCSI_FAILED_WRITE,
    USB_SCSI_FAILED_READ,
    USB_SCSI_COMMAND_NOT_SUPPORT,
    USB_SCSI_PARAMETER_NOT_SUPPORT,
    USB_SCSI_PARAMETER_ERROR,
    USB_SCSI_COMMAND_ERROR,
    USB_SCSI_MEDIUM_MAY_HAVE_CHANGED,
    USB_SCSI_UNKNOWN_SENSE_ERROR,
    USB_SCSI_TRANSFER_ERROR,                            /* ʑw̓]G[ */
    USB_SCSI_INTERNAL_FAILED_CORE,
    USB_SCSI_INTERNAL_FAILED_MSC,
    USB_SCSI_SYS_SYSTEM_ERROR,
    USB_SCSI_SYS_OUT_OF_RESOURCE
} USB_SCSI_STATUS;

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
void Usbh_Stor_Log_ReportError(const char *pFunctionName, uhs_ubit32_t nLine, uhs_ubit16_t nError, uhs_ubit8_t *pMesg, uhs_ubit16_t u16Length);
void Usbh_Stor_Log_ReportWarning(const char *pFunctionName, uhs_ubit32_t nLine, uhs_ubit16_t nWarning, uhs_ubit8_t *pMesg, uhs_ubit16_t u16Length);
void Usbh_Stor_Log_ReportMilestone(uhs_ubit16_t u16CheckPointNum);
void Usbh_Stor_Log_ReportDummy(uhs_ubit16_t nError);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif 
