/** 
 * @brief           KERNEL ITRON4 Header
 * @author          AXELL CORPORATION
 * @description     iTRON4.0ˑJ[lAPI`wb_B
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/

#ifndef __DEPEND_KERNEL_ITRON4_H__
#define __DEPEND_KERNEL_ITRON4_H__


// *************************************************************************************************
//	include
// *************************************************************************************************
#include	"uhs_configtop.h"
#include	"wrapper_kernel.h"
#include	<kernel.h>
#include	"uhs_type.h"
#include	"misc.h"


// *************************************************************************************************
//	extern
// *************************************************************************************************
/*------------------------------------------------------------------------------
 * ֐錾
 *------------------------------------------------------------------------------*/
extern uhs_inline uhs_status_t __kernel_initialize_itron4(
    IN OUT  kernel_context_t* osc,
    IN SIZE size,
    IN      uhs_ubit32_t address
);

extern uhs_inline uhs_status_t __kernel_terminate_itron4(
    IN OUT  kernel_context_t* osc
);

#ifdef		USBH_MEM_LEAK_CHK_ADDINFO
extern	uhs_inline uhs_status_t __kernel_mem_alloc_itron4(
    IN OUT  kernel_context_t* osc,
    OUT     void** address,
    IN      uhs_size_t size,
    OPTIONAL IN uhs_ubit32_t timeout,
    uhs_ubit8_t InInterrupt,
    uhs_ubit8_t	*file,
    uhs_ubit32_t	line_num
);
#else
extern uhs_inline uhs_status_t __kernel_mem_alloc_itron4(
    IN OUT  kernel_context_t* osc,
    OUT     void** address,
    IN      uhs_size_t size,
    OPTIONAL IN uhs_ubit32_t timeout,
    uhs_ubit8_t InInterrupt
);
#endif

extern uhs_inline uhs_status_t __kernel_mem_free_itron4(
    IN OUT  kernel_context_t* osc,
    IN      void* address,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_create_semaphore_itron4(
    IN OUT  kernel_context_t* osc,
    IN      uhs_index_t num,
    IN      uhs_index_t init
);

extern uhs_inline uhs_status_t __kernel_delete_semaphore_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_acquisition_semaphore_itron4(
    IN OUT  kernel_context_t* osc,
    OPTIONAL IN uhs_ubit32_t timeout,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_release_semaphore_itron4(
    IN OUT  kernel_context_t* osc,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_create_event_itron4(
    IN OUT  kernel_context_t* osc,
    IN      uhs_boolean_t initac
);

extern uhs_inline uhs_status_t __kernel_delete_event_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_set_event_itron4(
    IN OUT  kernel_context_t* osc,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_wait_event_itron4(
    IN OUT  kernel_context_t* osc,
    OPTIONAL IN uhs_ubit32_t timeout,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_create_dataqueue_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_delete_dataqueue_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_send_dataqueue_itron4(
    IN OUT  kernel_context_t* osc,
    IN      int data,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_recieve_dtq_itron4(
    IN OUT  kernel_context_t* osc,
    OUT     int *data,
    OPTIONAL IN uhs_ubit32_t timeout,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_wait_itron4(
    IN OUT  kernel_context_t* osc,
    IN      uhs_ubit32_t wait_time
);

extern uhs_inline uhs_status_t __kernel_create_cyclehnd_itron4(
    IN OUT  kernel_context_t* osc,
    IN      kernel_thread_call_t* start,
    IN OUT  void* context,
    IN      uhs_ubit32_t cycletime,
    IN      uhs_boolean_t initac
);

extern uhs_inline uhs_status_t __kernel_delete_cyclehnd_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_inact_cyclehnd_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_create_thread_itron4(
    IN OUT  kernel_context_t* osc,
    IN      kernel_thread_call_t* start,
    IN OUT  uhs_ubit32_t context,
    IN      uhs_index_t pri,
    IN      uhs_size_t stack
);

extern uhs_inline uhs_status_t __kernel_delete_thread_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_exit_thread_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_create_message_itron4(
    IN OUT  kernel_context_t* osc
);

extern uhs_inline uhs_status_t __kernel_delete_message_itron4(
    IN OUT  kernel_context_t* osc,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_send_message_itron4(
    IN OUT  kernel_context_t* osc,
    T_MSG   *pk_msg,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_receive_message_itron4(
    IN OUT  kernel_context_t* osc,
    T_MSG   **pk_msg,
    OPTIONAL IN uhs_ubit32_t timeout,
    uhs_ubit8_t InInterrupt
);

extern uhs_inline uhs_status_t __kernel_get_timer_itron4(
    IN OUT  kernel_context_t* osc,
    OUT     uhs_ubit32_t* time_h,
    OUT     uhs_ubit32_t* time_l
);

extern	uhs_inline uhs_status_t __kernel_register_interrupt( 
	IN	uhs_ubit32_t int_num ,
	IN	uhs_ubit32_t int_lvl ,
	IN	void *intr_handller ,
	OUT	uhs_sbit32_t *handle
);

extern	uhs_inline uhs_status_t __kernel_unregister_interrupt( 
	IN	uhs_ubit32_t int_hndle_num 
);

extern	uhs_inline uhs_status_t __kernel_enable_interrupt( 
	IN	uhs_ubit32_t int_num
);

extern	uhs_inline uhs_status_t __kernel_disable_interrupt( 
	IN	uhs_ubit32_t int_num
);

#endif	// __DEPEND_KERNEL_ITRON4_H__
