/** 
 * @brief           Wrapper Kernel Header
 * @author          AXELL CORPORATION
 * @description     Wrapper Kernel Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */


#ifndef __DEPEND_KERNEL_H__
#define __DEPEND_KERNEL_H__

// *************************************************************************************************
//	include
// *************************************************************************************************
#include	"uhs_configtop.h"
#include	"misc.h"
#include	"uhs_type.h"
#include	"wrapper.h"
#include	"info.h"


// *************************************************************************************************
//	define
// *************************************************************************************************
#define KERNEL_TIME_INFINITE                        0xFFFFFFFF      /*  */

/*
 * J[lˑReLXgiwb_j
 */
#if (USBH_CFG_DEBUG == YES)
struct kernel_context_header
{
    uhs_index_t                         type;                   /* ReLXg^Cv */
#define KERNEL_CONTEXTTYPE_MEMORY                   1
#define KERNEL_CONTEXTTYPE_SEMAPHORE                2
#define KERNEL_CONTEXTTYPE_MUTEX                    3
#define KERNEL_CONTEXTTYPE_EVENT                    4
#define KERNEL_CONTEXTTYPE_DATAQUEUE                5
#define KERNEL_CONTEXTTYPE_TIMER                    6
#define KERNEL_CONTEXTTYPE_CYCLEHND                 7
#define KERNEL_CONTEXTTYPE_THREAD                   8
#define KERNEL_CONTEXTTYPE_CONFIGURATION            9
#define KERNEL_CONTEXTTYPE_MESSAGE                  10
};
#endif /* USBH_CFG_DEBUG */


// *************************************************************************************************
//	structure
// *************************************************************************************************
/*
 * J[lˑReLXgiǗ\́j
 */
struct kernel_mnginfo_memory
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_memory               depend;                 /* OSŗLij */
};

/*
 * J[lˑReLXgiZ}tHǗ\́j
 */
struct kernel_mnginfo_semaphore
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_semaphore            depend;                 /* OSŗLiZ}tHj */
};

/*
 * J[lˑReLXgiCxgǗ\́j
 */
struct kernel_mnginfo_event
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_event                depend;                 /* OSŗLiCxgj */
};

/*
 * J[lˑReLXgif[^L[Ǘ\́j
 */
struct kernel_mnginfo_dataqueue
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_dataqueue            depend;                 /* OSŗLif[^L[j */
};

/*
 * J[lˑReLXginhǗ\́j
 */
struct kernel_mnginfo_cyclehnd
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_cyclehnd             depend;                 /* OSŗLinhj */
};

/*
 * J[lˑReLXgiXbhǗ\́j
 */
struct kernel_mnginfo_thread
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_thread               depend;                 /* OSŗLiXbhj */
};

/*
 * RtBO[V
 */
struct kernel_mnginfo_config
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_config               depend;                 /* OSŗLiRtBO[Vj */
    void*                                   context;                /* ReLXg */
};

/*
 * bZ[W
 */
struct kernel_mnginfo_message
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_message              depend;                 /* OSŗLibZ[Wj */

};

/*
 * J[lˑReLXgi^C}[Ǘ\́j
 */
struct kernel_mnginfo_timer
{
#if ( USBH_CFG_DEBUG == YES)
    struct kernel_context_header            header;                 /* wb_ */
#endif /* USBH_CFG_DEBUG */
    struct kernel_info_timer                depend;                 /* OSŗLi^C}[j */
};


/*
 * J[lˑReLXg^錾
 */
typedef union _kernel_context_t
{
#if ( USBH_CFG_DEBUG == YES)
        struct kernel_context_header            header;             /* wb_ */
#endif /* USBH_CFG_DEBUG */
        struct kernel_mnginfo_memory        memory;                 /*  */
        struct kernel_mnginfo_semaphore     semaphore;              /* Z}tH */
        struct kernel_mnginfo_event         event;                  /* Cxg */
        struct kernel_mnginfo_dataqueue     dtq;                    /* f[^L[ */
        struct kernel_mnginfo_timer         timer;                  /* ^C}[ */
        struct kernel_mnginfo_cyclehnd      cyclehnd;               /* TCNnh */
        struct kernel_mnginfo_thread        thread;                 /* Xbh */
        struct kernel_mnginfo_config        config;                 /* RtBO[V */
        struct kernel_mnginfo_message       message;                /* bZ[W */
} kernel_context_t;

/*
 * Xbh^錾
 */
typedef uhs_status_t kernel_thread_call_t( void* context);

/*------------------------------------------------------------------------------
 * CC֐錾Ԓ`
 *------------------------------------------------------------------------------*/
#define kernel_initialize( osc , size , addr)									WRAPPER_KERNEL_INITIALIZE( osc ,size , addr )
#define kernel_terminate( osc)													WRAPPER_KERNEL_TERMINATE( osc)
#ifdef		USBH_MEM_LEAK_CHK_ADDINFO
	#define kernel_mem_alloc( osc, address, size, timeout, InInterrupt)				WRAPPER_KERNEL_MEM_ALLOC( osc, address, size, timeout, InInterrupt , __FILE__ , __LINE__  )
#else
	#define kernel_mem_alloc( osc, address, size, timeout, InInterrupt)				WRAPPER_KERNEL_MEM_ALLOC( osc, address, size, timeout, InInterrupt)
#endif
#define kernel_mem_free( osc, address, InInterrupt)								WRAPPER_KERNEL_MEM_FREE( osc, address, InInterrupt)
#define kernel_create_semaphore( osc, num, init)								WRAPPER_KERNEL_CREATE_SEMAPHORE( osc, num, init)
#define kernel_delete_semaphore( osc)											WRAPPER_KERNEL_DELETE_SEMAPHORE( osc)
#define kernel_acquisition_semaphore( osc, timeout, InInterrupt)				WRAPPER_KERNEL_ACQUISITION_SEMAPHORE( osc, timeout, InInterrupt)
#define kernel_release_semaphore( osc, InInterrupt)								WRAPPER_KERNEL_RELEASE_SEMAPHORE( osc, InInterrupt)
#define kernel_create_event( osc, initac)										WRAPPER_KERNEL_CREATE_EVENT( osc, initac)
#define kernel_delete_event( osc)												WRAPPER_KERNEL_DELETE_EVENT( osc)
#define kernel_set_event( osc, InInterrupt)										WRAPPER_KERNEL_SET_EVENT( osc, InInterrupt)
#define kernel_wait_event( osc, timeout, InInterrupt)							WRAPPER_KERNEL_WAIT_EVENT( osc, timeout, InInterrupt)
#define kernel_wait( osc, time)													WRAPPER_KERNEL_WAIT( osc, time)
#define kernel_create_cyclehnd( osc, start, context, cycletime, initac)			WRAPPER_KERNEL_CREATE_CYCLEHND( osc, start, context, cycletime, initac)
#define kernel_delete_cyclehnd( osc)											WRAPPER_KERNEL_DELETE_CYCLEHND( osc)
#define kernel_create_thread( osc, start, context, pri, stack)					WRAPPER_KERNEL_CREATE_THREAD( osc, start, context, pri, stack)
#define kernel_delete_thread( osc)												WRAPPER_KERNEL_DELETE_THREAD( osc)
#define kernel_exit_thread( osc)												WRAPPER_KERNEL_EXIT_THREAD( osc)
#define kernel_create_message( osc)												WRAPPER_KERNEL_CREATE_MESSAGE( osc)
#define kernel_delete_message( osc, InInterrupt)								WRAPPER_KERNEL_DELETE_MESSAGE( osc, InInterrupt)
#define kernel_send_message( osc, pk_msg, InInterrupt)							WRAPPER_KERNEL_SEND_MESSAGE( osc, pk_msg, InInterrupt)
#define kernel_receive_message( osc, pk_msg, timeout, InInterrupt)				WRAPPER_KERNEL_RECEIVE_MESSAGE( osc, pk_msg, timeout, InInterrupt)
#define kernel_get_timer( osc, time_h, time_l)									WRAPPER_KERNEL_GET_TIMER( osc, time_h, time_l)
#define kernel_create_dtq( osc)													WRAPPER_KERNEL_CREATE_DTQ( osc)
#define kernel_delete_dtq( osc)													WRAPPER_KERNEL_DELETE_DTQ( osc)
#define kernel_send_dtq( osc, data, InInterrupt)								WRAPPER_KERNEL_SEND_DTQ( osc, data, InInterrupt)
#define kernel_recieve_dtq( osc, data, timeout, InInterrupt)					WRAPPER_KERNEL_RECIEVE_DTQ( osc, data, timeout, InInterrupt)
#define	kernel_register_interrupt( int_num , int_lvl , intr_handller , handle )	WRAPPER_KERNEL_REGISTER_INTERRUPT( int_num , int_lvl , intr_handller , handle	)
#define	kernel_unregister_interrupt( int_hndle_num )							WRAPPER_KERNEL_UNREGISTER_INTERRUPT( int_hndle_num )
#define	kernel_enable_interrupt( int_num )										WRAPPER_KERNEL_ENABLE_INTERRUPT( int_num )
#define	kernel_disable_interrupt( int_num )										WRAPPER_KERNEL_DISABLE_INTERRUPT( int_num )

#endif /* __DEPEND_KERNEL_H__ */

