/**
 * @brief       VIA Manager
 * @author      AXELL CORPORATION
 * @description VIA Manager Layer.
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
 * @history     2019_03_08  [SDK2.2] VIAɃrfI͂̐MLł邱Ƃo֐ǉ (#2454)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include <stdio.h>
#include "via/viaprm.h"
#include "via/viamgr.h"
#include "pgp/pgpprm.h"
#include "sys/spcprm.h"
#include "sys/sscprm.h"

/* OAChԂł邱Ƃw܂ */
#define PGP_IDLE    (0)

/* WX^̌Œl */
#define GCAT        (0x1)       /* VIA.SRC_SELECT.GCAT */
#define NSNS        (0x1)       /* VIA.SRC_SELECT.NSNS */
#define NONS        (0x1)       /* VIA.SRC_SELECT.NONS */
#define TRAP        (0x0)       /* VIA.SIG_YCS.TRAP */
#define AGCEN       (0x1)       /* VIA.CHD_SETUP3.AGCEN */
#define ACCOV       (0x30)      /* VIA.CHD_SETUP3.ACCOV */
#define ACCTC       (0x1)       /* VIA.CHD_SETUP3.ACCTC */
#define CBPLLULTH   (0x12)      /* VIA.CHD_SETUP5.CBPLLULTH */
#define CBPLLULSV   (0x0)       /* VIA.CHD_SETUP5.CBPLLULSV */
#define AGCGAINSPD  (0x3)       /* VIA.CHD_SETUP5.AGCGAINSPD */
#define AGCOFSTSPD  (0x3)       /* VIA.CHD_SETUP5.AGCOFSTSPD */
#define AGCPOS      (0x0)       /* VIA.CHD_SETUP5.AGCPOS */
#define AGCGAINEN   (0x1)       /* VIA.CHD_SETUP5.AGCGAINEN */
#define AGCOFSTEN   (0x1)       /* VIA.CHD_SETUP5.AGCOFSTEN */
#define CLAMPOFS    (0x10)      /* VIA.CLAMP_LEVEL.CLAMPOFS */

/* `FbN */
static _Bool init_check = false;

/* AiOrfI͂̃ReLXg */
static struct {
    _Bool                       used_ports[AG903_VIA_MGR_MAX_PORTS];
    AG903_ViaMgrInputHandle     ports[AG903_VIA_MGR_MAX_PORTS];
} ViaContext = {
    {false, false, false, false},
    {{0}}
};

/* AiOrfI͂̃tH[}bgl */
static struct {
    uint16_t    fmt;            /* VIA.SRC_FORMAT.FMT */
    uint16_t    hcycle;         /* VIA.SRC_HCYCLE.HCYCLE */
    uint16_t    hvalid;         /* VIA.SRC_HVALID.HVALID */
    uint16_t    hdelay;         /* VIA.SRC_HDELAY.HDELAY */
    uint16_t    vcycle;         /* VIA.SRC_VCYCLE.VCYCLE */
    uint16_t    vvalid;         /* VIA.SRC_VVALID.VVALID */
    uint16_t    vdelay;         /* VIA.SRC_VDELAY.VDELAY */
    uint16_t    frm;            /* VIA.SRC_FRMFREQ.FRM */
    uint16_t    accmark;        /* VIA.CHD_SETUP3.ACCMARK */
    uint16_t    agcpal;         /* VIA.CHD_SETUP5.AGCPAL */
} ViaFormat[AG903_VIA_MGR_FORMAT_MAX] = {
    { 0x0000, 0x06B4, 0x05A0, 0x001A, 0x020D, 0x01E0, 0x000A, 0x0000, 0x003E, 0x0000 }, /* NTSC-BT */
    { 0x0008, 0x0618, 0x0500, 0x0014, 0x020D, 0x01E0, 0x000A, 0x0000, 0x0039, 0x0000 }, /* NTSC-SQ */
    { 0x0007, 0x071C, 0x0600, 0x0094, 0x020D, 0x01E0, 0x000A, 0x0000, 0x003E, 0x0000 }, /* NTSC-4F */
    { 0x0001, 0x06C0, 0x05A0, 0x0014, 0x0271, 0x0240, 0x000A, 0x0001, 0x003E, 0x0001 }, /* PAL-BT */
    { 0x0009, 0x0760, 0x0600, 0x0014, 0x0271, 0x0240, 0x000A, 0x0001, 0x0032, 0x0001 }, /* PAL-SQ */
};

/* AiOrfI͂̃J[[hl */
static struct {
    uint16_t    nsck;       /* VIA.SRC_SELECT.NSCK */
    uint16_t    mono;       /* VIA.SIG_YCS.MONO */
} ViaMode[AG903_VIA_MGR_MODE_MAX] = {
    { 0x0001, 0x0000 }, /* COLOR */
    { 0x0000, 0x0001 }, /* MONO */
};


/**
 * @brief         VIA@
 * @param         void 
 * @return        
 * @retval        AG903_ENONE I 
 * @description   AiOrfI͊֘Ãn[hEFA܂B 
 * @note          AiOrfI̓nh擾OɌĂяoĂB 
*/
int32_t AG903_ViaMgrInit(void)
{
    /* SSC.VIDEOADC_SETUP:0x0000F0FF */
    {
        AG903_SSCPrmVideoAdcParam param = {0};

        param.acq_clr       = 0x0;
        param.acq_en        = 0x0;
        param.dat_en        = 0xF;
        param.clmp_tmg      = 0x0;
        param.clmp_lv       = 0xF;
        param.pga_ctl       = 0xF;

        AG903_SSCPrmSetVideoAdcSetup(&param);
    }
    /* SPC.VIDEOADC_MISC_CTRL1:0x00000001 */
    /* SPC.VIDEOADC_MISC_CTRL2:0xA5A5A5DE */
    /* SPC.VIDEOADC_MISC_CTRL3:0x070707A5 */
    /* SPC.VIDEOADC_MISC_CTRL4:0x20080007 */
    /* SPC.VIDEOADC_MISC_CTRL5:0x00040004 */
    {
        AG903_SPCPrmVideoAdcParam param = {0};
        AG903_SPCPrmVideoAdcEnable enable = {0};

        param.clmp_en0      = 0x0;
        param.clmp_en1      = 0x0;
        param.clmp_en2      = 0x0;
        param.clmp_en3      = 0x0;
        param.clmp_lv0      = 0xA5;
        param.clmp_lv1      = 0xA5;
        param.clmp_lv2      = 0xA5;
        param.clmp_lv3      = 0xA5;
        param.clmp_imp      = 0x3;
        param.gain0         = 0x7;
        param.gain1         = 0x7;
        param.gain2         = 0x7;
        param.gain3         = 0x7;
        param.aaf_ctrl      = 0x20;
        param.qntzr_bias_up = 0x2;
        param.input_range   = 0x1;
        param.ref_bias_up   = 0x1;
        enable.adc          = 0x1;
        enable.ch0          = 0x1;
        enable.ch1          = 0x1;
        enable.ch2          = 0x1;
        enable.ch3          = 0x1;

        AG903_SPCPrmSetVideoAdcCtrl(&param, &enable);
    }

    init_check = true;

    return AG903_ENONE;
}


/**
 * @brief         VIA nh擾
 * @param         ports [in] 擾̓|[gԍi[z
 * @param         num_ports [in] ports̔zvfi=擾nhj
 * @param         handles [out] 擾nhi[z 
 * @return        nh擾 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL AiOrfI͂̏sĂȂꍇ<p>ports  0~3 ͈̔͊O̒lw肳ꂽꍇ<p>portsAhandles  NULL 
 *  							w肳ꂽꍇ
 * @retval        -AG903_ENOMEM ports Ŏw肳ꂽ|[gɑΉnh擾ς̏ꍇ 
 * @description   ̓|[gԍw肵ăiOrfIA̓nh(AG903_ViaMgrInputHandle)擾܂B<p> 
 *  							vꂽԍgp̏ꍇAhandles ɂ͉i[܂B<p>
 *  							handles ɂ̓|[gԍɎw肳ꂽԍɃnhi[܂B
*/
int32_t AG903_ViaMgrGetInputHandle(int32_t *ports, int32_t num_ports, AG903_ViaMgrInputHandle **handles)
{
    int32_t i;
    _Bool num_check[AG903_VIA_MGR_MAX_PORTS] = {false};

    if (init_check != true) {
        return -AG903_EINVAL;
    }
    if (num_ports > AG903_VIA_MGR_MAX_PORTS) {
        return -AG903_EINVAL;
    }
    if ((ports == NULL) || (handles == NULL)) {
        return -AG903_EINVAL;
    }
    for (i = 0; i < num_ports; i++) {
        if ((ports[i] < 0) || (ports[i] >= AG903_VIA_MGR_MAX_PORTS)) {
            return -AG903_EINVAL;
        }
        if (ViaContext.used_ports[ports[i]] != false) {
            return -AG903_ENOMEM;
        }
        /* ԍw肳ꂽꍇ̓G[ */
        if (num_check[ports[i]] == true) {
            return -AG903_EINVAL;
        }
        num_check[ports[i]] = true;
    }

    for (i = 0; i < num_ports; i++) {
        /* AiOrfI̓nhhandlesɊi[ď */
        handles[i] = (AG903_ViaMgrInputHandle *)&ViaContext.ports[ports[i]];
        handles[i]->id = AG903_VIA_MGR_INPUT_HANDLE_ID;
        handles[i]->port_no = ports[i];
        /* 擾ς̃|[gɏԑJڂ */
        ViaContext.used_ports[ports[i]] = true;
    }
    return AG903_ENONE;
}


/**
 * @brief         VIA nh
 * @param         handle [in] AiOrfI̓nh 
 * @return        nh
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handle ɕsȃAiOrfI̓nhw肳ꂽꍇ 
 * @description   w肳ꂽAiOrfI̓nh܂B<p>AiOrfI̓nh̃óAport_no ȊOS 0 ŏ܂B
 * @note          {֐R[ꍇ́AOW[~Ă邱ƂmFĂB
*/
int32_t AG903_ViaMgrReleaseInputHandle(AG903_ViaMgrInputHandle *handle)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VIA_MGR_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ς̃|[gɏԑJڂ */
    ViaContext.used_ports[handle->port_no] = false;

    /* port_noȊÕo0ɏiid0ɏ邱ƂŖȃnhɑJڂj */
    handle->id = 0;

    return AG903_ENONE;
}


/**
 * @brief         tH[}bg^J[[hݒ
 * @param         handle [in] VIA nh
 * @param         format [in] tH[}bg
 * @param         mode [in] J[[h 
 * @return        ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handle ɕsȃAiOrfI̓nhw肳ꂽꍇ<p>format ɕsȒlw肳ꂽꍇ<p>mode 
 *  							ɕsȒlw肳ꂽꍇ
 * @description   w肳ꂽAiOrfI̓nhɑ΂ătH[}bgAJ[[hݒ肵܂B<p> 
 *                format ɂ́uVIAtH[}bgvAmode ɂ́uVIAJ[[hvw肵ĂB 
*/
int32_t AG903_ViaMgrSetInputParameter(AG903_ViaMgrInputHandle *handle, uint32_t format, uint32_t mode)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VIA_MGR_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* formatɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (format) {
        case AG903_VIA_MGR_FORMAT_NTSC_BT:
        case AG903_VIA_MGR_FORMAT_NTSC_SQ:
        case AG903_VIA_MGR_FORMAT_NTSC_4F:
        case AG903_VIA_MGR_FORMAT_PAL_BT:
        case AG903_VIA_MGR_FORMAT_PAL_SQ:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* modeɕsȒlw肳ꂽꍇG[Ƃ܂ */
    switch (mode) {
        case AG903_VIA_MGR_MODE_COLOR:
        case AG903_VIA_MGR_MODE_MONOCHROME:
            break;
        default:
            return -AG903_EINVAL;
    }

    VIAPrmParamVIASRCSELECT select;
    select.gcat = GCAT;
    select.nsck = ViaMode[mode].nsck;
    select.nsns = NSNS;
    select.nons = NONS;
    AG903_ViaPrmSetVIASRCSELECT(handle->port_no, &select);

    AG903_ViaPrmSetVIASRCFORMAT(handle->port_no, ViaFormat[format].fmt);
    AG903_ViaPrmSetVIASRCHCYCLE(handle->port_no, ViaFormat[format].hcycle);
    AG903_ViaPrmSetVIASRCHVALID(handle->port_no, ViaFormat[format].hvalid);
    AG903_ViaPrmSetVIASRCHDELAY(handle->port_no, ViaFormat[format].hdelay);
    AG903_ViaPrmSetVIASRCVCYCLE(handle->port_no, ViaFormat[format].vcycle);
    AG903_ViaPrmSetVIASRCVVALID(handle->port_no, ViaFormat[format].vvalid);
    AG903_ViaPrmSetVIASRCVDELAY(handle->port_no, ViaFormat[format].vdelay);
    AG903_ViaPrmSetVIASRCFRMFREQ(handle->port_no, ViaFormat[format].frm);
    AG903_ViaPrmSetVIASIGYCS(handle->port_no, TRAP, ViaMode[mode].mono);

    VIAPrmParamVIACHDSETUP3 setup3;
    setup3.agcen   = AGCEN;
    setup3.accov   = ACCOV;
    setup3.acctc   = ACCTC;
    setup3.accmark = ViaFormat[format].accmark;
    AG903_ViaPrmSetVIACHDSETUP3(handle->port_no, &setup3);

    VIAPrmParamVIACHDSETUP5 setup5;
    setup5.cbpllulth  = CBPLLULTH;
    setup5.cbpllulsv  = CBPLLULSV;
    setup5.agcgainspd = AGCGAINSPD;
    setup5.agcofstspd = AGCOFSTSPD;
    setup5.agcpos     = AGCPOS;
    setup5.agcpal     = ViaFormat[format].agcpal;
    setup5.agcgainen  = AGCGAINEN;
    setup5.agcofsten  = AGCOFSTEN;
    AG903_ViaPrmSetVIACHDSETUP5(handle->port_no, &setup5);

    AG903_ViaPrmSetVIACLAMPLEVEL(handle->port_no, CLAMPOFS);

    return AG903_ENONE;
}


/**
 * @brief         rfI͐M̏Ԏ擾
 * @param         handle [in] VIA nh
 * @return        ݒ茋 
 * @retval        1 ͐ML
 * @retval        0 ͐M
 * @description   w肳ꂽAiOrfI̓nh̃rfI͂̐MLł邩ǂo܂B
 * @note          VIÃp[^ύXĂ1bȏo߂ĂsĉB
*/
int32_t AG903_ViaMgrIsInputValid(AG903_ViaMgrInputHandle *handle)
{
	VIAPrmParamVIADETSTATUS vdst = {
		.normal = 0,
		.nosync = 1,
	};
	AG903_ViaPrmGetVIADETSTATUS(handle->port_no, &vdst);
	if (!vdst.nosync && vdst.normal) {
		return 1;
	}
	return 0;
}
