/**
 * @brief       VIA Primitive
 * @author      AXELL CORPORATION
 * @description VIA Primitive Layer.
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include <stdio.h>
#include "via/viaprm.h"
#include "register/AG903_viareg.h"
#include "sys/sscprm.h"
#include "AG903_common.h"

/**
 * @brief         VIA.SRC_SELECT WX^ݒ
 * @param         id [in] `lԍ
 * @param         select [in] VIA.SRC_SELECTݒli[
 * @return        void 
 * @description   VIA.SRC_SELECT ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCSELECT(uint32_t id, VIAPrmParamVIASRCSELECT *select)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(select != NULL);
    ASSERT(!(select->gcat & ~(0x1)));
    ASSERT(!(select->nsck & ~(0x1)));
    ASSERT(!(select->nsns & ~(0x1)));
    ASSERT(!(select->nons & ~(0x1)));

    val = (select->gcat << AG903_VIA_SRC_SELECT_GCAT_POS)
        | (select->nsck << AG903_VIA_SRC_SELECT_NSCK_POS)
        | (select->nsns << AG903_VIA_SRC_SELECT_NSNS_POS)
        | (select->nons << AG903_VIA_SRC_SELECT_NONS_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_SELECT, val);
}


/**
 * @brief         VIA.SRC_SELECTWX^擾
 * @param         id [in] `lԍ
 * @param         select [out] VIA.SRC_SELECT擾li[
 * @return        void
 * @description   VIA.SRC_SELECT 擾܂B 
*/
void AG903_ViaPrmGetVIASRCSELECT(uint32_t id, VIAPrmParamVIASRCSELECT *select)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(select != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_SELECT, &val);

    select->gcat = (val & AG903_VIA_SRC_SELECT_GCAT_MSK) >> AG903_VIA_SRC_SELECT_GCAT_POS;
    select->nsck = (val & AG903_VIA_SRC_SELECT_NSCK_MSK) >> AG903_VIA_SRC_SELECT_NSCK_POS;
    select->nsns = (val & AG903_VIA_SRC_SELECT_NSNS_MSK) >> AG903_VIA_SRC_SELECT_NSNS_POS;
    select->nons = (val & AG903_VIA_SRC_SELECT_NONS_MSK) >> AG903_VIA_SRC_SELECT_NONS_POS;
}


/**
 * @brief         VIA.SRC_FORMAT WX^ݒ
 * @param         id [in] `lԍ
 * @param         fmt [in] FMTtB[hݒl
 * @return        void
 * @description   VIA.SRC_FORMAT ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCFORMAT(uint32_t id, uint16_t fmt)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(fmt & ~(0xF)));

    val = (fmt << AG903_VIA_SRC_FORMAT_FMT_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_FORMAT, val);
}


/**
 * @brief         VIA.SRC_FORMAT WX^擾
 * @param         id [in] `lԍ
 * @param         fmt [out] FMTtB[h擾l
 * @return        void
 * @description   VIA.SRC_FORMAT 擾܂B 
*/
void AG903_ViaPrmGetVIASRCFORMAT(uint32_t id, uint16_t *fmt)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(fmt != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_FORMAT, &val);

    *fmt = (val & AG903_VIA_SRC_FORMAT_FMT_MSK) >> AG903_VIA_SRC_FORMAT_FMT_POS;
}


/**
 * @brief         VIA.SRC_HCYCLE WX^ݒ
 * @param         id [in] `lԍ
 * @param         hcycle [in] HCYCLEtB[hݒl
 * @return        void
 * @description   VIA.SRC_HCYCLE ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCHCYCLE(uint32_t id, uint16_t hcycle)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(hcycle & ~(0xFFF)));

    val = (hcycle << AG903_VIA_SRC_HCYCLE_HCYCLE_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_HCYCLE, val);
}


/**
 * @brief         VIA.SRC_HCYCLE WX^擾
 * @param         id [in] `lԍ
 * @param         hcycle [out] HCYCLEtB[h擾l
 * @return        void
 * @description   VIA.SRC_SELECT 擾܂B 
*/
void AG903_ViaPrmGetVIASRCHCYCLE(uint32_t id, uint16_t *hcycle)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(hcycle != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_HCYCLE, &val);

    *hcycle = (val & AG903_VIA_SRC_HCYCLE_HCYCLE_MSK) >> AG903_VIA_SRC_HCYCLE_HCYCLE_POS;
}


/**
 * @brief         VIA.SRC_HVALID WX^ݒ
 * @param         id [in] `lԍ
 * @param         hvalid [in] HVALIDtB[hݒl
 * @return        void
 * @description   VIA.SRC_HVALID ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCHVALID(uint32_t id, uint16_t hvalid)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(hvalid & ~(0xFFF)));

    val = (hvalid << AG903_VIA_SRC_HVALID_HVALID_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_HVALID, val);
}


/**
 * @brief         VIA.SRC_HVALID WX^擾
 * @param         id [in] `lԍ
 * @param         hvalid [out] HVALIDtB[h擾l
 * @return        void
 * @description   VIA.SRC_HVALID 擾܂B 
*/
void AG903_ViaPrmGetVIASRCHVALID(uint32_t id, uint16_t *hvalid)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(hvalid != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_HVALID, &val);

    *hvalid = (val & AG903_VIA_SRC_HVALID_HVALID_MSK) >> AG903_VIA_SRC_HVALID_HVALID_POS;
}


/**
 * @brief         VIA.SRC_HDELAY WX^ݒ
 * @param         id [in] `lԍ
 * @param         hdelay [in] HDELAYtB[hݒl
 * @return        void
 * @description   VIA.SRC_HDELAY ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCHDELAY(uint32_t id, uint16_t hdelay)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(hdelay & ~(0x7FF)));

    val = (hdelay << AG903_VIA_SRC_HDELAY_HDELAY_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_HDELAY, val);
}


/**
 * @brief         VIA.SRC_HDELAY WX^擾
 * @param         id [in] `lԍ
 * @param         hdelay [out] HDELAYtB[h擾l
 * @return        void
 * @description   VIA.SRC_HDELAY 擾܂B 
*/
void AG903_ViaPrmGetVIASRCHDELAY(uint32_t id, uint16_t *hdelay)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(hdelay != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_HDELAY, &val);

    *hdelay = (val & AG903_VIA_SRC_HDELAY_HDELAY_MSK) >> AG903_VIA_SRC_HDELAY_HDELAY_POS;
}


/**
 * @brief         VIA.SRC_VCYCLE WX^ݒ
 * @param         id [in] `lԍ
 * @param         vcycle [in] VCYCLEtB[hݒl
 * @return        void
 * @description   VIA.SRC_VCYCLE ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCVCYCLE(uint32_t id, uint16_t vcycle)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(vcycle & ~(0x3FF)));

    val = (vcycle << AG903_VIA_SRC_VCYCLE_VCYCLE_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_VCYCLE, val);
}


/**
 * @brief         VIA.SRC_VCYCLE WX^擾
 * @param         id [in] `lԍ
 * @param         vcycle [out] VCYCLEtB[h擾l
 * @return        void
 * @description   VIA.SRC_VCYCLE 擾܂B 
*/
void AG903_ViaPrmGetVIASRCVCYCLE(uint32_t id, uint16_t *vcycle)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(vcycle != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_VCYCLE, &val);

    *vcycle = (val & AG903_VIA_SRC_VCYCLE_VCYCLE_MSK) >> AG903_VIA_SRC_VCYCLE_VCYCLE_POS;
}


/**
 * @brief         VIA.SRC_VVALID WX^ݒ
 * @param         id [in] `lԍ
 * @param         vvalid [in] VVALIDtB[hݒl
 * @return        void
 * @description   VIA.SRC_VVALID ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCVVALID(uint32_t id, uint16_t vvalid)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(vvalid & ~(0x3FF)));

    val = (vvalid << AG903_VIA_SRC_VVALID_VVALID_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_VVALID, val);
}


/**
 * @brief         VIA.SRC_VVALID WX^擾
 * @param         id [in] `lԍ
 * @param         vvalid [out] VVALIDtB[h擾l
 * @return        void
 * @description   VIA.SRC_VVALID 擾܂B 
*/
void AG903_ViaPrmGetVIASRCVVALID(uint32_t id, uint16_t *vvalid)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(vvalid != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_VVALID, &val);

    *vvalid = (val & AG903_VIA_SRC_VVALID_VVALID_MSK) >> AG903_VIA_SRC_VVALID_VVALID_POS;
}


/**
 * @brief         VIA.SRC_VDELAY WX^ݒ
 * @param         id [in] `lԍ
 * @param         vdelay [in] VDELAYtB[hݒl
 * @return        void
 * @description   VIA.SRC_VDELAY ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCVDELAY(uint32_t id, uint16_t vdelay)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(vdelay & ~(0x3FF)));

    val = (vdelay << AG903_VIA_SRC_VDELAY_VDELAY_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_VDELAY, val);
}


/**
 * @brief         VIA.SRC_VDELAY WX^擾
 * @param         id [in] `lԍ
 * @param         vdelay [out] VDELAYtB[h擾l
 * @return        void
 * @description   VIA.SRC_VDELAY 擾܂B 
*/
void AG903_ViaPrmGetVIASRCVDELAY(uint32_t id, uint16_t *vdelay)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(vdelay != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_VDELAY, &val);

    *vdelay = (val & AG903_VIA_SRC_VDELAY_VDELAY_MSK) >> AG903_VIA_SRC_VDELAY_VDELAY_POS;
}


/**
 * @brief         VIA.SRC_FRMFREQ WX^ݒ
 * @param         id [in] `lԍ
 * @param         frm [in] FRMtB[hݒl
 * @return        void
 * @description   VIA.SRC_FRMFREQ ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASRCFRMFREQ(uint32_t id, uint16_t frm)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(frm & ~(0x1)));

    val = (frm << AG903_VIA_SRC_FRMFREQ_FRM_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SRC_FRMFREQ, val);
}


/**
 * @brief         VIA.SRC_FRMFREQ WX^擾
 * @param         id [in] `lԍ
 * @param         frm [out] FRMtB[h擾l
 * @return        void
 * @description   VIA.SRC_FRMFREQ 擾܂B 
*/
void AG903_ViaPrmGetVIASRCFRMFREQ(uint32_t id, uint16_t *frm)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(frm != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SRC_FRMFREQ, &val);

    *frm = (val & AG903_VIA_SRC_FRMFREQ_FRM_MSK) >> AG903_VIA_SRC_FRMFREQ_FRM_POS;
}


/**
 * @brief         VIA.SIG_YCS WX^ݒ
 * @param         id [in] `lԍ
 * @param         trap [in] TRAPtB[hݒl
 * @param         mono [in] MONOtB[hݒl
 * @return        void
 * @description   VIA.SIG_YCS ݒ肵܂B 
*/
void AG903_ViaPrmSetVIASIGYCS(uint32_t id, uint16_t trap, uint16_t mono)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(trap & ~(0x1)));
    ASSERT(!(mono & ~(0x1)));

    val = (trap << AG903_VIA_SIG_YCS_TRAP_POS)
        | (mono << AG903_VIA_SIG_YCS_MONO_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_SIG_YCS, val);
}


/**
 * @brief         VIA.SIG_YCS WX^擾
 * @param         id [in] `lԍ
 * @param         trap [out] TRAPtB[h擾l
 * @param         mono [out] MONOtB[h擾l
 * @return        void
 * @description   VIA.SIG_YCS 擾܂B 
*/
void AG903_ViaPrmGetVIASIGYCS(uint32_t id, uint16_t *trap, uint16_t *mono)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(trap != NULL);
    ASSERT(mono != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_SIG_YCS, &val);

    *trap = (val & AG903_VIA_SIG_YCS_TRAP_MSK) >> AG903_VIA_SIG_YCS_TRAP_POS;
    *mono = (val & AG903_VIA_SIG_YCS_MONO_MSK) >> AG903_VIA_SIG_YCS_MONO_POS;
}


/**
 * @brief         VIA.CHD_SETUP2 WX^ݒ
 * @param         id [in] `lԍ
 * @param         bpf [in] BPFtB[hݒl
 * @param         hue [in] HUEtB[hݒl
 * @return        void
 * @description   VIA.CHD_SETUP2 ݒ肵܂B 
*/
void AG903_ViaPrmSetVIACHDSETUP2(uint32_t id, uint16_t bpf, uint16_t hue)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(bpf & ~(0x1)));
    ASSERT(!(hue & ~(0xFF)));

    val = (bpf << AG903_VIA_CHD_SETUP2_BPF_POS)
        | (hue << AG903_VIA_CHD_SETUP2_HUE_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_CHD_SETUP2, val);
}


/**
 * @brief         VIA.CHD_SETUP2 WX^擾
 * @param         id [in] `lԍ
 * @param         bpf [out] BPFtB[h擾l
 * @param         hue [out] HUEtB[h擾l
 * @return        void
 * @description   VIA.CHD_SETUP2 擾܂B 
*/
void AG903_ViaPrmGetVIACHDSETUP2(uint32_t id, uint16_t *bpf, uint16_t *hue)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(bpf != NULL);
    ASSERT(hue != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_CHD_SETUP2, &val);

    *bpf = (val & AG903_VIA_CHD_SETUP2_BPF_MSK) >> AG903_VIA_CHD_SETUP2_BPF_POS;
    *hue = (val & AG903_VIA_CHD_SETUP2_HUE_MSK) >> AG903_VIA_CHD_SETUP2_HUE_POS;
}


/**
 * @brief         VIA.CHD_SETUP3 WX^ݒ
 * @param         id [in] `lԍ
 * @param         setup [in] VIA.CHD_SETUP3ݒli[
 * @return        void
 * @description   VIA.CHD_SETUP3 ݒ肵܂B 
*/
void AG903_ViaPrmSetVIACHDSETUP3(uint32_t id, VIAPrmParamVIACHDSETUP3 *setup)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(setup != NULL);
    ASSERT(!(setup->agcen & ~(0x1)));
    ASSERT(!(setup->accov & ~(0x3F)));
    ASSERT(!(setup->acctc & ~(0x3)));
    ASSERT(!(setup->accmark & ~(0x3F)));

    val = (setup->agcen << AG903_VIA_CHD_SETUP3_AGCEN_POS)
        | (setup->accov << AG903_VIA_CHD_SETUP3_ACCOV_POS)
        | (setup->acctc << AG903_VIA_CHD_SETUP3_ACCTC_POS)
        | (setup->accmark << AG903_VIA_CHD_SETUP3_ACCMARK_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_CHD_SETUP3, val);
}


/**
 * @brief         VIA.CHD_SETUP3 WX^擾
 * @param         id [in] `lԍ
 * @param         setup [out] VIA.CHD_SETUP3擾li[
 * @return        void
 * @description   VIA.CHD_SETUP3 擾܂B 
*/
void AG903_ViaPrmGetVIACHDSETUP3(uint32_t id, VIAPrmParamVIACHDSETUP3 *setup)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(setup != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_CHD_SETUP3, &val);

    setup->agcen   = (val & AG903_VIA_CHD_SETUP3_AGCEN_MSK) >> AG903_VIA_CHD_SETUP3_AGCEN_POS;
    setup->accov   = (val & AG903_VIA_CHD_SETUP3_ACCOV_MSK) >> AG903_VIA_CHD_SETUP3_ACCOV_POS;
    setup->acctc   = (val & AG903_VIA_CHD_SETUP3_ACCTC_MSK) >> AG903_VIA_CHD_SETUP3_ACCTC_POS;
    setup->accmark = (val & AG903_VIA_CHD_SETUP3_ACCMARK_MSK) >> AG903_VIA_CHD_SETUP3_ACCMARK_POS;
}


/**
 * @brief         VIA.CHD_SETUP5 WX^ݒ
 * @param         id [in] `lԍ
 * @param         setup [in] VIA.CHD_SETUP5ݒli[
 * @return        void
 * @description   VIA.CHD_SETUP5 ݒ肵܂B 
*/
void AG903_ViaPrmSetVIACHDSETUP5(uint32_t id, VIAPrmParamVIACHDSETUP5 *setup)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(setup != NULL);
    ASSERT(!(setup->cbpllulth & ~(0x3F)));
    ASSERT(!(setup->cbpllulsv & ~(0x3)));
    ASSERT(!(setup->agcgainspd & ~(0x3)));
    ASSERT(!(setup->agcofstspd & ~(0x3)));
    ASSERT(!(setup->agcpos & ~(0x1)));
    ASSERT(!(setup->agcpal & ~(0x1)));
    ASSERT(!(setup->agcgainen & ~(0x1)));
    ASSERT(!(setup->agcofsten & ~(0x1)));

    val = (setup->cbpllulth << AG903_VIA_CHD_SETUP5_CBPLLULTH_POS)
        | (setup->cbpllulsv << AG903_VIA_CHD_SETUP5_CBPLLULSV_POS)
        | (setup->agcgainspd << AG903_VIA_CHD_SETUP5_AGCGAINSPD_POS)
        | (setup->agcofstspd << AG903_VIA_CHD_SETUP5_AGCOFSTSPD_POS)
        | (setup->agcpos << AG903_VIA_CHD_SETUP5_AGCPOS_POS)
        | (setup->agcpal << AG903_VIA_CHD_SETUP5_AGCPAL_POS)
        | (setup->agcgainen << AG903_VIA_CHD_SETUP5_AGCGAINEN_POS)
        | (setup->agcofsten << AG903_VIA_CHD_SETUP5_AGCOFSTEN_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_CHD_SETUP5, val);
}


/**
 * @brief         VIA.CHD_SETUP5 WX^擾
 * @param         id [in] `lԍ
 * @param         setup [out] VIA.CHD_SETUP5擾li[
 * @return        void
 * @description   VIA.CHD_SETUP5 擾܂B 
*/
void AG903_ViaPrmGetVIACHDSETUP5(uint32_t id, VIAPrmParamVIACHDSETUP5 *setup)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(setup != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_CHD_SETUP5, &val);

    setup->cbpllulth  = (val & AG903_VIA_CHD_SETUP5_CBPLLULTH_MSK) >> AG903_VIA_CHD_SETUP5_CBPLLULTH_POS;
    setup->cbpllulsv  = (val & AG903_VIA_CHD_SETUP5_CBPLLULSV_MSK) >> AG903_VIA_CHD_SETUP5_CBPLLULSV_POS;
    setup->agcgainspd = (val & AG903_VIA_CHD_SETUP5_AGCGAINSPD_MSK) >> AG903_VIA_CHD_SETUP5_AGCGAINSPD_POS;
    setup->agcofstspd = (val & AG903_VIA_CHD_SETUP5_AGCOFSTSPD_MSK) >> AG903_VIA_CHD_SETUP5_AGCOFSTSPD_POS;
    setup->agcpos     = (val & AG903_VIA_CHD_SETUP5_AGCPOS_MSK) >> AG903_VIA_CHD_SETUP5_AGCPOS_POS;
    setup->agcpal     = (val & AG903_VIA_CHD_SETUP5_AGCPAL_MSK) >> AG903_VIA_CHD_SETUP5_AGCPAL_POS;
    setup->agcgainen  = (val & AG903_VIA_CHD_SETUP5_AGCGAINEN_MSK) >> AG903_VIA_CHD_SETUP5_AGCGAINEN_POS;
    setup->agcofsten  = (val & AG903_VIA_CHD_SETUP5_AGCOFSTEN_MSK) >> AG903_VIA_CHD_SETUP5_AGCOFSTEN_POS;
}


/**
 * @brief         VIA.OUT_LEVELY WX^ݒ
 * @param         id [in] `lԍ
 * @param         yofst [in] YOFSTtB[hݒl
 * @param         ygain [in] YGAINtB[hݒl
 * @return        void
 * @description   VIA.OUT_LEVELY ݒ肵܂B 
*/
void AG903_ViaPrmSetVIAOUTLEVELY(uint32_t id, uint16_t yofst, uint16_t ygain)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(yofst & ~(0xFF)));
    ASSERT(!(ygain & ~(0xFF)));

    val = (yofst << AG903_VIA_OUT_LEVELY_YOFST_POS)
        | (ygain << AG903_VIA_OUT_LEVELY_YGAIN_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_OUT_LEVELY, val);
}


/**
 * @brief         VIA.OUT_LEVELY WX^擾
 * @param         id [in] `lԍ
 * @param         yofst [out] YOFSTtB[h擾l
 * @param         ygain [out] YGAINtB[h擾l
 * @return        none
 * @description   VIA.OUT_LEVELY 擾܂B 
*/
void AG903_ViaPrmGetVIAOUTLEVELY(uint32_t id, uint16_t *yofst, uint16_t *ygain)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(yofst != NULL);
    ASSERT(ygain != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_OUT_LEVELY, &val);

    *yofst = (val & AG903_VIA_OUT_LEVELY_YOFST_MSK) >> AG903_VIA_OUT_LEVELY_YOFST_POS;
    *ygain = (val & AG903_VIA_OUT_LEVELY_YGAIN_MSK) >> AG903_VIA_OUT_LEVELY_YGAIN_POS;
}


/**
 * @brief         VIA.OUT_LEVELCB WX^ݒ
 * @param         id [in] `lԍ
 * @param         cbofst [in] CBOFSTtB[hݒl
 * @param         cbgain [in] CBGAINtB[hݒl
 * @return        void
 * @description   VIA.OUT_LEVELCB ݒ肵܂B 
*/
void AG903_ViaPrmSetVIAOUTLEVELCB(uint32_t id, uint16_t cbofst, uint16_t cbgain)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(cbofst & ~(0xFF)));
    ASSERT(!(cbgain & ~(0xFF)));

    val = (cbofst << AG903_VIA_OUT_LEVELCB_CBOFST_POS)
        | (cbgain << AG903_VIA_OUT_LEVELCB_CBGAIN_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_OUT_LEVELCB, val);
}


/**
 * @brief         VIA.OUT_LEVELCB WX^擾
 * @param         id [in] `lԍ
 * @param         cbofst [out] CBOFSTtB[h擾l
 * @param         cbgain [out] CBGAINtB[h擾l
 * @return        void
 * @description   VIA.OUT_LEVELCB 擾܂B 
*/
void AG903_ViaPrmGetVIAOUTLEVELCB(uint32_t id, uint16_t *cbofst, uint16_t *cbgain)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(cbofst != NULL);
    ASSERT(cbgain != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_OUT_LEVELCB, &val);

    *cbofst = (val & AG903_VIA_OUT_LEVELCB_CBOFST_MSK) >> AG903_VIA_OUT_LEVELCB_CBOFST_POS;
    *cbgain = (val & AG903_VIA_OUT_LEVELCB_CBGAIN_MSK) >> AG903_VIA_OUT_LEVELCB_CBGAIN_POS;
}


/**
 * @brief         VIA.OUT_LEVELCR WX^ݒ
 * @param         id [in] `lԍ
 * @param         crofst [in] CROFSTtB[hݒl
 * @param         crgain [in] CRGAINtB[hݒl
 * @return        void
 * @description   VIA.OUT_LEVELCR ݒ肵܂B 
*/
void AG903_ViaPrmSetVIAOUTLEVELCR(uint32_t id, uint16_t crofst, uint16_t crgain)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(crofst & ~(0xFF)));
    ASSERT(!(crgain & ~(0xFF)));

    val = (crofst << AG903_VIA_OUT_LEVELCR_CROFST_POS)
        | (crgain << AG903_VIA_OUT_LEVELCR_CRGAIN_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_OUT_LEVELCR, val);
}


/**
 * @brief         VIA.OUT_LEVELCR WX^擾
 * @param         id [in] `lԍ
 * @param         crofst [out] CROFSTtB[h擾l
 * @param         crgain [out] CRGAINtB[h擾l
 * @return        void
 * @description   VIA.OUT_LEVELCR 擾܂B 
*/
void AG903_ViaPrmGetVIAOUTLEVELCR(uint32_t id, uint16_t *crofst, uint16_t *crgain)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(crofst != NULL);
    ASSERT(crgain != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_OUT_LEVELCR, &val);

    *crofst = (val & AG903_VIA_OUT_LEVELCR_CROFST_MSK) >> AG903_VIA_OUT_LEVELCR_CROFST_POS;
    *crgain = (val & AG903_VIA_OUT_LEVELCR_CRGAIN_MSK) >> AG903_VIA_OUT_LEVELCR_CRGAIN_POS;
}


/**
 * @brief         VIA.CLAMP_LEVEL WX^ݒ
 * @param         id [in] `lԍ
 * @param         clampofs [in] CLAMPOFStB[hݒl
 * @return        void
 * @description   VIA.CLAMP_LEVEL ݒ肵܂B 
*/
void AG903_ViaPrmSetVIACLAMPLEVEL(uint32_t id, uint16_t clampofs)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(!(clampofs & ~(0x3FF)));

    val = (clampofs << AG903_VIA_CLAMP_LEVEL_CLAMPOFS_POS);

    AG903_SSCPrmWriteCmpstVideoDec(id, AG903_VIA_CLAMP_LEVEL, val);
}


/**
 * @brief         VIA.CLAMP_LEVEL WX^擾
 * @param         id [in] `lԍ
 * @param         clampofs [out] CLAMPOFStB[h擾l
 * @return        void
 * @description   VIA.CLAMP_LEVEL 擾܂B 
*/
void AG903_ViaPrmGetVIACLAMPLEVEL(uint32_t id, uint16_t *clampofs)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(clampofs != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_CLAMP_LEVEL, &val);

    *clampofs = (val & AG903_VIA_CLAMP_LEVEL_CLAMPOFS_MSK) >> AG903_VIA_CLAMP_LEVEL_CLAMPOFS_POS;
}


/**
 * @brief         VIA.DET_STATUS WX^擾
 * @param         id [in] `lԍ
 * @param         setup [out] VIA.DET_STATUS擾li[
 * @return        void
 * @description   VIA.DET_STATUS 擾܂B 
*/
void AG903_ViaPrmGetVIADETSTATUS(uint32_t id, VIAPrmParamVIADETSTATUS *status)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(status != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_DET_STATUS, &val);

    status->fmt    = (val & AG903_VIA_DET_STATUS_FMT_MSK) >> AG903_VIA_DET_STATUS_FMT_POS;
    status->tbcno  = (val & AG903_VIA_DET_STATUS_TBCNO_MSK) >> AG903_VIA_DET_STATUS_TBCNO_POS;
    status->std    = (val & AG903_VIA_DET_STATUS_STD_MSK) >> AG903_VIA_DET_STATUS_STD_POS;
    status->ckill  = (val & AG903_VIA_DET_STATUS_CKILL_MSK) >> AG903_VIA_DET_STATUS_CKILL_POS;
    status->trick  = (val & AG903_VIA_DET_STATUS_TRICK_MSK) >> AG903_VIA_DET_STATUS_TRICK_POS;
    status->normal = (val & AG903_VIA_DET_STATUS_NORMAL_MSK) >> AG903_VIA_DET_STATUS_NORMAL_POS;
    status->vtr    = (val & AG903_VIA_DET_STATUS_VTR_MSK) >> AG903_VIA_DET_STATUS_VTR_POS;
    status->prog   = (val & AG903_VIA_DET_STATUS_PROG_MSK) >> AG903_VIA_DET_STATUS_PROG_POS;
    status->nosync = (val & AG903_VIA_DET_STATUS_NOSYNC_MSK) >> AG903_VIA_DET_STATUS_NOSYNC_POS;
}


/**
 * @brief         VIA.DET_HCYCLE WX^擾
 * @param         id [in] `lԍ
 * @param         hcycle [out] HCYCLEtB[h擾l
 * @return        none
 * @description   VIA.DET_HCYCLE ݒ肵܂B 
*/
void AG903_ViaPrmGetVIADETHCYCLE(uint32_t id, uint16_t *hcycle)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(hcycle != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_DET_HCYCLE, &val);

    *hcycle = (val & AG903_VIA_DET_HCYCLE_HCYCLE_MSK) >> AG903_VIA_DET_HCYCLE_HCYCLE_POS;
}


/**
 * @brief         VIA.DET_VCYCLE WX^擾
 * @param         id [in] `lԍ
 * @param         vcycle [out] VCYCLEtB[h擾l
 * @return        void
 * @description   VIA.DET_HCYCLE 擾܂B 
*/
void AG903_ViaPrmGetVIADETVCYCLE(uint32_t id, uint16_t *vcycle)
{
    uint16_t                    val;

    ASSERT(id < AG903_VIA_PRM_MAX_PORTS);
    ASSERT(vcycle != NULL);

    AG903_SSCPrmReadCmpstVideoDec(id, AG903_VIA_DET_VCYCLE, &val);

    *vcycle = (val & AG903_VIA_DET_VCYCLE_VCYCLE_MSK) >> AG903_VIA_DET_VCYCLE_VCYCLE_POS;
}
