/**
 * @brief           VID Manager
 * @author          AXELL CORPORATION
 * @description     VID Manager Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include <stdio.h>
#include "vid/vidprm.h"
#include "vid/vidmgr.h"
#include "pgp/pgpprm.h"

/* OAChԂł邱Ƃw܂ */
#define PGP_IDLE    (0)

/* fW^rfI͂̃ReLXg */
static struct {
    _Bool                       used_in_ports[AG903_VID_MGR_MAX_IN_PORTS];
    AG903_VidMgrInputHandle     in_ports[AG903_VID_MGR_MAX_IN_PORTS];
    _Bool                       used_out_ports[AG903_VID_MGR_MAX_OUT_PORTS];
    AG903_VidMgrOutputHandle    out_ports[AG903_VID_MGR_MAX_OUT_PORTS];
    _Bool                       vid_enable;
    int32_t                     vid_format;
} VidContext = {
    {false, false},
    {{0}},
    {false, false, false, false},
    {{0}},
    false,
    0
};

/**
 * @brief         fW^rfI̗͂L/ݒ
 * @param         enable [in] Ĺ@trueÁ@false@ݒ肵܂B 
 * @return        ݒ茋 
 * @retval        AG903_ENONE I
 * @description   fW^rfI̗͂Lݒ肵܂B
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrEnable(_Bool enable)
{
    VidContext.vid_enable = enable;

    return AG903_ENONE;
}


static _Bool CheckFormatCompatibility(uint32_t format)
{
    switch (format) {
        case AG903_VID_MGR_24BIT_TO_CH0:
        case AG903_VID_MGR_8BITCH0_TO_CH0:
            if (VidContext.used_in_ports[0] == false || VidContext.used_out_ports[0] == false || 
                VidContext.used_in_ports[1] == true || VidContext.used_out_ports[1] == true ||
                VidContext.used_out_ports[2] == true || VidContext.used_out_ports[3] == true) {
                return false;
            }
            break;
        case AG903_VID_MGR_8BITCH1_TO_CH1:
            if (VidContext.used_in_ports[0] == true || VidContext.used_out_ports[0] == true ||
                VidContext.used_in_ports[1] == false || VidContext.used_out_ports[1] == false ||
                VidContext.used_out_ports[2] == true || VidContext.used_out_ports[3] == true) {
                return false;
            }
            break;
        case AG903_VID_MGR_8BITCH01_TO_CH01:
            if (((VidContext.used_in_ports[0] == false || VidContext.used_out_ports[0] == false) &&
                (VidContext.used_in_ports[1] == false || VidContext.used_out_ports[1] == false)) ||
                VidContext.used_out_ports[2] == true || VidContext.used_out_ports[3] == true) {
                return false;
            }
            break;
        case AG903_VID_MGR_8BITCH0_TO_CH0123:
        default:
            if (VidContext.used_in_ports[0] == false || VidContext.used_in_ports[1] == true || 
                (VidContext.used_out_ports[0] == false && VidContext.used_out_ports[1] == false &&
                VidContext.used_out_ports[2] == false && VidContext.used_out_ports[3] == false)) {
                return false;
            }
            break;
    }

    return true;
}


/**
 * @brief         fW^rfI͂̃tH[}bgݒ 
 * @param         format [in] ̓tH[}bgݒ肵܂B 
 * @return        ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL ̓tH[}bgƌݎ擾Ăo̓nhɌ݊ꍇ 
 * @description   fW^rfI̓tH[}bgw肵܂B<p> 
 *  							formatɂ́uVIDtH[}bgvw肵ĂB<p>
 *  							w肳ꂽtH[}bǵAݎ擾Ă̓|[gnhAo̓|[gnhƌ݊邩`FbN܂B<p>
 *  							tH[}bgƂ̌݊́uVIDtH[}bgvQƂĂB
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrSetInputFormat(uint32_t format)
{
    switch (format) {
        case AG903_VID_MGR_24BIT_TO_CH0:
        case AG903_VID_MGR_8BITCH0_TO_CH0:
        case AG903_VID_MGR_8BITCH1_TO_CH1:
        case AG903_VID_MGR_8BITCH01_TO_CH01:
        case AG903_VID_MGR_8BITCH0_TO_CH0123:
            break;
        default:
            return -AG903_EINVAL;
    }

    if (CheckFormatCompatibility(format) != true) {
        return -AG903_EINVAL;
    }

    VidContext.vid_format = format;

    return AG903_ENONE;
}


/**
 * @brief         fW^rfI͂̃nh擾 
 * @param         ports [in] 擾|[gԍi[zB
 * @param         num_ports [in] ports̔zvfi擾nhjB
 * @param         handles [out] 擾nhi[zB
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL ports0-1͈̔͊O̒lw肳ꂽꍇ<p>num_portsɎ擾\ȃnh̍ő吔ȏ̒lw肳ꂽꍇ<p>portsAhandlesNULLw肳ꂽꍇ
 * @retval        -AG903_ENOMEM portsŎw肳ꂽ|[gɑΉnh擾ς̏ꍇ 
 * @description   ̓|[gԍw肵ē̓|[gnh(AG903_VidMgrInputHandle)擾܂B<p> 
 *  							w肳ꂽԍɑΉnhgpƔfꂽꍇAhandles ɃAhXԂ܂B<p>
 *  							vꂽԍ̂gp̓̓|[gł݂ꍇAhandles ɂ͉i[܂B<p>
 *  							handles ɂ ports Ŏw肳ꂽԍɃnhi[܂B
*/
int32_t AG903_VidMgrGetInputHandle(int32_t *ports, int32_t num_ports, AG903_VidMgrInputHandle **handles)
{
    int32_t i;
    _Bool num_check[AG903_VID_MGR_MAX_IN_PORTS] = {false};

    if (num_ports > AG903_VID_MGR_MAX_IN_PORTS) {
        return -AG903_EINVAL;
    }
    if ((ports == NULL) || (handles == NULL)) {
        return -AG903_EINVAL;
    }
    for (i = 0; i < num_ports; i++) {
        if ((ports[i] < 0) || (ports[i] >= AG903_VID_MGR_MAX_IN_PORTS)) {
            return -AG903_EINVAL;
        }
        if (VidContext.used_in_ports[ports[i]] != false) {
            return -AG903_ENOMEM;
        }
        /* ԍw肳ꂽꍇ̓G[ */
        if (num_check[ports[i]] == true) {
            return -AG903_EINVAL;
        }
        num_check[ports[i]] = true;
    }

    for (i = 0; i < num_ports; i++) {
        /* fW^rfI̓nhhandlesɊi[ď */
        handles[i] = (AG903_VidMgrInputHandle *)&VidContext.in_ports[ports[i]];
        handles[i]->id = AG903_VID_MGR_INPUT_HANDLE_ID;
        handles[i]->port_no = ports[i];
        handles[i]->is_dirty = false;
        handles[i]->sync_signal = 0;
        handles[i]->inout_vsync_pol = 0;
        handles[i]->inout_hsync_pol = 0;
        handles[i]->in_de_pol = 0;
        handles[i]->in_field_pol = 0;
        handles[i]->in_clk_pol = 0;
        handles[i]->h_pulse_width = 0x60;
        handles[i]->h_front_porch = 0x10;
        handles[i]->h_back_porch = 0x30;
        handles[i]->h_frame_size = 0x280;
        handles[i]->v_pulse_width = 0x2;
        handles[i]->v_front_porch = 0xA;
        handles[i]->v_back_porch = 0x21;
        handles[i]->v_frame_size = 0x1E0;
        /* 擾ς̃|[gɏԑJڂ */
        VidContext.used_in_ports[ports[i]] = true;
    }
    return AG903_ENONE;
}


/**
 * @brief         fW^rfI͂̃nh
 * @param         handle [in] fW^rfI̓nh 
 * @return         
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfI̓nhw肳ꂽꍇ 
 * @description   w肳ꂽ̓|[gnh܂B<p> 
 *  							̓|[gnh́Aport_no ȊOS 0 ŏ܂B
 * @note          {֐R[ꍇ́AOW[~Ă邱ƂmFĂB 
*/
int32_t AG903_VidMgrReleaseInputHandle(AG903_VidMgrInputHandle *handle)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ς̃|[gɏԑJڂ */
    VidContext.used_in_ports[handle->port_no] = false;

    /* port_noȊÕo0ɏiid0ɏ邱ƂŖȃnhɑJڂj */
    handle->id = 0;
    handle->is_dirty = false;
    handle->sync_signal = 0;
    handle->inout_vsync_pol = 0;
    handle->inout_hsync_pol = 0;
    handle->in_de_pol = 0;
    handle->in_field_pol = 0;
    handle->in_clk_pol = 0;
    handle->h_pulse_width = 0;
    handle->h_front_porch = 0;
    handle->h_back_porch = 0;
    handle->h_frame_size = 0;
    handle->v_pulse_width = 0;
    handle->v_front_porch = 0;
    handle->v_back_porch = 0;
    handle->v_frame_size = 0;

    return AG903_ENONE;
}


/**
 * @brief         fW^rfIo͂̃nh擾 
 * @param         ports [in] 擾|[gԍi[zB
 * @param         num_ports [in] ports̔zvfi擾nhjB
 * @param         handles [out] 擾nhi[zB 
 * @return        擾 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL ports0-3͈̔͊O̒lw肳ꂽꍇ<p>num_portsɎ擾\ȃnh̍ő吔ȏ̒lw肳ꂽꍇ<p>portsAhandlesNULLw肳ꂽꍇ
 * @retval        -AG903_ENOMEM portsŎw肳ꂽ|[gɑΉnh擾ς̏ꍇ 
 * @description   o̓|[gԍw肵ďo̓|[gnh(AG903_VidMgrOutputHandle)擾܂B<p> 
 *  							w肳ꂽԍɑΉnhgpƔfꂽꍇAhandles ɃAhXԂ܂B<p>
 *  							vꂽԍ̂gp̏o̓|[gł݂ꍇAhandles ɂ͉i[܂B<p>
 *  							handles ɂ ports Ŏw肳ꂽԍɃnhi[܂B
 * @note    none
*/
int32_t AG903_VidMgrGetOutputHandle(int32_t *ports, int32_t num_ports, AG903_VidMgrOutputHandle **handles)
{
    int32_t i;
    _Bool num_check[AG903_VID_MGR_MAX_OUT_PORTS] = {false};

    if (num_ports > AG903_VID_MGR_MAX_OUT_PORTS) {
        return -AG903_EINVAL;
    }
    if ((ports == NULL) || (handles == NULL)) {
        return -AG903_EINVAL;
    }
    for (i = 0; i < num_ports; i++) {
        if ((ports[i] < 0) || (ports[i] >= AG903_VID_MGR_MAX_OUT_PORTS)) {
            return -AG903_EINVAL;
        }
        if (VidContext.used_out_ports[ports[i]] != false) {
            return -AG903_ENOMEM;
        }
        /* ԍw肳ꂽꍇ̓G[ */
        if (num_check[ports[i]] == true) {
            return -AG903_EINVAL;
        }
        num_check[ports[i]] = true;
    }

    for (i = 0; i < num_ports; i++) {
        /* fW^rfIo̓nhhandlesɊi[ď */
        handles[i] = (AG903_VidMgrOutputHandle *)&VidContext.out_ports[ports[i]];
        handles[i]->id = AG903_VID_MGR_OUTPUT_HANDLE_ID;
        handles[i]->port_no = ports[i];
        handles[i]->is_dirty = false;
        handles[i]->tdm = 0;
        handles[i]->delay = false;
        handles[i]->trs_dec_enable = false;
        handles[i]->trs_efp = 0;
        handles[i]->trs_ofp = 0;
        handles[i]->trs_vfp = 0x4;
        handles[i]->trs_href = 0;
        handles[i]->trs_hfp = 0;
        handles[i]->v_max = 8192;
        handles[i]->h_max = 8192;
        /* 擾ς̃|[gɏԑJڂ */
        VidContext.used_out_ports[ports[i]] = true;
    }
    return AG903_ENONE;
}


/**
 * @brief         fW^rfIo͂̃nh
 * @param         handle [in] fW^rfIo̓nhB 
 * @return         
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfIo̓nhw肳ꂽꍇ 
 * @description   w肳ꂽo̓|[gnh܂B<p>o̓|[gnh́Aport_no ȊOS 0 ŏ܂B
 * @note          {֐R[ꍇ́AOW[~Ă邱ƂmFĂB 
*/
int32_t AG903_VidMgrReleaseOutputHandle(AG903_VidMgrOutputHandle *handle)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_OUTPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* ς̃|[gɏԑJڂ */
    VidContext.used_out_ports[handle->port_no] = false;

    /* port_noȊÕo0ɏiid0ɏ邱ƂŖȃnhɑJڂj */
    handle->id = 0;
    handle->is_dirty = false;
    handle->tdm = 0;
    handle->delay = false;
    handle->trs_dec_enable = false;
    handle->trs_efp = 0;
    handle->trs_ofp = 0;
    handle->trs_vfp = 0;
    handle->trs_href = 0;
    handle->trs_hfp = 0;
    handle->v_max = 0;
    handle->h_max = 0;

    return AG903_ENONE;
}

/* TDM̃WX^ݒl肾}N */
#define GET_TDMBLK(v)   ((v) & 0x1)
#define GET_TDMTRS(v)   (((v) >> 1) & 0x1)

/* o̓p[^̐ݒl肷}N */
#define GET_H_PULSE(v)  ((v) == AG903_VID_MGR_MAX_OUT_HORIZONTAL_PULSE_WIDTH ? 0 : (v))
#define GET_H_FPORCH(v) ((v) == AG903_VID_MGR_MAX_OUT_HORIZONTAL_FRONT_PORCH ? 0 : (v))
#define GET_H_BPORCH(v) ((v) == AG903_VID_MGR_MAX_OUT_HORIZONTAL_BACK_PORCH ? 0 : (v))
#define GET_H_FSIZE(v)  ((v) == AG903_VID_MGR_MAX_OUT_HORIZONTAL_FRAME_SIZE ? 0 : (v))
#define GET_V_PULSE(v)  ((v) == AG903_VID_MGR_MAX_OUT_VERTICAL_PULSE_WIDTH ? 0 : (v))
#define GET_V_FPORCH(v) ((v) == AG903_VID_MGR_MAX_OUT_VERTICAL_FRONT_PORCH ? 0 : (v))
#define GET_V_BPORCH(v) ((v) == AG903_VID_MGR_MAX_OUT_VERTICAL_BACK_PORCH ? 0 : (v))
#define GET_V_FSIZE(v)  ((v) == AG903_VID_MGR_MAX_OUT_VERTICAL_FRAME_SIZE ? 0 : (v))

/* TRSfR[hւ̐ݒl肷}N */
#define GET_TRS_VFP(v)  ((v) == AG903_VID_MGR_MAX_TRS_VFP ? 0 : (v))
#define GET_TRS_HFP(v)  (v)

/* Mo̐ݒl肷}N */
#define GET_VMAX(v)     ((v) == AG903_VID_MGR_MAX_SD_VERTICAL_CYCLE ? 0 : (v))
#define GET_HMAX(v)     ((v) == AG903_VID_MGR_MAX_SD_HORIZONTAL_CYCLE ? 0 : (v))

/**
 * @brief         fW^rfIo͂̃n[hEFAݒ
 * @param         void
 * @return        ]  
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL ̓tH[}bgƌݎ擾Ăo̓nhɌ݊ꍇ 
 * @description   fW^rfIo͂̐ݒln[hEFAɐݒ肵܂B<p> 
 *  							f[^ƂĕێĂݒl{֐R[ꂽ_Ńn[hEFAɏ݂܂B<p>
 *  							ݎ擾Ă̓|[g/o̓|[g̃nhƐݒ肳Ă̓tH[}bgɌ݊ꍇG[Ԃ܂B<p>
 *  							tH[}bgƂ̌݊́uVIDtH[}bgvQƂĂB
*/
int32_t AG903_VidMgrCommitSetting(void)
{
    int32_t i;

    /* tH[}bgƌ݂̓o̓nh擾Ɍ݊邩`FbN܂ */
    if (CheckFormatCompatibility(VidContext.vid_format) != true) {
        return -AG903_EINVAL;
    }

    /*ʐݒ̃p[^HWɓ]܂*/
    AG903_VidPrmSetVIDCTRL(VidContext.vid_enable);
    AG903_VidPrmSetVIDFMT(VidContext.vid_format);

    /* p[^XVsȂĂ̓nh̐ݒHWɓ]܂ */
    for (i = 0; i < AG903_VID_MGR_MAX_IN_PORTS; i++) {
        AG903_VidMgrInputHandle *handle = (AG903_VidMgrInputHandle *)&VidContext.in_ports[i];
        if (VidContext.used_in_ports[i] == true && handle->is_dirty == true) {
            AG903_VidPrmSetVIDIOnCTRL(i, handle->sync_signal);

            VIDPrmParamVIDIOnMOD mod;
            mod.vpol = handle->inout_vsync_pol;
            mod.hpol = handle->inout_hsync_pol;
            mod.dpol = handle->in_de_pol;
            mod.fpol = handle->in_field_pol;
            mod.cpol = handle->in_clk_pol;
            AG903_VidPrmSetVIDIOnMOD(i, &mod);

            AG903_VidPrmSetVIDIOnOHPRM0(i, GET_H_PULSE(handle->h_pulse_width));
            AG903_VidPrmSetVIDIOnOHPRM1(i, GET_H_FPORCH(handle->h_front_porch), GET_H_BPORCH(handle->h_back_porch));
            AG903_VidPrmSetVIDIOnOVPRM0(i, GET_V_PULSE(handle->v_pulse_width));
            AG903_VidPrmSetVIDIOnOVPRM1(i, GET_V_FPORCH(handle->v_front_porch), GET_V_BPORCH(handle->v_back_porch));
            AG903_VidPrmSetVIDIOnOSIZE(i, GET_H_FSIZE(handle->v_frame_size), GET_V_FSIZE(handle->h_frame_size));
        }
    }
    /* p[^XVsȂĂo̓nh̐ݒHWɓ]܂ */
    for (i = 0; i < AG903_VID_MGR_MAX_OUT_PORTS; i++) {
        AG903_VidMgrOutputHandle *handle = (AG903_VidMgrOutputHandle *)&VidContext.out_ports[i];
        if (VidContext.used_out_ports[i] == true && handle->is_dirty == true) {

            VIDPrmParamVIDCOnMOD mod;
            mod.tdmblk = GET_TDMBLK(handle->tdm);
            mod.tdmtrs = GET_TDMTRS(handle->tdm);
            mod.delay  = handle->delay;
            mod.trsdec = handle->trs_dec_enable;
            AG903_VidPrmSetVIDCOnMOD(i, &mod);

            VIDPrmParamVIDCOnTRSPRM trsprm;
            trsprm.efp  = handle->trs_efp;
            trsprm.ofp  = handle->trs_ofp;
            trsprm.vfp  = GET_TRS_VFP(handle->trs_vfp);
            trsprm.href = handle->trs_href;
            trsprm.hfp  = GET_TRS_HFP(handle->trs_hfp);
            AG903_VidPrmSetVIDCOnTRSPRM(i, &trsprm);

            AG903_VidPrmSetVIDCOnSDPRM(i, GET_VMAX(handle->v_max), GET_HMAX(handle->h_max));
        }
    }

    return AG903_ENONE;
}


/**
 * @brief         w肵nhƌ݂̓̓tH[}bgƂ̌݊`FbN
 * @param         handle [in] ݊`FbN̓nh܂́Ao̓nhw肵܂B
 * @param         handle_type [in] handleɎw肵nh̃^Cv(̓nh܂́Ao̓nh)w肵܂B 
 * @return        ݊`FbN 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃnhw肳ꂽꍇ<p>handle_typeɕsȒlw肳ꂽꍇ<p>w肵nh݂̓̓tH[}bgƌ݊ꍇ
 * @description   ݐݒ肳Ă̓tH[}bgƎw肳ꂽnȟ݊`FbN܂B<p> 
 *  							nh^Cv(VIDnh^Cv)ɂo͂𔻕ʂ܂B<p>
 *  							tH[}bgƂ̌݊́uVIDtH[}bgvQƂĂB<p>
 *  							݊ɓKĂꍇALȃnhԂ܂B
*/
int32_t AG903_VidMgrCheckHandleValidation(void *handle, int32_t handle_type)
{
    uint32_t port_no;
    AG903_VidMgrInputHandle *input_handle = (AG903_VidMgrInputHandle *)handle;
    AG903_VidMgrOutputHandle *output_handle = (AG903_VidMgrOutputHandle *)handle;

    switch (handle_type) {
        case AG903_VID_MGR_INPUT_HANDLE:
            if ((handle == NULL) || (input_handle->id != AG903_VID_MGR_INPUT_HANDLE_ID)) {
                return -AG903_EINVAL;
            }
            port_no = input_handle->port_no;
            break;
        case AG903_VID_MGR_OUTPUT_HANDLE:
            if ((handle == NULL) || (output_handle->id != AG903_VID_MGR_OUTPUT_HANDLE_ID)) {
                return -AG903_EINVAL;
            }
            port_no = output_handle->port_no;
            break;
        default:
            return -AG903_EINVAL;
    }

    /* ݂̃tH[}bgƂ̌݊`FbN܂ */
    switch (VidContext.vid_format) {
        case AG903_VID_MGR_24BIT_TO_CH0:
        case AG903_VID_MGR_8BITCH0_TO_CH0:
            if ((handle_type == AG903_VID_MGR_INPUT_HANDLE && port_no != 0) ||
                (handle_type == AG903_VID_MGR_OUTPUT_HANDLE && port_no != 0)){
                return -AG903_EINVAL;
            }
            break;
        case AG903_VID_MGR_8BITCH1_TO_CH1:
            if ((handle_type == AG903_VID_MGR_INPUT_HANDLE && port_no != 1) ||
                (handle_type == AG903_VID_MGR_OUTPUT_HANDLE && port_no != 1)){
                return -AG903_EINVAL;
            }
            break;
        case AG903_VID_MGR_8BITCH01_TO_CH01:
            if ((handle_type == AG903_VID_MGR_OUTPUT_HANDLE && (port_no != 0 && port_no != 1))) {
                return -AG903_EINVAL;
            }
            break;
        case AG903_VID_MGR_8BITCH0_TO_CH0123:
        default:
            if ((handle_type == AG903_VID_MGR_INPUT_HANDLE && port_no != 0)) {
                return -AG903_EINVAL;
            }
            break;
    }
    return AG903_ENONE;
}


/**
 * @brief         fW^rfI͂̓Mo͐ݒ
 * @param         handle [in] fW^rfI̓nhB
 * @param         inout [in] M̓́Ao͂w肵܂B 
 * @return        o͐ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfI̓nhw肳ꂽꍇ<p>inoutɕsȒlw肳ꂽꍇ 
 * @description   M̓/o͂ݒ肵܂B<p>o͐ݒ́uVIDMóvQƂĂB 
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrSetIOSignal(AG903_VidMgrInputHandle *handle, uint32_t inout)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* inoutɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (inout) {
        case AG903_VID_MGR_IO_SIGNAL_INPUT:
        case AG903_VID_MGR_IO_SIGNAL_OUTPUT:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^ێAdirtytOZbg܂ */
    handle->sync_signal = inout;
    handle->is_dirty = true;

    return AG903_ENONE;
}


/**
 * @brief         fW^rfI͂̓샂[hݒ
 * @param         handle [in] fW^rfI̓nhB
 * @param         v_pol [in] oVSYNC̋ɐw肵܂B
 * @param         h_pol [in] oHSYNC̋ɐw肵܂B
 * @param         d_pol [in] DE̋ɐw肵܂B
 * @param         f_pol [in] FEILD̋ɐw肵܂B
 * @param         c_pol [in] ̓NbN̋ɐw肵܂B 
 * @return        ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfI̓nhw肳ꂽꍇ<p>v_pol/h_pol/d_pol/f_pol/c_polɕsȒlw肳ꂽꍇ
 * @description   샂[hݒ肵܂B<p> 
 *                wp[^ɂĂ͈ȉQƂĂB 
 *                <table>
 *                <tr><th>Ώۃp[^</th><th>QƐ</th></tr>
 *                <tr><td>v_pol</td><td>VIDVSYNCɐ</td></tr>
 *                <tr><td>h_pol</td><td>VIDHSYNCɐ</td></tr>
 *                <tr><td>d_pol</td><td>VIDDEɐ</td></tr>
 *                <tr><td>f_pol</td><td>VIDFIELDɐ</td></tr>
 *                <tr><td>c_pol</td><td>VID̓NbNɐ</td></tr>
 *                </table>
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrSetIOMode(AG903_VidMgrInputHandle *handle, uint32_t v_pol, uint32_t h_pol, uint32_t d_pol, uint32_t f_pol, uint32_t c_pol)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* v_polɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (v_pol) {
        case AG903_VID_MGR_IO_VSYNC_POL_MINUS:
        case AG903_VID_MGR_IO_VSYNC_POL_PLUS:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* h_polɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (h_pol) {
        case AG903_VID_MGR_IO_HSYNC_POL_MINUS:
        case AG903_VID_MGR_IO_HSYNC_POL_PLUS:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* d_polɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (d_pol) {
        case AG903_VID_MGR_IN_DE_POL_MINUS:
        case AG903_VID_MGR_IN_DE_POL_PLUS:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* f_polɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (f_pol) {
        case AG903_VID_MGR_IN_FIELD_POL_MINUS:
        case AG903_VID_MGR_IN_FIELD_POL_PLUS:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* c_polɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (c_pol) {
        case AG903_VID_MGR_IN_CLK_POL_MINUS:
        case AG903_VID_MGR_IN_CLK_POL_PLUS:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^ێAdirtytOZbg܂ */
    handle->inout_vsync_pol = v_pol;
    handle->inout_hsync_pol = h_pol;
    handle->in_de_pol = d_pol;
    handle->in_field_pol = f_pol;
    handle->in_clk_pol = c_pol;
    handle->is_dirty = true;

    return AG903_ENONE;
}


/**
 * @brief         fW^rfI͂̃p[^ݒ
 * @param         h_pw [in] MpXw肵܂B
 * @param         h_fp [in] tg|[`w肵܂B
 * @param         h_bp [in] obN|[`w肵܂B
 * @param         h_fs [in] t[TCYw肵܂B
 * @param         v_pw [in] MpXw肵܂B
 * @param         v_fp [in] tg|[`w肵܂B
 * @param         v_bp [in] obN|[`w肵܂B
 * @param         v_fs [in] t[TCYw肵܂B 
 * @return        p[^ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfI̓nhw肳ꂽꍇ
 * @retval        -AG903_EINVAL h_pw/h_fp/h_bp/h_fsl/v_pw/v_fp/v_bp/v_fslɕsȒlw肳ꂽꍇ
 * @description   M̏o̓p[^ݒ肵܂B<p> 
 *                <table>
 *                <tr><th>ݒp[^</th><th>L͈</th></tr>
 *                <tr><td>h_pw</td><td>1 ~ AG903_VID_MGR_MAX_OUT_HORIZONTAL_PULSE_WIDTH</td></tr>
 *  							<tr><td>h_fp</td><td>1 ~ AG903_VID_MGR_MAX_OUT_HORIZONTAL_FRONT_PORCH</td></tr>
 *  							<tr><td>h_bp</td><td>1 ~ AG903_VID_MGR_MAX_OUT_HORIZONTAL_BACK_PORCH</td></tr>
 *  							<tr><td>h_fsl</td><td>1 ~ AG903_VID_MGR_MAX_OUT_HORIZONTAL_FRAME_SIZE</td></tr>
 *  							<tr><td>v_pw</td><td>1 ~ AG903_VID_MGR_MAX_OUT_VERTICAL_PULSE_WIDTH</td></tr>
 *  							<tr><td>v_fp</td><td>1 ~ AG903_VID_MGR_MAX_OUT_VERTICAL_FRONT_PORCH</td></tr>
 *  							<tr><td>v_bp</td><td>1 ~ AG903_VID_MGR_MAX_OUT_VERTICAL_BACK_PORCH</td></tr>
 *  							<tr><td>v_fsl</td><td>1 ~ AG903_VID_MGR_MAX_OUT_VERTICAL_FRAME_SIZE</td></tr>
 *  							</table>
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrSetIOParameter(AG903_VidMgrInputHandle *handle, uint32_t h_pw, uint32_t h_fp, uint32_t h_bp, uint32_t h_fs, uint32_t v_pw, uint32_t v_fp, uint32_t v_bp, uint32_t v_fs)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* h_pwɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (h_pw == 0 || h_pw > AG903_VID_MGR_MAX_OUT_HORIZONTAL_PULSE_WIDTH) {
        return -AG903_EINVAL;
    }
    /* h_fpɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (h_fp == 0 || h_fp > AG903_VID_MGR_MAX_OUT_HORIZONTAL_FRONT_PORCH) {
        return -AG903_EINVAL;
    }
    /* h_bpɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (h_bp == 0 || h_bp > AG903_VID_MGR_MAX_OUT_HORIZONTAL_BACK_PORCH) {
        return -AG903_EINVAL;
    }
    /* h_fsɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (h_fs == 0 || h_fs > AG903_VID_MGR_MAX_OUT_HORIZONTAL_FRAME_SIZE) {
        return -AG903_EINVAL;
    }
    /* v_pwɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (v_pw == 0 || v_pw > AG903_VID_MGR_MAX_OUT_VERTICAL_PULSE_WIDTH) {
        return -AG903_EINVAL;
    }
    /* v_pwɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (v_fp == 0 || v_fp > AG903_VID_MGR_MAX_OUT_VERTICAL_FRONT_PORCH) {
        return -AG903_EINVAL;
    }
    /* v_bpɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (v_bp == 0 || v_bp > AG903_VID_MGR_MAX_OUT_VERTICAL_BACK_PORCH) {
        return -AG903_EINVAL;
    }
    /* v_fsɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (v_fs == 0 || v_fs > AG903_VID_MGR_MAX_OUT_VERTICAL_FRAME_SIZE) {
        return -AG903_EINVAL;
    }

    /* p[^ێAdirtytOZbg܂ */
    handle->h_pulse_width = h_pw;
    handle->h_front_porch = h_fp;
    handle->h_back_porch = h_bp;
    handle->h_frame_size = h_fs;
    handle->v_pulse_width = v_pw;
    handle->v_front_porch = v_fp;
    handle->v_back_porch = v_bp;
    handle->v_frame_size = v_fs;
    handle->is_dirty = true;

    return AG903_ENONE;
}


/**
 * @brief         fW^rfI͂̃hbgNbNXe[^X擾 
 * @param         handle [in] fW^rfI̓nhB
 * @param         cwt [out] hbgNbÑXe[^Xi[|C^w肵܂B 
 * @return        Xe[^X擾 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfI̓nhw肳ꂽꍇ 
 * @description   hbgNbÑXe[^X擾܂B<p> 
 *  							擾f[^ cwt Ɋi[܂B<p>
 *  							cwt==NULL ̏ꍇ͉܂B
*/
int32_t AG903_VidMgrGetIODotClk(AG903_VidMgrInputHandle *handle, uint32_t *cwt)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_INPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* Primitive Layer̊֐gpĎ擾܂ */
    if (cwt != NULL) {
        AG903_VidPrmGetVIDIOnSTAT(handle->port_no, cwt);
    }

    return AG903_ENONE;
}


/**
 * @brief         fW^rfIo̓`l[h4bitTDMݒ
 * @param         handle [in] fW^rfI̓nhB
 * @param         tdm [in] o̓`lTDM[hw肵܂B 
 * @return        ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfIo̓nhw肳ꂽꍇ<p>tdmɕsȒlw肳ꂽꍇ 
 * @description   Lv`o̓`l샂[h 4bit TDM ݒ肵܂B<p> 
 *                [hݒ́uVIDTDM[hvQƂĂB 
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrSetCaptureTDMMode(AG903_VidMgrOutputHandle *handle, uint32_t tdm)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_OUTPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* tdmɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (tdm) {
        case AG903_VID_MGR_TDM_NONE:
        case AG903_VID_MGR_TDM_FIT_BLANK_SIGNAL:
        case AG903_VID_MGR_TDM_FIT_TRS_SIGNAL:
            break;
        default:
            return -AG903_EINVAL;
    }

    /* p[^ێAdirtytOZbg܂ */
    handle->tdm = tdm;
    handle->is_dirty = true;

    return AG903_ENONE;
}


/**
 * @brief         ̓f[^x̗L/ݒ
 * @param         handle [in] fW^rfI̓nhB
 * @param         delay [in] xݒ̗Lw肵܂B 
 * @return        ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfIo̓nhw肳ꂽꍇ 
 * @description   ̓f[^x̗L/ݒ肵܂B 
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrEnableCaptureDelay(AG903_VidMgrOutputHandle *handle, _Bool delay)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_OUTPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* p[^ێAdirtytOZbg܂ */
    handle->delay = delay;
    handle->is_dirty = true;

    return AG903_ENONE;
}


/**
 * @brief         TRS fR[h̗L/ݒ
 * @param         handle [in] fW^rfI̓nhB
 * @param         trs_dec [in] TRS fR[h̗L/w肵܂B 
 * @return        ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfIo̓nhw肳ꂽꍇ 
 * @description   o̓|[g TRS fR[h̗L/ݒ肵܂B 
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrEnableTRSDecode(AG903_VidMgrOutputHandle *handle, _Bool trs_dec)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_OUTPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* p[^ێAdirtytOZbg܂ */
    handle->trs_dec_enable = trs_dec;
    handle->is_dirty = true;

    return AG903_ENONE;
}


/**
 * @brief         o̓|[g TRS fR[h̃p[^ݒ
 * @param         handle [in] fW^rfI̓nhB
 * @param         efp [in] C^[X[hEVENt[VPF̒w肵܂B
 * @param         ofp [in] C^[X[hODDt[VPF̒w肵܂B
 * @param         vfp [in] uNԊJnSAV/EAVVSYNCオFIELDlf܂ł̃TCNw肵܂B
 * @param         href [in] HSYNC̊w肵܂B
 * @param         hfp [in] SAV/EAVHSYNCオ܂ł̃TCNw肵܂B
 * @return        ݒ茋
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handle/efp/ofp/vfp/href/hfpɕsȃfW^rfIo̓nhw肳ꂽꍇ
 * @description   o̓|[g TRS@fR[h̃p[^ݒ肵܂B<p> 
 *                w\Ȓl͈̔͂ɂẮAȉQƂĂB<p> 
 *                <table>
 *                <tr><th>ݒp[^</th><th>L͈</th></tr>
 *                <tr><td>efp</td><td>VIDEvenFrame</td></tr>
 *  							<tr><td>ofp</td><td>VIDOddFrame</td></tr>
 *  							<tr><td>vfp</td><td>1 ~ AG903_VID_MGR_MAX_TRS_VFP</td></tr>
 *  							<tr><td>href</td><td>VIDHReference</td></tr>
 *  							<tr><td>hfp</td><td>1 ~ AG903_VID_MGR_MAX_TRS_HFP</td></tr>
 *  							</table>
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B<P>
 *                8rbg͂̏ꍇAhfpւ̊ݒ͋֎~łB
*/
int32_t AG903_VidMgrSetTRSParameter(AG903_VidMgrOutputHandle *handle, uint32_t efp, uint32_t ofp, uint32_t vfp, uint32_t href, uint32_t hfp)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_OUTPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* efɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (efp) {
        case AG903_VID_MGR_TRS_EFP_ZERO:
        case AG903_VID_MGR_TRS_EFP_ONE:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* ofɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (ofp) {
        case AG903_VID_MGR_TRS_OFP_ZERO:
        case AG903_VID_MGR_TRS_OFP_ONE:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* vfpɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (vfp == 0 || vfp > AG903_VID_MGR_MAX_TRS_VFP) {
        return -AG903_EINVAL;
    }
    /* hrefɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    switch (href) {
        case AG903_VID_MGR_TRS_HREF_EAV:
        case AG903_VID_MGR_TRS_HREF_SAV:
            break;
        default:
            return -AG903_EINVAL;
    }
    /* hfpɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (hfp > AG903_VID_MGR_MAX_TRS_HFP) {
        return -AG903_EINVAL;
    }

    /* p[^ێAdirtytOZbg܂ */
    handle->trs_efp = efp;
    handle->trs_ofp = ofp;
    handle->trs_vfp = vfp;
    handle->trs_href = href;
    handle->trs_hfp = hfp;
    handle->is_dirty = true;

    return AG903_ENONE;
}


/**
 * @brief         o̓|[g̓Mop[^ݒ
 * @param         handle [in] fW^rfI̓nhB
 * @param         v_max [in] ̍őTCNw肵܂B
 * @param         h_max [in] ̍őTCNw肵܂B 
 * @return        ݒ茋 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handle/v_max/h_maxɕsȃfW^rfIo̓nhw肳ꂽꍇ
 * @description   o̓|[g̓Mop[^ݒ肵܂B<p> 
 *                w\Ȓl͈̔͂ɂẮAȉQƂĂB<p> 
 *                <table>
 *                <tr><th>ݒp[^</th><th>L͈</th></tr>
 *  							<tr><td>v_max</td><td>1 ~ AG903_VID_MGR_MAX_SD_VERTICAL_CYCLE</td></tr>
 *  							<tr><td>h_max</td><td>1 ~ AG903_VID_MGR_MAX_SD_HORIZONTAL_CYCLE</td></tr>
 *  							</table>
 * @note          {֐R[_ł̓n[hEFAANZX͍s킸Af[^Ƃĕێ܂B
*/
int32_t AG903_VidMgrSetDetectionCycle(AG903_VidMgrOutputHandle *handle, uint32_t v_max, uint32_t h_max)
{
    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_OUTPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* v_maxɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (v_max == 0 || v_max > AG903_VID_MGR_MAX_SD_VERTICAL_CYCLE) {
        return -AG903_EINVAL;
    }
    /* h_maxɕsȒlw肳ꂽꍇ̓G[Ƃ܂ */
    if (h_max == 0 || h_max > AG903_VID_MGR_MAX_SD_HORIZONTAL_CYCLE) {
        return -AG903_EINVAL;
    }

    /* p[^ێAdirtytOZbg܂ */
    handle->v_max = v_max;
    handle->h_max = h_max;
    handle->is_dirty = true;

    return AG903_ENONE;
}


/**
 * @brief         o̓|[g̊eXe[^X擾 
 * @param         handle [in] fW^rfI̓nhB
 * @param         blk_val [out] o̓`lEAṼuNMi[|C^w肵܂B
 * @param         trs_val [out] o̓`lTRS4byteڂi[|C^w肵܂B
 * @param         v_blank [out] M͏Ԃi[|C^w肵܂B
 * @param         h_blank [out] M͏Ԃi[|C^w肵܂B
 * @param         tdm_ch [out] 4chTDM͂Ń`lݒ̌ʂi[|C^w肵܂B 
 * @return        擾 
 * @retval        AG903_ENONE I
 * @retval        -AG903_EINVAL handleɕsȃfW^rfIo̓nhw肳ꂽ 
 * @description   o̓|[g̊eXe[^X擾܂B<p> 
 *  							Xe[^X͊ẽ|C^Ɋi[܂B<p>
 *  							NULL ̏ꍇ͊i[܂B
*/
int32_t AG903_VidMgrGetOutputState(AG903_VidMgrOutputHandle *handle, uint32_t *blk_val, uint32_t *trs_val, uint32_t *v_blank, uint32_t *h_blank, uint32_t *tdm_ch)
{
    VIDPrmParamVIDCOnSTAT stat;

    /* nhIDsȏꍇ͖ȃnhƂď܂ */
    if ((handle == NULL) || (handle->id != AG903_VID_MGR_OUTPUT_HANDLE_ID)) {
        return -AG903_EINVAL;
    }

    /* Primitive Layer̊֐gpĎ擾܂ */
    AG903_VidPrmGetVIDCOnSTAT(handle->port_no, &stat);

    /* NULLȊÖɒli[܂ */
    if (blk_val != NULL) {
        *blk_val = stat.blkval;
    }
    if (trs_val != NULL) {
        *trs_val = stat.trsval;
    }
    if (v_blank != NULL) {
        *v_blank = stat.vblank;
    }
    if (h_blank != NULL) {
        *h_blank = stat.hblank;
    }
    if (tdm_ch != NULL) {
        *tdm_ch = stat.tdmch;
    }

    return AG903_ENONE;
}


