/**
 * @brief           ETH Register Definition
 * @author          AXELL CORPORATION
 * @description     ETH Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_ETH_REGMAP_H_
#define _AG903_ETH_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** ETH Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint32_t  ISR;

        struct {
            __I  uint32_t  RPKT_FINISH                    :  1;
            __I  uint32_t  NORXBUF                        :  1;
            __I  uint32_t  XPKT_FINISH                    :  1;
            __I  uint32_t  NOTXBUF                        :  1;
            __I  uint32_t  XPKT_OK                        :  1;
            __I  uint32_t  XPKT_LOST                      :  1;
            __I  uint32_t  RPKT_SAV                       :  1;
            __I  uint32_t  RPKT_LOST                      :  1;
            __I  uint32_t  AHB_ERR                        :  1;
            __I  uint32_t  PHYSTS_CHG                     :  1;
            __I  uint32_t  TX_LPI_EXIT                    :  1;
            __I  uint32_t  TX_LPI_IN                      :  1;
            __I  uint32_t  RX_LPI_EXIT                    :  1;
            __I  uint32_t  RX_LPI_IN                      :  1;
        } ISR_bits;
    };

    union {
        __IO uint32_t  IME;

        struct {
            __IO uint32_t  RPKT_FINISH_EN                 :  1;
            __IO uint32_t  NORXBUF_EN                     :  1;
            __IO uint32_t  XPKT_FINISH_EN                 :  1;
            __IO uint32_t  NOTXBUF_EN                     :  1;
            __IO uint32_t  XPKT_OK_EN                     :  1;
            __IO uint32_t  XPKT_LOST_EN                   :  1;
            __IO uint32_t  RPKT_SAV_EN                    :  1;
            __IO uint32_t  RPKT_LOST_EN                   :  1;
            __IO uint32_t  AHB_ERR_EN                     :  1;
            __IO uint32_t  PHYSTS_CHG_EN                  :  1;
            __IO uint32_t  TX_LPI_EXIT_EN                 :  1;
            __IO uint32_t  TX_LPI_IN_EN                   :  1;
            __IO uint32_t  RX_LPI_EXIT_EN                 :  1;
            __IO uint32_t  RX_LPI_IN_EN                   :  1;
        } IME_bits;
    };

    union {
        __IO uint32_t  MAC_MADR;

        struct {
            __IO uint32_t  MAC_MADR                       : 16;
        } MAC_MADR_bits;
    };

    union {
        __IO uint32_t  MAC_LADR;
    };

    union {
        __IO uint32_t  MAHT0;
    };

    union {
        __IO uint32_t  MAHT1;
    };

    union {
        __O  uint32_t  TXPD;
    };

    union {
        __O  uint32_t  RXPD;
    };

    union {
        __IO uint32_t  TXR_BADR;
    };

    union {
        __IO uint32_t  RXR_BADR;
    };

    union {
        __IO uint32_t  ITC;

        struct {
            __IO uint32_t  RXINT_CNT                      :  4;
            __IO uint32_t  RXINT_THR                      :  3;
            __IO uint32_t  RXINT_TIME_SEL                 :  1;
            __IO uint32_t  TXINT_CNT                      :  4;
            __IO uint32_t  TXINT_THR                      :  3;
            __IO uint32_t  TXINT_TIME_SEL                 :  1;
        } ITC_bits;
    };

    union {
        __IO uint32_t  APTC;

        struct {
            __IO uint32_t  RXPOLL_CNT                     :  4;
            __IO uint32_t  RXPOLL_TIME_SEL                :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  TXPOLL_CNT                     :  4;
            __IO uint32_t  TXPOLL_TIME_SEL                :  1;
        } APTC_bits;
    };

    union {
        __IO uint32_t  DBLAC;

        struct {
                 uint32_t                                 :  3;
            __IO uint32_t  RXFIFO_LTHR                    :  3;
            __IO uint32_t  RXFIFO_HTHR                    :  3;
            __IO uint32_t  RX_THR_EN                      :  1;
                 uint32_t                                 :  4;
            __IO uint32_t  INCR_SEL                       :  2;
        } DBLAC_bits;
    };

    union {
        __I  uint32_t  REVR;

        struct {
            __I  uint32_t  REV_B3                         :  8;
            __I  uint32_t  REV_B2                         :  8;
            __I  uint32_t  REV_B1                         :  8;
        } REVR_bits;
    };

    __I  uint32_t  RESERVED1[19];

    union {
        __IO uint32_t  LPICR;

        struct {
            __IO uint32_t  WAKE_CNT                       : 16;
            __IO uint32_t  IDLE_CNT                       :  8;
            __IO uint32_t  TX_LPI_EN                      :  1;
            __IO uint32_t  RX_LPI_EN                      :  1;
        } LPICR_bits;
    };

    union {
        __IO uint32_t  MACCR;

        struct {
            __IO uint32_t  XDMA_EN                        :  1;
            __IO uint32_t  RDMA_EN                        :  1;
            __IO uint32_t  SW_RST                         :  1;
            __IO uint32_t  LOOP_EN                        :  1;
            __IO uint32_t  CRC_DIS                        :  1;
            __IO uint32_t  XMT_EN                         :  1;
            __IO uint32_t  ENRX_IN_HALFTX                 :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  RCV_EN                         :  1;
            __IO uint32_t  HT_MULTI_EN                    :  1;
            __IO uint32_t  RX_RUNT                        :  1;
            __IO uint32_t  RX_FTL                         :  1;
            __IO uint32_t  RCV_ALL                        :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  CRC_APD                        :  1;
            __IO uint32_t  FULLDUP                        :  1;
            __IO uint32_t  RX_MULTIPKT                    :  1;
            __IO uint32_t  RX_BROADPKT                    :  1;
            __IO uint32_t  SPEED_100                      :  1;
            __IO uint32_t  ZEROCOPY_DIS                   :  1;
        } MACCR_bits;
    };

    union {
        __I  uint32_t  MACSR;

        struct {
            __I  uint32_t  MULTICAST                      :  1;
            __I  uint32_t  BROADCAST                      :  1;
            __I  uint32_t  COL                            :  1;
            __I  uint32_t  RPKT_SAVE                      :  1;
            __I  uint32_t  RPKT_LOST                      :  1;
            __I  uint32_t  CRC_ERR                        :  1;
            __I  uint32_t  FTL                            :  1;
            __I  uint32_t  RUNT                           :  1;
            __I  uint32_t  XPKT_OK                        :  1;
            __I  uint32_t  XPKT_LOST                      :  1;
            __I  uint32_t  LATE_COL                       :  1;
            __I  uint32_t  COL_EXCEED                     :  1;
        } MACSR_bits;
    };

    union {
        __IO uint32_t  PHYCR;

        struct {
            __I  uint32_t  MIIRDATA                       : 16;
            __IO uint32_t  PHYAD                          :  5;
            __IO uint32_t  REGAD                          :  5;
            __IO uint32_t  MIIRD                          :  1;
            __IO uint32_t  MIIWR                          :  1;
        } PHYCR_bits;
    };

    union {
        __IO uint32_t  PHYWDATA;

        struct {
            __IO uint32_t  MIIWDATA                       : 16;
            __IO uint32_t  MDC_CYCTHR                     :  8;
        } PHYWDATA_bits;
    };

    union {
        __IO uint32_t  FCR;

        struct {
            __IO uint32_t  FC_EN                          :  1;
            __IO uint32_t  TX_PAUSE                       :  1;
            __IO uint32_t  FCTHR_EN                       :  1;
            __I  uint32_t  TXPAUSED                       :  1;
            __I  uint32_t  RX_PAUSE                       :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  FC_LOW                         :  4;
            __IO uint32_t  FC_HIGH                        :  4;
            __IO uint32_t  PAUSE_TIME                     : 16;
        } FCR_bits;
    };

    union {
        __IO uint32_t  BPR;

        struct {
            __IO uint32_t  BK_EN                          :  1;
            __IO uint32_t  BK_MODE                        :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  BKJAM_LEN                      :  4;
            __IO uint32_t  BK_LOW                         :  4;
        } BPR_bits;
    };

    union {
        __IO uint32_t  WOLCR;

        struct {
            __IO uint32_t  LINKCHG0_EN                    :  1;
            __IO uint32_t  LINKCHG1_EN                    :  1;
            __IO uint32_t  MAGICPKT_EN                    :  1;
            __IO uint32_t  WAKEUP1_EN                     :  1;
            __IO uint32_t  WAKEUP2_EN                     :  1;
            __IO uint32_t  WAKEUP3_EN                     :  1;
            __IO uint32_t  WAKEUP4_EN                     :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  POWER_STATE                    :  2;
            __IO uint32_t  WAKEUP_SEL                     :  2;
            __IO uint32_t  SW_PDNPHY                      :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  WOL_TYPE                       :  2;
        } WOLCR_bits;
    };

    union {
        __IO uint32_t  WOLSR;

        struct {
            __IO uint32_t  LINKCHG0_STS                   :  1;
            __IO uint32_t  LINKCHG1_STS                   :  1;
            __IO uint32_t  MAGICPKT_STS                   :  1;
            __IO uint32_t  WAKEUP1_STS                    :  1;
            __IO uint32_t  WAKEUP2_STS                    :  1;
            __IO uint32_t  WAKEUP3_STS                    :  1;
            __IO uint32_t  WAKEUP4_STS                    :  1;
        } WOLSR_bits;
    };

    union {
        __IO uint32_t  WFCRC;
    };

    __I  uint32_t  RESERVED2[1];

    union {
        __IO uint32_t  WFBM1;
    };

    union {
        __IO uint32_t  WFBM2;
    };

    union {
        __IO uint32_t  WFBM3;
    };

    union {
        __IO uint32_t  WFBM4;
    };

    __I  uint32_t  RESERVED3[1];

    union {
        __IO uint32_t  TS;

        struct {
            __IO uint32_t  Test_seed                      : 14;
        } TS_bits;
    };

    union {
        __I  uint32_t  DMAFIFOS;

        struct {
            __I  uint32_t  RXDMA1_SM                      :  4;
            __I  uint32_t  RXDMA2_SM                      :  3;
                 uint32_t                                 :  1;
            __I  uint32_t  TXDMA1_SM                      :  4;
            __I  uint32_t  TXDMA2_SM                      :  3;
                 uint32_t                                 : 11;
            __I  uint32_t  RXFIFO_EMPTY                   :  1;
            __I  uint32_t  TXFIFO_EMPTY                   :  1;
            __I  uint32_t  DARB_RXGNT                     :  1;
            __I  uint32_t  DARB_TXGNT                     :  1;
            __I  uint32_t  RXD_REQ                        :  1;
            __I  uint32_t  TXD_REQ                        :  1;
        } DMAFIFOS_bits;
    };

    union {
        __IO uint32_t  TM;

        struct {
                 uint32_t                                 :  5;
            __IO uint32_t  TEST_EXCEL                     :  5;
            __IO uint32_t  TEST_TIME                      : 10;
            __IO uint32_t  TEST_MODE                      :  1;
            __IO uint32_t  SEED_SEL                       :  1;
            __IO uint32_t  TEST_SEED_SEL                  :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  ITIMER_TEST                    :  1;
            __IO uint32_t  PTIMER_TEST                    :  1;
            __IO uint32_t  SINGLE_PKT                     :  1;
            __IO uint32_t  DMA_SWAP                       :  1;
            __IO uint32_t  PKT_SWAP_B                     :  1;
            __IO uint32_t  BIG_FORM                       :  1;
        } TM_bits;
    };

    __I  uint32_t  RESERVED4[1];

    union {
        __I  uint32_t  COLCR;

        struct {
            __I  uint32_t  TX_SCOL                        : 16;
            __I  uint32_t  TX_MCOL                        : 16;
        } COLCR_bits;
    };

    union {
        __I  uint32_t  REFAEPCR;

        struct {
            __I  uint32_t  AEP                            : 16;
            __I  uint32_t  RPF                            : 16;
        } REFAEPCR_bits;
    };

    union {
        __I  uint32_t  XMPGCR;

        struct {
            __I  uint32_t  PG                             : 16;
            __I  uint32_t  XM                             : 16;
        } XMPGCR_bits;
    };

    union {
        __I  uint32_t  RUNTLCCCR;

        struct {
            __I  uint32_t  TLCC                           : 16;
            __I  uint32_t  RUNT_CNT                       : 16;
        } RUNTLCCCR_bits;
    };

    union {
        __I  uint32_t  CRCERFTLCR;

        struct {
            __I  uint32_t  FTL_CNT                        : 16;
            __I  uint32_t  CRCER_CNT                      : 16;
        } CRCERFTLCR_bits;
    };

    union {
        __I  uint32_t  RLCRCCCR;

        struct {
            __I  uint32_t  RCC                            : 16;
            __I  uint32_t  RLC                            : 16;
        } RLCRCCCR_bits;
    };

    union {
        __I  uint32_t  BROCCR;
    };

    union {
        __I  uint32_t  MULCACR;
    };

    union {
        __I  uint32_t  RPCR;
    };

    union {
        __I  uint32_t  XPCR;
    };

/* DOM-IGNORE-END */
}AG903_ETH_Type;

#define AG903_ETH                                ((volatile AG903_ETH_Type *) AG903_ETH_BASE)                            /** ETH Base Address */


#define AG903_ETH_ISR_RPKT_FINISH_POS                      0                                                             /** ETHISR RPKT_FINISH-bit position */
#define AG903_ETH_ISR_RPKT_FINISH_MSK                      (0x1UL << AG903_ETH_ISR_RPKT_FINISH_POS)                      /** ETHISR RPKT_FINISH-bit mask */
#define AG903_ETH_ISR_NORXBUF_POS                          1                                                             /** ETHISR NORXBUF-bit position */
#define AG903_ETH_ISR_NORXBUF_MSK                          (0x1UL << AG903_ETH_ISR_NORXBUF_POS)                          /** ETHISR NORXBUF-bit mask */
#define AG903_ETH_ISR_XPKT_FINISH_POS                      2                                                             /** ETHISR XPKT_FINISH-bit position */
#define AG903_ETH_ISR_XPKT_FINISH_MSK                      (0x1UL << AG903_ETH_ISR_XPKT_FINISH_POS)                      /** ETHISR XPKT_FINISH-bit mask */
#define AG903_ETH_ISR_NOTXBUF_POS                          3                                                             /** ETHISR NOTXBUF-bit position */
#define AG903_ETH_ISR_NOTXBUF_MSK                          (0x1UL << AG903_ETH_ISR_NOTXBUF_POS)                          /** ETHISR NOTXBUF-bit mask */
#define AG903_ETH_ISR_XPKT_OK_POS                          4                                                             /** ETHISR XPKT_OK-bit position */
#define AG903_ETH_ISR_XPKT_OK_MSK                          (0x1UL << AG903_ETH_ISR_XPKT_OK_POS)                          /** ETHISR XPKT_OK-bit mask */
#define AG903_ETH_ISR_XPKT_LOST_POS                        5                                                             /** ETHISR XPKT_LOST-bit position */
#define AG903_ETH_ISR_XPKT_LOST_MSK                        (0x1UL << AG903_ETH_ISR_XPKT_LOST_POS)                        /** ETHISR XPKT_LOST-bit mask */
#define AG903_ETH_ISR_RPKT_SAV_POS                         6                                                             /** ETHISR RPKT_SAV-bit position */
#define AG903_ETH_ISR_RPKT_SAV_MSK                         (0x1UL << AG903_ETH_ISR_RPKT_SAV_POS)                         /** ETHISR RPKT_SAV-bit mask */
#define AG903_ETH_ISR_RPKT_LOST_POS                        7                                                             /** ETHISR RPKT_LOST-bit position */
#define AG903_ETH_ISR_RPKT_LOST_MSK                        (0x1UL << AG903_ETH_ISR_RPKT_LOST_POS)                        /** ETHISR RPKT_LOST-bit mask */
#define AG903_ETH_ISR_AHB_ERR_POS                          8                                                             /** ETHISR AHB_ERR-bit position */
#define AG903_ETH_ISR_AHB_ERR_MSK                          (0x1UL << AG903_ETH_ISR_AHB_ERR_POS)                          /** ETHISR AHB_ERR-bit mask */
#define AG903_ETH_ISR_PHYSTS_CHG_POS                       9                                                             /** ETHISR PHYSTS_CHG-bit position */
#define AG903_ETH_ISR_PHYSTS_CHG_MSK                       (0x1UL << AG903_ETH_ISR_PHYSTS_CHG_POS)                       /** ETHISR PHYSTS_CHG-bit mask */
#define AG903_ETH_ISR_TX_LPI_EXIT_POS                      10                                                            /** ETHISR TX_LPI_EXIT-bit position */
#define AG903_ETH_ISR_TX_LPI_EXIT_MSK                      (0x1UL << AG903_ETH_ISR_TX_LPI_EXIT_POS)                      /** ETHISR TX_LPI_EXIT-bit mask */
#define AG903_ETH_ISR_TX_LPI_IN_POS                        11                                                            /** ETHISR TX_LPI_IN-bit position */
#define AG903_ETH_ISR_TX_LPI_IN_MSK                        (0x1UL << AG903_ETH_ISR_TX_LPI_IN_POS)                        /** ETHISR TX_LPI_IN-bit mask */
#define AG903_ETH_ISR_RX_LPI_EXIT_POS                      12                                                            /** ETHISR RX_LPI_EXIT-bit position */
#define AG903_ETH_ISR_RX_LPI_EXIT_MSK                      (0x1UL << AG903_ETH_ISR_RX_LPI_EXIT_POS)                      /** ETHISR RX_LPI_EXIT-bit mask */
#define AG903_ETH_ISR_RX_LPI_IN_POS                        13                                                            /** ETHISR RX_LPI_IN-bit position */
#define AG903_ETH_ISR_RX_LPI_IN_MSK                        (0x1UL << AG903_ETH_ISR_RX_LPI_IN_POS)                        /** ETHISR RX_LPI_IN-bit mask */

#define AG903_ETH_IME_RPKT_FINISH_EN_POS                   0                                                             /** ETHIME RPKT_FINISH_EN-bit position */
#define AG903_ETH_IME_RPKT_FINISH_EN_MSK                   (0x1UL << AG903_ETH_IME_RPKT_FINISH_EN_POS)                   /** ETHIME RPKT_FINISH_EN-bit mask */
#define AG903_ETH_IME_NORXBUF_EN_POS                       1                                                             /** ETHIME NORXBUF_EN-bit position */
#define AG903_ETH_IME_NORXBUF_EN_MSK                       (0x1UL << AG903_ETH_IME_NORXBUF_EN_POS)                       /** ETHIME NORXBUF_EN-bit mask */
#define AG903_ETH_IME_XPKT_FINISH_EN_POS                   2                                                             /** ETHIME XPKT_FINISH_EN-bit position */
#define AG903_ETH_IME_XPKT_FINISH_EN_MSK                   (0x1UL << AG903_ETH_IME_XPKT_FINISH_EN_POS)                   /** ETHIME XPKT_FINISH_EN-bit mask */
#define AG903_ETH_IME_NOTXBUF_EN_POS                       3                                                             /** ETHIME NOTXBUF_EN-bit position */
#define AG903_ETH_IME_NOTXBUF_EN_MSK                       (0x1UL << AG903_ETH_IME_NOTXBUF_EN_POS)                       /** ETHIME NOTXBUF_EN-bit mask */
#define AG903_ETH_IME_XPKT_OK_EN_POS                       4                                                             /** ETHIME XPKT_OK_EN-bit position */
#define AG903_ETH_IME_XPKT_OK_EN_MSK                       (0x1UL << AG903_ETH_IME_XPKT_OK_EN_POS)                       /** ETHIME XPKT_OK_EN-bit mask */
#define AG903_ETH_IME_XPKT_LOST_EN_POS                     5                                                             /** ETHIME XPKT_LOST_EN-bit position */
#define AG903_ETH_IME_XPKT_LOST_EN_MSK                     (0x1UL << AG903_ETH_IME_XPKT_LOST_EN_POS)                     /** ETHIME XPKT_LOST_EN-bit mask */
#define AG903_ETH_IME_RPKT_SAV_EN_POS                      6                                                             /** ETHIME RPKT_SAV_EN-bit position */
#define AG903_ETH_IME_RPKT_SAV_EN_MSK                      (0x1UL << AG903_ETH_IME_RPKT_SAV_EN_POS)                      /** ETHIME RPKT_SAV_EN-bit mask */
#define AG903_ETH_IME_RPKT_LOST_EN_POS                     7                                                             /** ETHIME RPKT_LOST_EN-bit position */
#define AG903_ETH_IME_RPKT_LOST_EN_MSK                     (0x1UL << AG903_ETH_IME_RPKT_LOST_EN_POS)                     /** ETHIME RPKT_LOST_EN-bit mask */
#define AG903_ETH_IME_AHB_ERR_EN_POS                       8                                                             /** ETHIME AHB_ERR_EN-bit position */
#define AG903_ETH_IME_AHB_ERR_EN_MSK                       (0x1UL << AG903_ETH_IME_AHB_ERR_EN_POS)                       /** ETHIME AHB_ERR_EN-bit mask */
#define AG903_ETH_IME_PHYSTS_CHG_EN_POS                    9                                                             /** ETHIME PHYSTS_CHG_EN-bit position */
#define AG903_ETH_IME_PHYSTS_CHG_EN_MSK                    (0x1UL << AG903_ETH_IME_PHYSTS_CHG_EN_POS)                    /** ETHIME PHYSTS_CHG_EN-bit mask */
#define AG903_ETH_IME_TX_LPI_EXIT_EN_POS                   10                                                            /** ETHIME TX_LPI_EXIT_EN-bit position */
#define AG903_ETH_IME_TX_LPI_EXIT_EN_MSK                   (0x1UL << AG903_ETH_IME_TX_LPI_EXIT_EN_POS)                   /** ETHIME TX_LPI_EXIT_EN-bit mask */
#define AG903_ETH_IME_TX_LPI_IN_EN_POS                     11                                                            /** ETHIME TX_LPI_IN_EN-bit position */
#define AG903_ETH_IME_TX_LPI_IN_EN_MSK                     (0x1UL << AG903_ETH_IME_TX_LPI_IN_EN_POS)                     /** ETHIME TX_LPI_IN_EN-bit mask */
#define AG903_ETH_IME_RX_LPI_EXIT_EN_POS                   12                                                            /** ETHIME RX_LPI_EXIT_EN-bit position */
#define AG903_ETH_IME_RX_LPI_EXIT_EN_MSK                   (0x1UL << AG903_ETH_IME_RX_LPI_EXIT_EN_POS)                   /** ETHIME RX_LPI_EXIT_EN-bit mask */
#define AG903_ETH_IME_RX_LPI_IN_EN_POS                     13                                                            /** ETHIME RX_LPI_IN_EN-bit position */
#define AG903_ETH_IME_RX_LPI_IN_EN_MSK                     (0x1UL << AG903_ETH_IME_RX_LPI_IN_EN_POS)                     /** ETHIME RX_LPI_IN_EN-bit mask */

#define AG903_ETH_MAC_MADR_MAC_MADR_POS                    0                                                             /** ETHMAC_MADR MAC_MADR-bit position */
#define AG903_ETH_MAC_MADR_MAC_MADR_MSK                    (0xffffUL << AG903_ETH_MAC_MADR_MAC_MADR_POS)                 /** ETHMAC_MADR MAC_MADR-bit mask */

#define AG903_ETH_MAC_LADR_MAC_LADR_POS                    0                                                             /** ETHMAC_LADR MAC_LADR-bit position */
#define AG903_ETH_MAC_LADR_MAC_LADR_MSK                    (0xffffffffUL << AG903_ETH_MAC_LADR_MAC_LADR_POS)             /** ETHMAC_LADR MAC_LADR-bit mask */

#define AG903_ETH_MAHT0_MAHT0_POS                          0                                                             /** ETHMAHT0 MAHT0-bit position */
#define AG903_ETH_MAHT0_MAHT0_MSK                          (0xffffffffUL << AG903_ETH_MAHT0_MAHT0_POS)                   /** ETHMAHT0 MAHT0-bit mask */

#define AG903_ETH_MAHT1_MAHT1_POS                          0                                                             /** ETHMAHT1 MAHT1-bit position */
#define AG903_ETH_MAHT1_MAHT1_MSK                          (0xffffffffUL << AG903_ETH_MAHT1_MAHT1_POS)                   /** ETHMAHT1 MAHT1-bit mask */

#define AG903_ETH_TXPD_TXPD_POS                            0                                                             /** ETHTXPD TXPD-bit position */
#define AG903_ETH_TXPD_TXPD_MSK                            (0xffffffffUL << AG903_ETH_TXPD_TXPD_POS)                     /** ETHTXPD TXPD-bit mask */

#define AG903_ETH_RXPD_RXPD_POS                            0                                                             /** ETHRXPD RXPD-bit position */
#define AG903_ETH_RXPD_RXPD_MSK                            (0xffffffffUL << AG903_ETH_RXPD_RXPD_POS)                     /** ETHRXPD RXPD-bit mask */

#define AG903_ETH_TXR_BADR_TXR_BADR_POS                    0                                                             /** ETHTXR_BADR TXR_BADR-bit position */
#define AG903_ETH_TXR_BADR_TXR_BADR_MSK                    (0xffffffffUL << AG903_ETH_TXR_BADR_TXR_BADR_POS)             /** ETHTXR_BADR TXR_BADR-bit mask */

#define AG903_ETH_RXR_BADR_RXR_BADR_POS                    0                                                             /** ETHRXR_BADR RXR_BADR-bit position */
#define AG903_ETH_RXR_BADR_RXR_BADR_MSK                    (0xffffffffUL << AG903_ETH_RXR_BADR_RXR_BADR_POS)             /** ETHRXR_BADR RXR_BADR-bit mask */

#define AG903_ETH_ITC_RXINT_CNT_POS                        0                                                             /** ETHITC RXINT_CNT-bit position */
#define AG903_ETH_ITC_RXINT_CNT_MSK                        (0xfUL << AG903_ETH_ITC_RXINT_CNT_POS)                        /** ETHITC RXINT_CNT-bit mask */
#define AG903_ETH_ITC_RXINT_THR_POS                        4                                                             /** ETHITC RXINT_THR-bit position */
#define AG903_ETH_ITC_RXINT_THR_MSK                        (0x7UL << AG903_ETH_ITC_RXINT_THR_POS)                        /** ETHITC RXINT_THR-bit mask */
#define AG903_ETH_ITC_RXINT_TIME_SEL_POS                   7                                                             /** ETHITC RXINT_TIME_SEL-bit position */
#define AG903_ETH_ITC_RXINT_TIME_SEL_MSK                   (0x1UL << AG903_ETH_ITC_RXINT_TIME_SEL_POS)                   /** ETHITC RXINT_TIME_SEL-bit mask */
#define AG903_ETH_ITC_TXINT_CNT_POS                        8                                                             /** ETHITC TXINT_CNT-bit position */
#define AG903_ETH_ITC_TXINT_CNT_MSK                        (0xfUL << AG903_ETH_ITC_TXINT_CNT_POS)                        /** ETHITC TXINT_CNT-bit mask */
#define AG903_ETH_ITC_TXINT_THR_POS                        12                                                            /** ETHITC TXINT_THR-bit position */
#define AG903_ETH_ITC_TXINT_THR_MSK                        (0x7UL << AG903_ETH_ITC_TXINT_THR_POS)                        /** ETHITC TXINT_THR-bit mask */
#define AG903_ETH_ITC_TXINT_TIME_SEL_POS                   15                                                            /** ETHITC TXINT_TIME_SEL-bit position */
#define AG903_ETH_ITC_TXINT_TIME_SEL_MSK                   (0x1UL << AG903_ETH_ITC_TXINT_TIME_SEL_POS)                   /** ETHITC TXINT_TIME_SEL-bit mask */

#define AG903_ETH_APTC_RXPOLL_CNT_POS                      0                                                             /** ETHAPTC RXPOLL_CNT-bit position */
#define AG903_ETH_APTC_RXPOLL_CNT_MSK                      (0xfUL << AG903_ETH_APTC_RXPOLL_CNT_POS)                      /** ETHAPTC RXPOLL_CNT-bit mask */
#define AG903_ETH_APTC_RXPOLL_TIME_SEL_POS                 4                                                             /** ETHAPTC RXPOLL_TIME_SEL-bit position */
#define AG903_ETH_APTC_RXPOLL_TIME_SEL_MSK                 (0x1UL << AG903_ETH_APTC_RXPOLL_TIME_SEL_POS)                 /** ETHAPTC RXPOLL_TIME_SEL-bit mask */
#define AG903_ETH_APTC_TXPOLL_CNT_POS                      8                                                             /** ETHAPTC TXPOLL_CNT-bit position */
#define AG903_ETH_APTC_TXPOLL_CNT_MSK                      (0xfUL << AG903_ETH_APTC_TXPOLL_CNT_POS)                      /** ETHAPTC TXPOLL_CNT-bit mask */
#define AG903_ETH_APTC_TXPOLL_TIME_SEL_POS                 12                                                            /** ETHAPTC TXPOLL_TIME_SEL-bit position */
#define AG903_ETH_APTC_TXPOLL_TIME_SEL_MSK                 (0x1UL << AG903_ETH_APTC_TXPOLL_TIME_SEL_POS)                 /** ETHAPTC TXPOLL_TIME_SEL-bit mask */

#define AG903_ETH_DBLAC_RXFIFO_LTHR_POS                    3                                                             /** ETHDBLAC RXFIFO_LTHR-bit position */
#define AG903_ETH_DBLAC_RXFIFO_LTHR_MSK                    (0x7UL << AG903_ETH_DBLAC_RXFIFO_LTHR_POS)                    /** ETHDBLAC RXFIFO_LTHR-bit mask */
#define AG903_ETH_DBLAC_RXFIFO_HTHR_POS                    6                                                             /** ETHDBLAC RXFIFO_HTHR-bit position */
#define AG903_ETH_DBLAC_RXFIFO_HTHR_MSK                    (0x7UL << AG903_ETH_DBLAC_RXFIFO_HTHR_POS)                    /** ETHDBLAC RXFIFO_HTHR-bit mask */
#define AG903_ETH_DBLAC_RX_THR_EN_POS                      9                                                             /** ETHDBLAC RX_THR_EN-bit position */
#define AG903_ETH_DBLAC_RX_THR_EN_MSK                      (0x1UL << AG903_ETH_DBLAC_RX_THR_EN_POS)                      /** ETHDBLAC RX_THR_EN-bit mask */
#define AG903_ETH_DBLAC_INCR_SEL_POS                       14                                                            /** ETHDBLAC INCR_SEL-bit position */
#define AG903_ETH_DBLAC_INCR_SEL_MSK                       (0x3UL << AG903_ETH_DBLAC_INCR_SEL_POS)                       /** ETHDBLAC INCR_SEL-bit mask */

#define AG903_ETH_REVR_REV_B3_POS                          0                                                             /** ETHREVR REV_B3-bit position */
#define AG903_ETH_REVR_REV_B3_MSK                          (0xffUL << AG903_ETH_REVR_REV_B3_POS)                         /** ETHREVR REV_B3-bit mask */
#define AG903_ETH_REVR_REV_B2_POS                          8                                                             /** ETHREVR REV_B2-bit position */
#define AG903_ETH_REVR_REV_B2_MSK                          (0xffUL << AG903_ETH_REVR_REV_B2_POS)                         /** ETHREVR REV_B2-bit mask */
#define AG903_ETH_REVR_REV_B1_POS                          16                                                            /** ETHREVR REV_B1-bit position */
#define AG903_ETH_REVR_REV_B1_MSK                          (0xffUL << AG903_ETH_REVR_REV_B1_POS)                         /** ETHREVR REV_B1-bit mask */

#define AG903_ETH_LPICR_WAKE_CNT_POS                       0                                                             /** ETHLPICR WAKE_CNT-bit position */
#define AG903_ETH_LPICR_WAKE_CNT_MSK                       (0xffffUL << AG903_ETH_LPICR_WAKE_CNT_POS)                    /** ETHLPICR WAKE_CNT-bit mask */
#define AG903_ETH_LPICR_IDLE_CNT_POS                       16                                                            /** ETHLPICR IDLE_CNT-bit position */
#define AG903_ETH_LPICR_IDLE_CNT_MSK                       (0xffUL << AG903_ETH_LPICR_IDLE_CNT_POS)                      /** ETHLPICR IDLE_CNT-bit mask */
#define AG903_ETH_LPICR_TX_LPI_EN_POS                      24                                                            /** ETHLPICR TX_LPI_EN-bit position */
#define AG903_ETH_LPICR_TX_LPI_EN_MSK                      (0x1UL << AG903_ETH_LPICR_TX_LPI_EN_POS)                      /** ETHLPICR TX_LPI_EN-bit mask */
#define AG903_ETH_LPICR_RX_LPI_EN_POS                      25                                                            /** ETHLPICR RX_LPI_EN-bit position */
#define AG903_ETH_LPICR_RX_LPI_EN_MSK                      (0x1UL << AG903_ETH_LPICR_RX_LPI_EN_POS)                      /** ETHLPICR RX_LPI_EN-bit mask */

#define AG903_ETH_MACCR_XDMA_EN_POS                        0                                                             /** ETHMACCR XDMA_EN-bit position */
#define AG903_ETH_MACCR_XDMA_EN_MSK                        (0x1UL << AG903_ETH_MACCR_XDMA_EN_POS)                        /** ETHMACCR XDMA_EN-bit mask */
#define AG903_ETH_MACCR_RDMA_EN_POS                        1                                                             /** ETHMACCR RDMA_EN-bit position */
#define AG903_ETH_MACCR_RDMA_EN_MSK                        (0x1UL << AG903_ETH_MACCR_RDMA_EN_POS)                        /** ETHMACCR RDMA_EN-bit mask */
#define AG903_ETH_MACCR_SW_RST_POS                         2                                                             /** ETHMACCR SW_RST-bit position */
#define AG903_ETH_MACCR_SW_RST_MSK                         (0x1UL << AG903_ETH_MACCR_SW_RST_POS)                         /** ETHMACCR SW_RST-bit mask */
#define AG903_ETH_MACCR_LOOP_EN_POS                        3                                                             /** ETHMACCR LOOP_EN-bit position */
#define AG903_ETH_MACCR_LOOP_EN_MSK                        (0x1UL << AG903_ETH_MACCR_LOOP_EN_POS)                        /** ETHMACCR LOOP_EN-bit mask */
#define AG903_ETH_MACCR_CRC_DIS_POS                        4                                                             /** ETHMACCR CRC_DIS-bit position */
#define AG903_ETH_MACCR_CRC_DIS_MSK                        (0x1UL << AG903_ETH_MACCR_CRC_DIS_POS)                        /** ETHMACCR CRC_DIS-bit mask */
#define AG903_ETH_MACCR_XMT_EN_POS                         5                                                             /** ETHMACCR XMT_EN-bit position */
#define AG903_ETH_MACCR_XMT_EN_MSK                         (0x1UL << AG903_ETH_MACCR_XMT_EN_POS)                         /** ETHMACCR XMT_EN-bit mask */
#define AG903_ETH_MACCR_ENRX_IN_HALFTX_POS                 6                                                             /** ETHMACCR ENRX_IN_HALFTX-bit position */
#define AG903_ETH_MACCR_ENRX_IN_HALFTX_MSK                 (0x1UL << AG903_ETH_MACCR_ENRX_IN_HALFTX_POS)                 /** ETHMACCR ENRX_IN_HALFTX-bit mask */
#define AG903_ETH_MACCR_RCV_EN_POS                         8                                                             /** ETHMACCR RCV_EN-bit position */
#define AG903_ETH_MACCR_RCV_EN_MSK                         (0x1UL << AG903_ETH_MACCR_RCV_EN_POS)                         /** ETHMACCR RCV_EN-bit mask */
#define AG903_ETH_MACCR_HT_MULTI_EN_POS                    9                                                             /** ETHMACCR HT_MULTI_EN-bit position */
#define AG903_ETH_MACCR_HT_MULTI_EN_MSK                    (0x1UL << AG903_ETH_MACCR_HT_MULTI_EN_POS)                    /** ETHMACCR HT_MULTI_EN-bit mask */
#define AG903_ETH_MACCR_RX_RUNT_POS                        10                                                            /** ETHMACCR RX_RUNT-bit position */
#define AG903_ETH_MACCR_RX_RUNT_MSK                        (0x1UL << AG903_ETH_MACCR_RX_RUNT_POS)                        /** ETHMACCR RX_RUNT-bit mask */
#define AG903_ETH_MACCR_RX_FTL_POS                         11                                                            /** ETHMACCR RX_FTL-bit position */
#define AG903_ETH_MACCR_RX_FTL_MSK                         (0x1UL << AG903_ETH_MACCR_RX_FTL_POS)                         /** ETHMACCR RX_FTL-bit mask */
#define AG903_ETH_MACCR_RCV_ALL_POS                        12                                                            /** ETHMACCR RCV_ALL-bit position */
#define AG903_ETH_MACCR_RCV_ALL_MSK                        (0x1UL << AG903_ETH_MACCR_RCV_ALL_POS)                        /** ETHMACCR RCV_ALL-bit mask */
#define AG903_ETH_MACCR_CRC_APD_POS                        14                                                            /** ETHMACCR CRC_APD-bit position */
#define AG903_ETH_MACCR_CRC_APD_MSK                        (0x1UL << AG903_ETH_MACCR_CRC_APD_POS)                        /** ETHMACCR CRC_APD-bit mask */
#define AG903_ETH_MACCR_FULLDUP_POS                        15                                                            /** ETHMACCR FULLDUP-bit position */
#define AG903_ETH_MACCR_FULLDUP_MSK                        (0x1UL << AG903_ETH_MACCR_FULLDUP_POS)                        /** ETHMACCR FULLDUP-bit mask */
#define AG903_ETH_MACCR_RX_MULTIPKT_POS                    16                                                            /** ETHMACCR RX_MULTIPKT-bit position */
#define AG903_ETH_MACCR_RX_MULTIPKT_MSK                    (0x1UL << AG903_ETH_MACCR_RX_MULTIPKT_POS)                    /** ETHMACCR RX_MULTIPKT-bit mask */
#define AG903_ETH_MACCR_RX_BROADPKT_POS                    17                                                            /** ETHMACCR RX_BROADPKT-bit position */
#define AG903_ETH_MACCR_RX_BROADPKT_MSK                    (0x1UL << AG903_ETH_MACCR_RX_BROADPKT_POS)                    /** ETHMACCR RX_BROADPKT-bit mask */
#define AG903_ETH_MACCR_SPEED_100_POS                      18                                                            /** ETHMACCR SPEED_100-bit position */
#define AG903_ETH_MACCR_SPEED_100_MSK                      (0x1UL << AG903_ETH_MACCR_SPEED_100_POS)                      /** ETHMACCR SPEED_100-bit mask */
#define AG903_ETH_MACCR_ZEROCOPY_DIS_POS                   19                                                            /** ETHMACCR ZEROCOPY_DIS-bit position */
#define AG903_ETH_MACCR_ZEROCOPY_DIS_MSK                   (0x1UL << AG903_ETH_MACCR_ZEROCOPY_DIS_POS)                   /** ETHMACCR ZEROCOPY_DIS-bit mask */

#define AG903_ETH_MACSR_MULTICAST_POS                      0                                                             /** ETHMACSR MULTICAST-bit position */
#define AG903_ETH_MACSR_MULTICAST_MSK                      (0x1UL << AG903_ETH_MACSR_MULTICAST_POS)                      /** ETHMACSR MULTICAST-bit mask */
#define AG903_ETH_MACSR_BROADCAST_POS                      1                                                             /** ETHMACSR BROADCAST-bit position */
#define AG903_ETH_MACSR_BROADCAST_MSK                      (0x1UL << AG903_ETH_MACSR_BROADCAST_POS)                      /** ETHMACSR BROADCAST-bit mask */
#define AG903_ETH_MACSR_COL_POS                            2                                                             /** ETHMACSR COL-bit position */
#define AG903_ETH_MACSR_COL_MSK                            (0x1UL << AG903_ETH_MACSR_COL_POS)                            /** ETHMACSR COL-bit mask */
#define AG903_ETH_MACSR_RPKT_SAVE_POS                      3                                                             /** ETHMACSR RPKT_SAVE-bit position */
#define AG903_ETH_MACSR_RPKT_SAVE_MSK                      (0x1UL << AG903_ETH_MACSR_RPKT_SAVE_POS)                      /** ETHMACSR RPKT_SAVE-bit mask */
#define AG903_ETH_MACSR_RPKT_LOST_POS                      4                                                             /** ETHMACSR RPKT_LOST-bit position */
#define AG903_ETH_MACSR_RPKT_LOST_MSK                      (0x1UL << AG903_ETH_MACSR_RPKT_LOST_POS)                      /** ETHMACSR RPKT_LOST-bit mask */
#define AG903_ETH_MACSR_CRC_ERR_POS                        5                                                             /** ETHMACSR CRC_ERR-bit position */
#define AG903_ETH_MACSR_CRC_ERR_MSK                        (0x1UL << AG903_ETH_MACSR_CRC_ERR_POS)                        /** ETHMACSR CRC_ERR-bit mask */
#define AG903_ETH_MACSR_FTL_POS                            6                                                             /** ETHMACSR FTL-bit position */
#define AG903_ETH_MACSR_FTL_MSK                            (0x1UL << AG903_ETH_MACSR_FTL_POS)                            /** ETHMACSR FTL-bit mask */
#define AG903_ETH_MACSR_RUNT_POS                           7                                                             /** ETHMACSR RUNT-bit position */
#define AG903_ETH_MACSR_RUNT_MSK                           (0x1UL << AG903_ETH_MACSR_RUNT_POS)                           /** ETHMACSR RUNT-bit mask */
#define AG903_ETH_MACSR_XPKT_OK_POS                        8                                                             /** ETHMACSR XPKT_OK-bit position */
#define AG903_ETH_MACSR_XPKT_OK_MSK                        (0x1UL << AG903_ETH_MACSR_XPKT_OK_POS)                        /** ETHMACSR XPKT_OK-bit mask */
#define AG903_ETH_MACSR_XPKT_LOST_POS                      9                                                             /** ETHMACSR XPKT_LOST-bit position */
#define AG903_ETH_MACSR_XPKT_LOST_MSK                      (0x1UL << AG903_ETH_MACSR_XPKT_LOST_POS)                      /** ETHMACSR XPKT_LOST-bit mask */
#define AG903_ETH_MACSR_LATE_COL_POS                       10                                                            /** ETHMACSR LATE_COL-bit position */
#define AG903_ETH_MACSR_LATE_COL_MSK                       (0x1UL << AG903_ETH_MACSR_LATE_COL_POS)                       /** ETHMACSR LATE_COL-bit mask */
#define AG903_ETH_MACSR_COL_EXCEED_POS                     11                                                            /** ETHMACSR COL_EXCEED-bit position */
#define AG903_ETH_MACSR_COL_EXCEED_MSK                     (0x1UL << AG903_ETH_MACSR_COL_EXCEED_POS)                     /** ETHMACSR COL_EXCEED-bit mask */

#define AG903_ETH_PHYCR_MIIRDATA_POS                       0                                                             /** ETHPHYCR MIIRDATA-bit position */
#define AG903_ETH_PHYCR_MIIRDATA_MSK                       (0xffffUL << AG903_ETH_PHYCR_MIIRDATA_POS)                    /** ETHPHYCR MIIRDATA-bit mask */
#define AG903_ETH_PHYCR_PHYAD_POS                          16                                                            /** ETHPHYCR PHYAD-bit position */
#define AG903_ETH_PHYCR_PHYAD_MSK                          (0x1fUL << AG903_ETH_PHYCR_PHYAD_POS)                         /** ETHPHYCR PHYAD-bit mask */
#define AG903_ETH_PHYCR_REGAD_POS                          21                                                            /** ETHPHYCR REGAD-bit position */
#define AG903_ETH_PHYCR_REGAD_MSK                          (0x1fUL << AG903_ETH_PHYCR_REGAD_POS)                         /** ETHPHYCR REGAD-bit mask */
#define AG903_ETH_PHYCR_MIIRD_POS                          26                                                            /** ETHPHYCR MIIRD-bit position */
#define AG903_ETH_PHYCR_MIIRD_MSK                          (0x1UL << AG903_ETH_PHYCR_MIIRD_POS)                          /** ETHPHYCR MIIRD-bit mask */
#define AG903_ETH_PHYCR_MIIWR_POS                          27                                                            /** ETHPHYCR MIIWR-bit position */
#define AG903_ETH_PHYCR_MIIWR_MSK                          (0x1UL << AG903_ETH_PHYCR_MIIWR_POS)                          /** ETHPHYCR MIIWR-bit mask */

#define AG903_ETH_PHYWDATA_MIIWDATA_POS                    0                                                             /** ETHPHYWDATA MIIWDATA-bit position */
#define AG903_ETH_PHYWDATA_MIIWDATA_MSK                    (0xffffUL << AG903_ETH_PHYWDATA_MIIWDATA_POS)                 /** ETHPHYWDATA MIIWDATA-bit mask */
#define AG903_ETH_PHYWDATA_MDC_CYCTHR_POS                  16                                                            /** ETHPHYWDATA MDC_CYCTHR-bit position */
#define AG903_ETH_PHYWDATA_MDC_CYCTHR_MSK                  (0xffUL << AG903_ETH_PHYWDATA_MDC_CYCTHR_POS)                 /** ETHPHYWDATA MDC_CYCTHR-bit mask */

#define AG903_ETH_FCR_FC_EN_POS                            0                                                             /** ETHFCR FC_EN-bit position */
#define AG903_ETH_FCR_FC_EN_MSK                            (0x1UL << AG903_ETH_FCR_FC_EN_POS)                            /** ETHFCR FC_EN-bit mask */
#define AG903_ETH_FCR_TX_PAUSE_POS                         1                                                             /** ETHFCR TX_PAUSE-bit position */
#define AG903_ETH_FCR_TX_PAUSE_MSK                         (0x1UL << AG903_ETH_FCR_TX_PAUSE_POS)                         /** ETHFCR TX_PAUSE-bit mask */
#define AG903_ETH_FCR_FCTHR_EN_POS                         2                                                             /** ETHFCR FCTHR_EN-bit position */
#define AG903_ETH_FCR_FCTHR_EN_MSK                         (0x1UL << AG903_ETH_FCR_FCTHR_EN_POS)                         /** ETHFCR FCTHR_EN-bit mask */
#define AG903_ETH_FCR_TXPAUSED_POS                         3                                                             /** ETHFCR TXPAUSED-bit position */
#define AG903_ETH_FCR_TXPAUSED_MSK                         (0x1UL << AG903_ETH_FCR_TXPAUSED_POS)                         /** ETHFCR TXPAUSED-bit mask */
#define AG903_ETH_FCR_RX_PAUSE_POS                         4                                                             /** ETHFCR RX_PAUSE-bit position */
#define AG903_ETH_FCR_RX_PAUSE_MSK                         (0x1UL << AG903_ETH_FCR_RX_PAUSE_POS)                         /** ETHFCR RX_PAUSE-bit mask */
#define AG903_ETH_FCR_FC_LOW_POS                           8                                                             /** ETHFCR FC_LOW-bit position */
#define AG903_ETH_FCR_FC_LOW_MSK                           (0xfUL << AG903_ETH_FCR_FC_LOW_POS)                           /** ETHFCR FC_LOW-bit mask */
#define AG903_ETH_FCR_FC_HIGH_POS                          12                                                            /** ETHFCR FC_HIGH-bit position */
#define AG903_ETH_FCR_FC_HIGH_MSK                          (0xfUL << AG903_ETH_FCR_FC_HIGH_POS)                          /** ETHFCR FC_HIGH-bit mask */
#define AG903_ETH_FCR_PAUSE_TIME_POS                       16                                                            /** ETHFCR PAUSE_TIME-bit position */
#define AG903_ETH_FCR_PAUSE_TIME_MSK                       (0xffffUL << AG903_ETH_FCR_PAUSE_TIME_POS)                    /** ETHFCR PAUSE_TIME-bit mask */

#define AG903_ETH_BPR_BK_EN_POS                            0                                                             /** ETHBPR BK_EN-bit position */
#define AG903_ETH_BPR_BK_EN_MSK                            (0x1UL << AG903_ETH_BPR_BK_EN_POS)                            /** ETHBPR BK_EN-bit mask */
#define AG903_ETH_BPR_BK_MODE_POS                          1                                                             /** ETHBPR BK_MODE-bit position */
#define AG903_ETH_BPR_BK_MODE_MSK                          (0x1UL << AG903_ETH_BPR_BK_MODE_POS)                          /** ETHBPR BK_MODE-bit mask */
#define AG903_ETH_BPR_BKJAM_LEN_POS                        4                                                             /** ETHBPR BKJAM_LEN-bit position */
#define AG903_ETH_BPR_BKJAM_LEN_MSK                        (0xfUL << AG903_ETH_BPR_BKJAM_LEN_POS)                        /** ETHBPR BKJAM_LEN-bit mask */
#define AG903_ETH_BPR_BK_LOW_POS                           8                                                             /** ETHBPR BK_LOW-bit position */
#define AG903_ETH_BPR_BK_LOW_MSK                           (0xfUL << AG903_ETH_BPR_BK_LOW_POS)                           /** ETHBPR BK_LOW-bit mask */

#define AG903_ETH_WOLCR_LINKCHG0_EN_POS                    0                                                             /** ETHWOLCR LINKCHG0_EN-bit position */
#define AG903_ETH_WOLCR_LINKCHG0_EN_MSK                    (0x1UL << AG903_ETH_WOLCR_LINKCHG0_EN_POS)                    /** ETHWOLCR LINKCHG0_EN-bit mask */
#define AG903_ETH_WOLCR_LINKCHG1_EN_POS                    1                                                             /** ETHWOLCR LINKCHG1_EN-bit position */
#define AG903_ETH_WOLCR_LINKCHG1_EN_MSK                    (0x1UL << AG903_ETH_WOLCR_LINKCHG1_EN_POS)                    /** ETHWOLCR LINKCHG1_EN-bit mask */
#define AG903_ETH_WOLCR_MAGICPKT_EN_POS                    2                                                             /** ETHWOLCR MAGICPKT_EN-bit position */
#define AG903_ETH_WOLCR_MAGICPKT_EN_MSK                    (0x1UL << AG903_ETH_WOLCR_MAGICPKT_EN_POS)                    /** ETHWOLCR MAGICPKT_EN-bit mask */
#define AG903_ETH_WOLCR_WAKEUP1_EN_POS                     3                                                             /** ETHWOLCR WAKEUP1_EN-bit position */
#define AG903_ETH_WOLCR_WAKEUP1_EN_MSK                     (0x1UL << AG903_ETH_WOLCR_WAKEUP1_EN_POS)                     /** ETHWOLCR WAKEUP1_EN-bit mask */
#define AG903_ETH_WOLCR_WAKEUP2_EN_POS                     4                                                             /** ETHWOLCR WAKEUP2_EN-bit position */
#define AG903_ETH_WOLCR_WAKEUP2_EN_MSK                     (0x1UL << AG903_ETH_WOLCR_WAKEUP2_EN_POS)                     /** ETHWOLCR WAKEUP2_EN-bit mask */
#define AG903_ETH_WOLCR_WAKEUP3_EN_POS                     5                                                             /** ETHWOLCR WAKEUP3_EN-bit position */
#define AG903_ETH_WOLCR_WAKEUP3_EN_MSK                     (0x1UL << AG903_ETH_WOLCR_WAKEUP3_EN_POS)                     /** ETHWOLCR WAKEUP3_EN-bit mask */
#define AG903_ETH_WOLCR_WAKEUP4_EN_POS                     6                                                             /** ETHWOLCR WAKEUP4_EN-bit position */
#define AG903_ETH_WOLCR_WAKEUP4_EN_MSK                     (0x1UL << AG903_ETH_WOLCR_WAKEUP4_EN_POS)                     /** ETHWOLCR WAKEUP4_EN-bit mask */
#define AG903_ETH_WOLCR_POWER_STATE_POS                    14                                                            /** ETHWOLCR POWER_STATE-bit position */
#define AG903_ETH_WOLCR_POWER_STATE_MSK                    (0x3UL << AG903_ETH_WOLCR_POWER_STATE_POS)                    /** ETHWOLCR POWER_STATE-bit mask */
#define AG903_ETH_WOLCR_WAKEUP_SEL_POS                     16                                                            /** ETHWOLCR WAKEUP_SEL-bit position */
#define AG903_ETH_WOLCR_WAKEUP_SEL_MSK                     (0x3UL << AG903_ETH_WOLCR_WAKEUP_SEL_POS)                     /** ETHWOLCR WAKEUP_SEL-bit mask */
#define AG903_ETH_WOLCR_SW_PDNPHY_POS                      18                                                            /** ETHWOLCR SW_PDNPHY-bit position */
#define AG903_ETH_WOLCR_SW_PDNPHY_MSK                      (0x1UL << AG903_ETH_WOLCR_SW_PDNPHY_POS)                      /** ETHWOLCR SW_PDNPHY-bit mask */
#define AG903_ETH_WOLCR_WOL_TYPE_POS                       24                                                            /** ETHWOLCR WOL_TYPE-bit position */
#define AG903_ETH_WOLCR_WOL_TYPE_MSK                       (0x3UL << AG903_ETH_WOLCR_WOL_TYPE_POS)                       /** ETHWOLCR WOL_TYPE-bit mask */

#define AG903_ETH_WOLSR_LINKCHG0_STS_POS                   0                                                             /** ETHWOLSR LINKCHG0_STS-bit position */
#define AG903_ETH_WOLSR_LINKCHG0_STS_MSK                   (0x1UL << AG903_ETH_WOLSR_LINKCHG0_STS_POS)                   /** ETHWOLSR LINKCHG0_STS-bit mask */
#define AG903_ETH_WOLSR_LINKCHG1_STS_POS                   1                                                             /** ETHWOLSR LINKCHG1_STS-bit position */
#define AG903_ETH_WOLSR_LINKCHG1_STS_MSK                   (0x1UL << AG903_ETH_WOLSR_LINKCHG1_STS_POS)                   /** ETHWOLSR LINKCHG1_STS-bit mask */
#define AG903_ETH_WOLSR_MAGICPKT_STS_POS                   2                                                             /** ETHWOLSR MAGICPKT_STS-bit position */
#define AG903_ETH_WOLSR_MAGICPKT_STS_MSK                   (0x1UL << AG903_ETH_WOLSR_MAGICPKT_STS_POS)                   /** ETHWOLSR MAGICPKT_STS-bit mask */
#define AG903_ETH_WOLSR_WAKEUP1_STS_POS                    3                                                             /** ETHWOLSR WAKEUP1_STS-bit position */
#define AG903_ETH_WOLSR_WAKEUP1_STS_MSK                    (0x1UL << AG903_ETH_WOLSR_WAKEUP1_STS_POS)                    /** ETHWOLSR WAKEUP1_STS-bit mask */
#define AG903_ETH_WOLSR_WAKEUP2_STS_POS                    4                                                             /** ETHWOLSR WAKEUP2_STS-bit position */
#define AG903_ETH_WOLSR_WAKEUP2_STS_MSK                    (0x1UL << AG903_ETH_WOLSR_WAKEUP2_STS_POS)                    /** ETHWOLSR WAKEUP2_STS-bit mask */
#define AG903_ETH_WOLSR_WAKEUP3_STS_POS                    5                                                             /** ETHWOLSR WAKEUP3_STS-bit position */
#define AG903_ETH_WOLSR_WAKEUP3_STS_MSK                    (0x1UL << AG903_ETH_WOLSR_WAKEUP3_STS_POS)                    /** ETHWOLSR WAKEUP3_STS-bit mask */
#define AG903_ETH_WOLSR_WAKEUP4_STS_POS                    6                                                             /** ETHWOLSR WAKEUP4_STS-bit position */
#define AG903_ETH_WOLSR_WAKEUP4_STS_MSK                    (0x1UL << AG903_ETH_WOLSR_WAKEUP4_STS_POS)                    /** ETHWOLSR WAKEUP4_STS-bit mask */

#define AG903_ETH_WFCRC_WFCRC_POS                          0                                                             /** ETHWFCRC WFCRC-bit position */
#define AG903_ETH_WFCRC_WFCRC_MSK                          (0xffffffffUL << AG903_ETH_WFCRC_WFCRC_POS)                   /** ETHWFCRC WFCRC-bit mask */

#define AG903_ETH_WFBM1_WFBM1_POS                          0                                                             /** ETHWFBM1 WFBM1-bit position */
#define AG903_ETH_WFBM1_WFBM1_MSK                          (0xffffffffUL << AG903_ETH_WFBM1_WFBM1_POS)                   /** ETHWFBM1 WFBM1-bit mask */

#define AG903_ETH_WFBM2_WFBM2_POS                          0                                                             /** ETHWFBM2 WFBM2-bit position */
#define AG903_ETH_WFBM2_WFBM2_MSK                          (0xffffffffUL << AG903_ETH_WFBM2_WFBM2_POS)                   /** ETHWFBM2 WFBM2-bit mask */

#define AG903_ETH_WFBM3_WFBM3_POS                          0                                                             /** ETHWFBM3 WFBM3-bit position */
#define AG903_ETH_WFBM3_WFBM3_MSK                          (0xffffffffUL << AG903_ETH_WFBM3_WFBM3_POS)                   /** ETHWFBM3 WFBM3-bit mask */

#define AG903_ETH_WFBM4_WFBM4_POS                          0                                                             /** ETHWFBM4 WFBM4-bit position */
#define AG903_ETH_WFBM4_WFBM4_MSK                          (0xffffffffUL << AG903_ETH_WFBM4_WFBM4_POS)                   /** ETHWFBM4 WFBM4-bit mask */

#define AG903_ETH_TS_Test_seed_POS                         0                                                             /** ETHTS Test_seed-bit position */
#define AG903_ETH_TS_Test_seed_MSK                         (0x3fffUL << AG903_ETH_TS_Test_seed_POS)                      /** ETHTS Test_seed-bit mask */

#define AG903_ETH_DMAFIFOS_RXDMA1_SM_POS                   0                                                             /** ETHDMAFIFOS RXDMA1_SM-bit position */
#define AG903_ETH_DMAFIFOS_RXDMA1_SM_MSK                   (0xfUL << AG903_ETH_DMAFIFOS_RXDMA1_SM_POS)                   /** ETHDMAFIFOS RXDMA1_SM-bit mask */
#define AG903_ETH_DMAFIFOS_RXDMA2_SM_POS                   4                                                             /** ETHDMAFIFOS RXDMA2_SM-bit position */
#define AG903_ETH_DMAFIFOS_RXDMA2_SM_MSK                   (0x7UL << AG903_ETH_DMAFIFOS_RXDMA2_SM_POS)                   /** ETHDMAFIFOS RXDMA2_SM-bit mask */
#define AG903_ETH_DMAFIFOS_TXDMA1_SM_POS                   8                                                             /** ETHDMAFIFOS TXDMA1_SM-bit position */
#define AG903_ETH_DMAFIFOS_TXDMA1_SM_MSK                   (0xfUL << AG903_ETH_DMAFIFOS_TXDMA1_SM_POS)                   /** ETHDMAFIFOS TXDMA1_SM-bit mask */
#define AG903_ETH_DMAFIFOS_TXDMA2_SM_POS                   12                                                            /** ETHDMAFIFOS TXDMA2_SM-bit position */
#define AG903_ETH_DMAFIFOS_TXDMA2_SM_MSK                   (0x7UL << AG903_ETH_DMAFIFOS_TXDMA2_SM_POS)                   /** ETHDMAFIFOS TXDMA2_SM-bit mask */
#define AG903_ETH_DMAFIFOS_RXFIFO_EMPTY_POS                26                                                            /** ETHDMAFIFOS RXFIFO_EMPTY-bit position */
#define AG903_ETH_DMAFIFOS_RXFIFO_EMPTY_MSK                (0x1UL << AG903_ETH_DMAFIFOS_RXFIFO_EMPTY_POS)                /** ETHDMAFIFOS RXFIFO_EMPTY-bit mask */
#define AG903_ETH_DMAFIFOS_TXFIFO_EMPTY_POS                27                                                            /** ETHDMAFIFOS TXFIFO_EMPTY-bit position */
#define AG903_ETH_DMAFIFOS_TXFIFO_EMPTY_MSK                (0x1UL << AG903_ETH_DMAFIFOS_TXFIFO_EMPTY_POS)                /** ETHDMAFIFOS TXFIFO_EMPTY-bit mask */
#define AG903_ETH_DMAFIFOS_DARB_RXGNT_POS                  28                                                            /** ETHDMAFIFOS DARB_RXGNT-bit position */
#define AG903_ETH_DMAFIFOS_DARB_RXGNT_MSK                  (0x1UL << AG903_ETH_DMAFIFOS_DARB_RXGNT_POS)                  /** ETHDMAFIFOS DARB_RXGNT-bit mask */
#define AG903_ETH_DMAFIFOS_DARB_TXGNT_POS                  29                                                            /** ETHDMAFIFOS DARB_TXGNT-bit position */
#define AG903_ETH_DMAFIFOS_DARB_TXGNT_MSK                  (0x1UL << AG903_ETH_DMAFIFOS_DARB_TXGNT_POS)                  /** ETHDMAFIFOS DARB_TXGNT-bit mask */
#define AG903_ETH_DMAFIFOS_RXD_REQ_POS                     30                                                            /** ETHDMAFIFOS RXD_REQ-bit position */
#define AG903_ETH_DMAFIFOS_RXD_REQ_MSK                     (0x1UL << AG903_ETH_DMAFIFOS_RXD_REQ_POS)                     /** ETHDMAFIFOS RXD_REQ-bit mask */
#define AG903_ETH_DMAFIFOS_TXD_REQ_POS                     31                                                            /** ETHDMAFIFOS TXD_REQ-bit position */
#define AG903_ETH_DMAFIFOS_TXD_REQ_MSK                     (0x1UL << AG903_ETH_DMAFIFOS_TXD_REQ_POS)                     /** ETHDMAFIFOS TXD_REQ-bit mask */

#define AG903_ETH_TM_TEST_EXCEL_POS                        5                                                             /** ETHTM TEST_EXCEL-bit position */
#define AG903_ETH_TM_TEST_EXCEL_MSK                        (0x1fUL << AG903_ETH_TM_TEST_EXCEL_POS)                       /** ETHTM TEST_EXCEL-bit mask */
#define AG903_ETH_TM_TEST_TIME_POS                         10                                                            /** ETHTM TEST_TIME-bit position */
#define AG903_ETH_TM_TEST_TIME_MSK                         (0x3ffUL << AG903_ETH_TM_TEST_TIME_POS)                       /** ETHTM TEST_TIME-bit mask */
#define AG903_ETH_TM_TEST_MODE_POS                         20                                                            /** ETHTM TEST_MODE-bit position */
#define AG903_ETH_TM_TEST_MODE_MSK                         (0x1UL << AG903_ETH_TM_TEST_MODE_POS)                         /** ETHTM TEST_MODE-bit mask */
#define AG903_ETH_TM_SEED_SEL_POS                          21                                                            /** ETHTM SEED_SEL-bit position */
#define AG903_ETH_TM_SEED_SEL_MSK                          (0x1UL << AG903_ETH_TM_SEED_SEL_POS)                          /** ETHTM SEED_SEL-bit mask */
#define AG903_ETH_TM_TEST_SEED_SEL_POS                     22                                                            /** ETHTM TEST_SEED_SEL-bit position */
#define AG903_ETH_TM_TEST_SEED_SEL_MSK                     (0x1UL << AG903_ETH_TM_TEST_SEED_SEL_POS)                     /** ETHTM TEST_SEED_SEL-bit mask */
#define AG903_ETH_TM_ITIMER_TEST_POS                       24                                                            /** ETHTM ITIMER_TEST-bit position */
#define AG903_ETH_TM_ITIMER_TEST_MSK                       (0x1UL << AG903_ETH_TM_ITIMER_TEST_POS)                       /** ETHTM ITIMER_TEST-bit mask */
#define AG903_ETH_TM_PTIMER_TEST_POS                       25                                                            /** ETHTM PTIMER_TEST-bit position */
#define AG903_ETH_TM_PTIMER_TEST_MSK                       (0x1UL << AG903_ETH_TM_PTIMER_TEST_POS)                       /** ETHTM PTIMER_TEST-bit mask */
#define AG903_ETH_TM_SINGLE_PKT_POS                        26                                                            /** ETHTM SINGLE_PKT-bit position */
#define AG903_ETH_TM_SINGLE_PKT_MSK                        (0x1UL << AG903_ETH_TM_SINGLE_PKT_POS)                        /** ETHTM SINGLE_PKT-bit mask */
#define AG903_ETH_TM_DMA_SWAP_POS                          27                                                            /** ETHTM DMA_SWAP-bit position */
#define AG903_ETH_TM_DMA_SWAP_MSK                          (0x1UL << AG903_ETH_TM_DMA_SWAP_POS)                          /** ETHTM DMA_SWAP-bit mask */
#define AG903_ETH_TM_PKT_SWAP_B_POS                        28                                                            /** ETHTM PKT_SWAP_B-bit position */
#define AG903_ETH_TM_PKT_SWAP_B_MSK                        (0x1UL << AG903_ETH_TM_PKT_SWAP_B_POS)                        /** ETHTM PKT_SWAP_B-bit mask */
#define AG903_ETH_TM_BIG_FORM_POS                          29                                                            /** ETHTM BIG_FORM-bit position */
#define AG903_ETH_TM_BIG_FORM_MSK                          (0x1UL << AG903_ETH_TM_BIG_FORM_POS)                          /** ETHTM BIG_FORM-bit mask */

#define AG903_ETH_COLCR_TX_SCOL_POS                        0                                                             /** ETHCOLCR TX_SCOL-bit position */
#define AG903_ETH_COLCR_TX_SCOL_MSK                        (0xffffUL << AG903_ETH_COLCR_TX_SCOL_POS)                     /** ETHCOLCR TX_SCOL-bit mask */
#define AG903_ETH_COLCR_TX_MCOL_POS                        16                                                            /** ETHCOLCR TX_MCOL-bit position */
#define AG903_ETH_COLCR_TX_MCOL_MSK                        (0xffffUL << AG903_ETH_COLCR_TX_MCOL_POS)                     /** ETHCOLCR TX_MCOL-bit mask */

#define AG903_ETH_REFAEPCR_AEP_POS                         0                                                             /** ETHREFAEPCR AEP-bit position */
#define AG903_ETH_REFAEPCR_AEP_MSK                         (0xffffUL << AG903_ETH_REFAEPCR_AEP_POS)                      /** ETHREFAEPCR AEP-bit mask */
#define AG903_ETH_REFAEPCR_RPF_POS                         16                                                            /** ETHREFAEPCR RPF-bit position */
#define AG903_ETH_REFAEPCR_RPF_MSK                         (0xffffUL << AG903_ETH_REFAEPCR_RPF_POS)                      /** ETHREFAEPCR RPF-bit mask */

#define AG903_ETH_XMPGCR_PG_POS                            0                                                             /** ETHXMPGCR PG-bit position */
#define AG903_ETH_XMPGCR_PG_MSK                            (0xffffUL << AG903_ETH_XMPGCR_PG_POS)                         /** ETHXMPGCR PG-bit mask */
#define AG903_ETH_XMPGCR_XM_POS                            16                                                            /** ETHXMPGCR XM-bit position */
#define AG903_ETH_XMPGCR_XM_MSK                            (0xffffUL << AG903_ETH_XMPGCR_XM_POS)                         /** ETHXMPGCR XM-bit mask */

#define AG903_ETH_RUNTLCCCR_TLCC_POS                       0                                                             /** ETHRUNTLCCCR TLCC-bit position */
#define AG903_ETH_RUNTLCCCR_TLCC_MSK                       (0xffffUL << AG903_ETH_RUNTLCCCR_TLCC_POS)                    /** ETHRUNTLCCCR TLCC-bit mask */
#define AG903_ETH_RUNTLCCCR_RUNT_CNT_POS                   16                                                            /** ETHRUNTLCCCR RUNT_CNT-bit position */
#define AG903_ETH_RUNTLCCCR_RUNT_CNT_MSK                   (0xffffUL << AG903_ETH_RUNTLCCCR_RUNT_CNT_POS)                /** ETHRUNTLCCCR RUNT_CNT-bit mask */

#define AG903_ETH_CRCERFTLCR_FTL_CNT_POS                   0                                                             /** ETHCRCERFTLCR FTL_CNT-bit position */
#define AG903_ETH_CRCERFTLCR_FTL_CNT_MSK                   (0xffffUL << AG903_ETH_CRCERFTLCR_FTL_CNT_POS)                /** ETHCRCERFTLCR FTL_CNT-bit mask */
#define AG903_ETH_CRCERFTLCR_CRCER_CNT_POS                 16                                                            /** ETHCRCERFTLCR CRCER_CNT-bit position */
#define AG903_ETH_CRCERFTLCR_CRCER_CNT_MSK                 (0xffffUL << AG903_ETH_CRCERFTLCR_CRCER_CNT_POS)              /** ETHCRCERFTLCR CRCER_CNT-bit mask */

#define AG903_ETH_RLCRCCCR_RCC_POS                         0                                                             /** ETHRLCRCCCR RCC-bit position */
#define AG903_ETH_RLCRCCCR_RCC_MSK                         (0xffffUL << AG903_ETH_RLCRCCCR_RCC_POS)                      /** ETHRLCRCCCR RCC-bit mask */
#define AG903_ETH_RLCRCCCR_RLC_POS                         16                                                            /** ETHRLCRCCCR RLC-bit position */
#define AG903_ETH_RLCRCCCR_RLC_MSK                         (0xffffUL << AG903_ETH_RLCRCCCR_RLC_POS)                      /** ETHRLCRCCCR RLC-bit mask */

#define AG903_ETH_BROCCR_BROC_POS                          0                                                             /** ETHBROCCR BROC-bit position */
#define AG903_ETH_BROCCR_BROC_MSK                          (0xffffffffUL << AG903_ETH_BROCCR_BROC_POS)                   /** ETHBROCCR BROC-bit mask */

#define AG903_ETH_MULCACR_MULCA_POS                        0                                                             /** ETHMULCACR MULCA-bit position */
#define AG903_ETH_MULCACR_MULCA_MSK                        (0xffffffffUL << AG903_ETH_MULCACR_MULCA_POS)                 /** ETHMULCACR MULCA-bit mask */

#define AG903_ETH_RPCR_RP_POS                              0                                                             /** ETHRPCR RP-bit position */
#define AG903_ETH_RPCR_RP_MSK                              (0xffffffffUL << AG903_ETH_RPCR_RP_POS)                       /** ETHRPCR RP-bit mask */

#define AG903_ETH_XPCR_XP_POS                              0                                                             /** ETHXPCR XP-bit position */
#define AG903_ETH_XPCR_XP_MSK                              (0xffffffffUL << AG903_ETH_XPCR_XP_POS)                       /** ETHXPCR XP-bit mask */

#endif /* _AG903_ETH_REGMAP_H_ */

