#include "sample_common.h"
#include "com.h"
#include "cap_simple.h"
#include "cap_common.h"

#include "via/viamgr.h"
#include "pgp/pgpmgr.h"
#include "dsp/dspmgr.h"

extern int32_t gCAPErrCode;		/* G[`FbNp */

int32_t CAP_Simple_Demo(uint32_t mode)
{
	int32_t rc = AG903_ENONE;

	int32_t				pipe_num		= -1;
	CAP_Framebuffer		framebuffer		= {0};
	AG903_DSPMgrWindowParam win_param	= {0};
	uint32_t			status;
	uint32_t			loop;

	AG903_ViaMgrInputHandle		*via	= NULL;
	AG903_VidMgrOutputHandle	*vid	= NULL;
	AG903_DSPMgrHandle			*dsp	= NULL;
	AG903_DSPMgrWinAttribute	*attr	= NULL;

	if (mode >= CAP_MODE_MAX) {
		CAP_ErrPrintf("ERROR: INVALID MODE. ABORT.\r\n");
		return -AG903_EINVAL;
	}

	/* t[obt@m */
	if(CAP_MODE_VIA_LVDS == mode || CAP_MODE_VIA_CMOS == mode) {
		via = CAP_GetVIAHandle(0);
		framebuffer.size = CAP_ANALOG_IN_WIDTH*CAP_ANALOG_IN_HEIGHT*2;
	}
	else {
		vid = CAP_GetVIDOutHandle();
		framebuffer.size = CAP_DIGITAL_IN_WIDTH*CAP_DIGITAL_IN_HEIGHT*4;
	}
	framebuffer.buf = sys_memalign(framebuffer.size, 0x1000);
	if (framebuffer.buf == NULL) {
		CAP_ErrPrintf("ERROR: Framebuffer allocate failed.\r\n");
		rc = -AG903_ENOMEM;
		return rc;
	}
	sys_memset(framebuffer.buf, 0, framebuffer.size);

	/* \ʐݒ */
	rc = CAP_SetupDisplay(mode);
	if (CAP_MODE_VIA_LVDS == mode || CAP_MODE_VID == mode) {
		dsp = CAP_GetDSPHandle(1);
	} else {
		dsp = CAP_GetDSPHandle(0);
	}

	/* EBhE0 */
	AG903_DSPMgrGetAttribute(dsp, 0, &attr);
	sys_memset(attr, 0, 0x20);
	attr->destination_width  = CAP_WINDOW_WIDTH;
	attr->position_x = (CAP_DISPLAY_WIDTH - CAP_WINDOW_WIDTH)>>1; /* Z^O */
	attr->destination_height = CAP_WINDOW_HEIGHT;
	attr->position_y = (CAP_DISPLAY_HEIGHT - CAP_WINDOW_HEIGHT)>>1; /* Z^O */
	attr->framebuffer_base = (uint32_t)framebuffer.buf;
	attr->conf.default_alpha = 0xFF;
	attr->conf.valid = true;
	if(CAP_MODE_VIA_LVDS == mode || CAP_MODE_VIA_CMOS == mode) {
		attr->source_width  = CAP_ANALOG_IN_WIDTH;
		attr->source_height = CAP_ANALOG_IN_HEIGHT;
		attr->hrz_size      = attr->source_width<<1;
		attr->conf.framebuffer_format = AG903_DSP_FFMT_YUV422_BT601_LIMIT;
	}
	else {
	    attr->source_height = CAP_DIGITAL_IN_HEIGHT;
	    attr->source_width  = CAP_DIGITAL_IN_WIDTH;
	    attr->hrz_size      = attr->source_width<<2;
	    attr->conf.framebuffer_format = AG903_DSP_FFMT_X8R8G8B8;
	}
	NOERRCHK(AG903_ENONE, AG903_DSPMgrSetAttribute(dsp, 0));

	/* EBhEݒ */
	win_param.background			= 0xFF000000;
	win_param.num_attr				= 1;
	win_param.num_config			= 1;
	win_param.update_timing			= AG903_DSP_ATTR_END_OF_VSYNC;
	win_param.window_attr_base		= (uint32_t)attr;
	win_param.window_attr_update	= true;
	NOERRCHK(AG903_ENONE, AG903_DSPMgrSetWindowParam(dsp, &win_param));

	AG903_DSPMgrEnable(dsp);
	sys_dlytsk(1000); /* fBXvC̈҂ */

	/* PGPݒ */
	AG903_PgpMgrPipelineHandle *pgp;
	rc = AG903_PgpMgrGetPipelineHandle(1, &pgp);

	if(CAP_MODE_VIA_LVDS == mode || CAP_MODE_VIA_CMOS == mode) {
		/*--- pCvC̐ݒ:͒i ---*/
		/* ̓|[g:VIA */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetInputPort(pgp, via));
		/* ͓샂[hFODDtB[hVSYNCɂ */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputMode(pgp, AG903_PGP_MGR_INPUT_MD_ODD_VSYNC));
		/* HSYNC̓fBC:x */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputHSyncDelay(pgp, CAP_HSYNC_DELAY));
		/* ̓t[@:C^[X, VPOSȂ */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputScan(pgp, AG903_PGP_MGR_SCAN_INTERLACE, false, false));
		/* ̓tH[}bg:YCbCr422 IPϊL */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputFormat(pgp, AG903_PGP_MGR_INPUT_FMT_YCBCR422_W_IP));
		/* IPϊHݒ:Limited range, uN0x00o */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetConfigIPConversion(pgp, AG903_PGP_MGR_LIMIT_16_235_AND_240, 0x00, 0x00));
		/* ͉𑜓xݒ */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputSize(pgp, CAP_ANALOG_IN_HEIGHT>>1, CAP_ANALOG_IN_WIDTH));
		/* Lv`JnWw */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputPosition(pgp, CAP_VIA_VPOS_OFFSET, CAP_VIA_HPOS_OFFSET));

		/*--- pCvC̐ݒ:o͒i ---*/
		/* o̓tH[}bg:YCbCr422 */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamOutputFormat(pgp, AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR422));
		/* o̓AhXw */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetConfigOutputBaseAddr(pgp, framebuffer.buf));
		/* o̓AhXw@:2 */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamOutputAddrDim(pgp, AG903_PGP_MGR_ADDR_DIMENTION_2));
		/* 2õ͎XgChw */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamOutputStride(pgp, CAP_ANALOG_IN_WIDTH << 1));
		/* o̓t[@:vObVu */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamOutputScan(pgp, AG903_PGP_MGR_SCAN_PROGRESSIVE));
		/* C^[X͂̃t[ۑ@:tB[hɏ] */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetConfigOutputInterlaceFrame(pgp, AG903_PGP_MGR_OUTPUT_FRAME_SAVE_FIELD));
		/* o̓~b^ݒ:~b^L(16-235/0-240) */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetConfigOutputLimit(pgp, AG903_PGP_MGR_LIMIT_16_235_AND_240));
	}
	else {
		/*--- pCvC̐ݒ:͒i ---*/
		/* ̓|[g:VID */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetInputPort(pgp, vid));
		/* ͓샂[hFLv`JnEIVSYNC */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputMode(pgp, AG903_PGP_MGR_INPUT_MD_VSYNC));
		/* HSYNC̓fBC:x */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputHSyncDelay(pgp, CAP_HSYNC_DELAY));
		/* ̓tH[}bg:RGB888 */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputFormat(pgp, AG903_PGP_MGR_INPUT_FMT_RGB888));
		/* ͉𑜓xݒ */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputSize(pgp, CAP_DIGITAL_IN_HEIGHT, CAP_DIGITAL_IN_WIDTH));
		/* Lv`JnWw */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamInputPosition(pgp, CAP_VID_VPOS_OFFSET, CAP_VID_HPOS_OFFSET));

		/*--- pCvC̐ݒ:o͒i ---*/
		/* o̓tH[}bg:RGB888 */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamOutputFormat(pgp, AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB888_32BIT));
		/* o̓AhXw */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetConfigOutputBaseAddr(pgp, framebuffer.buf));
		/* o̓AhXw@:2 */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamOutputAddrDim(pgp, AG903_PGP_MGR_ADDR_DIMENTION_2));
		/* 2õ͎XgChw */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetParamOutputStride(pgp, CAP_DIGITAL_IN_WIDTH<<2));
		/* o̓~b^ݒ:~b^L(0-255) */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetConfigOutputLimit(pgp, AG903_PGP_MGR_LIMIT_0_255));
		/* t[ۑ̃pfBOF0xFF */
		NOERRCHK(AG903_ENONE, AG903_PgpMgrSetConfigOutputFramePadding(pgp, 0xFF));
	}

	/* pCvC蓖 */
	pipe_num = AG903_PgpMgrAssignPipeline(pgp);
	CAP_Printf("[PGP] Pipeline #%u assigned.\r\n", pipe_num);

	/* Lv`Jn */
	NOERRCHK(AG903_ENONE, AG903_PgpMgrExecPipeline(pgp, AG903_PGP_MGR_CMD_EXEC_CONTINUE));

	{
		char input[2];
		CAP_Printf("Press enter key to exit.");
		COM_GetNum_Wait(input, sizeof(input));
	}

	/* Lv`~ */
	NOERRCHK(AG903_ENONE, AG903_PgpMgrExecPipeline(pgp, AG903_PGP_MGR_CMD_IDLE));

	/* pCvC~҂ */
	for(loop=0; loop<CAP_PIPESTOP_TIMEOUT; loop++) {
		NOERRCHK(AG903_ENONE, AG903_PgpMgrGetPipelineStatus(pgp, NULL, NULL, NULL, NULL, &status));
		if(AG903_PGP_MGR_STATE_IDLE == status) {
			break;
		}
		sys_dlytsk(10);
	}
	if(CAP_PIPESTOP_TIMEOUT<=loop) {
		CAP_ErrPrintf("ERROR: Pipeline Stop Failure.\r\n");
	}

	/* pCvCnhԋp */
	NOERRCHK(AG903_ENONE, AG903_PgpMgrReleasePipelineHandle(pgp));

	/* I */
	sys_free(framebuffer.buf); /* t[obt@ */
	rc = CAP_ReleaseDisplay(); /* \I */

	return rc;
}

