/*
* This program was created by AXELL CORPORATION.
* Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "sample_common.h"
#include "com.h"
#include "dmac/dmacmgr.h"

/* vg^Cv */
static int32_t Dmac_init_module(void);
static int32_t Dmac_term_module(void);
static void Dmac_SampleHelp(void);
static void Dmac_SimpleTrns(void);
static void Dmac_DescListTrns(void);
static void Dmac_ChEventTrns(void);
static void Dmac_RemoteDescTrns(void);
static void Dmac_WriteOnlyTrns(void);
static void Dmac_SetLdmFull(AG903_DMACMgrHandle *handle);
static int32_t Dmac_GetMem(uint8_t** srcaddr, uint8_t** dstaddr0, uint8_t** dstaddr1);
static int32_t Dmac_RelMem(uint8_t* srcaddr, uint8_t* dstaddr0, uint8_t* dstaddr1);
static int32_t Dmac_CheckVerify(uint8_t* src, uint8_t* dst, uint32_t size);
static int32_t Dmac_WatiTerm(uint32_t timout);
static void Dmac_TermHdlr(AG903_DMACMgrHandle* handle, AG903_DMACMgrDesc** desc, uint8_t* end);
static void Dmac_AbortHdlr(AG903_DMACMgrHandle* handle);
static void Dmac_ErrHdlr(AG903_DMACMgrHandle* handle);

/* Param */
#define DMAC_SMP_TRNS_SIZE		(1024)					/* f[^][byte] */
#define DMAC_SMP_ALIGN_SIZE		(32)					/* obt@ACTCY[byte] */
#define DMAC_SMP_MPL_SIZE		(DMAC_SMP_TRNS_SIZE*4)	/* v[TCY */
#define DMAC_SMP_MPL_ADDR		(AG903_SAMPLE_VRAM_ADDR)	/* v[AhX */
#define DMAC_SMP_CH_MAIN		(0)						/* DMAC CH (Mani) */
#define DMAC_SMP_CH_SUB			(1)						/* DMAC CH (Sub) */
#define DMAC_SMP_EVENT			(1)						/* Eventԍ */
#define DMAC_SMP_CONSTVAL		(0xFF00AA55)			/* Const Data */
#define DMAC_SMP_LD_ALIGN		(8)						/* fBXNv^AC[byte] */

/* Macro */
#define	EPRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define	PRINT(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)
#define DMAC_ERROR(str)			sys_print(1, " ERROR:%s[%d] *%s*\r\n",__FUNCTION__, __LINE__, str)

static void (*func[])() = {
	Dmac_SampleHelp,
	Dmac_SimpleTrns,
	Dmac_DescListTrns,
	Dmac_ChEventTrns,
	Dmac_RemoteDescTrns,
	Dmac_WriteOnlyTrns,
};

static _Bool	Dmacterm;

/**
 * @brief		C
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void DMAC_main(uint8_t param)
{
	((void)param);
	uint8_t		mode = 0;
	char		input[2+2];

	Dmac_SampleHelp();	/* Help\ */

	Dmac_init_module();

	while (mode != 0xFF) {
		EPRINT(" -- Choose sample number (00h<HELP> to FFh): ");
		COM_GetNum_Wait(input, sizeof(input));
		mode = (ASCtoBIN(input[0]) << 4)
			 | (ASCtoBIN(input[1]) << 0);
		if(0xFF == mode) {
			break;
		}
		if(mode >= (sizeof(func)/sizeof(void*))) {
			func[0](); /* Help */
		}
		else {
			func[mode]();	/* Sample funcs */
		}
	}

	Dmac_term_module();

	return;
}

/**
 * @brief		Tu
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void DMAC_sub(uint32_t param)
{
	((void)param);
	return;
}

/**
 * @brief		W[
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t Dmac_init_module(void)
{
	int32_t	ret;
	
	ret = sys_meminit(AG903_SAMPLE_VRAM_ALLOC_SIZE,
				 (void *)AG903_SAMPLE_VRAM_ADDR,
				 SYSMEM_NORMAL_CACHE_OFF);
	if(AG903_ENONE != ret) {
		DMAC_ERROR("CreateMpl");
	}

	return AG903_ENONE;
}

/**
 * @brief		W[I
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t Dmac_term_module(void)
{
	sys_memfinal();
	return AG903_ENONE;
}

/**
 * @brief		wv\
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Dmac_SampleHelp(void)
{
	PRINT("\t# 00 ... Help");
	PRINT("\t# 01 ... Simple Transfer");
	PRINT("\t# 02 ... Descriptor List Transfer");
	PRINT("\t# 03 ... Channel Event Transfer");
	PRINT("\t# 04 ... Remote Descriptor Transfer");
	PRINT("\t# 05 ... Write Only Mode Transfer");
	PRINT("\t# FF ... Exit Sample");

	return;
}

/**
 * @brief		ȈՃfBXNv^]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Dmac_SimpleTrns(void)
{
	AG903_DMACMgrHandle *handle;
	uint8_t* 	srcaddr = NULL;
	uint8_t* 	dstaddr = NULL;
	int32_t 	result;

	PRINT(" Simple Transfer");

	Dmacterm = false;

	result = Dmac_GetMem(&srcaddr, &dstaddr, NULL);	/* ]̈m */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetMem");
	}

	/* DMACݒ */
	result = AG903_DMACMgrGetHandle(DMAC_SMP_CH_MAIN, &handle); 					/* nh擾 */
	if(AG903_ENONE != result) {
		DMAC_ERROR("GetHandle");
	}
	result = AG903_DMACMgrSetIntCallback(handle, Dmac_TermHdlr, Dmac_AbortHdlr, Dmac_ErrHdlr); 	/* R[obNo^ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetIntCallback");
	}
	result = AG903_DMACMgrSetSimpleTrnsDesc(handle, (void*)srcaddr,
											DMAC_SMP_TRNS_SIZE, (void*)dstaddr); 	/* ȈՓ]pfBXNv^ݒ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetSimpleTrnsDesc");
	}

	/* ]Jn`҂ */
	PRINT(" * Transfer Start");
	result = AG903_DMACMgrEnable(handle); 											/* s */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Enable");
	}
	result = Dmac_WatiTerm(1000);
	if(AG903_ENONE != result) {
		DMAC_ERROR("WaitTerm");
	}
	else {
		PRINT(" * Transfer End");
	}
	result = Dmac_CheckVerify(srcaddr, dstaddr, DMAC_SMP_TRNS_SIZE); 				/* xt@C */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Verify");
	}
	else {
		PRINT(" * Verify OK");
	}

	/* DMAC */
	result = AG903_DMACMgrReleaseHandle(handle); 									/* nh */
	if(AG903_ENONE != result) {
		DMAC_ERROR("ReleaseHandle");
	}

	result = Dmac_RelMem(srcaddr, dstaddr, NULL);	/* ]̈ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		fBXNv^Xg]
 * @param		Ȃ
 * @return		Ȃ
 * @note		2̃fBXNv^pӂ2ӏ֓]܂
 */
static void Dmac_DescListTrns(void)
{
	AG903_DMACMgrHandle *handle;
    AG903_DMACMgrConfig config;
	AG903_DMACMgrDesc	desc[2];
	uint8_t* 	srcaddr  = NULL;
	uint8_t* 	dstaddr0 = NULL;
	uint8_t* 	dstaddr1 = NULL;
	int32_t 	result;

	PRINT(" Descriptor List Transfer");

	Dmacterm = false;

	result = Dmac_GetMem(&srcaddr, &dstaddr0, &dstaddr1);	/* ]̈m */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetMem");
	}

	/* DMACݒ */
	result = AG903_DMACMgrGetHandle(DMAC_SMP_CH_MAIN, &handle); 					/* nh擾 */
	if(AG903_ENONE != result) {
		DMAC_ERROR("GetHandle");
	}
	result = AG903_DMACMgrSetIntCallback(handle, Dmac_TermHdlr, Dmac_AbortHdlr, Dmac_ErrHdlr); 	/* R[obNo^ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetIntCallback");
	}
	config.val = 0;
	desc[0].Ctrl.val = 0;
	desc[0].SrcAddr  = (uint32_t)srcaddr;
	desc[0].DstAddr  = (uint32_t)dstaddr0;
	desc[0].Trns.val = DMAC_SMP_TRNS_SIZE;
	desc[0].Stride.val = 0;
	desc[0].next = (void*)&desc[1]; /* desc[1] */
	desc[1].Ctrl.val = 0;
	desc[1].SrcAddr  = (uint32_t)srcaddr;
	desc[1].DstAddr  = (uint32_t)dstaddr1;
	desc[1].Trns.val = DMAC_SMP_TRNS_SIZE;
	desc[1].Stride.val = 0;
	desc[1].next = 0;
	AG903_DMACMgrSetDescList(handle, &config, desc, 2); 							/* fBXNv^ݒ */

	/* ]Jn`҂ */
	PRINT(" * Transfer Start");
	result = AG903_DMACMgrEnable(handle); 											/* s */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Enable");
	}
	result = Dmac_WatiTerm(1000);
	if(AG903_ENONE != result) {
		DMAC_ERROR("WaitTerm");
	}
	else {
		PRINT(" * Transfer End");
	}
	result = Dmac_CheckVerify(srcaddr, dstaddr0, DMAC_SMP_TRNS_SIZE); 				/* xt@C */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Verify");
	}
	else {
		PRINT(" * 1st Verify OK");
	}
	result = Dmac_CheckVerify(srcaddr, dstaddr1, DMAC_SMP_TRNS_SIZE); 				/* xt@C */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Verify");
	}
	else {
		PRINT(" * 2nd Verify OK");
	}

	/* DMAC */
	result = AG903_DMACMgrReleaseHandle(handle); 									/* nh */
	if(AG903_ENONE != result) {
		DMAC_ERROR("ReleaseHandle");
	}

	result = Dmac_RelMem(srcaddr, dstaddr0, dstaddr1);	/* ]̈ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		`lCxg]
 * @param		Ȃ
 * @return		Ȃ
 * @note		2DMACgp2ӏ֓]܂
 */
static void Dmac_ChEventTrns(void)
{
	AG903_DMACMgrHandle *handle0;
	AG903_DMACMgrHandle *handle1;
    AG903_DMACMgrConfig config;
	AG903_DMACMgrDesc	desc;
	uint8_t* 	srcaddr  = NULL;
	uint8_t* 	dstaddr0 = NULL;
	uint8_t* 	dstaddr1 = NULL;
	int32_t 	result;

	PRINT(" Channel Event Transfer");

	Dmacterm = false;

	result = Dmac_GetMem(&srcaddr, &dstaddr0, &dstaddr1);	/* ]̈m */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetMem");
	}

	/* DMAC0ݒ */
	result = AG903_DMACMgrGetHandle(DMAC_SMP_CH_MAIN, &handle0); 				/* nh擾 */
	if(AG903_ENONE != result) {
		DMAC_ERROR("GetHandle");
	}
	config.val = 0;
	desc.Ctrl.val = 0;
	desc.Ctrl.st.ExpEn = 1;
	desc.Ctrl.st.SEventEn = 1; /* Set Event */
	desc.Ctrl.st.ChSEvent = DMAC_SMP_EVENT;
	desc.SrcAddr  = (uint32_t)srcaddr;
	desc.DstAddr  = (uint32_t)dstaddr0;
	desc.Trns.val = DMAC_SMP_TRNS_SIZE;
	desc.Stride.val = 0;
	desc.next = 0;
	AG903_DMACMgrSetDescList(handle0, &config, &desc, 1); 							/* fBXNv^ݒ */

	/* DMAC1ݒ */
	result = AG903_DMACMgrGetHandle(DMAC_SMP_CH_SUB, &handle1); 					/* nh擾 */
	if(AG903_ENONE != result) {
		DMAC_ERROR("GetHandle");
	}
	result = AG903_DMACMgrSetIntCallback(handle1, Dmac_TermHdlr, Dmac_AbortHdlr, Dmac_ErrHdlr); 	/* R[obNo^ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetIntCallback");
	}
	config.val = 0;
	desc.Ctrl.val = 0;
	desc.Ctrl.st.ExpEn = 1;
	desc.Ctrl.st.WEventEn = 1; /* Wait Event */
	desc.Ctrl.st.ChWEvent = (1<<DMAC_SMP_EVENT);
	desc.SrcAddr  = (uint32_t)dstaddr0;
	desc.DstAddr  = (uint32_t)dstaddr1;
	desc.Trns.val = DMAC_SMP_TRNS_SIZE;
	desc.Stride.val = 0;
	desc.next = 0;
	AG903_DMACMgrSetDescList(handle1, &config, &desc, 1); 							/* fBXNv^ݒ */

	/* ]Jn`҂ */
	PRINT(" * Transfer Start");
	result = AG903_DMACMgrEnable(handle1); 											/* DMAC1s (DMAC0҂) */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Enable");
	}
	result = AG903_DMACMgrEnable(handle0); 											/* DMAC0s */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Enable");
	}
	result = Dmac_WatiTerm(1000);
	if(AG903_ENONE != result) {
		DMAC_ERROR("WaitTerm");
	}
	else {
		PRINT(" * Transfer End");
	}
	result = Dmac_CheckVerify(srcaddr, dstaddr0, DMAC_SMP_TRNS_SIZE); 				/* xt@C */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Verify");
	}
	else {
		PRINT(" * 1st Verify OK");
	}
	result = Dmac_CheckVerify(srcaddr, dstaddr1, DMAC_SMP_TRNS_SIZE); 				/* xt@C */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Verify");
	}
	else {
		PRINT(" * 2nd Verify OK");
	}

	/* DMAC */
	result = AG903_DMACMgrReleaseHandle(handle0); 									/* DMAC0nh */
	if(AG903_ENONE != result) {
		DMAC_ERROR("ReleaseHandle");
	}
	result = AG903_DMACMgrReleaseHandle(handle1); 									/* DMAC1nh */
	if(AG903_ENONE != result) {
		DMAC_ERROR("ReleaseHandle");
	}

	result = Dmac_RelMem(srcaddr, dstaddr0, dstaddr1);	/* ]̈ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		[hfBXNv^]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Dmac_RemoteDescTrns(void)
{
	AG903_DMACMgrHandle *handle;
	AG903_DMACMgrHandle *dummy;
    AG903_DMACMgrConfig config;
	AG903_DMACMgrDesc	desc;
	uint8_t* 	srcaddr = NULL;
	uint8_t*	dstaddr = NULL;
	uint8_t*	rddbuf;
	int32_t 	result;

	PRINT(" Remote Descriptor Transfer");

	Dmacterm = false;

	result = Dmac_GetMem(&srcaddr, &dstaddr, NULL);	/* ]̈m */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetMem");
	}

	/* LDM_~[Ŗ߂ (LDMFULL̏Ӑ}Iɍ) */
	result = AG903_DMACMgrGetHandle(DMAC_SMP_CH_SUB, &dummy);
	if(AG903_ENONE != result) {
		DMAC_ERROR("GetHandle");
	}
	Dmac_SetLdmFull(dummy);

	/* [hfBXNv^̈ݒ */
	rddbuf = (uint8_t*)sys_memalign(AG903_DMAC_RDD_ENTRY_NUM*AG903_DMAC_DESC_SIZE, DMAC_SMP_LD_ALIGN);
	result = AG903_DMACMgrSetRemoteDescAddr((void*)rddbuf);
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetRemoteDescAddr");
	}

	/* DMACݒ */
	result = AG903_DMACMgrGetHandle(DMAC_SMP_CH_MAIN, &handle); 		/* nh擾 */
	if(AG903_ENONE != result) {
		DMAC_ERROR("GetHandle");
	}
	result = AG903_DMACMgrSetIntCallback(handle, Dmac_TermHdlr, Dmac_AbortHdlr, Dmac_ErrHdlr); 	/* R[obNo^ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetIntCallback");
	}
	config.val = 0;
	desc.Ctrl.val = 0;
	desc.SrcAddr  = (uint32_t)srcaddr;
	desc.DstAddr  = (uint32_t)dstaddr;
	desc.Trns.val = DMAC_SMP_TRNS_SIZE;
	desc.Stride.val = 0;
	desc.next = 0;
	AG903_DMACMgrSetDescList(handle, &config, &desc, 1); 				/* fBXNv^ݒ */

	/* ]Jn`҂ */
	PRINT(" * Transfer Start");
	result = AG903_DMACMgrEnable(handle); 								/* s */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Enable");
	}
	result = Dmac_WatiTerm(1000);
	if(AG903_ENONE != result) {
		DMAC_ERROR("WaitTerm");
	}
	else {
		PRINT(" * Transfer End");
	}
	result = Dmac_CheckVerify(srcaddr, dstaddr, DMAC_SMP_TRNS_SIZE); 	/* xt@C */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Verify");
	}
	else {
		PRINT(" * Verify OK");
	}

	/* DMAC */
	result = AG903_DMACMgrReleaseHandle(handle); 						/* nh */
	if(AG903_ENONE != result) {
		DMAC_ERROR("ReleaseHandle");
	}
	result = AG903_DMACMgrReleaseHandle(dummy); 						/* _~[nh */
	if(AG903_ENONE != result) {
		DMAC_ERROR("ReleaseHandle");
	}

	/* [hfBXNv^̈NA */
	result = AG903_DMACMgrClearRemoteDescAddr();
	if(AG903_ENONE != result) {
		DMAC_ERROR("ClearRemoteDescAddr");
	}
	sys_free(rddbuf);

	result = Dmac_RelMem(srcaddr, dstaddr, NULL);	/* ]̈ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		Write Only Mode]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Dmac_WriteOnlyTrns(void)
{
	AG903_DMACMgrHandle *handle;
    AG903_DMACMgrConfig config;
	AG903_DMACMgrDesc	desc;
	uint8_t* 	dstaddr = NULL;
	int32_t 	result;

	PRINT(" Write Only Mode Transfer");

	Dmacterm = false;

	result = Dmac_GetMem(NULL, &dstaddr, NULL);	/* ]̈m */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetMem");
	}

	/* DMACݒ */
	result = AG903_DMACMgrGetHandle(DMAC_SMP_CH_MAIN, &handle); 					/* nh擾 */
	if(AG903_ENONE != result) {
		DMAC_ERROR("GetHandle");
	}
	result = AG903_DMACMgrSetIntCallback(handle, Dmac_TermHdlr, Dmac_AbortHdlr, Dmac_ErrHdlr); 	/* R[obNo^ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetIntCallback");
	}
	result = AG903_DMACMgrSetConstantValue(DMAC_SMP_CONSTVAL);						/* Write Valݒ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("SetConstantVal");
	}
	config.val        = 0;
	config.st.WOMode = 1; /* WriteOnlyMode */
	desc.Ctrl.val     = 0;
	desc.DstAddr      = (uint32_t)dstaddr;
	desc.Trns.val     = DMAC_SMP_TRNS_SIZE;
	desc.Stride.val   = 0;
	desc.next = 0;
	AG903_DMACMgrSetDescList(handle, &config, &desc, 1); 							/* fBXNv^ݒ */

	/* ]Jn`҂ */
	PRINT(" * Transfer Start");
	result = AG903_DMACMgrEnable(handle); 											/* s */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Enable");
	}
	result = Dmac_WatiTerm(1000);
	if(AG903_ENONE != result) {
		DMAC_ERROR("WaitTerm");
	}
	else {
		PRINT(" * Transfer End");
	}
	result = Dmac_CheckVerify(NULL, dstaddr, DMAC_SMP_TRNS_SIZE); 					/* xt@C */
	if(AG903_ENONE != result) {
		DMAC_ERROR("Verify");
	}
	else {
		PRINT(" * Verify OK");
	}

	/* DMAC */
	result = AG903_DMACMgrReleaseHandle(handle); 									/* nh */
	if(AG903_ENONE != result) {
		DMAC_ERROR("ReleaseHandle");
	}

	result = Dmac_RelMem(NULL, dstaddr, NULL);	/* ]̈ */
	if(AG903_ENONE != result) {
		DMAC_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		LDM Full (eXgp)
 * @param[in]	DMACnh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Dmac_SetLdmFull(AG903_DMACMgrHandle *handle)
{
    AG903_DMACMgrConfig config;
	AG903_DMACMgrDesc	desc;
	uint32_t 	src;
	uint32_t 	dst;
	int32_t 	result;
	uint32_t	loop;

	config.val = 0;
	desc.Ctrl.val = 0;
	desc.Ctrl.st.SrcCtrl = 2; /* Fixed */
	desc.Ctrl.st.DstCtrl = 2; /* Fixed */
	desc.SrcAddr  = (uint32_t)&src;
	desc.DstAddr  = (uint32_t)&dst;
	desc.Trns.val = DMAC_SMP_TRNS_SIZE;
	desc.Stride.val = 0;
	desc.next = 0;

	for(loop=0; loop<AG903_DMAC_LDD_ENTRY_NUM; loop++) {
		result = AG903_DMACMgrSetDescList(handle, &config, &desc, 1);
		if(-AG903_ENOBUFS == result) {
			break;
		}
	}

	return;
}

/**
 * @brief		]pm
 * @param[out]	Mobt@
 * @param[out]	Mobt@
 * @return		Ȃ
 * @note		mیɓe܂
 */
static int32_t Dmac_GetMem(uint8_t** srcaddr, uint8_t** dstaddr0, uint8_t** dstaddr1)
{
	uint8_t* 	getbuf;
	uint32_t 	loop;

	if(NULL != srcaddr) {
		getbuf = (uint8_t*)sys_memalign(DMAC_SMP_TRNS_SIZE, DMAC_SMP_ALIGN_SIZE);
		if(NULL == getbuf) {
			return -AG903_EFAULT;
		}
		for(loop=0; loop<DMAC_SMP_TRNS_SIZE; loop++) {
			*(getbuf+loop) = loop;	/* ]f[^Zbg */
		}
		(*srcaddr) = getbuf;
	}

	if(NULL != dstaddr0) {
		getbuf = (uint8_t*)sys_memalign(DMAC_SMP_TRNS_SIZE, DMAC_SMP_ALIGN_SIZE);
		if(NULL == getbuf) {
			return -AG903_EFAULT;
		}
		for(loop=0; loop<DMAC_SMP_TRNS_SIZE; loop++) {
			*(getbuf+loop) = 0;		/* ]f[^NA */
		}
		(*dstaddr0) = getbuf;
	}

	if(NULL != dstaddr1) {
		getbuf = (uint8_t*)sys_memalign(DMAC_SMP_TRNS_SIZE, DMAC_SMP_ALIGN_SIZE);
		if(NULL == getbuf) {
			return -AG903_EFAULT;
		}
		for(loop=0; loop<DMAC_SMP_TRNS_SIZE; loop++) {
			*(getbuf+loop) = 0;		/* ]f[^NA */
		}
		(*dstaddr1) = getbuf;
	}

	return AG903_ENONE;
}

/**
 * @brief		]p
 * @param[in]	Mobt@
 * @param[in]	Mobt@
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Dmac_RelMem(uint8_t* srcaddr, uint8_t* dstaddr0, uint8_t* dstaddr1)
{
	int32_t 	result;

	if(NULL != srcaddr) {
		result = sys_free(srcaddr);
		if(AG903_ENONE != result) {
			return result;
		}
	}

	if(NULL != dstaddr0) {
		result = sys_free(dstaddr0);
		if(AG903_ENONE != result) {
			return result;
		}
	}

	if(NULL != dstaddr1) {
		result = sys_free(dstaddr1);
		if(AG903_ENONE != result) {
			return result;
		}
	}

	return AG903_ENONE;
}

/**
 * @brief		xt@C`FbN
 * @param[in]	src		r
 * @param[in]	dst		r
 * @param[in]	size	rTCY
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Dmac_CheckVerify(uint8_t* src, uint8_t* dst, uint32_t size)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	loop;
	uint32_t*	dst32 = (uint32_t*)dst;

	if(NULL != src) {
		for(loop=0; loop<size; loop++) {
			if( *(src+loop) != *(dst+loop) ) {
				retval = -AG903_EFAULT;
				break;
			}
		}
	}
	else {
		/* srcNULL̏ꍇconstf[^Ɣr */
		for(loop=0; loop<(size/4); loop++) {
			if( DMAC_SMP_CONSTVAL != (*dst32) ) {
				retval = -AG903_EFAULT;
				break;
			}
			dst32 ++;
		}
	}

	return retval;
}

/**
 * @brief		]҂
 * @param[in]	timout	^CAEg[ms]
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Dmac_WatiTerm(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == Dmacterm) {
			Dmacterm = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}




/**
 * @brief		]I
 * @param[in]	handle	nh
 * @param[out]	desc	fBXNv^i[
 * @param[out]	end		zItO
 * @return		Ȃ
 * @note		Ȃ
 */
static void Dmac_TermHdlr(AG903_DMACMgrHandle* handle, AG903_DMACMgrDesc** desc, uint8_t* end)
{
	((void)handle);
	((void)desc);
	((void)end);
	Dmacterm = true;
	return;
}

/**
 * @brief		A{[g
 * @param[in]	handle	nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Dmac_AbortHdlr(AG903_DMACMgrHandle* handle)
{
	((void)handle);
	return;
}

/**
 * @brief		G[
 * @param[in]	handle	nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Dmac_ErrHdlr(AG903_DMACMgrHandle* handle)
{
	((void)handle);
	return;
}
