/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

/* VGPathIuWFNg */
static VGPath maskpath;
/* VGImageIuWFNg */
static VGImage image;
static VGImage maskimg;

static VGubyte mask_cmd[] = {
    0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x02, 0x0c, 
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x04, 0x04, 0x0c, 0x0c, 
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x04, 0x04, 
    0x0c, 0x0c, 0x00, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x02, 0x04, 0x04, 
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x02, 0x04, 0x04, 0x04, 
    0x00, 
};

static VGfloat mask_coord[] = {
    280.30, 217.89, 256.41, 211.94, 185.72, 40.16, 184.41, 194.02, 
    164.69, 189.12, 167.21, -105.74, 186.93, -100.83, 186.07, -0.83, 
    200.54, 34.13, 260.32, -82.56, 285.91, -76.19, 215.27, 62.80, 
    280.30, 217.89, 91.51, 174.37, 86.18, 174.30, 80.59, 173.54, 
    74.72, 172.08, 58.59, 168.07, 45.35, 156.83, 35.00, 138.38, 
    24.64, 120.06, 19.57, 98.55, 19.78, 73.87, 19.96, 52.35, 
    23.27, 35.64, 29.69, 23.75, 36.17, 12.00, 46.02, 4.99, 
    59.21, 2.72, 65.74, 1.70, 71.89, 1.05, 77.68, 0.77, 
    83.54, 0.51, 88.97, -0.32, 93.97, -1.73, 100.57, -3.52, 
    105.49, -7.13, 108.73, -12.54, 112.04, -17.93, 113.75, -27.16, 
    113.86, -40.23, 113.99, -55.42, 110.67, -68.41, 103.91, -79.22, 
    97.22, -90.02, 87.77, -96.93, 75.55, -99.97, 66.92, -102.12, 
    57.66, -101.05, 47.78, -96.77, 37.90, -92.48, 29.15, -85.06, 
    21.54, -74.52, 20.15, -74.87, 20.57, -123.98, 29.47, -129.57, 
    38.18, -133.29, 46.71, -135.13, 55.31, -136.96, 64.95, -136.55, 
    75.64, -133.89, 85.60, -131.41, 94.08, -126.92, 101.07, -120.41, 
    108.14, -113.89, 114.29, -105.74, 119.53, -95.97, 124.31, -86.98, 
    127.97, -76.54, 130.53, -64.66, 133.16, -52.76, 134.42, -41.07, 
    134.33, -29.58, 134.15, -8.46, 131.22, 7.28, 125.54, 17.64, 
    119.86, 28.00, 111.49, 34.72, 100.42, 37.78, 94.95, 39.20, 
    88.29, 40.25, 80.44, 40.94, 72.58, 41.63, 66.52, 42.37, 
    62.25, 43.16, 54.19, 44.86, 48.53, 48.81, 45.29, 55.02, 
    42.04, 61.22, 40.37, 70.46, 40.26, 82.74, 40.14, 96.47, 
    43.23, 108.48, 49.53, 118.78, 55.90, 129.10, 64.36, 135.57, 
    74.91, 138.19, 84.54, 140.59, 93.96, 139.76, 103.18, 135.70, 
    112.46, 131.80, 119.96, 125.79, 125.68, 117.69, 127.08, 118.04, 
    126.68, 164.38, 119.93, 168.52, 112.19, 171.48, 103.46, 173.28, 
    99.64, 174.06, 95.65, 174.43, 91.51, 174.37, -50.90, 135.45, 
    -77.19, 128.91, -128.64, -179.37, -108.63, -174.39, -94.79, -88.60, 
    -30.66, -72.63, -15.42, -151.19, 5.59, -145.96, -50.90, 135.45, 
    -153.87, 109.83, -181.25, 103.01, -218.09, -70.67, -259.02, 83.65, 
    -285.91, 76.96, -283.39, -217.89, -264.97, -213.31, -267.14, 40.75, 
    -224.74, -121.93, -212.99, -119.01, -173.24, 64.13, -171.07, -189.93, 
    -151.35, -185.03, -153.87, 109.83, -64.25, 97.80, -37.02, -40.48, 
    -89.11, -53.45, -64.25, 97.80, 
};

static void *image_data1, *image_data2;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* 摜Ǎ */
    image_data1 = GfxGetFreeArea(VGA_WIDTH, VGA_HEIGHT, VGA_BPP<<3);
    GfxFsRead((int8_t*)VGA_NAME, VGA_STRIDE * VGA_HEIGHT, (void*)image_data1);
    image_data2 = GfxGetFreeArea(MASK_WIDTH, MASK_HEIGHT, MASK_BPP<<3);
    GfxFsRead((int8_t*)MASK_NAME, MASK_STRIDE * MASK_HEIGHT, (void*)image_data2);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGPathIuWFNg̐i}XN`j */
    maskpath = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_F, 1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);

    /* VGPathIuWFNgɌ`f[^o^ */
    vgAppendPathData(maskpath, sizeof(mask_cmd), mask_cmd, mask_coord);

    /* VGImageIuWFNg̐i}XN`j */
    maskimg = vgCreateImage(VG_A_8, MASK_WIDTH, MASK_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED | VG_IMAGE_QUALITY_FASTER | VG_IMAGE_QUALITY_BETTER);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(maskimg, image_data2, MASK_STRIDE, VG_A_8, 0, 0, MASK_WIDTH, MASK_HEIGHT);

    /* VGImageIuWFNg̐ */
    image = vgCreateImage(VG_sRGBA_8888, VGA_WIDTH, VGA_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED | VG_IMAGE_QUALITY_FASTER | VG_IMAGE_QUALITY_BETTER);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(image, image_data1, VGA_STRIDE, VG_sRGBA_8888, 0, 0, VGA_WIDTH, VGA_HEIGHT);

    /* IMAGE_USER_TO_SURFACEPʍsɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);
    vgLoadIdentity();
    /* Jg}gNXPATH_USER_TO_SURFACEɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);
    vgLoadIdentity();
}

static void DrawWithMask(VGint width, VGint height)
{
    /* }XNobt@Ƀ}XNp^iVGImagejZbg */
    vgMask(maskimg, VG_SET_MASK, 0, 0, width, height);

    /* }XNobt@Ƀ}XN`iVGPathj */
    vgTranslate(320, 240);
    vgRenderToMask(maskpath, VG_FILL_PATH, VG_UNION_MASK);

    /* At@}XNL */
    vgSeti(VG_MASKING, VG_TRUE);

    /* ` */
    vgDrawImage(image);

    /* At@}XN𖳌 */
    vgSeti(VG_MASKING, VG_FALSE);
}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data1);
    GfxReleaseFreeArea(image_data2);

    /* IuWFNg̔j */
    vgDestroyPath(maskpath);
    vgDestroyImage(maskimg);
    vgDestroyImage(image);
}

void MaskMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* At@}XN */
    DrawWithMask(GFX_WIDTH, GFX_HEIGHT);

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
