/**
 * @brief           EQS Controller
 * @author          AXELL CORPORATION
 * @description     EQS Controller Layer.
 * @note            none
 * @history         2017_09_05  
 * @history         2017_10_26  Ver2.0
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_common.h"

#include "eqs/eqsprm.h"
#include "eqs/eqsctl.h"

/**
 * @brief           EQSW[
 * @param           div [in] 
 * @param           cnt [in] EFCgTCN
 * @return          AG903_ENONE     I
 * @return          -AG903_EINVAL   ُ
 * @description     KEQSCtl֘AAPIɌĂяoĂ.<p>
 *                  ̍Œl 2 ł.<p>
 *                  EFCgTCŃACSMlQ[gAT[g܂ł̍ŏ҂Ԃł.<p>
 *                  ҂Ԃ̒Pʂ̓VXeNbNŁA0ݒ肵ꍇ65536TCNɂȂ܂.<p>
 *                  ̒ʐM[hAG903_EQS_MODE_NORM(SPI[h)ł.
 */
int32_t AG903_EQSCtlInit(uint16_t div, uint16_t cnt)
{
	int32_t			rc        = AG903_ENONE;
	const uint32_t	clk3KHz   = (AG903_EQS_SYS_CLK / (3 * 1000));			/* ŏʐMx	*/
	const uint32_t	clk100MHz = (AG903_EQS_SYS_CLK / (100 * 1000 * 1000));	/* őʐMx	*/

	if ((div > clk3KHz) || (div < clk100MHz)) {
		/* 2ȏłȂ(ʐMx3KHz`100MHzO) */
		rc = -AG903_EINVAL;
	}

	if (rc == AG903_ENONE) {
		AG903_EQSPrmSetMOD(AG903_EQS_MODE_NORM);
		AG903_EQSPrmSetDivide(div);
		AG903_EQSPrmSetWaitCycle(cnt);
	}

	return rc;
}

/**
 * @brief           ʐM[hݒ
 * @param           mode [in] ʐM[h
 * @return          G[R[h
 * @retval          AG903_ENONE     I
 * @retval          -AG903_EINVAL   ُ
 * @description     EQS̒ʐM[hύX܂.<p>
 *                  'AG903_EQS_MODE_NORM'=SPI[h, 'AG903_EQS_MODE_QUAD'=SQI[h.
 */
int32_t AG903_EQSCtlSetMode(uint8_t mode)
{
	int32_t		rc = AG903_ENONE;

	if (mode > AG903_EQS_MODE_QUAD) {
		rc = -AG903_EINVAL;
	}

	if (rc == AG903_ENONE) {
		AG903_EQSPrmSetMOD((mode & 0x1));
	}

	return rc;
}

/**
 * @brief           GAAhX擾
 * @param           area [in] EQSGAԍ
 * @param           addr [out] EQSGAAhXi[obt@
 * @return          G[R[h
 * @retval          AG903_ENONE     I
 * @retval          -AG903_EINVAL   ُ
 * @description     w肵GAɑΉAhX擾܂.
 */
int32_t AG903_EQSCtlGetAddress(uint8_t area, uint32_t *addr)
{
	int32_t	rc = AG903_ENONE;

	if ((area >= AG903_EQS_AREA_NUM) || (addr == NULL)) {
		rc = -AG903_EINVAL;
	}

	if (rc == AG903_ENONE) {
		AG903_EQSPrmGetAddress(area, addr);
	}

	return rc;
}

/**
 * @brief           EQSZbgAbv
 * @param           area [in] EQSGAԍ
 * @param           dir [in] I/O
 * @param           format [in] tH[}bg
 * @return          G[R[h
 * @retval          AG903_ENONE     I
 * @retval          -AG903_EINVAL   ُ
 * @description     w肵ANZXẽtH[}bgύX܂.
 */
int32_t AG903_EQSCtlSetup(uint8_t area, uint8_t dir, AG903_EQSCtlFormat *format)
{
	AG903_EQSPrmFormat param;
	int32_t	rc = AG903_ENONE;

	if ((area >= AG903_EQS_AREA_NUM) || (format == NULL)) {
		rc = -AG903_EINVAL;
	}

	if (rc == AG903_ENONE) {
		if (AG903_EQS_DIR_READ == dir) {
			param.command  = format->command;
			param.wait     = format->wait;
			param.data_len = 0;
			param.addr_len = format->addr_len;
			param.flow     = format->flow;
			AG903_EQSPrmSetRdFORMAT(area, &param);
		}
		else {
			param.command  = format->command;
			param.wait     = format->wait;
			param.data_len = format->data_len;
			param.addr_len = format->addr_len;
			param.flow     = format->flow;
			AG903_EQSPrmSetWrFORMAT(area, &param);
		}
	}

	return rc;
}
