/**
 * @brief       OSP Primitive
 * @author      AXELL CORPORATION
 * @description OSP Primitive
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
 * @history     2019_03_08  [SDK2.2] AG903_OSPPrmEnableEventł̐ݒ莞OVFrbgNA悤ɕύX (#2199)
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_common.h"

#include "register/AG903_ospreg.h"
#include "osp/ospprm.h"
#include "osp/ospmgr.h"
#include "osp.h"

/** ʃWX^ANZX}N */
#define	EVENT(R)			(AG903_OSP->R)
/** EVENTnWX^ANZX}N */
#define	EVENTn(N)			*((uint32_t *)AG903_OSP + N)
/** OSPEvt_Type\̂ł̃ANZXp}N */
#define	EVTn(EVT)			((OSPEvt_Type *)(AG903_OSP_BASE + (EVT / 4) * 0x04UL))

/** OSPEVENTWX^\ */
typedef struct _OSPEvt_Type {
	/** ANZXPʋp̒` */
	union {
		uint32_t EVENT;				/** union:32bit			 */

		struct {
			uint32_t VAL0:4;		/** 0:JE^l		 */
			uint32_t OVF0:1;		/** 0:I[o[t[	 */
			uint32_t EN0 :1;		/** 0:JE^L	 */
			uint32_t	 :2;		/**						 */

			uint32_t VAL1:4;		/** 1:JE^l		 */
			uint32_t OVF1:1;		/** 1:I[o[t[	 */
			uint32_t EN1 :1;		/** 1:JE^L	 */
			uint32_t	 :2;		/**						 */
			uint32_t VAL2:4;		/** 2:JE^l		 */
			uint32_t OVF2:1;		/** 2:I[o[t[	 */
			uint32_t EN2 :1;		/** 2:JE^L	 */
			uint32_t	 :2;		/**						 */

			uint32_t VAL3:4;		/** 3:JE^l		 */
			uint32_t OVF3:1;		/** 3:I[o[t[	 */
			uint32_t EN3 :1;		/** 3:JE^L	 */
			uint32_t	 :2;		/**						 */
		};							/** union:rbg		 */
	};
}OSPEvt_Type;

/**
 * @brief           `l
 * @param           ch [in] `l (0`3)
 * @param           en [in] `l (0: 1:L)
 * @return          void
 * @description     `lݒύX܂.<p>
 *                  AG903_OSPn(ch)->CTRL ɃCg܂.
 */
void AG903_OSPPrmCTRL(const uint8_t ch, const uint8_t en)
{
	ASSERT(ch < AG903_OSP_CH_NUM);

	AG903_OSPn(ch)->CTRL = (en << AG903_OSPn_CTRL_EN_POS) & AG903_OSPn_CTRL_EN_MSK;
}

/**
 * @brief           `lDx
 * @param           ch [in] `l (0`3)
 * @param           pri [in] `lDx(0: ` 3:)
 * @return          void
 * @description     `lDx
 *                  AG903_OSPn(ch)->PRIOR ɃCg܂.
 */
void AG903_OSPPrmPRIOR(const uint8_t ch, const uint8_t pri)
{
	ASSERT(ch < AG903_OSP_CH_NUM);
	ASSERT(pri < AG903_OSP_PRI_NUM);

	AG903_OSPn(ch)->PRIOR = (pri << AG903_OSPn_PRIOR_PRIOR_POS) & AG903_OSPn_PRIOR_PRIOR_MSK;
}

/**
 * @brief           FIFO
 * @param           ch [in] `l (0`3)
 * @param           ovf [out] FIFÕI[o[t[ (1:I[o[t[)
 * @param           siz [out] FIFŐ󂫗e
 * @return          void
 * @description     FIFOԂ擾܂.<p>
 *                  AG903_OSPn(ch)->FIFOSTAT 烊[h܂.
 */
void AG903_OSPPrmFIFOSTAT(const uint8_t ch, uint8_t *ovf, uint8_t *siz)
{
	uint32_t	val;

	ASSERT(ch < AG903_OSP_CH_NUM);
	ASSERT(ovf != NULL);
	ASSERT(siz != NULL);

	val  = AG903_OSPn(ch)->FIFOSTAT;
	*ovf = (val & AG903_OSPn_FIFOSTAT_OVF_MSK) >> AG903_OSPn_FIFOSTAT_OVF_POS;
	*siz = (val & AG903_OSPn_FIFOSTAT_SIZE_MSK ) >> AG903_OSPn_FIFOSTAT_SIZE_POS;
}

/**
 * @brief           FIFO
 * @param           ch [in] `l (0`3)
 * @return          void
 * @note            none
 * @description     FIFOݒύX܂.<p>
 *                  AG903_OSPn(ch)->FIFOCTRL ɃCg܂.
 */
void AG903_OSPPrmFIFOCTRL(const uint8_t ch)
{
	ASSERT(ch < AG903_OSP_CH_NUM);

	AG903_OSPn(ch)->FIFOCTRL = AG903_OSPn_FIFOCTRL_CLR_MSK;
}

/**
 * @brief           FIFOf[^
 * @param           ch [in] `l (0`3)
 * @param           dats [in] f[^Xg
 * @param           len [in] f[^TCY
 * @return          void
 * @description     FIFOf[^ɏ݂܂.<p>
 *                  AG903_OSPn(ch)->FIFODT ɃCg܂.
 */
void AG903_OSPPrmFIFODT(const uint8_t ch, const uint32_t *dats, const uint32_t len)
{
	uint32_t	ii;

	ASSERT(ch < AG903_OSP_CH_NUM);
	ASSERT(dats != NULL);

	for (ii = 0;ii < len;ii++) {
		AG903_OSPn(ch)->FIFODT = *dats++;
	}
}

/**
 * @brief           Ԏ擾
 * @param           ch [in] `l (0`3)
 * @param           stat [out] Ԋi[obt@
 * @param           cnt [out] ݃JEgli[obt@
 * @return          void
 * @description     Ԃ擾܂.<p>
 *                  AG903_OSPn(ch)->STAT 烊[h܂.
 */
void AG903_OSPPrmSTAT(const uint8_t ch, uint8_t *stat, uint8_t *cnt)
{
	uint32_t	val;

	ASSERT(ch < AG903_OSP_CH_NUM);
	ASSERT(stat != NULL);
	ASSERT(cnt != NULL);

	val   = AG903_OSPn(ch)->STAT;
	*cnt  = (val & AG903_OSPn_STAT_COUNT_MSK) >> AG903_OSPn_STAT_COUNT_POS;
	*stat = (val & AG903_OSPn_STAT_STAT_MSK) >> AG903_OSPn_STAT_STAT_POS;
}

/**
 * @brief           Cxg
 * @param           evt [in] Cxgԍ
 * @param           en [in] CxgCl[u
 * @param           cnt [in] CxgJE^
 * @return          void
 * @description     eCxg̐ݒύX܂.
 * @note            CxgJE^svȏꍇ0w肵Ă.
 *                  JE^̃I[o[t[̓NA܂.
 */
void AG903_OSPPrmEnableEvent(const uint8_t evt, const uint8_t en, const uint8_t cnt)
{
	uint8_t evtno, regno, ecnt, ovf;

	ASSERT(evt < AG903_OSP_EVENT_NUM);

	regno = evt / 4;
	evtno = evt % 4;								/* YWX^ԍ擾		*/

	uint8_t *reg = (uint8_t *)&EVENTn(regno) + evtno;
	if (en == 0) {
		ecnt = (*reg & AG903_OSP_EVENT0_VAL0_MSK) >> AG903_OSP_EVENT0_VAL0_POS;
		ovf  = (*reg & AG903_OSP_EVENT0_OVF0_MSK) >> AG903_OSP_EVENT0_OVF0_POS;
	} else {
		ecnt = cnt;
		ovf  = 0;
	}
	*reg = ((en << AG903_OSP_EVENT0_EN0_POS) & AG903_OSP_EVENT0_EN0_MSK		)|
		   ((ovf  << AG903_OSP_EVENT0_OVF0_POS) & AG903_OSP_EVENT0_OVF0_MSK )|
		   ((ecnt << AG903_OSP_EVENT0_VAL0_POS) & AG903_OSP_EVENT0_VAL0_MSK	);
}

/**
 * @brief           CxgԎ擾
 * @param           evt [in] Cxgԍ
 * @param           ovf [out] I[o[t[
 * @param           cnt [out] CxgJEg
 * @return          void
 * @description     eCxg̏Ԃ擾܂.
 */
void AG903_OSPPrmGetEventStat(const uint8_t evt, uint8_t *ovf, uint8_t *cnt)
{
	uint8_t		evtno;

	ASSERT(evt < AG903_OSP_EVENT_NUM);
	ASSERT(ovf != NULL);
	ASSERT(cnt != NULL);

	evtno = evt % 4;								/* YWX^ԍ擾		*/

	switch (evtno) {
		case  0:
			*ovf = EVTn(evt)->OVF0;
			*cnt = EVTn(evt)->VAL0;
			break;

		case  1:
			*ovf = EVTn(evt)->OVF1;
			*cnt = EVTn(evt)->VAL1;
			break;

		case  2:
			*ovf = EVTn(evt)->OVF2;
			*cnt = EVTn(evt)->VAL2;
			break;

		case  3:
			*ovf = EVTn(evt)->OVF3;
			*cnt = EVTn(evt)->VAL3;
			break;
	}
}

/**
 * @brief           tOZbg
 * @param           flag [in] tOԍ(rbg)
 * @return          void
 * @description     '1b'w肵rbgɊYtOtOZbg܂.
 */
void AG903_OSPPrmFLAGSET(const uint32_t flag)
{
	EVENT(FLAGSET) = (flag << AG903_OSP_FLAGSET_F_POS) & AG903_OSP_FLAGSET_F_MSK;
}

/**
 * @brief           tONA
 * @param           flag [in] tOԍ(rbg)
 * @return          void
 * @description     '1b'w肵rbgɊYtONA܂.
 */
void AG903_OSPPrmFLAGCLR(const uint32_t flag)
{
	EVENT(FLAGCLR) = (flag << AG903_OSP_FLAGCLR_F_POS) & AG903_OSP_FLAGCLR_F_MSK;
}

/**
 * @brief           tO
 * @param           val [out] tO̒l(0:OFF 1:ON)
 * @return          void
 * @description     etȌԂ擾܂.
 */
void AG903_OSPPrmFLAGSTAT(uint32_t *val)
{
	ASSERT(val != NULL);

	*val = (EVENT(FLAGSTAT) & AG903_OSP_FLAGSTAT_F_MSK) >> AG903_OSP_FLAGSTAT_F_POS;
}
