/** 
 * @brief           USBH MSC Osutils Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC Osutils Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
 
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_MSC_OSUTILS_H__
#define __USB_MSC_OSUTILS_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_msc_coreinclude.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern void *MscUtils_Malloc(uhs_size_t nSize);
extern uhs_boolean_t MscUtils_Free(void *pMem);

extern kernel_context_t *MscUtils_CreateSemaphore(kernel_context_t *pSem, uhs_index_t num, uhs_index_t init);
extern uhs_boolean_t MscUtils_DeleteSemaphore(kernel_context_t *pSem);
extern uhs_status_t MscUtils_AcquisitionSemaphore(kernel_context_t *pSem, uhs_ubit32_t u32Timeout);
extern uhs_status_t MscUtils_ReleaseSemaphore(kernel_context_t *pSem);

extern kernel_context_t *MscUtils_CreateEvent(kernel_context_t* pEvent, uhs_boolean_t bInit);
extern uhs_boolean_t MscUtils_DeleteEvent(kernel_context_t *pEvent);
extern uhs_status_t MscUtils_SetEvent(kernel_context_t *pEvent);
extern uhs_status_t MscUtils_WaitEvent(kernel_context_t *pEvent, uhs_ubit32_t u32Timeout);


/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_MSC_OSUTILS_H__ */
