/** 
 * @brief           USBH MSC Scsicmd Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC Scsicmd Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_MSC_SCSICMD_H__
#define __USB_MSC_SCSICMD_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_msc_coreinclude.h"
#include "usb_msc_param.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
enum ScsiCommand {
    SCSI_INQUIRY = 0x12,
    SCSI_REQUEST_SENSE = 0x03,
    SCSI_READ_CAPACITY = 0x25,
    SCSI_READ_FORMAT_CAPACITIES = 0x23,
    SCSI_TEST_UNIT_READY = 0x00,
    SCSI_READ10 = 0x28,
    SCSI_WRITE10 = 0x2a,
	SCSI_START_STOP_UNIT = 0x1b
};

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern USB_SCSI_STATUS Usbh_Stor_ScsiCmd_Inquiry( STOR_UNIT *pStorUnit, uhs_ubit8_t *pDataBuf, uhs_ubit16_t u16DataLen, uhs_ubit8_t u8EVPD, uhs_ubit8_t u8PageCode, uhs_ubit8_t u8AllocationLength );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCmd_RequestSense( STOR_UNIT *pStorUnit, uhs_ubit8_t *pDataBuf, uhs_ubit16_t u16DataLen, uhs_ubit8_t u8AllocationLength );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCmd_ReadCapacity( STOR_UNIT *pStorUnit, uhs_ubit8_t *pDataBuf, uhs_ubit16_t u16DataLen, uhs_ubit32_t u32LBA, uhs_ubit8_t u8PMI );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCmd_ReadFormatCapacities( STOR_UNIT *pStorUnit, uhs_ubit8_t *pDataBuf, uhs_ubit16_t u16DataLen, uhs_ubit16_t u16AllocationLength );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCmd_TestUnitReady( STOR_UNIT *pStorUnit );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCmd_Read10( STOR_UNIT *pStorUnit, uhs_ubit8_t *pDataBuf, uhs_ubit32_t u32DataLen, uhs_ubit8_t u8FUA, uhs_ubit32_t u32LBA, uhs_ubit16_t u16BlockCnt );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCmd_Write10( STOR_UNIT *pStorUnit, uhs_ubit8_t *pDataBuf, uhs_ubit32_t u32DataLen, uhs_ubit8_t u8FUA, uhs_ubit32_t u32LBA, uhs_ubit16_t u16BlockCnt );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCmd_StartStopUnit( STOR_UNIT *pStorUnit, uhs_ubit8_t u8Immed, uhs_ubit8_t u8LoEj, uhs_ubit8_t u8Start );

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_MSC_SCSICMD_H__ */
