/** 
 * @brief           HCD COM Header
 * @author          AXELL CORPORATION
 * @description     hcd_com.cpwb_
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */




#ifndef __HCD_COM_H__
    #define __HCD_COM_H__


// *************************************************************************************************
//	include
// *************************************************************************************************
#include "usbc_main.h"
#include "usbc_api.h"


// *************************************************************************************************
//	define
// *************************************************************************************************
// HCDʕ o[W
#define HCD_COMMON_MODULE_VERSION       0x0100                  // HCDʕ̃o[W(1.00)
#define HCD_MAX_DRIVERS                 10                      // HCDhCo̍ő吔

// [gnup錾
//#define HUB_DESCRIPTOR_TYPE         0x29
#define HUB_DESCRIPTOR_SIZE         0x6

#define HUB_NOTICE_HUB_CHANGED      0x01
#define HUB_NOTICE_PORT_CHANGED     0x01

#define ROOTHUB_PORT_NUM            0x01                        // [gnũ|[g


struct hcd_driver_info;

// *************************************************************************************************
//	structure
// *************************************************************************************************
typedef uhs_status_t (*Hcd_OpenPipe_t)(struct usb_control_block * ucb);                 // pCvI[v֐|C^
typedef uhs_status_t (*Hcd_ClosePipe_t)(struct usb_control_block * ucb);                // pCvN[Y֐|C^
typedef uhs_status_t (*Hcd_TransReq_t)(struct usb_control_block * ucb);                 // ]vAPI֐|C^
typedef uhs_status_t (*Hcd_TransStopReq_t)(struct usb_control_block * ucb);             // ]~vAPI֐|C^
typedef uhs_ubit32_t (*Hcd_GetFrameNo_t)(struct usbd_usb_deviceinfo * usbdev);          // t[ԍ擾API֐|C^
typedef uhs_ubit32_t (*Hcd_GetHcRevision_t)(struct usbd_usb_deviceinfo * usbdev);       // HCrWԍ擾֐|C^
typedef uhs_status_t (*Hcd_DevAttach_t)(struct usbd_usb_deviceinfo * usbdev);           // USBfoCXڑAHCL̐ݒ{
typedef void         (*Hcd_DevDisConnect_t)(struct usbd_usb_deviceinfo * usbdev);       // USBfoCXؒfAHCL̐ݒ{
typedef uhs_status_t (*drv_hcd_attach_callback_t)(struct hcd_driver_info *hcd_reg, void * base_addr);   // zXgRg[̃R[obN
typedef uhs_status_t (*drv_hcd_detach_callback_t)(struct hcd_driver_info *hcd_reg);     // zXgRg[IpR[obN
typedef uhs_status_t (*Hcd_ResetController_t)( struct usbd_usb_deviceinfo * usbdev );   // HC RESETvAPI֐|C^
typedef uhs_status_t (*Hcd_NotifyStartSuspend)( struct usbd_usb_deviceinfo * usbdev );	//	SuspendJnʒm
typedef uhs_status_t (*Hcd_NotifyFinishSuspend)( struct usbd_usb_deviceinfo * usbdev );	//	SuspendIʒm

// HCDi[\
struct hcd_info {

    Hcd_OpenPipe_t					open_pipe;                              // pCvI[v֐|C^
    Hcd_ClosePipe_t					close_pipe;                             // pCvN[Y֐|C^
    Hcd_TransReq_t					trans_req;                              // ]vAPI֐|C^
    Hcd_TransStopReq_t				trans_end_req;                          // ]~vAPI֐|C^

    Hcd_GetFrameNo_t				get_frame_no;                           // t[ԍ擾API֐|C^
    Hcd_GetHcRevision_t				get_revision;                           // HCrWԍ擾֐|C^
    Hcd_DevAttach_t					dev_attach;                             // USBfoCXڑAHCL̐ݒ{
    Hcd_DevDisConnect_t				dev_detach;                             // USBfoCXؒfAHCL̐ݒ{
    struct usbd_usb_deviceinfo		*root_hub_dev;                   		// [gnũfoCX\̊i[

	Hcd_NotifyStartSuspend			start_suspend;							//	SuspendJniHUBȊO̒ʐMREQ NGj
	Hcd_NotifyFinishSuspend			finish_suspend;							//	SuspendIiSʐMREQ OKj

    void 							* hcd;                                  // HCefohAhXi[|C^

	//	root_hubp
    Hcd_OpenPipe_t					rh_open_pipe;                           // pCvI[v֐|C^
    Hcd_ClosePipe_t					rh_close_pipe;                          // pCvN[Y֐|C^
    Hcd_TransReq_t					rh_trans_req;                           // ]vAPI֐|C^
    Hcd_TransStopReq_t				rh_trans_end_req;                       // ]~vAPI֐|C^

	Hcd_ResetController_t			rh_reset_hc;							// Reset HC

};



// HCDhCoe[u
struct hcd_driver_ids{      // __st__
    uhs_ubit8_t     class_id;                                   // NXR[h
        #define SERIAL_BUS_CONTROLLER   0x0c                        // VAӃoXRg[
    uhs_ubit8_t     subclass_id;                                // TuNXR[h
        #define USB_BUS_CONTROLLER      0x03                        // USBRg[
    uhs_ubit8_t     interface_id;                               // vOEC^[tF[X
        #define USB_UHCI_CONTROLLER     0x00                        // UHCIzXgRg[
        #define USB_OHCI_CONTROLLER     0x10                        // OHCIzXgRg[
        #define USB_EHCI_CONTROLLER     0x20                        // EHCIzXgRg[
};


// HCDhCoo^p\
struct hcd_driver_info{     // __st__
    // ΉfoCX
    struct hcd_driver_ids           id_table;
    // ΉfoCXR[obN
    drv_hcd_attach_callback_t       attach;     // foCXڑɃR[R[obN֐
    // ΉfoCXIR[obN
    drv_hcd_detach_callback_t       detach;     // IɃR[R[obN֐
    // ReLXg
    void *                          context;    // ɐݒ肵AIɗpB
};


struct root_hub{                    // __st__
    enum usb_state{
        USB_DEFAULT = 0,
        USB_ADDRESS,
        USB_CONFIGURED
    }device_state;                                          // Default, Addressed, ConfiguredԂi[

    uhs_ubit32_t    config_value;                           // Configurationli[
};


#endif	//  __HCD_COM_H__

