/** 
 * @brief           Info Header
 * @author          AXELL CORPORATION
 * @description     OSŗL`wb_B
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/

#ifndef __DEPEND_KERNEL_INFO_H__
#define __DEPEND_KERNEL_INFO_H__

// *************************************************************************************************
//	include
// *************************************************************************************************
#include	"depend_cfg.h"
#include	"uhs_type.h"
#include	<kernel.h>


// *************************************************************************************************
//	define
// *************************************************************************************************
/*------------------------------------------------------------------------------
 * bp[
 *------------------------------------------------------------------------------*/
#define WRAPPER_MEM     struct { ID mplid; INT blksz;}
#define WRAPPER_SEM     struct { T_CSEM sem; ID semid;}
#define WRAPPER_EVT     struct { T_CFLG flg; ID flgid;}
#define WRAPPER_DTQ     struct { T_CDTQ dtq; ID dtqid;}
#define WRAPPER_CYC     struct { T_CCYC ccyc; ID cycid;}
#define WRAPPER_TSK     struct { T_CTSK tsk; ID tskid; void* context;}
#define WRAPPER_CONFIG  struct{ struct { T_CMPL mpl; ID mplid;}mem;}
#define WRAPPER_MESSAGE struct{ T_CMBX mbx; ID mbxid;}
#define WRAPPER_TIM     struct { void* dummy;}


// *************************************************************************************************
//	structure
// *************************************************************************************************
/*------------------------------------------------------------------------------
 * OSŗL \̐錾
 *------------------------------------------------------------------------------*/
struct kernel_info_memory
{
    WRAPPER_MEM                     control;
};

struct kernel_info_semaphore
{
    WRAPPER_SEM                     control;
};

struct kernel_info_event
{
    WRAPPER_EVT                     control;
};

struct kernel_info_dataqueue
{
    WRAPPER_DTQ                     control;
};

struct kernel_info_cyclehnd
{
    WRAPPER_CYC                     control;
};

struct kernel_info_thread
{
    WRAPPER_TSK                     control;
};

struct kernel_info_config
{
    WRAPPER_CONFIG                  control;
    void*                           context;
};

struct kernel_info_message
{
    WRAPPER_MESSAGE                 control;
};

struct kernel_info_timer
{
    WRAPPER_TIM                     control;
};

#endif /* __DEPEND_KERNEL_INFO_H__ */
