/**
 * @brief           Movie Player Sample t@CC^tF[X
 * @author          AXELL CORPORATION
 * @description     MPS̃t@CVXepC^tF[X
 * @note            G[R[hAG903_error.hQƂ̂.
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2019_03_08  [SDK2.2] MPSłGVDT[`W̐ݒɂăfR[_IȂȂsC (#2449)
 */

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

/* DOM-IGNORE-BEGIN */
#ifndef __MPS_FILEIO_H_
#define __MPS_FILEIO_H_
/* DOM-IGNORE-END */

#include <gvd/gvd_extern.h>
#include "mps/mps_api.h"

/** Xg[ɕtf[^TCY */
#define MPS_STREAM_TRAILING_BYTE 5

int32_t *mps_fopen(const char *filename, const char *mode);
int32_t mps_fclose(int32_t *stream);
size_t mps_fread(void *ptr, size_t size, size_t nmemb, int32_t *stream);
size_t mps_fwrite(const void *ptr, size_t size, size_t nmemb, int32_t *stream);
int32_t mps_ferror(void);
int32_t mps_fseek(int32_t *stream, long offset, int32_t from);

/* GVD File interfaces */
gvdError gvdFileInitialize(gvdFile gvdfile);
gvdError gvdFileOpen(gvdFile gvdfile, const char *filename);
gvdError gvdFileRead(gvdFile gvdfile, void *buf, size_t rdsize, size_t *actual_rdsize);
bool gvdFileIsEOF(gvdFile gvdfile);
gvdError gvdFileSeekAbs(gvdFile gvdfile, gvdFilePos pos);
gvdError gvdFileClose(gvdFile gvdfile);
gvdError gvdFileFinalize(gvdFile gvdfile);


#endif /* __MPS_FILEIO_H_ */
