/**
 * @brief           Movie Player Sample f[^^
 * @author          AXELL CORPORATION
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2019_03_08  [SDK2.2] MPSłGVDT[`W̐ݒɂăfR[_IȂȂsC (#2449)
 * @description     MPS̃}NAf[^^`
 * @note            G[R[hAG903_error.hQƂ̂.
 */

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

/* DOM-IGNORE-BEGIN */
#ifndef __MPS_TYPE_H_
#define __MPS_TYPE_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include <gvd/gvd.h>
#include <AG903_errno.h>

/** t@C̍ő咷 */
#define MPS_MAX_FILENAME_LENGTH 256

/** {bNX^Cv 'mdat' */
#define MPS_BOX_TYPE_MDAT (0x6D646174)
/** {bNX^Cv 'moov' */
#define MPS_BOX_TYPE_MOOV (0x6D6F6F76)
/** {bNX^Cv 'mvhd' */
#define MPS_BOX_TYPE_MVHD (0x6D766864)
/** {bNX^Cv 'trak' */
#define MPS_BOX_TYPE_TRAK (0x7472616B)
/** {bNX^Cv 'mdia' */
#define MPS_BOX_TYPE_MDIA (0x6D646961)
/** {bNX^Cv 'mdhd' */
#define MPS_BOX_TYPE_MDHD (0x6D646864)
/** {bNX^Cv 'minf' */
#define MPS_BOX_TYPE_MINF (0x6D696E66)
/** {bNX^Cv 'stbl' */
#define MPS_BOX_TYPE_STBL (0x7374626C)
/** {bNX^Cv 'stsd' */
#define MPS_BOX_TYPE_STSD (0x73747364)
/** {bNX^Cv 'avc1' */
#define MPS_BOX_TYPE_AVC1 (0x61766331)
/** {bNX^Cv 'avcC' */
#define MPS_BOX_TYPE_AVCC (0x61766343)
/** {bNX^Cv 'stts' */
#define MPS_BOX_TYPE_STTS (0x73747473)
/** {bNX^Cv 'stss' */
#define MPS_BOX_TYPE_STSS (0x73747373)
/** {bNX^Cv 'stsc' */
#define MPS_BOX_TYPE_STSC (0x73747363)
/** {bNX^Cv 'stsz' */
#define MPS_BOX_TYPE_STSZ (0x7374737A)
/** {bNX^Cv 'stco' */
#define MPS_BOX_TYPE_STCO (0x7374636F)

/** avc1擪avcC̃ItZbg */
#define MPS_BOX_AVCC_OFFSET_FROM_AVC1 86

/** MPS̏p[^ */
typedef struct
{
    uint32_t max_stream;                /** ő哯ĐXg[ */
    uint32_t stream_buffer_size;        /** Xg[obt@TCY */
    uintptr_t stream_buffer_num;        /** Xg[obt@ */
    gvdCbFunc func_decode_done_handler; /** fR[hR[obNnh */
	gvdCbFunc func_fatalerror_handler; /** vIG[R[obNnh */
}mpsSetting;

/** GVD̏p[^ */
typedef struct
{
    void *memory_work_top;             /** GVD[NRAM̈擪AhX */
    uint32_t memory_work_size;         /** GVD[NRAM̈TCY<p> \
									       Q:MPS_GetRequiredWorkMemorySize */
    void *memory_heap_top;             /** GVDq[vRAM̈擪AhX */
    uint32_t memory_heap_size;         /** GVDq[vRAM̈TCY */
    gvdOutMod output_select;           /** GVDo͐I */
    uint32_t num_out_buffer;           /** o̓obt@̒i */
}mpsConfig;

/** 񓯊ptO */
typedef struct
{
    bool bInitialized;     /** tO */
    bool bParsed;          /** MP4Rei͊tO */
    bool bOpened;          /** I[vtO */
    bool bPlayAccepted;    /** ĐttO */
    bool bPaused;          /** ꎞ~tO */
    bool bSought;          /** V[NtO */
    bool bRewindAccepted;  /** ߂ttO */
    bool bRewindDone;      /** ߂tO */
    bool bForwardAccepted; /** ttO */
    bool bDecDone;         /** fR[htO */
    bool bClosed;          /** N[YtO */
    bool bFinalized;       /** ItO */
}mpsAsyncFlag;

/** MP4Rei */
typedef struct
{
    uint32_t profile;        /** H.264 vt@C */
    uint32_t level;          /** H.264 x */
    uint32_t total_frame;    /** t[ */
    uint32_t height;         /** t[[pixel] */
    uint32_t width;          /** t[[pixel] */
    uint32_t stream_size;    /** Xg[TCY[Byte] */
    uint32_t time_scale;     /** TvOg (mdhd) */
    uint32_t duration;       /** [sample] (mdhd) */
    uint32_t frame_length;   /** t[ĐԊu[ms] (stts) */
    uint32_t max_ref_frames; /** őQƃt[ (avcC) */
    uint32_t keyframe_count; /** IDRt[ (stss) */
    uint32_t *keyframe;      /** IDRt[Xg (stss) */
    uint32_t position_count; /** ʒuobt@vf */
    gvdPositionBuffer *position_buf;  /** ʒuobt@(GVDp) */
}mpsMovieInfo;

/** ReLXg */
typedef struct
{
    int32_t id;         /** ReLXgID */
    int32_t *fp;        /** t@C|C^ */
    uint32_t filesize;  /** t@CTCY */
    gvdContext *gvdctx; /** GVDReLXg\ */
    mpsAsyncFlag flag;  /** 񓯊ntOQ */
    mpsMovieInfo info;  /** t@C\ */
    char filename[MPS_MAX_FILENAME_LENGTH]; /** t@CpX */
}mpsContext;

/** BoxItZbg */
typedef struct
{
    uint32_t mdat; /** stream data */
    uint32_t mvhd; /** ms-unit duration(for sync?) */
    uint32_t mdhd; /** timescale, duration */
    uint32_t avc1; /** width, height */
    uint32_t avcC; /** profile, level, refs */
    uint32_t stts; /** frame length[sample] */
    uint32_t stss; /** IDR-Frame numbers */
    uint32_t stsc; /** chunk info */
    uint32_t stsz; /** sample size */
    uint32_t stco; /** chunk offset */
}mpsInfoPos;

/** t[ԍƃXg[ʒȗΉ */
typedef struct
{
    uint32_t frame_id; /** t[ԍ */
    uint32_t pos;      /** Xg[ItZbg */
}mpsFramePos;

/** o̓obt@ */
typedef gvdOutBufInfo mpsOutBufInfo;

/** V[N */
typedef enum {
    MPS_SEEK_INDEX,          /** ʒuP */
    MPS_SEEK_RELATIVE_INDEX, /** ʒuPʁi΁j */
    MPS_SEEK_FRAME,          /** t[P */
    MPS_SEEK_TIME,           /** ԒP */
}mpsSeekMode;

/** AVCwb_ */
typedef struct
{
    uint32_t size; /** datãTCY */
    uint8_t *data; /** wb_ */
}mpsAVCHeader;

#endif /* __MPS_TYPE_H_ */
