/**
 * @brief           PBD Register Definition
 * @author          AXELL CORPORATION
 * @description     PBD Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_PBD_REGMAP_H_
#define _AG903_PBD_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** PBD Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CONFIG;

        struct {
            __IO uint32_t  W32_L                          :  1;
            __IO uint32_t  BED_L                          :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  RW0_L                          :  1;
            __IO uint32_t  RW1_L                          :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  W32_U                          :  1;
            __IO uint32_t  BED_U                          :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  RW0_U                          :  1;
            __IO uint32_t  RW1_U                          :  1;
        } CONFIG_bits;
    };

    union {
        __IO uint32_t  WAITDLY;

        struct {
            __IO uint32_t  DLY                            :  3;
        } WAITDLY_bits;
    };

    union {
        __IO uint32_t  MAPCS0;
    };

    union {
        __IO uint32_t  MAPCS1;
    };

    union {
        __IO uint32_t  WAITCTRL;

        struct {
            __IO uint32_t  EN                             :  1;
            __IO uint32_t  OD                             :  1;
            __IO uint32_t  POL                            :  1;
        } WAITCTRL_bits;
    };

    union {
        __IO uint32_t  DMACTRL;

        struct {
            __IO uint32_t  EN                             :  1;
            __IO uint32_t  DCK                            :  1;
            __IO uint32_t  DRQ                            :  1;
        } DMACTRL_bits;
    };

    union {
        __IO uint32_t  INTMSK;

        struct {
            __IO uint32_t  INT0                           :  1;
            __IO uint32_t  INT1                           :  1;
        } INTMSK_bits;
    };

    union {
        __IO uint32_t  INTPOL;

        struct {
            __IO uint32_t  INT0                           :  1;
            __IO uint32_t  INT1                           :  1;
        } INTPOL_bits;
    };

    union {
        __I  uint32_t  IRQMON0;

        struct {
            __I  uint32_t  IRQ0                           :  2;
            __I  uint32_t  IRQ1                           :  2;
            __I  uint32_t  IRQ2                           :  2;
            __I  uint32_t  IRQ3                           :  2;
            __I  uint32_t  IRQ4                           :  2;
            __I  uint32_t  IRQ5                           :  2;
            __I  uint32_t  IRQ6                           :  2;
            __I  uint32_t  IRQ7                           :  2;
            __I  uint32_t  IRQ8                           :  2;
            __I  uint32_t  IRQ9                           :  2;
            __I  uint32_t  IRQ10                          :  2;
            __I  uint32_t  IRQ11                          :  2;
            __I  uint32_t  IRQ12                          :  2;
            __I  uint32_t  IRQ13                          :  2;
            __I  uint32_t  IRQ14                          :  2;
            __I  uint32_t  IRQ15                          :  2;
        } IRQMON0_bits;
    };

    union {
        __I  uint32_t  IRQMON1;

        struct {
            __I  uint32_t  IRQ16                          :  2;
            __I  uint32_t  IRQ17                          :  2;
            __I  uint32_t  IRQ18                          :  2;
            __I  uint32_t  IRQ19                          :  2;
            __I  uint32_t  IRQ20                          :  2;
            __I  uint32_t  IRQ21                          :  2;
            __I  uint32_t  IRQ22                          :  2;
            __I  uint32_t  IRQ23                          :  2;
            __I  uint32_t  IRQ24                          :  2;
            __I  uint32_t  IRQ25                          :  2;
            __I  uint32_t  IRQ26                          :  2;
            __I  uint32_t  IRQ27                          :  2;
            __I  uint32_t  IRQ28                          :  2;
            __I  uint32_t  IRQ29                          :  2;
            __I  uint32_t  IRQ30                          :  2;
            __I  uint32_t  IRQ31                          :  2;
        } IRQMON1_bits;
    };

    union {
        __I  uint32_t  IRQMON2;

        struct {
            __I  uint32_t  IRQ32                          :  2;
            __I  uint32_t  IRQ33                          :  2;
            __I  uint32_t  IRQ34                          :  2;
            __I  uint32_t  IRQ35                          :  2;
            __I  uint32_t  IRQ36                          :  2;
            __I  uint32_t  IRQ37                          :  2;
            __I  uint32_t  IRQ38                          :  2;
            __I  uint32_t  IRQ39                          :  2;
            __I  uint32_t  IRQ40                          :  2;
            __I  uint32_t  IRQ41                          :  2;
            __I  uint32_t  IRQ42                          :  2;
            __I  uint32_t  IRQ43                          :  2;
            __I  uint32_t  IRQ44                          :  2;
            __I  uint32_t  IRQ45                          :  2;
            __I  uint32_t  IRQ46                          :  2;
            __I  uint32_t  IRQ47                          :  2;
        } IRQMON2_bits;
    };

    union {
        __I  uint32_t  IRQMON3;

        struct {
            __I  uint32_t  IRQ48                          :  2;
            __I  uint32_t  IRQ49                          :  2;
            __I  uint32_t  IRQ50                          :  2;
            __I  uint32_t  IRQ51                          :  2;
            __I  uint32_t  IRQ52                          :  2;
            __I  uint32_t  IRQ53                          :  2;
            __I  uint32_t  IRQ54                          :  2;
            __I  uint32_t  IRQ55                          :  2;
            __I  uint32_t  IRQ56                          :  2;
            __I  uint32_t  IRQ57                          :  2;
            __I  uint32_t  IRQ58                          :  2;
            __I  uint32_t  IRQ59                          :  2;
            __I  uint32_t  IRQ60                          :  2;
            __I  uint32_t  IRQ61                          :  2;
            __I  uint32_t  IRQ62                          :  2;
            __I  uint32_t  IRQ63                          :  2;
        } IRQMON3_bits;
    };

    union {
        __IO uint32_t  IRQSEL0;

        struct {
            __IO uint32_t  IRQ0                           :  2;
            __IO uint32_t  IRQ1                           :  2;
            __IO uint32_t  IRQ2                           :  2;
            __IO uint32_t  IRQ3                           :  2;
            __IO uint32_t  IRQ4                           :  2;
            __IO uint32_t  IRQ5                           :  2;
            __IO uint32_t  IRQ6                           :  2;
            __IO uint32_t  IRQ7                           :  2;
            __IO uint32_t  IRQ8                           :  2;
            __IO uint32_t  IRQ9                           :  2;
            __IO uint32_t  IRQ10                          :  2;
            __IO uint32_t  IRQ11                          :  2;
            __IO uint32_t  IRQ12                          :  2;
            __IO uint32_t  IRQ13                          :  2;
            __IO uint32_t  IRQ14                          :  2;
            __IO uint32_t  IRQ15                          :  2;
        } IRQSEL0_bits;
    };

    union {
        __IO uint32_t  IRQSEL1;

        struct {
            __IO uint32_t  IRQ16                          :  2;
            __IO uint32_t  IRQ17                          :  2;
            __IO uint32_t  IRQ18                          :  2;
            __IO uint32_t  IRQ19                          :  2;
            __IO uint32_t  IRQ20                          :  2;
            __IO uint32_t  IRQ21                          :  2;
            __IO uint32_t  IRQ22                          :  2;
            __IO uint32_t  IRQ23                          :  2;
            __IO uint32_t  IRQ24                          :  2;
            __IO uint32_t  IRQ25                          :  2;
            __IO uint32_t  IRQ26                          :  2;
            __IO uint32_t  IRQ27                          :  2;
            __IO uint32_t  IRQ28                          :  2;
            __IO uint32_t  IRQ29                          :  2;
            __IO uint32_t  IRQ30                          :  2;
            __IO uint32_t  IRQ31                          :  2;
        } IRQSEL1_bits;
    };

    union {
        __IO uint32_t  IRQSEL2;

        struct {
            __IO uint32_t  IRQ32                          :  2;
            __IO uint32_t  IRQ33                          :  2;
            __IO uint32_t  IRQ34                          :  2;
            __IO uint32_t  IRQ35                          :  2;
            __IO uint32_t  IRQ36                          :  2;
            __IO uint32_t  IRQ37                          :  2;
            __IO uint32_t  IRQ38                          :  2;
            __IO uint32_t  IRQ39                          :  2;
            __IO uint32_t  IRQ40                          :  2;
            __IO uint32_t  IRQ41                          :  2;
            __IO uint32_t  IRQ42                          :  2;
            __IO uint32_t  IRQ43                          :  2;
            __IO uint32_t  IRQ44                          :  2;
            __IO uint32_t  IRQ45                          :  2;
            __IO uint32_t  IRQ46                          :  2;
            __IO uint32_t  IRQ47                          :  2;
        } IRQSEL2_bits;
    };

    union {
        __IO uint32_t  IRQSEL3;

        struct {
            __IO uint32_t  IRQ48                          :  2;
            __IO uint32_t  IRQ49                          :  2;
            __IO uint32_t  IRQ50                          :  2;
            __IO uint32_t  IRQ51                          :  2;
            __IO uint32_t  IRQ52                          :  2;
            __IO uint32_t  IRQ53                          :  2;
            __IO uint32_t  IRQ54                          :  2;
            __IO uint32_t  IRQ55                          :  2;
            __IO uint32_t  IRQ56                          :  2;
            __IO uint32_t  IRQ57                          :  2;
            __IO uint32_t  IRQ58                          :  2;
            __IO uint32_t  IRQ59                          :  2;
            __IO uint32_t  IRQ60                          :  2;
            __IO uint32_t  IRQ61                          :  2;
            __IO uint32_t  IRQ62                          :  2;
            __IO uint32_t  IRQ63                          :  2;
        } IRQSEL3_bits;
    };

    union {
        __IO uint32_t  MAPMODE;

        struct {
            __IO uint32_t  MODE                           :  1;
        } MAPMODE_bits;
    };

    union {
        __IO uint32_t  TIMEOUTCONFIG;

        struct {
            __IO uint32_t  TIMEOUT                        : 16;
        } TIMEOUTCONFIG_bits;
    };

    union {
        __IO uint32_t  TIMEOUTDEFVAL;
    };

    union {
        __IO uint32_t  TIMEOUTSTATUS;

        struct {
            __IO uint32_t  TS                             :  1;
                 uint32_t                                 :  3;
            __I  uint32_t  RB                             :  1;
            __I  uint32_t  WB                             :  1;
        } TIMEOUTSTATUS_bits;
    };

    union {
        __I  uint32_t  TIMEOUTADR;
    };

/* DOM-IGNORE-END */
}AG903_PBD_Type;

#define AG903_PBD                                ((volatile AG903_PBD_Type *) AG903_PBD_BASE)                            /** PBD Base Address */


#define AG903_PBD_CONFIG_W32_L_POS                         0                                                             /** PBDCONFIG W32_L-bit position */
#define AG903_PBD_CONFIG_W32_L_MSK                         (0x1UL << AG903_PBD_CONFIG_W32_L_POS)                         /** PBDCONFIG W32_L-bit mask */
#define AG903_PBD_CONFIG_BED_L_POS                         1                                                             /** PBDCONFIG BED_L-bit position */
#define AG903_PBD_CONFIG_BED_L_MSK                         (0x1UL << AG903_PBD_CONFIG_BED_L_POS)                         /** PBDCONFIG BED_L-bit mask */
#define AG903_PBD_CONFIG_RW0_L_POS                         8                                                             /** PBDCONFIG RW0_L-bit position */
#define AG903_PBD_CONFIG_RW0_L_MSK                         (0x1UL << AG903_PBD_CONFIG_RW0_L_POS)                         /** PBDCONFIG RW0_L-bit mask */
#define AG903_PBD_CONFIG_RW1_L_POS                         9                                                             /** PBDCONFIG RW1_L-bit position */
#define AG903_PBD_CONFIG_RW1_L_MSK                         (0x1UL << AG903_PBD_CONFIG_RW1_L_POS)                         /** PBDCONFIG RW1_L-bit mask */
#define AG903_PBD_CONFIG_W32_U_POS                         16                                                            /** PBDCONFIG W32_U-bit position */
#define AG903_PBD_CONFIG_W32_U_MSK                         (0x1UL << AG903_PBD_CONFIG_W32_U_POS)                         /** PBDCONFIG W32_U-bit mask */
#define AG903_PBD_CONFIG_BED_U_POS                         17                                                            /** PBDCONFIG BED_U-bit position */
#define AG903_PBD_CONFIG_BED_U_MSK                         (0x1UL << AG903_PBD_CONFIG_BED_U_POS)                         /** PBDCONFIG BED_U-bit mask */
#define AG903_PBD_CONFIG_RW0_U_POS                         24                                                            /** PBDCONFIG RW0_U-bit position */
#define AG903_PBD_CONFIG_RW0_U_MSK                         (0x1UL << AG903_PBD_CONFIG_RW0_U_POS)                         /** PBDCONFIG RW0_U-bit mask */
#define AG903_PBD_CONFIG_RW1_U_POS                         25                                                            /** PBDCONFIG RW1_U-bit position */
#define AG903_PBD_CONFIG_RW1_U_MSK                         (0x1UL << AG903_PBD_CONFIG_RW1_U_POS)                         /** PBDCONFIG RW1_U-bit mask */

#define AG903_PBD_WAITDLY_DLY_POS                          0                                                             /** PBDWAITDLY DLY-bit position */
#define AG903_PBD_WAITDLY_DLY_MSK                          (0x7UL << AG903_PBD_WAITDLY_DLY_POS)                          /** PBDWAITDLY DLY-bit mask */

#define AG903_PBD_MAPCS0_BASE_POS                          0                                                             /** PBDMAPCS0 BASE-bit position */
#define AG903_PBD_MAPCS0_BASE_MSK                          (0xffffffffUL << AG903_PBD_MAPCS0_BASE_POS)                   /** PBDMAPCS0 BASE-bit mask */

#define AG903_PBD_MAPCS1_BASE_POS                          0                                                             /** PBDMAPCS1 BASE-bit position */
#define AG903_PBD_MAPCS1_BASE_MSK                          (0xffffffffUL << AG903_PBD_MAPCS1_BASE_POS)                   /** PBDMAPCS1 BASE-bit mask */

#define AG903_PBD_WAITCTRL_EN_POS                          0                                                             /** PBDWAITCTRL EN-bit position */
#define AG903_PBD_WAITCTRL_EN_MSK                          (0x1UL << AG903_PBD_WAITCTRL_EN_POS)                          /** PBDWAITCTRL EN-bit mask */
#define AG903_PBD_WAITCTRL_OD_POS                          1                                                             /** PBDWAITCTRL OD-bit position */
#define AG903_PBD_WAITCTRL_OD_MSK                          (0x1UL << AG903_PBD_WAITCTRL_OD_POS)                          /** PBDWAITCTRL OD-bit mask */
#define AG903_PBD_WAITCTRL_POL_POS                         2                                                             /** PBDWAITCTRL POL-bit position */
#define AG903_PBD_WAITCTRL_POL_MSK                         (0x1UL << AG903_PBD_WAITCTRL_POL_POS)                         /** PBDWAITCTRL POL-bit mask */

#define AG903_PBD_DMACTRL_EN_POS                           0                                                             /** PBDDMACTRL EN-bit position */
#define AG903_PBD_DMACTRL_EN_MSK                           (0x1UL << AG903_PBD_DMACTRL_EN_POS)                           /** PBDDMACTRL EN-bit mask */
#define AG903_PBD_DMACTRL_DCK_POS                          1                                                             /** PBDDMACTRL DCK-bit position */
#define AG903_PBD_DMACTRL_DCK_MSK                          (0x1UL << AG903_PBD_DMACTRL_DCK_POS)                          /** PBDDMACTRL DCK-bit mask */
#define AG903_PBD_DMACTRL_DRQ_POS                          2                                                             /** PBDDMACTRL DRQ-bit position */
#define AG903_PBD_DMACTRL_DRQ_MSK                          (0x1UL << AG903_PBD_DMACTRL_DRQ_POS)                          /** PBDDMACTRL DRQ-bit mask */

#define AG903_PBD_INTMSK_INT0_POS                          0                                                             /** PBDINTMSK INT0-bit position */
#define AG903_PBD_INTMSK_INT0_MSK                          (0x1UL << AG903_PBD_INTMSK_INT0_POS)                          /** PBDINTMSK INT0-bit mask */
#define AG903_PBD_INTMSK_INT1_POS                          1                                                             /** PBDINTMSK INT1-bit position */
#define AG903_PBD_INTMSK_INT1_MSK                          (0x1UL << AG903_PBD_INTMSK_INT1_POS)                          /** PBDINTMSK INT1-bit mask */

#define AG903_PBD_INTPOL_INT0_POS                          0                                                             /** PBDINTPOL INT0-bit position */
#define AG903_PBD_INTPOL_INT0_MSK                          (0x1UL << AG903_PBD_INTPOL_INT0_POS)                          /** PBDINTPOL INT0-bit mask */
#define AG903_PBD_INTPOL_INT1_POS                          1                                                             /** PBDINTPOL INT1-bit position */
#define AG903_PBD_INTPOL_INT1_MSK                          (0x1UL << AG903_PBD_INTPOL_INT1_POS)                          /** PBDINTPOL INT1-bit mask */

#define AG903_PBD_IRQMON0_IRQ0_POS                         0                                                             /** PBDIRQMON0 IRQ0-bit position */
#define AG903_PBD_IRQMON0_IRQ0_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ0_POS)                         /** PBDIRQMON0 IRQ0-bit mask */
#define AG903_PBD_IRQMON0_IRQ1_POS                         2                                                             /** PBDIRQMON0 IRQ1-bit position */
#define AG903_PBD_IRQMON0_IRQ1_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ1_POS)                         /** PBDIRQMON0 IRQ1-bit mask */
#define AG903_PBD_IRQMON0_IRQ2_POS                         4                                                             /** PBDIRQMON0 IRQ2-bit position */
#define AG903_PBD_IRQMON0_IRQ2_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ2_POS)                         /** PBDIRQMON0 IRQ2-bit mask */
#define AG903_PBD_IRQMON0_IRQ3_POS                         6                                                             /** PBDIRQMON0 IRQ3-bit position */
#define AG903_PBD_IRQMON0_IRQ3_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ3_POS)                         /** PBDIRQMON0 IRQ3-bit mask */
#define AG903_PBD_IRQMON0_IRQ4_POS                         8                                                             /** PBDIRQMON0 IRQ4-bit position */
#define AG903_PBD_IRQMON0_IRQ4_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ4_POS)                         /** PBDIRQMON0 IRQ4-bit mask */
#define AG903_PBD_IRQMON0_IRQ5_POS                         10                                                            /** PBDIRQMON0 IRQ5-bit position */
#define AG903_PBD_IRQMON0_IRQ5_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ5_POS)                         /** PBDIRQMON0 IRQ5-bit mask */
#define AG903_PBD_IRQMON0_IRQ6_POS                         12                                                            /** PBDIRQMON0 IRQ6-bit position */
#define AG903_PBD_IRQMON0_IRQ6_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ6_POS)                         /** PBDIRQMON0 IRQ6-bit mask */
#define AG903_PBD_IRQMON0_IRQ7_POS                         14                                                            /** PBDIRQMON0 IRQ7-bit position */
#define AG903_PBD_IRQMON0_IRQ7_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ7_POS)                         /** PBDIRQMON0 IRQ7-bit mask */
#define AG903_PBD_IRQMON0_IRQ8_POS                         16                                                            /** PBDIRQMON0 IRQ8-bit position */
#define AG903_PBD_IRQMON0_IRQ8_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ8_POS)                         /** PBDIRQMON0 IRQ8-bit mask */
#define AG903_PBD_IRQMON0_IRQ9_POS                         18                                                            /** PBDIRQMON0 IRQ9-bit position */
#define AG903_PBD_IRQMON0_IRQ9_MSK                         (0x3UL << AG903_PBD_IRQMON0_IRQ9_POS)                         /** PBDIRQMON0 IRQ9-bit mask */
#define AG903_PBD_IRQMON0_IRQ10_POS                        20                                                            /** PBDIRQMON0 IRQ10-bit position */
#define AG903_PBD_IRQMON0_IRQ10_MSK                        (0x3UL << AG903_PBD_IRQMON0_IRQ10_POS)                        /** PBDIRQMON0 IRQ10-bit mask */
#define AG903_PBD_IRQMON0_IRQ11_POS                        22                                                            /** PBDIRQMON0 IRQ11-bit position */
#define AG903_PBD_IRQMON0_IRQ11_MSK                        (0x3UL << AG903_PBD_IRQMON0_IRQ11_POS)                        /** PBDIRQMON0 IRQ11-bit mask */
#define AG903_PBD_IRQMON0_IRQ12_POS                        24                                                            /** PBDIRQMON0 IRQ12-bit position */
#define AG903_PBD_IRQMON0_IRQ12_MSK                        (0x3UL << AG903_PBD_IRQMON0_IRQ12_POS)                        /** PBDIRQMON0 IRQ12-bit mask */
#define AG903_PBD_IRQMON0_IRQ13_POS                        26                                                            /** PBDIRQMON0 IRQ13-bit position */
#define AG903_PBD_IRQMON0_IRQ13_MSK                        (0x3UL << AG903_PBD_IRQMON0_IRQ13_POS)                        /** PBDIRQMON0 IRQ13-bit mask */
#define AG903_PBD_IRQMON0_IRQ14_POS                        28                                                            /** PBDIRQMON0 IRQ14-bit position */
#define AG903_PBD_IRQMON0_IRQ14_MSK                        (0x3UL << AG903_PBD_IRQMON0_IRQ14_POS)                        /** PBDIRQMON0 IRQ14-bit mask */
#define AG903_PBD_IRQMON0_IRQ15_POS                        30                                                            /** PBDIRQMON0 IRQ15-bit position */
#define AG903_PBD_IRQMON0_IRQ15_MSK                        (0x3UL << AG903_PBD_IRQMON0_IRQ15_POS)                        /** PBDIRQMON0 IRQ15-bit mask */

#define AG903_PBD_IRQMON1_IRQ16_POS                        0                                                             /** PBDIRQMON1 IRQ16-bit position */
#define AG903_PBD_IRQMON1_IRQ16_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ16_POS)                        /** PBDIRQMON1 IRQ16-bit mask */
#define AG903_PBD_IRQMON1_IRQ17_POS                        2                                                             /** PBDIRQMON1 IRQ17-bit position */
#define AG903_PBD_IRQMON1_IRQ17_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ17_POS)                        /** PBDIRQMON1 IRQ17-bit mask */
#define AG903_PBD_IRQMON1_IRQ18_POS                        4                                                             /** PBDIRQMON1 IRQ18-bit position */
#define AG903_PBD_IRQMON1_IRQ18_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ18_POS)                        /** PBDIRQMON1 IRQ18-bit mask */
#define AG903_PBD_IRQMON1_IRQ19_POS                        6                                                             /** PBDIRQMON1 IRQ19-bit position */
#define AG903_PBD_IRQMON1_IRQ19_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ19_POS)                        /** PBDIRQMON1 IRQ19-bit mask */
#define AG903_PBD_IRQMON1_IRQ20_POS                        8                                                             /** PBDIRQMON1 IRQ20-bit position */
#define AG903_PBD_IRQMON1_IRQ20_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ20_POS)                        /** PBDIRQMON1 IRQ20-bit mask */
#define AG903_PBD_IRQMON1_IRQ21_POS                        10                                                            /** PBDIRQMON1 IRQ21-bit position */
#define AG903_PBD_IRQMON1_IRQ21_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ21_POS)                        /** PBDIRQMON1 IRQ21-bit mask */
#define AG903_PBD_IRQMON1_IRQ22_POS                        12                                                            /** PBDIRQMON1 IRQ22-bit position */
#define AG903_PBD_IRQMON1_IRQ22_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ22_POS)                        /** PBDIRQMON1 IRQ22-bit mask */
#define AG903_PBD_IRQMON1_IRQ23_POS                        14                                                            /** PBDIRQMON1 IRQ23-bit position */
#define AG903_PBD_IRQMON1_IRQ23_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ23_POS)                        /** PBDIRQMON1 IRQ23-bit mask */
#define AG903_PBD_IRQMON1_IRQ24_POS                        16                                                            /** PBDIRQMON1 IRQ24-bit position */
#define AG903_PBD_IRQMON1_IRQ24_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ24_POS)                        /** PBDIRQMON1 IRQ24-bit mask */
#define AG903_PBD_IRQMON1_IRQ25_POS                        18                                                            /** PBDIRQMON1 IRQ25-bit position */
#define AG903_PBD_IRQMON1_IRQ25_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ25_POS)                        /** PBDIRQMON1 IRQ25-bit mask */
#define AG903_PBD_IRQMON1_IRQ26_POS                        20                                                            /** PBDIRQMON1 IRQ26-bit position */
#define AG903_PBD_IRQMON1_IRQ26_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ26_POS)                        /** PBDIRQMON1 IRQ26-bit mask */
#define AG903_PBD_IRQMON1_IRQ27_POS                        22                                                            /** PBDIRQMON1 IRQ27-bit position */
#define AG903_PBD_IRQMON1_IRQ27_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ27_POS)                        /** PBDIRQMON1 IRQ27-bit mask */
#define AG903_PBD_IRQMON1_IRQ28_POS                        24                                                            /** PBDIRQMON1 IRQ28-bit position */
#define AG903_PBD_IRQMON1_IRQ28_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ28_POS)                        /** PBDIRQMON1 IRQ28-bit mask */
#define AG903_PBD_IRQMON1_IRQ29_POS                        26                                                            /** PBDIRQMON1 IRQ29-bit position */
#define AG903_PBD_IRQMON1_IRQ29_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ29_POS)                        /** PBDIRQMON1 IRQ29-bit mask */
#define AG903_PBD_IRQMON1_IRQ30_POS                        28                                                            /** PBDIRQMON1 IRQ30-bit position */
#define AG903_PBD_IRQMON1_IRQ30_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ30_POS)                        /** PBDIRQMON1 IRQ30-bit mask */
#define AG903_PBD_IRQMON1_IRQ31_POS                        30                                                            /** PBDIRQMON1 IRQ31-bit position */
#define AG903_PBD_IRQMON1_IRQ31_MSK                        (0x3UL << AG903_PBD_IRQMON1_IRQ31_POS)                        /** PBDIRQMON1 IRQ31-bit mask */

#define AG903_PBD_IRQMON2_IRQ32_POS                        0                                                             /** PBDIRQMON2 IRQ32-bit position */
#define AG903_PBD_IRQMON2_IRQ32_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ32_POS)                        /** PBDIRQMON2 IRQ32-bit mask */
#define AG903_PBD_IRQMON2_IRQ33_POS                        2                                                             /** PBDIRQMON2 IRQ33-bit position */
#define AG903_PBD_IRQMON2_IRQ33_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ33_POS)                        /** PBDIRQMON2 IRQ33-bit mask */
#define AG903_PBD_IRQMON2_IRQ34_POS                        4                                                             /** PBDIRQMON2 IRQ34-bit position */
#define AG903_PBD_IRQMON2_IRQ34_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ34_POS)                        /** PBDIRQMON2 IRQ34-bit mask */
#define AG903_PBD_IRQMON2_IRQ35_POS                        6                                                             /** PBDIRQMON2 IRQ35-bit position */
#define AG903_PBD_IRQMON2_IRQ35_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ35_POS)                        /** PBDIRQMON2 IRQ35-bit mask */
#define AG903_PBD_IRQMON2_IRQ36_POS                        8                                                             /** PBDIRQMON2 IRQ36-bit position */
#define AG903_PBD_IRQMON2_IRQ36_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ36_POS)                        /** PBDIRQMON2 IRQ36-bit mask */
#define AG903_PBD_IRQMON2_IRQ37_POS                        10                                                            /** PBDIRQMON2 IRQ37-bit position */
#define AG903_PBD_IRQMON2_IRQ37_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ37_POS)                        /** PBDIRQMON2 IRQ37-bit mask */
#define AG903_PBD_IRQMON2_IRQ38_POS                        12                                                            /** PBDIRQMON2 IRQ38-bit position */
#define AG903_PBD_IRQMON2_IRQ38_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ38_POS)                        /** PBDIRQMON2 IRQ38-bit mask */
#define AG903_PBD_IRQMON2_IRQ39_POS                        14                                                            /** PBDIRQMON2 IRQ39-bit position */
#define AG903_PBD_IRQMON2_IRQ39_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ39_POS)                        /** PBDIRQMON2 IRQ39-bit mask */
#define AG903_PBD_IRQMON2_IRQ40_POS                        16                                                            /** PBDIRQMON2 IRQ40-bit position */
#define AG903_PBD_IRQMON2_IRQ40_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ40_POS)                        /** PBDIRQMON2 IRQ40-bit mask */
#define AG903_PBD_IRQMON2_IRQ41_POS                        18                                                            /** PBDIRQMON2 IRQ41-bit position */
#define AG903_PBD_IRQMON2_IRQ41_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ41_POS)                        /** PBDIRQMON2 IRQ41-bit mask */
#define AG903_PBD_IRQMON2_IRQ42_POS                        20                                                            /** PBDIRQMON2 IRQ42-bit position */
#define AG903_PBD_IRQMON2_IRQ42_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ42_POS)                        /** PBDIRQMON2 IRQ42-bit mask */
#define AG903_PBD_IRQMON2_IRQ43_POS                        22                                                            /** PBDIRQMON2 IRQ43-bit position */
#define AG903_PBD_IRQMON2_IRQ43_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ43_POS)                        /** PBDIRQMON2 IRQ43-bit mask */
#define AG903_PBD_IRQMON2_IRQ44_POS                        24                                                            /** PBDIRQMON2 IRQ44-bit position */
#define AG903_PBD_IRQMON2_IRQ44_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ44_POS)                        /** PBDIRQMON2 IRQ44-bit mask */
#define AG903_PBD_IRQMON2_IRQ45_POS                        26                                                            /** PBDIRQMON2 IRQ45-bit position */
#define AG903_PBD_IRQMON2_IRQ45_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ45_POS)                        /** PBDIRQMON2 IRQ45-bit mask */
#define AG903_PBD_IRQMON2_IRQ46_POS                        28                                                            /** PBDIRQMON2 IRQ46-bit position */
#define AG903_PBD_IRQMON2_IRQ46_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ46_POS)                        /** PBDIRQMON2 IRQ46-bit mask */
#define AG903_PBD_IRQMON2_IRQ47_POS                        30                                                            /** PBDIRQMON2 IRQ47-bit position */
#define AG903_PBD_IRQMON2_IRQ47_MSK                        (0x3UL << AG903_PBD_IRQMON2_IRQ47_POS)                        /** PBDIRQMON2 IRQ47-bit mask */

#define AG903_PBD_IRQMON3_IRQ48_POS                        0                                                             /** PBDIRQMON3 IRQ48-bit position */
#define AG903_PBD_IRQMON3_IRQ48_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ48_POS)                        /** PBDIRQMON3 IRQ48-bit mask */
#define AG903_PBD_IRQMON3_IRQ49_POS                        2                                                             /** PBDIRQMON3 IRQ49-bit position */
#define AG903_PBD_IRQMON3_IRQ49_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ49_POS)                        /** PBDIRQMON3 IRQ49-bit mask */
#define AG903_PBD_IRQMON3_IRQ50_POS                        4                                                             /** PBDIRQMON3 IRQ50-bit position */
#define AG903_PBD_IRQMON3_IRQ50_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ50_POS)                        /** PBDIRQMON3 IRQ50-bit mask */
#define AG903_PBD_IRQMON3_IRQ51_POS                        6                                                             /** PBDIRQMON3 IRQ51-bit position */
#define AG903_PBD_IRQMON3_IRQ51_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ51_POS)                        /** PBDIRQMON3 IRQ51-bit mask */
#define AG903_PBD_IRQMON3_IRQ52_POS                        8                                                             /** PBDIRQMON3 IRQ52-bit position */
#define AG903_PBD_IRQMON3_IRQ52_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ52_POS)                        /** PBDIRQMON3 IRQ52-bit mask */
#define AG903_PBD_IRQMON3_IRQ53_POS                        10                                                            /** PBDIRQMON3 IRQ53-bit position */
#define AG903_PBD_IRQMON3_IRQ53_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ53_POS)                        /** PBDIRQMON3 IRQ53-bit mask */
#define AG903_PBD_IRQMON3_IRQ54_POS                        12                                                            /** PBDIRQMON3 IRQ54-bit position */
#define AG903_PBD_IRQMON3_IRQ54_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ54_POS)                        /** PBDIRQMON3 IRQ54-bit mask */
#define AG903_PBD_IRQMON3_IRQ55_POS                        14                                                            /** PBDIRQMON3 IRQ55-bit position */
#define AG903_PBD_IRQMON3_IRQ55_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ55_POS)                        /** PBDIRQMON3 IRQ55-bit mask */
#define AG903_PBD_IRQMON3_IRQ56_POS                        16                                                            /** PBDIRQMON3 IRQ56-bit position */
#define AG903_PBD_IRQMON3_IRQ56_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ56_POS)                        /** PBDIRQMON3 IRQ56-bit mask */
#define AG903_PBD_IRQMON3_IRQ57_POS                        18                                                            /** PBDIRQMON3 IRQ57-bit position */
#define AG903_PBD_IRQMON3_IRQ57_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ57_POS)                        /** PBDIRQMON3 IRQ57-bit mask */
#define AG903_PBD_IRQMON3_IRQ58_POS                        20                                                            /** PBDIRQMON3 IRQ58-bit position */
#define AG903_PBD_IRQMON3_IRQ58_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ58_POS)                        /** PBDIRQMON3 IRQ58-bit mask */
#define AG903_PBD_IRQMON3_IRQ59_POS                        22                                                            /** PBDIRQMON3 IRQ59-bit position */
#define AG903_PBD_IRQMON3_IRQ59_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ59_POS)                        /** PBDIRQMON3 IRQ59-bit mask */
#define AG903_PBD_IRQMON3_IRQ60_POS                        24                                                            /** PBDIRQMON3 IRQ60-bit position */
#define AG903_PBD_IRQMON3_IRQ60_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ60_POS)                        /** PBDIRQMON3 IRQ60-bit mask */
#define AG903_PBD_IRQMON3_IRQ61_POS                        26                                                            /** PBDIRQMON3 IRQ61-bit position */
#define AG903_PBD_IRQMON3_IRQ61_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ61_POS)                        /** PBDIRQMON3 IRQ61-bit mask */
#define AG903_PBD_IRQMON3_IRQ62_POS                        28                                                            /** PBDIRQMON3 IRQ62-bit position */
#define AG903_PBD_IRQMON3_IRQ62_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ62_POS)                        /** PBDIRQMON3 IRQ62-bit mask */
#define AG903_PBD_IRQMON3_IRQ63_POS                        30                                                            /** PBDIRQMON3 IRQ63-bit position */
#define AG903_PBD_IRQMON3_IRQ63_MSK                        (0x3UL << AG903_PBD_IRQMON3_IRQ63_POS)                        /** PBDIRQMON3 IRQ63-bit mask */

#define AG903_PBD_IRQSEL0_IRQ0_POS                         0                                                             /** PBDIRQSEL0 IRQ0-bit position */
#define AG903_PBD_IRQSEL0_IRQ0_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ0_POS)                         /** PBDIRQSEL0 IRQ0-bit mask */
#define AG903_PBD_IRQSEL0_IRQ1_POS                         2                                                             /** PBDIRQSEL0 IRQ1-bit position */
#define AG903_PBD_IRQSEL0_IRQ1_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ1_POS)                         /** PBDIRQSEL0 IRQ1-bit mask */
#define AG903_PBD_IRQSEL0_IRQ2_POS                         4                                                             /** PBDIRQSEL0 IRQ2-bit position */
#define AG903_PBD_IRQSEL0_IRQ2_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ2_POS)                         /** PBDIRQSEL0 IRQ2-bit mask */
#define AG903_PBD_IRQSEL0_IRQ3_POS                         6                                                             /** PBDIRQSEL0 IRQ3-bit position */
#define AG903_PBD_IRQSEL0_IRQ3_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ3_POS)                         /** PBDIRQSEL0 IRQ3-bit mask */
#define AG903_PBD_IRQSEL0_IRQ4_POS                         8                                                             /** PBDIRQSEL0 IRQ4-bit position */
#define AG903_PBD_IRQSEL0_IRQ4_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ4_POS)                         /** PBDIRQSEL0 IRQ4-bit mask */
#define AG903_PBD_IRQSEL0_IRQ5_POS                         10                                                            /** PBDIRQSEL0 IRQ5-bit position */
#define AG903_PBD_IRQSEL0_IRQ5_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ5_POS)                         /** PBDIRQSEL0 IRQ5-bit mask */
#define AG903_PBD_IRQSEL0_IRQ6_POS                         12                                                            /** PBDIRQSEL0 IRQ6-bit position */
#define AG903_PBD_IRQSEL0_IRQ6_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ6_POS)                         /** PBDIRQSEL0 IRQ6-bit mask */
#define AG903_PBD_IRQSEL0_IRQ7_POS                         14                                                            /** PBDIRQSEL0 IRQ7-bit position */
#define AG903_PBD_IRQSEL0_IRQ7_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ7_POS)                         /** PBDIRQSEL0 IRQ7-bit mask */
#define AG903_PBD_IRQSEL0_IRQ8_POS                         16                                                            /** PBDIRQSEL0 IRQ8-bit position */
#define AG903_PBD_IRQSEL0_IRQ8_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ8_POS)                         /** PBDIRQSEL0 IRQ8-bit mask */
#define AG903_PBD_IRQSEL0_IRQ9_POS                         18                                                            /** PBDIRQSEL0 IRQ9-bit position */
#define AG903_PBD_IRQSEL0_IRQ9_MSK                         (0x3UL << AG903_PBD_IRQSEL0_IRQ9_POS)                         /** PBDIRQSEL0 IRQ9-bit mask */
#define AG903_PBD_IRQSEL0_IRQ10_POS                        20                                                            /** PBDIRQSEL0 IRQ10-bit position */
#define AG903_PBD_IRQSEL0_IRQ10_MSK                        (0x3UL << AG903_PBD_IRQSEL0_IRQ10_POS)                        /** PBDIRQSEL0 IRQ10-bit mask */
#define AG903_PBD_IRQSEL0_IRQ11_POS                        22                                                            /** PBDIRQSEL0 IRQ11-bit position */
#define AG903_PBD_IRQSEL0_IRQ11_MSK                        (0x3UL << AG903_PBD_IRQSEL0_IRQ11_POS)                        /** PBDIRQSEL0 IRQ11-bit mask */
#define AG903_PBD_IRQSEL0_IRQ12_POS                        24                                                            /** PBDIRQSEL0 IRQ12-bit position */
#define AG903_PBD_IRQSEL0_IRQ12_MSK                        (0x3UL << AG903_PBD_IRQSEL0_IRQ12_POS)                        /** PBDIRQSEL0 IRQ12-bit mask */
#define AG903_PBD_IRQSEL0_IRQ13_POS                        26                                                            /** PBDIRQSEL0 IRQ13-bit position */
#define AG903_PBD_IRQSEL0_IRQ13_MSK                        (0x3UL << AG903_PBD_IRQSEL0_IRQ13_POS)                        /** PBDIRQSEL0 IRQ13-bit mask */
#define AG903_PBD_IRQSEL0_IRQ14_POS                        28                                                            /** PBDIRQSEL0 IRQ14-bit position */
#define AG903_PBD_IRQSEL0_IRQ14_MSK                        (0x3UL << AG903_PBD_IRQSEL0_IRQ14_POS)                        /** PBDIRQSEL0 IRQ14-bit mask */
#define AG903_PBD_IRQSEL0_IRQ15_POS                        30                                                            /** PBDIRQSEL0 IRQ15-bit position */
#define AG903_PBD_IRQSEL0_IRQ15_MSK                        (0x3UL << AG903_PBD_IRQSEL0_IRQ15_POS)                        /** PBDIRQSEL0 IRQ15-bit mask */

#define AG903_PBD_IRQSEL1_IRQ16_POS                        0                                                             /** PBDIRQSEL1 IRQ16-bit position */
#define AG903_PBD_IRQSEL1_IRQ16_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ16_POS)                        /** PBDIRQSEL1 IRQ16-bit mask */
#define AG903_PBD_IRQSEL1_IRQ17_POS                        2                                                             /** PBDIRQSEL1 IRQ17-bit position */
#define AG903_PBD_IRQSEL1_IRQ17_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ17_POS)                        /** PBDIRQSEL1 IRQ17-bit mask */
#define AG903_PBD_IRQSEL1_IRQ18_POS                        4                                                             /** PBDIRQSEL1 IRQ18-bit position */
#define AG903_PBD_IRQSEL1_IRQ18_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ18_POS)                        /** PBDIRQSEL1 IRQ18-bit mask */
#define AG903_PBD_IRQSEL1_IRQ19_POS                        6                                                             /** PBDIRQSEL1 IRQ19-bit position */
#define AG903_PBD_IRQSEL1_IRQ19_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ19_POS)                        /** PBDIRQSEL1 IRQ19-bit mask */
#define AG903_PBD_IRQSEL1_IRQ20_POS                        8                                                             /** PBDIRQSEL1 IRQ20-bit position */
#define AG903_PBD_IRQSEL1_IRQ20_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ20_POS)                        /** PBDIRQSEL1 IRQ20-bit mask */
#define AG903_PBD_IRQSEL1_IRQ21_POS                        10                                                            /** PBDIRQSEL1 IRQ21-bit position */
#define AG903_PBD_IRQSEL1_IRQ21_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ21_POS)                        /** PBDIRQSEL1 IRQ21-bit mask */
#define AG903_PBD_IRQSEL1_IRQ22_POS                        12                                                            /** PBDIRQSEL1 IRQ22-bit position */
#define AG903_PBD_IRQSEL1_IRQ22_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ22_POS)                        /** PBDIRQSEL1 IRQ22-bit mask */
#define AG903_PBD_IRQSEL1_IRQ23_POS                        14                                                            /** PBDIRQSEL1 IRQ23-bit position */
#define AG903_PBD_IRQSEL1_IRQ23_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ23_POS)                        /** PBDIRQSEL1 IRQ23-bit mask */
#define AG903_PBD_IRQSEL1_IRQ24_POS                        16                                                            /** PBDIRQSEL1 IRQ24-bit position */
#define AG903_PBD_IRQSEL1_IRQ24_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ24_POS)                        /** PBDIRQSEL1 IRQ24-bit mask */
#define AG903_PBD_IRQSEL1_IRQ25_POS                        18                                                            /** PBDIRQSEL1 IRQ25-bit position */
#define AG903_PBD_IRQSEL1_IRQ25_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ25_POS)                        /** PBDIRQSEL1 IRQ25-bit mask */
#define AG903_PBD_IRQSEL1_IRQ26_POS                        20                                                            /** PBDIRQSEL1 IRQ26-bit position */
#define AG903_PBD_IRQSEL1_IRQ26_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ26_POS)                        /** PBDIRQSEL1 IRQ26-bit mask */
#define AG903_PBD_IRQSEL1_IRQ27_POS                        22                                                            /** PBDIRQSEL1 IRQ27-bit position */
#define AG903_PBD_IRQSEL1_IRQ27_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ27_POS)                        /** PBDIRQSEL1 IRQ27-bit mask */
#define AG903_PBD_IRQSEL1_IRQ28_POS                        24                                                            /** PBDIRQSEL1 IRQ28-bit position */
#define AG903_PBD_IRQSEL1_IRQ28_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ28_POS)                        /** PBDIRQSEL1 IRQ28-bit mask */
#define AG903_PBD_IRQSEL1_IRQ29_POS                        26                                                            /** PBDIRQSEL1 IRQ29-bit position */
#define AG903_PBD_IRQSEL1_IRQ29_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ29_POS)                        /** PBDIRQSEL1 IRQ29-bit mask */
#define AG903_PBD_IRQSEL1_IRQ30_POS                        28                                                            /** PBDIRQSEL1 IRQ30-bit position */
#define AG903_PBD_IRQSEL1_IRQ30_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ30_POS)                        /** PBDIRQSEL1 IRQ30-bit mask */
#define AG903_PBD_IRQSEL1_IRQ31_POS                        30                                                            /** PBDIRQSEL1 IRQ31-bit position */
#define AG903_PBD_IRQSEL1_IRQ31_MSK                        (0x3UL << AG903_PBD_IRQSEL1_IRQ31_POS)                        /** PBDIRQSEL1 IRQ31-bit mask */

#define AG903_PBD_IRQSEL2_IRQ32_POS                        0                                                             /** PBDIRQSEL2 IRQ32-bit position */
#define AG903_PBD_IRQSEL2_IRQ32_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ32_POS)                        /** PBDIRQSEL2 IRQ32-bit mask */
#define AG903_PBD_IRQSEL2_IRQ33_POS                        2                                                             /** PBDIRQSEL2 IRQ33-bit position */
#define AG903_PBD_IRQSEL2_IRQ33_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ33_POS)                        /** PBDIRQSEL2 IRQ33-bit mask */
#define AG903_PBD_IRQSEL2_IRQ34_POS                        4                                                             /** PBDIRQSEL2 IRQ34-bit position */
#define AG903_PBD_IRQSEL2_IRQ34_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ34_POS)                        /** PBDIRQSEL2 IRQ34-bit mask */
#define AG903_PBD_IRQSEL2_IRQ35_POS                        6                                                             /** PBDIRQSEL2 IRQ35-bit position */
#define AG903_PBD_IRQSEL2_IRQ35_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ35_POS)                        /** PBDIRQSEL2 IRQ35-bit mask */
#define AG903_PBD_IRQSEL2_IRQ36_POS                        8                                                             /** PBDIRQSEL2 IRQ36-bit position */
#define AG903_PBD_IRQSEL2_IRQ36_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ36_POS)                        /** PBDIRQSEL2 IRQ36-bit mask */
#define AG903_PBD_IRQSEL2_IRQ37_POS                        10                                                            /** PBDIRQSEL2 IRQ37-bit position */
#define AG903_PBD_IRQSEL2_IRQ37_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ37_POS)                        /** PBDIRQSEL2 IRQ37-bit mask */
#define AG903_PBD_IRQSEL2_IRQ38_POS                        12                                                            /** PBDIRQSEL2 IRQ38-bit position */
#define AG903_PBD_IRQSEL2_IRQ38_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ38_POS)                        /** PBDIRQSEL2 IRQ38-bit mask */
#define AG903_PBD_IRQSEL2_IRQ39_POS                        14                                                            /** PBDIRQSEL2 IRQ39-bit position */
#define AG903_PBD_IRQSEL2_IRQ39_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ39_POS)                        /** PBDIRQSEL2 IRQ39-bit mask */
#define AG903_PBD_IRQSEL2_IRQ40_POS                        16                                                            /** PBDIRQSEL2 IRQ40-bit position */
#define AG903_PBD_IRQSEL2_IRQ40_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ40_POS)                        /** PBDIRQSEL2 IRQ40-bit mask */
#define AG903_PBD_IRQSEL2_IRQ41_POS                        18                                                            /** PBDIRQSEL2 IRQ41-bit position */
#define AG903_PBD_IRQSEL2_IRQ41_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ41_POS)                        /** PBDIRQSEL2 IRQ41-bit mask */
#define AG903_PBD_IRQSEL2_IRQ42_POS                        20                                                            /** PBDIRQSEL2 IRQ42-bit position */
#define AG903_PBD_IRQSEL2_IRQ42_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ42_POS)                        /** PBDIRQSEL2 IRQ42-bit mask */
#define AG903_PBD_IRQSEL2_IRQ43_POS                        22                                                            /** PBDIRQSEL2 IRQ43-bit position */
#define AG903_PBD_IRQSEL2_IRQ43_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ43_POS)                        /** PBDIRQSEL2 IRQ43-bit mask */
#define AG903_PBD_IRQSEL2_IRQ44_POS                        24                                                            /** PBDIRQSEL2 IRQ44-bit position */
#define AG903_PBD_IRQSEL2_IRQ44_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ44_POS)                        /** PBDIRQSEL2 IRQ44-bit mask */
#define AG903_PBD_IRQSEL2_IRQ45_POS                        26                                                            /** PBDIRQSEL2 IRQ45-bit position */
#define AG903_PBD_IRQSEL2_IRQ45_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ45_POS)                        /** PBDIRQSEL2 IRQ45-bit mask */
#define AG903_PBD_IRQSEL2_IRQ46_POS                        28                                                            /** PBDIRQSEL2 IRQ46-bit position */
#define AG903_PBD_IRQSEL2_IRQ46_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ46_POS)                        /** PBDIRQSEL2 IRQ46-bit mask */
#define AG903_PBD_IRQSEL2_IRQ47_POS                        30                                                            /** PBDIRQSEL2 IRQ47-bit position */
#define AG903_PBD_IRQSEL2_IRQ47_MSK                        (0x3UL << AG903_PBD_IRQSEL2_IRQ47_POS)                        /** PBDIRQSEL2 IRQ47-bit mask */

#define AG903_PBD_IRQSEL3_IRQ48_POS                        0                                                             /** PBDIRQSEL3 IRQ48-bit position */
#define AG903_PBD_IRQSEL3_IRQ48_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ48_POS)                        /** PBDIRQSEL3 IRQ48-bit mask */
#define AG903_PBD_IRQSEL3_IRQ49_POS                        2                                                             /** PBDIRQSEL3 IRQ49-bit position */
#define AG903_PBD_IRQSEL3_IRQ49_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ49_POS)                        /** PBDIRQSEL3 IRQ49-bit mask */
#define AG903_PBD_IRQSEL3_IRQ50_POS                        4                                                             /** PBDIRQSEL3 IRQ50-bit position */
#define AG903_PBD_IRQSEL3_IRQ50_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ50_POS)                        /** PBDIRQSEL3 IRQ50-bit mask */
#define AG903_PBD_IRQSEL3_IRQ51_POS                        6                                                             /** PBDIRQSEL3 IRQ51-bit position */
#define AG903_PBD_IRQSEL3_IRQ51_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ51_POS)                        /** PBDIRQSEL3 IRQ51-bit mask */
#define AG903_PBD_IRQSEL3_IRQ52_POS                        8                                                             /** PBDIRQSEL3 IRQ52-bit position */
#define AG903_PBD_IRQSEL3_IRQ52_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ52_POS)                        /** PBDIRQSEL3 IRQ52-bit mask */
#define AG903_PBD_IRQSEL3_IRQ53_POS                        10                                                            /** PBDIRQSEL3 IRQ53-bit position */
#define AG903_PBD_IRQSEL3_IRQ53_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ53_POS)                        /** PBDIRQSEL3 IRQ53-bit mask */
#define AG903_PBD_IRQSEL3_IRQ54_POS                        12                                                            /** PBDIRQSEL3 IRQ54-bit position */
#define AG903_PBD_IRQSEL3_IRQ54_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ54_POS)                        /** PBDIRQSEL3 IRQ54-bit mask */
#define AG903_PBD_IRQSEL3_IRQ55_POS                        14                                                            /** PBDIRQSEL3 IRQ55-bit position */
#define AG903_PBD_IRQSEL3_IRQ55_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ55_POS)                        /** PBDIRQSEL3 IRQ55-bit mask */
#define AG903_PBD_IRQSEL3_IRQ56_POS                        16                                                            /** PBDIRQSEL3 IRQ56-bit position */
#define AG903_PBD_IRQSEL3_IRQ56_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ56_POS)                        /** PBDIRQSEL3 IRQ56-bit mask */
#define AG903_PBD_IRQSEL3_IRQ57_POS                        18                                                            /** PBDIRQSEL3 IRQ57-bit position */
#define AG903_PBD_IRQSEL3_IRQ57_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ57_POS)                        /** PBDIRQSEL3 IRQ57-bit mask */
#define AG903_PBD_IRQSEL3_IRQ58_POS                        20                                                            /** PBDIRQSEL3 IRQ58-bit position */
#define AG903_PBD_IRQSEL3_IRQ58_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ58_POS)                        /** PBDIRQSEL3 IRQ58-bit mask */
#define AG903_PBD_IRQSEL3_IRQ59_POS                        22                                                            /** PBDIRQSEL3 IRQ59-bit position */
#define AG903_PBD_IRQSEL3_IRQ59_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ59_POS)                        /** PBDIRQSEL3 IRQ59-bit mask */
#define AG903_PBD_IRQSEL3_IRQ60_POS                        24                                                            /** PBDIRQSEL3 IRQ60-bit position */
#define AG903_PBD_IRQSEL3_IRQ60_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ60_POS)                        /** PBDIRQSEL3 IRQ60-bit mask */
#define AG903_PBD_IRQSEL3_IRQ61_POS                        26                                                            /** PBDIRQSEL3 IRQ61-bit position */
#define AG903_PBD_IRQSEL3_IRQ61_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ61_POS)                        /** PBDIRQSEL3 IRQ61-bit mask */
#define AG903_PBD_IRQSEL3_IRQ62_POS                        28                                                            /** PBDIRQSEL3 IRQ62-bit position */
#define AG903_PBD_IRQSEL3_IRQ62_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ62_POS)                        /** PBDIRQSEL3 IRQ62-bit mask */
#define AG903_PBD_IRQSEL3_IRQ63_POS                        30                                                            /** PBDIRQSEL3 IRQ63-bit position */
#define AG903_PBD_IRQSEL3_IRQ63_MSK                        (0x3UL << AG903_PBD_IRQSEL3_IRQ63_POS)                        /** PBDIRQSEL3 IRQ63-bit mask */

#define AG903_PBD_MAPMODE_MODE_POS                         0                                                             /** PBDMAPMODE MODE-bit position */
#define AG903_PBD_MAPMODE_MODE_MSK                         (0x1UL << AG903_PBD_MAPMODE_MODE_POS)                         /** PBDMAPMODE MODE-bit mask */

#define AG903_PBD_TIMEOUTCONFIG_TIMEOUT_POS                0                                                             /** PBDTIMEOUTCONFIG TIMEOUT-bit position */
#define AG903_PBD_TIMEOUTCONFIG_TIMEOUT_MSK                (0xffffUL << AG903_PBD_TIMEOUTCONFIG_TIMEOUT_POS)             /** PBDTIMEOUTCONFIG TIMEOUT-bit mask */

#define AG903_PBD_TIMEOUTDEFVAL_DEFVAL_POS                 0                                                             /** PBDTIMEOUTDEFVAL DEFVAL-bit position */
#define AG903_PBD_TIMEOUTDEFVAL_DEFVAL_MSK                 (0xffffffffUL << AG903_PBD_TIMEOUTDEFVAL_DEFVAL_POS)          /** PBDTIMEOUTDEFVAL DEFVAL-bit mask */

#define AG903_PBD_TIMEOUTSTATUS_TS_POS                     0                                                             /** PBDTIMEOUTSTATUS TS-bit position */
#define AG903_PBD_TIMEOUTSTATUS_TS_MSK                     (0x1UL << AG903_PBD_TIMEOUTSTATUS_TS_POS)                     /** PBDTIMEOUTSTATUS TS-bit mask */
#define AG903_PBD_TIMEOUTSTATUS_RB_POS                     4                                                             /** PBDTIMEOUTSTATUS RB-bit position */
#define AG903_PBD_TIMEOUTSTATUS_RB_MSK                     (0x1UL << AG903_PBD_TIMEOUTSTATUS_RB_POS)                     /** PBDTIMEOUTSTATUS RB-bit mask */
#define AG903_PBD_TIMEOUTSTATUS_WB_POS                     5                                                             /** PBDTIMEOUTSTATUS WB-bit position */
#define AG903_PBD_TIMEOUTSTATUS_WB_MSK                     (0x1UL << AG903_PBD_TIMEOUTSTATUS_WB_POS)                     /** PBDTIMEOUTSTATUS WB-bit mask */

#define AG903_PBD_TIMEOUTADR_ADR_POS                       0                                                             /** PBDTIMEOUTADR ADR-bit position */
#define AG903_PBD_TIMEOUTADR_ADR_MSK                       (0xffffffffUL << AG903_PBD_TIMEOUTADR_ADR_POS)                /** PBDTIMEOUTADR ADR-bit mask */


#endif /* _AG903_PBD_REGMAP_H_ */

