/**
 * @brief           SPI Register Definition
 * @author          AXELL CORPORATION
 * @description     SPI Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_SPI_REGMAP_H_
#define _AG903_SPI_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** SPI Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CMDW0;
    };

    union {
        __IO uint32_t  CMDW1;

        struct {
            __IO uint32_t  ADDR_LEN                       :  3;
                 uint32_t                                 : 13;
            __IO uint32_t  DUM2_CYC                       :  8;
            __IO uint32_t  INST_LEN                       :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  CONT_READ                      :  1;
        } CMDW1_bits;
    };

    union {
        __IO uint32_t  CMDW2;
    };

    union {
        __IO uint32_t  CMDW3;

        struct {
                 uint32_t                                 :  1;
            __IO uint32_t  WE_EN                          :  1;
            __IO uint32_t  RD_STAT_EN                     :  1;
            __IO uint32_t  RD_STAT                        :  1;
            __IO uint32_t  DTR_MODE                       :  1;
            __IO uint32_t  SPI_MODE                       :  3;
            __IO uint32_t  START_CS                       :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  CONT_CODE                      :  8;
            __IO uint32_t  INST_CODE                      :  8;
        } CMDW3_bits;
    };

    union {
        __IO uint32_t  CTRL;

        struct {
            __IO uint32_t  CLK_DIV                        :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  CLK_MODE                       :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  ABORT                          :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  RDY_LOC                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DAMR                           :  1;
        } CTRL_bits;
    };

    union {
        __IO uint32_t  TIMING;

        struct {
            __IO uint32_t  CS_DLY                         :  4;
        } TIMING_bits;
    };

    union {
        __I  uint32_t  FIFOSTAT;

        struct {
            __I  uint32_t  TX_RDY                         :  1;
            __I  uint32_t  RX_RDY                         :  1;
        } FIFOSTAT_bits;
    };

    __I  uint32_t  RESERVED1[1];

    union {
        __IO uint32_t  INTCTRL;

        struct {
            __IO uint32_t  DMA_EN                         :  1;
            __IO uint32_t  COMP_EN                        :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  TX_TH                          :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  RX_TH                          :  2;
        } INTCTRL_bits;
    };

    union {
        __IO uint32_t  INTSTAT;

        struct {
            __IO uint32_t  COMP                           :  1;
        } INTSTAT_bits;
    };

    union {
        __I  uint32_t  READSTAT;

        struct {
            __I  uint32_t  READ                           :  8;
        } READSTAT_bits;
    };

    union {
        __IO uint32_t  ADDRMASK;
    };

    __I  uint32_t  RESERVED2[8];

    union {
        __I  uint32_t  REVISION;
    };

    union {
        __I  uint32_t  FEATURE;

        struct {
            __I  uint32_t  TX_DEPTH                       :  8;
            __I  uint32_t  RX_DEPTH                       :  8;
                 uint32_t                                 :  3;
            __I  uint32_t  AXI_ID_DW                      :  5;
            __I  uint32_t  DTR_MODE                       :  1;
            __I  uint32_t  CLK_MODE                       :  1;
                 uint32_t                                 :  3;
            __I  uint32_t  DAMR_PORT                      :  1;
            __I  uint32_t  HOST_IF_DW                     :  1;
            __I  uint32_t  HOST_IF                        :  1;
        } FEATURE_bits;
    };

    __I  uint32_t  RESERVED3[42];

    union {
        __IO uint32_t  DATAPORT;
    };

/* DOM-IGNORE-END */
}AG903_SPI_Type;

#define AG903_SPI                                ((volatile AG903_SPI_Type *) AG903_SPI_BASE)                            /** SPI Base Address */


#define AG903_SPI_CMDW0_ADDRESS_POS                        0                                                             /** SPICMDW0 ADDRESS-bit position */
#define AG903_SPI_CMDW0_ADDRESS_MSK                        (0xffffffffUL << AG903_SPI_CMDW0_ADDRESS_POS)                 /** SPICMDW0 ADDRESS-bit mask */

#define AG903_SPI_CMDW1_ADDR_LEN_POS                       0                                                             /** SPICMDW1 ADDR_LEN-bit position */
#define AG903_SPI_CMDW1_ADDR_LEN_MSK                       (0x7UL << AG903_SPI_CMDW1_ADDR_LEN_POS)                       /** SPICMDW1 ADDR_LEN-bit mask */
#define AG903_SPI_CMDW1_DUM2_CYC_POS                       16                                                            /** SPICMDW1 DUM2_CYC-bit position */
#define AG903_SPI_CMDW1_DUM2_CYC_MSK                       (0xffUL << AG903_SPI_CMDW1_DUM2_CYC_POS)                      /** SPICMDW1 DUM2_CYC-bit mask */
#define AG903_SPI_CMDW1_INST_LEN_POS                       24                                                            /** SPICMDW1 INST_LEN-bit position */
#define AG903_SPI_CMDW1_INST_LEN_MSK                       (0x3UL << AG903_SPI_CMDW1_INST_LEN_POS)                       /** SPICMDW1 INST_LEN-bit mask */
#define AG903_SPI_CMDW1_CONT_READ_POS                      28                                                            /** SPICMDW1 CONT_READ-bit position */
#define AG903_SPI_CMDW1_CONT_READ_MSK                      (0x1UL << AG903_SPI_CMDW1_CONT_READ_POS)                      /** SPICMDW1 CONT_READ-bit mask */

#define AG903_SPI_CMDW2_DAT_CNT_POS                        0                                                             /** SPICMDW2 DAT_CNT-bit position */
#define AG903_SPI_CMDW2_DAT_CNT_MSK                        (0xffffffffUL << AG903_SPI_CMDW2_DAT_CNT_POS)                 /** SPICMDW2 DAT_CNT-bit mask */

#define AG903_SPI_CMDW3_WE_EN_POS                          1                                                             /** SPICMDW3 WE_EN-bit position */
#define AG903_SPI_CMDW3_WE_EN_MSK                          (0x1UL << AG903_SPI_CMDW3_WE_EN_POS)                          /** SPICMDW3 WE_EN-bit mask */
#define AG903_SPI_CMDW3_RD_STAT_EN_POS                     2                                                             /** SPICMDW3 RD_STAT_EN-bit position */
#define AG903_SPI_CMDW3_RD_STAT_EN_MSK                     (0x1UL << AG903_SPI_CMDW3_RD_STAT_EN_POS)                     /** SPICMDW3 RD_STAT_EN-bit mask */
#define AG903_SPI_CMDW3_RD_STAT_POS                        3                                                             /** SPICMDW3 RD_STAT-bit position */
#define AG903_SPI_CMDW3_RD_STAT_MSK                        (0x1UL << AG903_SPI_CMDW3_RD_STAT_POS)                        /** SPICMDW3 RD_STAT-bit mask */
#define AG903_SPI_CMDW3_DTR_MODE_POS                       4                                                             /** SPICMDW3 DTR_MODE-bit position */
#define AG903_SPI_CMDW3_DTR_MODE_MSK                       (0x1UL << AG903_SPI_CMDW3_DTR_MODE_POS)                       /** SPICMDW3 DTR_MODE-bit mask */
#define AG903_SPI_CMDW3_SPI_MODE_POS                       5                                                             /** SPICMDW3 SPI_MODE-bit position */
#define AG903_SPI_CMDW3_SPI_MODE_MSK                       (0x7UL << AG903_SPI_CMDW3_SPI_MODE_POS)                       /** SPICMDW3 SPI_MODE-bit mask */
#define AG903_SPI_CMDW3_START_CS_POS                       8                                                             /** SPICMDW3 START_CS-bit position */
#define AG903_SPI_CMDW3_START_CS_MSK                       (0x3UL << AG903_SPI_CMDW3_START_CS_POS)                       /** SPICMDW3 START_CS-bit mask */
#define AG903_SPI_CMDW3_CONT_CODE_POS                      16                                                            /** SPICMDW3 CONT_CODE-bit position */
#define AG903_SPI_CMDW3_CONT_CODE_MSK                      (0xffUL << AG903_SPI_CMDW3_CONT_CODE_POS)                     /** SPICMDW3 CONT_CODE-bit mask */
#define AG903_SPI_CMDW3_INST_CODE_POS                      24                                                            /** SPICMDW3 INST_CODE-bit position */
#define AG903_SPI_CMDW3_INST_CODE_MSK                      (0xffUL << AG903_SPI_CMDW3_INST_CODE_POS)                     /** SPICMDW3 INST_CODE-bit mask */

#define AG903_SPI_CTRL_CLK_DIV_POS                         0                                                             /** SPICTRL CLK_DIV-bit position */
#define AG903_SPI_CTRL_CLK_DIV_MSK                         (0x3UL << AG903_SPI_CTRL_CLK_DIV_POS)                         /** SPICTRL CLK_DIV-bit mask */
#define AG903_SPI_CTRL_CLK_MODE_POS                        4                                                             /** SPICTRL CLK_MODE-bit position */
#define AG903_SPI_CTRL_CLK_MODE_MSK                        (0x1UL << AG903_SPI_CTRL_CLK_MODE_POS)                        /** SPICTRL CLK_MODE-bit mask */
#define AG903_SPI_CTRL_ABORT_POS                           8                                                             /** SPICTRL ABORT-bit position */
#define AG903_SPI_CTRL_ABORT_MSK                           (0x1UL << AG903_SPI_CTRL_ABORT_POS)                           /** SPICTRL ABORT-bit mask */
#define AG903_SPI_CTRL_RDY_LOC_POS                         16                                                            /** SPICTRL RDY_LOC-bit position */
#define AG903_SPI_CTRL_RDY_LOC_MSK                         (0x7UL << AG903_SPI_CTRL_RDY_LOC_POS)                         /** SPICTRL RDY_LOC-bit mask */
#define AG903_SPI_CTRL_DAMR_POS                            20                                                            /** SPICTRL DAMR-bit position */
#define AG903_SPI_CTRL_DAMR_MSK                            (0x1UL << AG903_SPI_CTRL_DAMR_POS)                            /** SPICTRL DAMR-bit mask */

#define AG903_SPI_TIMING_CS_DLY_POS                        0                                                             /** SPITIMING CS_DLY-bit position */
#define AG903_SPI_TIMING_CS_DLY_MSK                        (0xfUL << AG903_SPI_TIMING_CS_DLY_POS)                        /** SPITIMING CS_DLY-bit mask */

#define AG903_SPI_FIFOSTAT_TX_RDY_POS                      0                                                             /** SPIFIFOSTAT TX_RDY-bit position */
#define AG903_SPI_FIFOSTAT_TX_RDY_MSK                      (0x1UL << AG903_SPI_FIFOSTAT_TX_RDY_POS)                      /** SPIFIFOSTAT TX_RDY-bit mask */
#define AG903_SPI_FIFOSTAT_RX_RDY_POS                      1                                                             /** SPIFIFOSTAT RX_RDY-bit position */
#define AG903_SPI_FIFOSTAT_RX_RDY_MSK                      (0x1UL << AG903_SPI_FIFOSTAT_RX_RDY_POS)                      /** SPIFIFOSTAT RX_RDY-bit mask */

#define AG903_SPI_INTCTRL_DMA_EN_POS                       0                                                             /** SPIINTCTRL DMA_EN-bit position */
#define AG903_SPI_INTCTRL_DMA_EN_MSK                       (0x1UL << AG903_SPI_INTCTRL_DMA_EN_POS)                       /** SPIINTCTRL DMA_EN-bit mask */
#define AG903_SPI_INTCTRL_COMP_EN_POS                      1                                                             /** SPIINTCTRL COMP_EN-bit position */
#define AG903_SPI_INTCTRL_COMP_EN_MSK                      (0x1UL << AG903_SPI_INTCTRL_COMP_EN_POS)                      /** SPIINTCTRL COMP_EN-bit mask */
#define AG903_SPI_INTCTRL_TX_TH_POS                        8                                                             /** SPIINTCTRL TX_TH-bit position */
#define AG903_SPI_INTCTRL_TX_TH_MSK                        (0x3UL << AG903_SPI_INTCTRL_TX_TH_POS)                        /** SPIINTCTRL TX_TH-bit mask */
#define AG903_SPI_INTCTRL_RX_TH_POS                        12                                                            /** SPIINTCTRL RX_TH-bit position */
#define AG903_SPI_INTCTRL_RX_TH_MSK                        (0x3UL << AG903_SPI_INTCTRL_RX_TH_POS)                        /** SPIINTCTRL RX_TH-bit mask */

#define AG903_SPI_INTSTAT_COMP_POS                         0                                                             /** SPIINTSTAT COMP-bit position */
#define AG903_SPI_INTSTAT_COMP_MSK                         (0x1UL << AG903_SPI_INTSTAT_COMP_POS)                         /** SPIINTSTAT COMP-bit mask */

#define AG903_SPI_READSTAT_READ_POS                        0                                                             /** SPIREADSTAT READ-bit position */
#define AG903_SPI_READSTAT_READ_MSK                        (0xffUL << AG903_SPI_READSTAT_READ_POS)                       /** SPIREADSTAT READ-bit mask */

#define AG903_SPI_ADDRMASK_ADDR_MASK_POS                   0                                                             /** SPIADDRMASK ADDR_MASK-bit position */
#define AG903_SPI_ADDRMASK_ADDR_MASK_MSK                   (0xffffffffUL << AG903_SPI_ADDRMASK_ADDR_MASK_POS)            /** SPIADDRMASK ADDR_MASK-bit mask */

#define AG903_SPI_REVISION_REVISION_POS                    0                                                             /** SPIREVISION REVISION-bit position */
#define AG903_SPI_REVISION_REVISION_MSK                    (0xffffffffUL << AG903_SPI_REVISION_REVISION_POS)             /** SPIREVISION REVISION-bit mask */

#define AG903_SPI_FEATURE_TX_DEPTH_POS                     0                                                             /** SPIFEATURE TX_DEPTH-bit position */
#define AG903_SPI_FEATURE_TX_DEPTH_MSK                     (0xffUL << AG903_SPI_FEATURE_TX_DEPTH_POS)                    /** SPIFEATURE TX_DEPTH-bit mask */
#define AG903_SPI_FEATURE_RX_DEPTH_POS                     8                                                             /** SPIFEATURE RX_DEPTH-bit position */
#define AG903_SPI_FEATURE_RX_DEPTH_MSK                     (0xffUL << AG903_SPI_FEATURE_RX_DEPTH_POS)                    /** SPIFEATURE RX_DEPTH-bit mask */
#define AG903_SPI_FEATURE_AXI_ID_DW_POS                    19                                                            /** SPIFEATURE AXI_ID_DW-bit position */
#define AG903_SPI_FEATURE_AXI_ID_DW_MSK                    (0x1fUL << AG903_SPI_FEATURE_AXI_ID_DW_POS)                   /** SPIFEATURE AXI_ID_DW-bit mask */
#define AG903_SPI_FEATURE_DTR_MODE_POS                     24                                                            /** SPIFEATURE DTR_MODE-bit position */
#define AG903_SPI_FEATURE_DTR_MODE_MSK                     (0x1UL << AG903_SPI_FEATURE_DTR_MODE_POS)                     /** SPIFEATURE DTR_MODE-bit mask */
#define AG903_SPI_FEATURE_CLK_MODE_POS                     25                                                            /** SPIFEATURE CLK_MODE-bit position */
#define AG903_SPI_FEATURE_CLK_MODE_MSK                     (0x1UL << AG903_SPI_FEATURE_CLK_MODE_POS)                     /** SPIFEATURE CLK_MODE-bit mask */
#define AG903_SPI_FEATURE_DAMR_PORT_POS                    29                                                            /** SPIFEATURE DAMR_PORT-bit position */
#define AG903_SPI_FEATURE_DAMR_PORT_MSK                    (0x1UL << AG903_SPI_FEATURE_DAMR_PORT_POS)                    /** SPIFEATURE DAMR_PORT-bit mask */
#define AG903_SPI_FEATURE_HOST_IF_DW_POS                   30                                                            /** SPIFEATURE HOST_IF_DW-bit position */
#define AG903_SPI_FEATURE_HOST_IF_DW_MSK                   (0x1UL << AG903_SPI_FEATURE_HOST_IF_DW_POS)                   /** SPIFEATURE HOST_IF_DW-bit mask */
#define AG903_SPI_FEATURE_HOST_IF_POS                      31                                                            /** SPIFEATURE HOST_IF-bit position */
#define AG903_SPI_FEATURE_HOST_IF_MSK                      (0x1UL << AG903_SPI_FEATURE_HOST_IF_POS)                      /** SPIFEATURE HOST_IF-bit mask */

#define AG903_SPI_DATAPORT_DATAPORT_POS                    0                                                             /** SPIDATAPORT DATAPORT-bit position */
#define AG903_SPI_DATAPORT_DATAPORT_MSK                    (0xffffffffUL << AG903_SPI_DATAPORT_DATAPORT_POS)             /** SPIDATAPORT DATAPORT-bit mask */

#endif /* _AG903_SPI_REGMAP_H_ */

