/**
 * @brief           VID Register Definition
 * @author          AXELL CORPORATION
 * @description     VID Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_VID_REGMAP_H_
#define _AG903_VID_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** VID Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CTRL;

        struct {
            __IO uint32_t  ON                             :  1;
        } CTRL_bits;
    };

    union {
        __IO uint32_t  FMT;

        struct {
            __IO uint32_t  FMT                            :  3;
        } FMT_bits;
    };

/* DOM-IGNORE-END */
}AG903_VID_Type;

/** VIDIOn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CTRL;

        struct {
            __IO uint32_t  SOE                            :  1;
        } CTRL_bits;
    };

    union {
        __IO uint32_t  MOD;

        struct {
            __IO uint32_t  CPOL                           :  1;
            __IO uint32_t  FPOL                           :  1;
            __IO uint32_t  DPOL                           :  1;
            __IO uint32_t  HPOL                           :  1;
            __IO uint32_t  VPOL                           :  1;
        } MOD_bits;
    };

    union {
        __IO uint32_t  OHPRM0;

        struct {
            __IO uint32_t  HPW                            : 12;
        } OHPRM0_bits;
    };

    union {
        __IO uint32_t  OHPRM1;

        struct {
            __IO uint32_t  HBP                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  HFP                            : 12;
        } OHPRM1_bits;
    };

    union {
        __IO uint32_t  OVPRM0;

        struct {
            __IO uint32_t  VPW                            : 12;
        } OVPRM0_bits;
    };

    union {
        __IO uint32_t  OVPRM1;

        struct {
            __IO uint32_t  VBP                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  VFP                            : 12;
        } OVPRM1_bits;
    };

    union {
        __IO uint32_t  OSIZE;

        struct {
            __IO uint32_t  HFS                            : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  VFS                            : 12;
        } OSIZE_bits;
    };

    union {
        __I  uint32_t  STAT;

        struct {
            __I  uint32_t  CWT                            :  1;
        } STAT_bits;
    };

/* DOM-IGNORE-END */
}AG903_VIDIOn_Type;

/** VIDCOn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  MOD;

        struct {
            __IO uint32_t  TRSDEC                         :  1;
                 uint32_t                                 : 15;
            __IO uint32_t  DELAY                          :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  TDMTRS                         :  1;
            __IO uint32_t  TDMBLK                         :  1;
        } MOD_bits;
    };

    union {
        __IO uint32_t  TRSPRM;

        struct {
            __IO uint32_t  HFP                            : 12;
            __IO uint32_t  HREF                           :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  VFP                            : 12;
            __IO uint32_t  OFP                            :  1;
            __IO uint32_t  EFP                            :  1;
        } TRSPRM_bits;
    };

    union {
        __IO uint32_t  SDPRM;

        struct {
            __IO uint32_t  HMAX                           : 13;
                 uint32_t                                 :  3;
            __IO uint32_t  VMAX                           : 13;
        } SDPRM_bits;
    };

    union {
        __I  uint32_t  STAT;

        struct {
            __I  uint32_t  TDMCH                          :  3;
                 uint32_t                                 :  5;
            __I  uint32_t  HBLANK                         :  1;
            __I  uint32_t  VBLANK                         :  1;
                 uint32_t                                 :  6;
            __I  uint32_t  TRSVAL                         :  8;
            __I  uint32_t  BLKVAL                         :  8;
        } STAT_bits;
    };

    union {
        __I  uint32_t  HST0;

        struct {
            __I  uint32_t  HPW                            : 13;
        } HST0_bits;
    };

    union {
        __I  uint32_t  HST1;

        struct {
            __I  uint32_t  HBP                            : 13;
                 uint32_t                                 :  3;
            __I  uint32_t  HFP                            : 13;
        } HST1_bits;
    };

    union {
        __I  uint32_t  VST0;

        struct {
            __I  uint32_t  VPW                            : 13;
                 uint32_t                                 :  3;
            __I  uint32_t  OFP                            :  1;
            __I  uint32_t  OBP                            :  1;
            __I  uint32_t  EFP                            :  1;
            __I  uint32_t  EBP                            :  1;
            __I  uint32_t  SCAN                           :  1;
        } VST0_bits;
    };

    union {
        __I  uint32_t  VST1;

        struct {
            __I  uint32_t  VBP                            : 13;
                 uint32_t                                 :  3;
            __I  uint32_t  VFP                            : 13;
        } VST1_bits;
    };

    union {
        __I  uint32_t  FST;

        struct {
            __I  uint32_t  HFS                            : 13;
                 uint32_t                                 :  3;
            __I  uint32_t  VFS                            : 13;
        } FST_bits;
    };

/* DOM-IGNORE-END */
}AG903_VIDCOn_Type;

#define AG903_VIDIOn(ch)                         ((volatile AG903_VIDIOn_Type *)(AG903_VIDIO0_BASE + 0x40 * ch))         /** VIDIOn Base Address (n=0..1) */
#define AG903_VIDIOn_CTRL(ch)                    AG903_VIDIOn(ch)->CTRL                                                  /** VIDIOnCTRL Address (n=0..1) */
#define AG903_VIDIOn_MOD(ch)                     AG903_VIDIOn(ch)->MOD                                                   /** VIDIOnMOD Address (n=0..1) */
#define AG903_VIDIOn_OHPRM0(ch)                  AG903_VIDIOn(ch)->OHPRM0                                                /** VIDIOnOHPRM0 Address (n=0..1) */
#define AG903_VIDIOn_OHPRM1(ch)                  AG903_VIDIOn(ch)->OHPRM1                                                /** VIDIOnOHPRM1 Address (n=0..1) */
#define AG903_VIDIOn_OVPRM0(ch)                  AG903_VIDIOn(ch)->OVPRM0                                                /** VIDIOnOVPRM0 Address (n=0..1) */
#define AG903_VIDIOn_OVPRM1(ch)                  AG903_VIDIOn(ch)->OVPRM1                                                /** VIDIOnOVPRM1 Address (n=0..1) */
#define AG903_VIDIOn_OSIZE(ch)                   AG903_VIDIOn(ch)->OSIZE                                                 /** VIDIOnOSIZE Address (n=0..1) */
#define AG903_VIDIOn_STAT(ch)                    AG903_VIDIOn(ch)->STAT                                                  /** VIDIOnSTAT Address (n=0..1) */

#define AG903_VIDCOn(ch)                         ((volatile AG903_VIDCOn_Type *)(AG903_VIDCO0_BASE + 0x40 * ch))         /** VIDCOn Base Address (n=0..3) */
#define AG903_VIDCOn_MOD(ch)                     AG903_VIDCOn(ch)->MOD                                                   /** VIDCOnMOD Address (n=0..3) */
#define AG903_VIDCOn_TRSPRM(ch)                  AG903_VIDCOn(ch)->TRSPRM                                                /** VIDCOnTRSPRM Address (n=0..3) */
#define AG903_VIDCOn_SDPRM(ch)                   AG903_VIDCOn(ch)->SDPRM                                                 /** VIDCOnSDPRM Address (n=0..3) */
#define AG903_VIDCOn_STAT(ch)                    AG903_VIDCOn(ch)->STAT                                                  /** VIDCOnSTAT Address (n=0..3) */
#define AG903_VIDCOn_HST0(ch)                    AG903_VIDCOn(ch)->HST0                                                  /** VIDCOnHST0 Address (n=0..3) */
#define AG903_VIDCOn_HST1(ch)                    AG903_VIDCOn(ch)->HST1                                                  /** VIDCOnHST1 Address (n=0..3) */
#define AG903_VIDCOn_VST0(ch)                    AG903_VIDCOn(ch)->VST0                                                  /** VIDCOnVST0 Address (n=0..3) */
#define AG903_VIDCOn_VST1(ch)                    AG903_VIDCOn(ch)->VST1                                                  /** VIDCOnVST1 Address (n=0..3) */
#define AG903_VIDCOn_FST(ch)                     AG903_VIDCOn(ch)->FST                                                   /** VIDCOnFST Address (n=0..3) */

#define AG903_VID                                ((volatile AG903_VID_Type *) AG903_VID_BASE)                            /** VID Base Address */
#define AG903_VIDIO0                             ((volatile AG903_VIDIOn_Type *) AG903_VIDIO0_BASE)                      /** VIDIOn Base Address */
#define AG903_VIDIO1                             ((volatile AG903_VIDIOn_Type *) AG903_VIDIO1_BASE)                      /** VIDIOn Base Address */
#define AG903_VIDCO0                             ((volatile AG903_VIDCOn_Type *) AG903_VIDCO0_BASE)                      /** VIDCOn Base Address */
#define AG903_VIDCO1                             ((volatile AG903_VIDCOn_Type *) AG903_VIDCO1_BASE)                      /** VIDCOn Base Address */
#define AG903_VIDCO2                             ((volatile AG903_VIDCOn_Type *) AG903_VIDCO2_BASE)                      /** VIDCOn Base Address */
#define AG903_VIDCO3                             ((volatile AG903_VIDCOn_Type *) AG903_VIDCO3_BASE)                      /** VIDCOn Base Address */


#define AG903_VID_CTRL_ON_POS                              0                                                             /** VIDCTRL ON-bit position */
#define AG903_VID_CTRL_ON_MSK                              (0x1UL << AG903_VID_CTRL_ON_POS)                              /** VIDCTRL ON-bit mask */

#define AG903_VID_FMT_FMT_POS                              0                                                             /** VIDFMT FMT-bit position */
#define AG903_VID_FMT_FMT_MSK                              (0x7UL << AG903_VID_FMT_FMT_POS)                              /** VIDFMT FMT-bit mask */

#define AG903_VIDIOn_CTRL_SOE_POS                          0                                                             /** VIDIOnCTRL SOE-bit position */
#define AG903_VIDIOn_CTRL_SOE_MSK                          (0x1UL << AG903_VIDIOn_CTRL_SOE_POS)                          /** VIDIOnCTRL SOE-bit mask */

#define AG903_VIDIOn_MOD_CPOL_POS                          0                                                             /** VIDIOnMOD CPOL-bit position */
#define AG903_VIDIOn_MOD_CPOL_MSK                          (0x1UL << AG903_VIDIOn_MOD_CPOL_POS)                          /** VIDIOnMOD CPOL-bit mask */
#define AG903_VIDIOn_MOD_FPOL_POS                          1                                                             /** VIDIOnMOD FPOL-bit position */
#define AG903_VIDIOn_MOD_FPOL_MSK                          (0x1UL << AG903_VIDIOn_MOD_FPOL_POS)                          /** VIDIOnMOD FPOL-bit mask */
#define AG903_VIDIOn_MOD_DPOL_POS                          2                                                             /** VIDIOnMOD DPOL-bit position */
#define AG903_VIDIOn_MOD_DPOL_MSK                          (0x1UL << AG903_VIDIOn_MOD_DPOL_POS)                          /** VIDIOnMOD DPOL-bit mask */
#define AG903_VIDIOn_MOD_HPOL_POS                          3                                                             /** VIDIOnMOD HPOL-bit position */
#define AG903_VIDIOn_MOD_HPOL_MSK                          (0x1UL << AG903_VIDIOn_MOD_HPOL_POS)                          /** VIDIOnMOD HPOL-bit mask */
#define AG903_VIDIOn_MOD_VPOL_POS                          4                                                             /** VIDIOnMOD VPOL-bit position */
#define AG903_VIDIOn_MOD_VPOL_MSK                          (0x1UL << AG903_VIDIOn_MOD_VPOL_POS)                          /** VIDIOnMOD VPOL-bit mask */

#define AG903_VIDIOn_OHPRM0_HPW_POS                        0                                                             /** VIDIOnOHPRM0 HPW-bit position */
#define AG903_VIDIOn_OHPRM0_HPW_MSK                        (0xfffUL << AG903_VIDIOn_OHPRM0_HPW_POS)                      /** VIDIOnOHPRM0 HPW-bit mask */

#define AG903_VIDIOn_OHPRM1_HBP_POS                        0                                                             /** VIDIOnOHPRM1 HBP-bit position */
#define AG903_VIDIOn_OHPRM1_HBP_MSK                        (0xfffUL << AG903_VIDIOn_OHPRM1_HBP_POS)                      /** VIDIOnOHPRM1 HBP-bit mask */
#define AG903_VIDIOn_OHPRM1_HFP_POS                        16                                                            /** VIDIOnOHPRM1 HFP-bit position */
#define AG903_VIDIOn_OHPRM1_HFP_MSK                        (0xfffUL << AG903_VIDIOn_OHPRM1_HFP_POS)                      /** VIDIOnOHPRM1 HFP-bit mask */

#define AG903_VIDIOn_OVPRM0_VPW_POS                        0                                                             /** VIDIOnOVPRM0 VPW-bit position */
#define AG903_VIDIOn_OVPRM0_VPW_MSK                        (0xfffUL << AG903_VIDIOn_OVPRM0_VPW_POS)                      /** VIDIOnOVPRM0 VPW-bit mask */

#define AG903_VIDIOn_OVPRM1_VBP_POS                        0                                                             /** VIDIOnOVPRM1 VBP-bit position */
#define AG903_VIDIOn_OVPRM1_VBP_MSK                        (0xfffUL << AG903_VIDIOn_OVPRM1_VBP_POS)                      /** VIDIOnOVPRM1 VBP-bit mask */
#define AG903_VIDIOn_OVPRM1_VFP_POS                        16                                                            /** VIDIOnOVPRM1 VFP-bit position */
#define AG903_VIDIOn_OVPRM1_VFP_MSK                        (0xfffUL << AG903_VIDIOn_OVPRM1_VFP_POS)                      /** VIDIOnOVPRM1 VFP-bit mask */

#define AG903_VIDIOn_OSIZE_HFS_POS                         0                                                             /** VIDIOnOSIZE HFS-bit position */
#define AG903_VIDIOn_OSIZE_HFS_MSK                         (0xfffUL << AG903_VIDIOn_OSIZE_HFS_POS)                       /** VIDIOnOSIZE HFS-bit mask */
#define AG903_VIDIOn_OSIZE_VFS_POS                         16                                                            /** VIDIOnOSIZE VFS-bit position */
#define AG903_VIDIOn_OSIZE_VFS_MSK                         (0xfffUL << AG903_VIDIOn_OSIZE_VFS_POS)                       /** VIDIOnOSIZE VFS-bit mask */

#define AG903_VIDIOn_STAT_CWT_POS                          0                                                             /** VIDIOnSTAT CWT-bit position */
#define AG903_VIDIOn_STAT_CWT_MSK                          (0x1UL << AG903_VIDIOn_STAT_CWT_POS)                          /** VIDIOnSTAT CWT-bit mask */

#define AG903_VIDCOn_MOD_TRSDEC_POS                        0                                                             /** VIDCOnMOD TRSDEC-bit position */
#define AG903_VIDCOn_MOD_TRSDEC_MSK                        (0x1UL << AG903_VIDCOn_MOD_TRSDEC_POS)                        /** VIDCOnMOD TRSDEC-bit mask */
#define AG903_VIDCOn_MOD_DELAY_POS                         16                                                            /** VIDCOnMOD DELAY-bit position */
#define AG903_VIDCOn_MOD_DELAY_MSK                         (0x1UL << AG903_VIDCOn_MOD_DELAY_POS)                         /** VIDCOnMOD DELAY-bit mask */
#define AG903_VIDCOn_MOD_TDMTRS_POS                        24                                                            /** VIDCOnMOD TDMTRS-bit position */
#define AG903_VIDCOn_MOD_TDMTRS_MSK                        (0x1UL << AG903_VIDCOn_MOD_TDMTRS_POS)                        /** VIDCOnMOD TDMTRS-bit mask */
#define AG903_VIDCOn_MOD_TDMBLK_POS                        25                                                            /** VIDCOnMOD TDMBLK-bit position */
#define AG903_VIDCOn_MOD_TDMBLK_MSK                        (0x1UL << AG903_VIDCOn_MOD_TDMBLK_POS)                        /** VIDCOnMOD TDMBLK-bit mask */

#define AG903_VIDCOn_TRSPRM_HFP_POS                        0                                                             /** VIDCOnTRSPRM HFP-bit position */
#define AG903_VIDCOn_TRSPRM_HFP_MSK                        (0xfffUL << AG903_VIDCOn_TRSPRM_HFP_POS)                      /** VIDCOnTRSPRM HFP-bit mask */
#define AG903_VIDCOn_TRSPRM_HREF_POS                       12                                                            /** VIDCOnTRSPRM HREF-bit position */
#define AG903_VIDCOn_TRSPRM_HREF_MSK                       (0x1UL << AG903_VIDCOn_TRSPRM_HREF_POS)                       /** VIDCOnTRSPRM HREF-bit mask */
#define AG903_VIDCOn_TRSPRM_VFP_POS                        16                                                            /** VIDCOnTRSPRM VFP-bit position */
#define AG903_VIDCOn_TRSPRM_VFP_MSK                        (0xfffUL << AG903_VIDCOn_TRSPRM_VFP_POS)                      /** VIDCOnTRSPRM VFP-bit mask */
#define AG903_VIDCOn_TRSPRM_OFP_POS                        28                                                            /** VIDCOnTRSPRM OFP-bit position */
#define AG903_VIDCOn_TRSPRM_OFP_MSK                        (0x1UL << AG903_VIDCOn_TRSPRM_OFP_POS)                        /** VIDCOnTRSPRM OFP-bit mask */
#define AG903_VIDCOn_TRSPRM_EFP_POS                        29                                                            /** VIDCOnTRSPRM EFP-bit position */
#define AG903_VIDCOn_TRSPRM_EFP_MSK                        (0x1UL << AG903_VIDCOn_TRSPRM_EFP_POS)                        /** VIDCOnTRSPRM EFP-bit mask */

#define AG903_VIDCOn_SDPRM_HMAX_POS                        0                                                             /** VIDCOnSDPRM HMAX-bit position */
#define AG903_VIDCOn_SDPRM_HMAX_MSK                        (0x1fffUL << AG903_VIDCOn_SDPRM_HMAX_POS)                     /** VIDCOnSDPRM HMAX-bit mask */
#define AG903_VIDCOn_SDPRM_VMAX_POS                        16                                                            /** VIDCOnSDPRM VMAX-bit position */
#define AG903_VIDCOn_SDPRM_VMAX_MSK                        (0x1fffUL << AG903_VIDCOn_SDPRM_VMAX_POS)                     /** VIDCOnSDPRM VMAX-bit mask */

#define AG903_VIDCOn_STAT_TDMCH_POS                        0                                                             /** VIDCOnSTAT TDMCH-bit position */
#define AG903_VIDCOn_STAT_TDMCH_MSK                        (0x7UL << AG903_VIDCOn_STAT_TDMCH_POS)                        /** VIDCOnSTAT TDMCH-bit mask */
#define AG903_VIDCOn_STAT_HBLANK_POS                       8                                                             /** VIDCOnSTAT HBLANK-bit position */
#define AG903_VIDCOn_STAT_HBLANK_MSK                       (0x1UL << AG903_VIDCOn_STAT_HBLANK_POS)                       /** VIDCOnSTAT HBLANK-bit mask */
#define AG903_VIDCOn_STAT_VBLANK_POS                       9                                                             /** VIDCOnSTAT VBLANK-bit position */
#define AG903_VIDCOn_STAT_VBLANK_MSK                       (0x1UL << AG903_VIDCOn_STAT_VBLANK_POS)                       /** VIDCOnSTAT VBLANK-bit mask */
#define AG903_VIDCOn_STAT_TRSVAL_POS                       16                                                            /** VIDCOnSTAT TRSVAL-bit position */
#define AG903_VIDCOn_STAT_TRSVAL_MSK                       (0xffUL << AG903_VIDCOn_STAT_TRSVAL_POS)                      /** VIDCOnSTAT TRSVAL-bit mask */
#define AG903_VIDCOn_STAT_BLKVAL_POS                       24                                                            /** VIDCOnSTAT BLKVAL-bit position */
#define AG903_VIDCOn_STAT_BLKVAL_MSK                       (0xffUL << AG903_VIDCOn_STAT_BLKVAL_POS)                      /** VIDCOnSTAT BLKVAL-bit mask */

#define AG903_VIDCOn_HST0_HPW_POS                          0                                                             /** VIDCOnHST0 HPW-bit position */
#define AG903_VIDCOn_HST0_HPW_MSK                          (0x1fffUL << AG903_VIDCOn_HST0_HPW_POS)                       /** VIDCOnHST0 HPW-bit mask */

#define AG903_VIDCOn_HST1_HBP_POS                          0                                                             /** VIDCOnHST1 HBP-bit position */
#define AG903_VIDCOn_HST1_HBP_MSK                          (0x1fffUL << AG903_VIDCOn_HST1_HBP_POS)                       /** VIDCOnHST1 HBP-bit mask */
#define AG903_VIDCOn_HST1_HFP_POS                          16                                                            /** VIDCOnHST1 HFP-bit position */
#define AG903_VIDCOn_HST1_HFP_MSK                          (0x1fffUL << AG903_VIDCOn_HST1_HFP_POS)                       /** VIDCOnHST1 HFP-bit mask */

#define AG903_VIDCOn_VST0_VPW_POS                          0                                                             /** VIDCOnVST0 VPW-bit position */
#define AG903_VIDCOn_VST0_VPW_MSK                          (0x1fffUL << AG903_VIDCOn_VST0_VPW_POS)                       /** VIDCOnVST0 VPW-bit mask */
#define AG903_VIDCOn_VST0_OFP_POS                          16                                                            /** VIDCOnVST0 OFP-bit position */
#define AG903_VIDCOn_VST0_OFP_MSK                          (0x1UL << AG903_VIDCOn_VST0_OFP_POS)                          /** VIDCOnVST0 OFP-bit mask */
#define AG903_VIDCOn_VST0_OBP_POS                          17                                                            /** VIDCOnVST0 OBP-bit position */
#define AG903_VIDCOn_VST0_OBP_MSK                          (0x1UL << AG903_VIDCOn_VST0_OBP_POS)                          /** VIDCOnVST0 OBP-bit mask */
#define AG903_VIDCOn_VST0_EFP_POS                          18                                                            /** VIDCOnVST0 EFP-bit position */
#define AG903_VIDCOn_VST0_EFP_MSK                          (0x1UL << AG903_VIDCOn_VST0_EFP_POS)                          /** VIDCOnVST0 EFP-bit mask */
#define AG903_VIDCOn_VST0_EBP_POS                          19                                                            /** VIDCOnVST0 EBP-bit position */
#define AG903_VIDCOn_VST0_EBP_MSK                          (0x1UL << AG903_VIDCOn_VST0_EBP_POS)                          /** VIDCOnVST0 EBP-bit mask */
#define AG903_VIDCOn_VST0_SCAN_POS                         20                                                            /** VIDCOnVST0 SCAN-bit position */
#define AG903_VIDCOn_VST0_SCAN_MSK                         (0x1UL << AG903_VIDCOn_VST0_SCAN_POS)                         /** VIDCOnVST0 SCAN-bit mask */

#define AG903_VIDCOn_VST1_VBP_POS                          0                                                             /** VIDCOnVST1 VBP-bit position */
#define AG903_VIDCOn_VST1_VBP_MSK                          (0x1fffUL << AG903_VIDCOn_VST1_VBP_POS)                       /** VIDCOnVST1 VBP-bit mask */
#define AG903_VIDCOn_VST1_VFP_POS                          16                                                            /** VIDCOnVST1 VFP-bit position */
#define AG903_VIDCOn_VST1_VFP_MSK                          (0x1fffUL << AG903_VIDCOn_VST1_VFP_POS)                       /** VIDCOnVST1 VFP-bit mask */

#define AG903_VIDCOn_FST_HFS_POS                           0                                                             /** VIDCOnFST HFS-bit position */
#define AG903_VIDCOn_FST_HFS_MSK                           (0x1fffUL << AG903_VIDCOn_FST_HFS_POS)                        /** VIDCOnFST HFS-bit mask */
#define AG903_VIDCOn_FST_VFS_POS                           16                                                            /** VIDCOnFST VFS-bit position */
#define AG903_VIDCOn_FST_VFS_MSK                           (0x1fffUL << AG903_VIDCOn_FST_VFS_POS)                        /** VIDCOnFST VFS-bit mask */

#endif /* _AG903_VID_REGMAP_H_ */

