/**
 * @brief           VOD Register Definition
 * @author          AXELL CORPORATION
 * @description     VOD Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_VOD_REGMAP_H_
#define _AG903_VOD_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** VODn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  PORTSEL;

        struct {
            __IO uint32_t  SEL                            :  2;
        } PORTSEL_bits;
    };

    union {
        __IO uint32_t  MOD;

        struct {
            __IO uint32_t  DP                             :  1;
            __IO uint32_t  VP                             :  1;
            __IO uint32_t  HP                             :  1;
            __IO uint32_t  FP                             :  1;
            __IO uint32_t  CDP                            :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  DEX                            :  1;
            __IO uint32_t  VEX                            :  1;
            __IO uint32_t  HEX                            :  1;
            __IO uint32_t  FEX                            :  1;
            __IO uint32_t  CDEX                           :  1;
            __IO uint32_t  PEX                            :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  CP                             :  1;
            __IO uint32_t  CODE                           :  1;
            __IO uint32_t  YUV                            :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  FMT                            :  2;
            __IO uint32_t  CT0                            :  1;
            __IO uint32_t  CT1                            :  1;
        } MOD_bits;
    };

    __I  uint32_t  RESERVED1[1];

    union {
        __IO uint32_t  BPWRMOD;

        struct {
            __IO uint32_t  EN                             :  1;
                 uint32_t                                 : 15;
            __IO uint32_t  UNIT                           :  1;
        } BPWRMOD_bits;
    };

    union {
        __IO uint32_t  PPWRONCNT;
    };

    union {
        __IO uint32_t  BPWRONCNT;
    };

    union {
        __IO uint32_t  BLGTONCNT;
    };

    union {
        __IO uint32_t  PPWROFFCNT;
    };

    union {
        __IO uint32_t  BPWROFFCNT;
    };

    union {
        __IO uint32_t  BLGTOFFCNT;
    };

    union {
        __IO uint32_t  PWMPERIOD;
    };

    union {
        __IO uint32_t  PWMCNT;
    };

    union {
        __I  uint32_t  STAT;

        struct {
            __I  uint32_t  STATE                          :  4;
        } STAT_bits;
    };

/* DOM-IGNORE-END */
}AG903_VODn_Type;

/** VOD Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  MACRO0;

        struct {
            __IO uint32_t  FR                             :  2;
                 uint32_t                                 : 14;
            __IO uint32_t  PM                             :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  PDX                            :  1;
        } MACRO0_bits;
    };

    union {
        __IO uint32_t  MACRO1;

        struct {
            __IO uint32_t  FR                             :  2;
                 uint32_t                                 : 14;
            __IO uint32_t  PM                             :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  PDX                            :  1;
        } MACRO1_bits;
    };

/* DOM-IGNORE-END */
}AG903_VOD_Type;

#define AG903_VODn(ch)                           ((volatile AG903_VODn_Type *)(AG903_VOD0_BASE + 0x40 * ch))             /** VODn Base Address (n=0..1) */
#define AG903_VODn_PORTSEL(ch)                   AG903_VODn(ch)->PORTSEL                                                 /** VODnPORTSEL Address (n=0..1) */
#define AG903_VODn_MOD(ch)                       AG903_VODn(ch)->MOD                                                     /** VODnMOD Address (n=0..1) */
#define AG903_VODn_BPWRMOD(ch)                   AG903_VODn(ch)->BPWRMOD                                                 /** VODnBPWRMOD Address (n=0..1) */
#define AG903_VODn_PPWRONCNT(ch)                 AG903_VODn(ch)->PPWRONCNT                                               /** VODnPPWRONCNT Address (n=0..1) */
#define AG903_VODn_BPWRONCNT(ch)                 AG903_VODn(ch)->BPWRONCNT                                               /** VODnBPWRONCNT Address (n=0..1) */
#define AG903_VODn_BLGTONCNT(ch)                 AG903_VODn(ch)->BLGTONCNT                                               /** VODnBLGTONCNT Address (n=0..1) */
#define AG903_VODn_PPWROFFCNT(ch)                AG903_VODn(ch)->PPWROFFCNT                                              /** VODnPPWROFFCNT Address (n=0..1) */
#define AG903_VODn_BPWROFFCNT(ch)                AG903_VODn(ch)->BPWROFFCNT                                              /** VODnBPWROFFCNT Address (n=0..1) */
#define AG903_VODn_BLGTOFFCNT(ch)                AG903_VODn(ch)->BLGTOFFCNT                                              /** VODnBLGTOFFCNT Address (n=0..1) */
#define AG903_VODn_PWMPERIOD(ch)                 AG903_VODn(ch)->PWMPERIOD                                               /** VODnPWMPERIOD Address (n=0..1) */
#define AG903_VODn_PWMCNT(ch)                    AG903_VODn(ch)->PWMCNT                                                  /** VODnPWMCNT Address (n=0..1) */
#define AG903_VODn_STAT(ch)                      AG903_VODn(ch)->STAT                                                    /** VODnSTAT Address (n=0..1) */

#define AG903_VOD0                               ((volatile AG903_VODn_Type *) AG903_VOD0_BASE)                          /** VODn Base Address */
#define AG903_VOD1                               ((volatile AG903_VODn_Type *) AG903_VOD1_BASE)                          /** VODn Base Address */
#define AG903_VOD                                ((volatile AG903_VOD_Type *) AG903_VOD_BASE)                            /** VOD Base Address */


#define AG903_VODn_PORTSEL_SEL_POS                         0                                                             /** VODnPORTSEL SEL-bit position */
#define AG903_VODn_PORTSEL_SEL_MSK                         (0x3UL << AG903_VODn_PORTSEL_SEL_POS)                         /** VODnPORTSEL SEL-bit mask */

#define AG903_VODn_MOD_DP_POS                              0                                                             /** VODnMOD DP-bit position */
#define AG903_VODn_MOD_DP_MSK                              (0x1UL << AG903_VODn_MOD_DP_POS)                              /** VODnMOD DP-bit mask */
#define AG903_VODn_MOD_VP_POS                              1                                                             /** VODnMOD VP-bit position */
#define AG903_VODn_MOD_VP_MSK                              (0x1UL << AG903_VODn_MOD_VP_POS)                              /** VODnMOD VP-bit mask */
#define AG903_VODn_MOD_HP_POS                              2                                                             /** VODnMOD HP-bit position */
#define AG903_VODn_MOD_HP_MSK                              (0x1UL << AG903_VODn_MOD_HP_POS)                              /** VODnMOD HP-bit mask */
#define AG903_VODn_MOD_FP_POS                              3                                                             /** VODnMOD FP-bit position */
#define AG903_VODn_MOD_FP_MSK                              (0x1UL << AG903_VODn_MOD_FP_POS)                              /** VODnMOD FP-bit mask */
#define AG903_VODn_MOD_CDP_POS                             4                                                             /** VODnMOD CDP-bit position */
#define AG903_VODn_MOD_CDP_MSK                             (0x1UL << AG903_VODn_MOD_CDP_POS)                             /** VODnMOD CDP-bit mask */
#define AG903_VODn_MOD_DEX_POS                             8                                                             /** VODnMOD DEX-bit position */
#define AG903_VODn_MOD_DEX_MSK                             (0x1UL << AG903_VODn_MOD_DEX_POS)                             /** VODnMOD DEX-bit mask */
#define AG903_VODn_MOD_VEX_POS                             9                                                             /** VODnMOD VEX-bit position */
#define AG903_VODn_MOD_VEX_MSK                             (0x1UL << AG903_VODn_MOD_VEX_POS)                             /** VODnMOD VEX-bit mask */
#define AG903_VODn_MOD_HEX_POS                             10                                                            /** VODnMOD HEX-bit position */
#define AG903_VODn_MOD_HEX_MSK                             (0x1UL << AG903_VODn_MOD_HEX_POS)                             /** VODnMOD HEX-bit mask */
#define AG903_VODn_MOD_FEX_POS                             11                                                            /** VODnMOD FEX-bit position */
#define AG903_VODn_MOD_FEX_MSK                             (0x1UL << AG903_VODn_MOD_FEX_POS)                             /** VODnMOD FEX-bit mask */
#define AG903_VODn_MOD_CDEX_POS                            12                                                            /** VODnMOD CDEX-bit position */
#define AG903_VODn_MOD_CDEX_MSK                            (0x1UL << AG903_VODn_MOD_CDEX_POS)                            /** VODnMOD CDEX-bit mask */
#define AG903_VODn_MOD_PEX_POS                             13                                                            /** VODnMOD PEX-bit position */
#define AG903_VODn_MOD_PEX_MSK                             (0x1UL << AG903_VODn_MOD_PEX_POS)                             /** VODnMOD PEX-bit mask */
#define AG903_VODn_MOD_CP_POS                              16                                                            /** VODnMOD CP-bit position */
#define AG903_VODn_MOD_CP_MSK                              (0x1UL << AG903_VODn_MOD_CP_POS)                              /** VODnMOD CP-bit mask */
#define AG903_VODn_MOD_CODE_POS                            17                                                            /** VODnMOD CODE-bit position */
#define AG903_VODn_MOD_CODE_MSK                            (0x1UL << AG903_VODn_MOD_CODE_POS)                            /** VODnMOD CODE-bit mask */
#define AG903_VODn_MOD_YUV_POS                             18                                                            /** VODnMOD YUV-bit position */
#define AG903_VODn_MOD_YUV_MSK                             (0x1UL << AG903_VODn_MOD_YUV_POS)                             /** VODnMOD YUV-bit mask */
#define AG903_VODn_MOD_FMT_POS                             24                                                            /** VODnMOD FMT-bit position */
#define AG903_VODn_MOD_FMT_MSK                             (0x3UL << AG903_VODn_MOD_FMT_POS)                             /** VODnMOD FMT-bit mask */
#define AG903_VODn_MOD_CT0_POS                             26                                                            /** VODnMOD CT0-bit position */
#define AG903_VODn_MOD_CT0_MSK                             (0x1UL << AG903_VODn_MOD_CT0_POS)                             /** VODnMOD CT0-bit mask */
#define AG903_VODn_MOD_CT1_POS                             27                                                            /** VODnMOD CT1-bit position */
#define AG903_VODn_MOD_CT1_MSK                             (0x1UL << AG903_VODn_MOD_CT1_POS)                             /** VODnMOD CT1-bit mask */

#define AG903_VODn_BPWRMOD_EN_POS                          0                                                             /** VODnBPWRMOD EN-bit position */
#define AG903_VODn_BPWRMOD_EN_MSK                          (0x1UL << AG903_VODn_BPWRMOD_EN_POS)                          /** VODnBPWRMOD EN-bit mask */
#define AG903_VODn_BPWRMOD_UNIT_POS                        16                                                            /** VODnBPWRMOD UNIT-bit position */
#define AG903_VODn_BPWRMOD_UNIT_MSK                        (0x1UL << AG903_VODn_BPWRMOD_UNIT_POS)                        /** VODnBPWRMOD UNIT-bit mask */

#define AG903_VODn_PPWRONCNT_CNT_POS                       0                                                             /** VODnPPWRONCNT CNT-bit position */
#define AG903_VODn_PPWRONCNT_CNT_MSK                       (0xffffffffUL << AG903_VODn_PPWRONCNT_CNT_POS)                /** VODnPPWRONCNT CNT-bit mask */

#define AG903_VODn_BPWRONCNT_CNT_POS                       0                                                             /** VODnBPWRONCNT CNT-bit position */
#define AG903_VODn_BPWRONCNT_CNT_MSK                       (0xffffffffUL << AG903_VODn_BPWRONCNT_CNT_POS)                /** VODnBPWRONCNT CNT-bit mask */

#define AG903_VODn_BLGTONCNT_CNT_POS                       0                                                             /** VODnBLGTONCNT CNT-bit position */
#define AG903_VODn_BLGTONCNT_CNT_MSK                       (0xffffffffUL << AG903_VODn_BLGTONCNT_CNT_POS)                /** VODnBLGTONCNT CNT-bit mask */

#define AG903_VODn_PPWROFFCNT_CNT_POS                      0                                                             /** VODnPPWROFFCNT CNT-bit position */
#define AG903_VODn_PPWROFFCNT_CNT_MSK                      (0xffffffffUL << AG903_VODn_PPWROFFCNT_CNT_POS)               /** VODnPPWROFFCNT CNT-bit mask */

#define AG903_VODn_BPWROFFCNT_CNT_POS                      0                                                             /** VODnBPWROFFCNT CNT-bit position */
#define AG903_VODn_BPWROFFCNT_CNT_MSK                      (0xffffffffUL << AG903_VODn_BPWROFFCNT_CNT_POS)               /** VODnBPWROFFCNT CNT-bit mask */

#define AG903_VODn_BLGTOFFCNT_CNT_POS                      0                                                             /** VODnBLGTOFFCNT CNT-bit position */
#define AG903_VODn_BLGTOFFCNT_CNT_MSK                      (0xffffffffUL << AG903_VODn_BLGTOFFCNT_CNT_POS)               /** VODnBLGTOFFCNT CNT-bit mask */

#define AG903_VODn_PWMPERIOD_PERIOD_POS                    0                                                             /** VODnPWMPERIOD PERIOD-bit position */
#define AG903_VODn_PWMPERIOD_PERIOD_MSK                    (0xffffffffUL << AG903_VODn_PWMPERIOD_PERIOD_POS)             /** VODnPWMPERIOD PERIOD-bit mask */

#define AG903_VODn_PWMCNT_CNT_POS                          0                                                             /** VODnPWMCNT CNT-bit position */
#define AG903_VODn_PWMCNT_CNT_MSK                          (0xffffffffUL << AG903_VODn_PWMCNT_CNT_POS)                   /** VODnPWMCNT CNT-bit mask */

#define AG903_VODn_STAT_STATE_POS                          0                                                             /** VODnSTAT STATE-bit position */
#define AG903_VODn_STAT_STATE_MSK                          (0xfUL << AG903_VODn_STAT_STATE_POS)                          /** VODnSTAT STATE-bit mask */

#define AG903_VOD_MACRO0_FR_POS                            0                                                             /** VODMACRO0 FR-bit position */
#define AG903_VOD_MACRO0_FR_MSK                            (0x3UL << AG903_VOD_MACRO0_FR_POS)                            /** VODMACRO0 FR-bit mask */
#define AG903_VOD_MACRO0_PM_POS                            16                                                            /** VODMACRO0 PM-bit position */
#define AG903_VOD_MACRO0_PM_MSK                            (0x1UL << AG903_VOD_MACRO0_PM_POS)                            /** VODMACRO0 PM-bit mask */
#define AG903_VOD_MACRO0_PDX_POS                           24                                                            /** VODMACRO0 PDX-bit position */
#define AG903_VOD_MACRO0_PDX_MSK                           (0x1UL << AG903_VOD_MACRO0_PDX_POS)                           /** VODMACRO0 PDX-bit mask */

#define AG903_VOD_MACRO1_FR_POS                            0                                                             /** VODMACRO1 FR-bit position */
#define AG903_VOD_MACRO1_FR_MSK                            (0x3UL << AG903_VOD_MACRO1_FR_POS)                            /** VODMACRO1 FR-bit mask */
#define AG903_VOD_MACRO1_PM_POS                            16                                                            /** VODMACRO1 PM-bit position */
#define AG903_VOD_MACRO1_PM_MSK                            (0x1UL << AG903_VOD_MACRO1_PM_POS)                            /** VODMACRO1 PM-bit mask */
#define AG903_VOD_MACRO1_PDX_POS                           24                                                            /** VODMACRO1 PDX-bit position */
#define AG903_VOD_MACRO1_PDX_MSK                           (0x1UL << AG903_VOD_MACRO1_PDX_POS)                           /** VODMACRO1 PDX-bit mask */


#endif /* _AG903_VOD_REGMAP_H_ */

