/**
 * @brief           SPC Additional Bit Define Header
 * @author          AXELL CORPORATION
 * @description     SPC̃NbNQ[eBO, \tgEFAZbgpǉrbg`
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _SPCDEF_H_
#define _SPCDEF_H_
/* DOM-IGNORE-END */

/* Clock gating */
#define AG903_SPC_AHB_CLK_CTRL_ATA_POS            25                                                /** SPCAHB_CLK_CTRL ATA-bit position */
#define AG903_SPC_AHB_CLK_CTRL_ATA_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_ATA_POS)               /** SPCAHB_CLK_CTRL ATA-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_SMC_POS            24                                                /** SPCAHB_CLK_CTRL SMC-bit position */
#define AG903_SPC_AHB_CLK_CTRL_SMC_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_SMC_POS)               /** SPCAHB_CLK_CTRL SMC-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_H2P_POS            23                                                /** SPCAHB_CLK_CTRL H2P-bit position */
#define AG903_SPC_AHB_CLK_CTRL_H2P_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_H2P_POS)               /** SPCAHB_CLK_CTRL H2P-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_SPI_POS            22                                                /** SPCAHB_CLK_CTRL SPI-bit position */
#define AG903_SPC_AHB_CLK_CTRL_SPI_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_SPI_POS)               /** SPCAHB_CLK_CTRL SPI-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_EBI_POS            21                                                /** SPCAHB_CLK_CTRL EBI-bit position */
#define AG903_SPC_AHB_CLK_CTRL_EBI_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_EBI_POS)               /** SPCAHB_CLK_CTRL EBI-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_BSC_POS            20                                                /** SPCAHB_CLK_CTRL BSC-bit position */
#define AG903_SPC_AHB_CLK_CTRL_BSC_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_BSC_POS)               /** SPCAHB_CLK_CTRL BSC-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_X2H3_POS           19                                                /** SPCAHB_CLK_CTRL X2H3-bit position */
#define AG903_SPC_AHB_CLK_CTRL_X2H3_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_X2H3_POS)              /** SPCAHB_CLK_CTRL X2H3-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_X2H1_POS           18                                                /** SPCAHB_CLK_CTRL X2H1-bit position */
#define AG903_SPC_AHB_CLK_CTRL_X2H1_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_X2H1_POS)              /** SPCAHB_CLK_CTRL X2H1-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_HBCB_POS           17                                                /** SPCAHB_CLK_CTRL HBCB-bit position */
#define AG903_SPC_AHB_CLK_CTRL_HBCB_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_HBCB_POS)              /** SPCAHB_CLK_CTRL HBCB-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_HBCP_POS           16                                                /** SPCAHB_CLK_CTRL HBCP-bit position */
#define AG903_SPC_AHB_CLK_CTRL_HBCP_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_HBCP_POS)              /** SPCAHB_CLK_CTRL HBCP-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_USBP_POS           12                                                /** SPCAHB_CLK_CTRL USBP-bit position */
#define AG903_SPC_AHB_CLK_CTRL_USBP_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_USBP_POS)              /** SPCAHB_CLK_CTRL USBP-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_DDR7_POS           11                                                /** SPCAHB_CLK_CTRL DDR7-bit position */
#define AG903_SPC_AHB_CLK_CTRL_DDR7_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_DDR7_POS)              /** SPCAHB_CLK_CTRL DDR7-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_USBC_POS           10                                                /** SPCAHB_CLK_CTRL USBC-bit position */
#define AG903_SPC_AHB_CLK_CTRL_USBC_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_USBC_POS)              /** SPCAHB_CLK_CTRL USBC-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_SDC_POS            9                                                 /** SPCAHB_CLK_CTRL SDC-bit position */
#define AG903_SPC_AHB_CLK_CTRL_SDC_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_SDC_POS)               /** SPCAHB_CLK_CTRL SDC-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_ETH_POS            8                                                 /** SPCAHB_CLK_CTRL ETH-bit position */
#define AG903_SPC_AHB_CLK_CTRL_ETH_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_ETH_POS)               /** SPCAHB_CLK_CTRL ETH-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_H2X_POS            6                                                 /** SPCAHB_CLK_CTRL H2X-bit position */
#define AG903_SPC_AHB_CLK_CTRL_H2X_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_H2X_POS)               /** SPCAHB_CLK_CTRL H2X-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_X2H0_POS           5                                                 /** SPCAHB_CLK_CTRL X2H0-bit position */
#define AG903_SPC_AHB_CLK_CTRL_X2H0_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_X2H0_POS)              /** SPCAHB_CLK_CTRL X2H0-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_ALS_POS            3                                                 /** SPCAHB_CLK_CTRL ALS-bit position */
#define AG903_SPC_AHB_CLK_CTRL_ALS_MSK            (1<<AG903_SPC_AHB_CLK_CTRL_ALS_POS)               /** SPCAHB_CLK_CTRL ALS-bit mask */
#define AG903_SPC_AHB_CLK_CTRL_HBCM_POS           1                                                 /** SPCAHB_CLK_CTRL HBCM-bit position */
#define AG903_SPC_AHB_CLK_CTRL_HBCM_MSK           (1<<AG903_SPC_AHB_CLK_CTRL_HBCM_POS)              /** SPCAHB_CLK_CTRL HBCM-bit mask */

#define AG903_SPC_APB_CLK_CTRL_UART3_POS          27                                                /** SPCAPB_CLK_CTRL UART3-bit position */
#define AG903_SPC_APB_CLK_CTRL_UART3_MSK          (1<<AG903_SPC_APB_CLK_CTRL_UART3_POS)             /** SPCAPB_CLK_CTRL UART3-bit % */
#define AG903_SPC_APB_CLK_CTRL_UART2_POS          26                                                /** SPCAPB_CLK_CTRL UART2-bit position */
#define AG903_SPC_APB_CLK_CTRL_UART2_MSK          (1<<AG903_SPC_APB_CLK_CTRL_UART2_POS)             /** SPCAPB_CLK_CTRL UART2-bit % */
#define AG903_SPC_APB_CLK_CTRL_UART1_POS          25                                                /** SPCAPB_CLK_CTRL UART1-bit position */
#define AG903_SPC_APB_CLK_CTRL_UART1_MSK          (1<<AG903_SPC_APB_CLK_CTRL_UART1_POS)             /** SPCAPB_CLK_CTRL UART1-bit % */
#define AG903_SPC_APB_CLK_CTRL_UART0_POS          24                                                /** SPCAPB_CLK_CTRL UART0-bit position */
#define AG903_SPC_APB_CLK_CTRL_UART0_MSK          (1<<AG903_SPC_APB_CLK_CTRL_UART0_POS)             /** SPCAPB_CLK_CTRL UART0-bit % */
#define AG903_SPC_APB_CLK_CTRL_CA5_POS            19                                                /** SPCAPB_CLK_CTRL CA5-bit position */
#define AG903_SPC_APB_CLK_CTRL_CA5_MSK            (1<<AG903_SPC_APB_CLK_CTRL_CA5_POS)               /** SPCAPB_CLK_CTRL CA5-bit % */
#define AG903_SPC_APB_CLK_CTRL_H2X_POS            18                                                /** SPCAPB_CLK_CTRL H2X-bit position */
#define AG903_SPC_APB_CLK_CTRL_H2X_MSK            (1<<AG903_SPC_APB_CLK_CTRL_H2X_POS)               /** SPCAPB_CLK_CTRL H2X-bit % */
#define AG903_SPC_APB_CLK_CTRL_IFW_POS            17                                                /** SPCAPB_CLK_CTRL IFW-bit position */
#define AG903_SPC_APB_CLK_CTRL_IFW_MSK            (1<<AG903_SPC_APB_CLK_CTRL_IFW_POS)               /** SPCAPB_CLK_CTRL IFW-bit % */
#define AG903_SPC_APB_CLK_CTRL_IWM_POS            16                                                /** SPCAPB_CLK_CTRL IWM-bit position */
#define AG903_SPC_APB_CLK_CTRL_IWM_MSK            (1<<AG903_SPC_APB_CLK_CTRL_IWM_POS)               /** SPCAPB_CLK_CTRL IWM-bit % */
#define AG903_SPC_APB_CLK_CTRL_X2H4_POS           15                                                /** SPCAPB_CLK_CTRL X2H4-bit position */
#define AG903_SPC_APB_CLK_CTRL_X2H4_MSK           (1<<AG903_SPC_APB_CLK_CTRL_X2H4_POS)              /** SPCAPB_CLK_CTRL X2H4-bit % */
#define AG903_SPC_APB_CLK_CTRL_X2H3_POS           14                                                /** SPCAPB_CLK_CTRL X2H3-bit position */
#define AG903_SPC_APB_CLK_CTRL_X2H3_MSK           (1<<AG903_SPC_APB_CLK_CTRL_X2H3_POS)              /** SPCAPB_CLK_CTRL X2H3-bit % */
#define AG903_SPC_APB_CLK_CTRL_X2H2_POS           13                                                /** SPCAPB_CLK_CTRL X2H2-bit position */
#define AG903_SPC_APB_CLK_CTRL_X2H2_MSK           (1<<AG903_SPC_APB_CLK_CTRL_X2H2_POS)              /** SPCAPB_CLK_CTRL X2H2-bit % */
#define AG903_SPC_APB_CLK_CTRL_X2H1_POS           12                                                /** SPCAPB_CLK_CTRL X2H1-bit position */
#define AG903_SPC_APB_CLK_CTRL_X2H1_MSK           (1<<AG903_SPC_APB_CLK_CTRL_X2H1_POS)              /** SPCAPB_CLK_CTRL X2H1-bit % */
#define AG903_SPC_APB_CLK_CTRL_X2H0_POS           11                                                /** SPCAPB_CLK_CTRL X2H0-bit position */
#define AG903_SPC_APB_CLK_CTRL_X2H0_MSK           (1<<AG903_SPC_APB_CLK_CTRL_X2H0_POS)              /** SPCAPB_CLK_CTRL X2H0-bit % */
#define AG903_SPC_APB_CLK_CTRL_AXIC_POS           10                                                /** SPCAPB_CLK_CTRL AXIC-bit position */
#define AG903_SPC_APB_CLK_CTRL_AXIC_MSK           (1<<AG903_SPC_APB_CLK_CTRL_AXIC_POS)              /** SPCAPB_CLK_CTRL AXIC-bit % */
#define AG903_SPC_APB_CLK_CTRL_DDR_POS            9                                                 /** SPCAPB_CLK_CTRL DDR-bit position */
#define AG903_SPC_APB_CLK_CTRL_DDR_MSK            (1<<AG903_SPC_APB_CLK_CTRL_DDR_POS)               /** SPCAPB_CLK_CTRL DDR-bit % */
#define AG903_SPC_APB_CLK_CTRL_DMAC_POS           8                                                 /** SPCAPB_CLK_CTRL DMAC-bit position */
#define AG903_SPC_APB_CLK_CTRL_DMAC_MSK           (1<<AG903_SPC_APB_CLK_CTRL_DMAC_POS)              /** SPCAPB_CLK_CTRL DMAC-bit % */
#define AG903_SPC_APB_CLK_CTRL_WDT_POS            7                                                 /** SPCAPB_CLK_CTRL WDT-bit position */
#define AG903_SPC_APB_CLK_CTRL_WDT_MSK            (1<<AG903_SPC_APB_CLK_CTRL_WDT_POS)               /** SPCAPB_CLK_CTRL WDT-bit mask */
#define AG903_SPC_APB_CLK_CTRL_SSP3_POS           6                                                 /** SPCAPB_CLK_CTRL SSP3-bit position */
#define AG903_SPC_APB_CLK_CTRL_SSP3_MSK           (1<<AG903_SPC_APB_CLK_CTRL_SSP3_POS)              /** SPCAPB_CLK_CTRL SSP3-bit mask */
#define AG903_SPC_APB_CLK_CTRL_SSP2_POS           5                                                 /** SPCAPB_CLK_CTRL SSP2-bit position */
#define AG903_SPC_APB_CLK_CTRL_SSP2_MSK           (1<<AG903_SPC_APB_CLK_CTRL_SSP2_POS)              /** SPCAPB_CLK_CTRL SSP2-bit mask */
#define AG903_SPC_APB_CLK_CTRL_SSP1_POS           4                                                 /** SPCAPB_CLK_CTRL SSP1-bit position */
#define AG903_SPC_APB_CLK_CTRL_SSP1_MSK           (1<<AG903_SPC_APB_CLK_CTRL_SSP1_POS)              /** SPCAPB_CLK_CTRL SSP1-bit mask */
#define AG903_SPC_APB_CLK_CTRL_SSP0_POS           3                                                 /** SPCAPB_CLK_CTRL SSP0-bit position */
#define AG903_SPC_APB_CLK_CTRL_SSP0_MSK           (1<<AG903_SPC_APB_CLK_CTRL_SSP0_POS)              /** SPCAPB_CLK_CTRL SSP0-bit mask */
#define AG903_SPC_APB_CLK_CTRL_IIC1_POS           2                                                 /** SPCAPB_CLK_CTRL IIC1-bit position */
#define AG903_SPC_APB_CLK_CTRL_IIC1_MSK           (1<<AG903_SPC_APB_CLK_CTRL_IIC1_POS)              /** SPCAPB_CLK_CTRL IIC1-bit mask */
#define AG903_SPC_APB_CLK_CTRL_IIC0_POS           1                                                 /** SPCAPB_CLK_CTRL IIC0-bit position */
#define AG903_SPC_APB_CLK_CTRL_IIC0_MSK           (1<<AG903_SPC_APB_CLK_CTRL_IIC0_POS)              /** SPCAPB_CLK_CTRL IIC0-bit mask */
#define AG903_SPC_APB_CLK_CTRL_X2PP_POS           0                                                 /** SPCAPB_CLK_CTRL X2PP-bit position */
#define AG903_SPC_APB_CLK_CTRL_X2PP_MSK           (1<<AG903_SPC_APB_CLK_CTRL_X2PP_POS)              /** SPCAPB_CLK_CTRL X2PP-bit mask */

#define AG903_SPC_AXI_CLK_CTRL1_OSP_POS           20                                                /** SPCAXI_CLK_CTRL1 OSP-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_OSP_MSK           (1<<AG903_SPC_AXI_CLK_CTRL1_OSP_POS)              /** SPCAXI_CLK_CTRL1 OSP-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_ACP_POS           19                                                /** SPCAXI_CLK_CTRL1 ACP-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_ACP_MSK           (1<<AG903_SPC_AXI_CLK_CTRL1_ACP_POS)              /** SPCAXI_CLK_CTRL1 ACP-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_DDR6_POS          18                                                /** SPCAXI_CLK_CTRL1 DDR6-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_DDR6_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_DDR6_POS)             /** SPCAXI_CLK_CTRL1 DDR6-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_DDR5_POS          17                                                /** SPCAXI_CLK_CTRL1 DDR5-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_DDR5_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_DDR5_POS)             /** SPCAXI_CLK_CTRL1 DDR5-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_DDR4_POS          16                                                /** SPCAXI_CLK_CTRL1 DDR4-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_DDR4_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_DDR4_POS)             /** SPCAXI_CLK_CTRL1 DDR4-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_DDR3_POS          15                                                /** SPCAXI_CLK_CTRL1 DDR3-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_DDR3_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_DDR3_POS)             /** SPCAXI_CLK_CTRL1 DDR3-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_DDR2_POS          14                                                /** SPCAXI_CLK_CTRL1 DDR2-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_DDR2_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_DDR2_POS)             /** SPCAXI_CLK_CTRL1 DDR2-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_DDR1_POS          13                                                /** SPCAXI_CLK_CTRL1 DDR1-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_DDR1_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_DDR1_POS)             /** SPCAXI_CLK_CTRL1 DDR1-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_DDR0_POS          12                                                /** SPCAXI_CLK_CTRL1 DDR0-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_DDR0_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_DDR0_POS)             /** SPCAXI_CLK_CTRL1 DDR0-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_PBD_POS           11                                                /** SPCAXI_CLK_CTRL1 PBD-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_PBD_MSK           (1<<AG903_SPC_AXI_CLK_CTRL1_PBD_POS)              /** SPCAXI_CLK_CTRL1 PBD-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_X2PM_POS          10                                                /** SPCAXI_CLK_CTRL1 X2PM-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_X2PM_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_X2PM_POS)             /** SPCAXI_CLK_CTRL1 X2PM-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_X2PP_POS          9                                                 /** SPCAXI_CLK_CTRL1 X2PP-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_X2PP_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_X2PP_POS)             /** SPCAXI_CLK_CTRL1 X2PP-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_X2H4_POS          8                                                 /** SPCAXI_CLK_CTRL1 X2H4-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_X2H4_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_X2H4_POS)             /** SPCAXI_CLK_CTRL1 X2H4-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_X2H3_POS          7                                                 /** SPCAXI_CLK_CTRL1 X2H3-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_X2H3_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_X2H3_POS)             /** SPCAXI_CLK_CTRL1 X2H3-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_X2H2_POS          6                                                 /** SPCAXI_CLK_CTRL1 X2H2-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_X2H2_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_X2H2_POS)             /** SPCAXI_CLK_CTRL1 X2H2-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_X2H1_POS          5                                                 /** SPCAXI_CLK_CTRL1 X2H1-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_X2H1_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_X2H1_POS)             /** SPCAXI_CLK_CTRL1 X2H1-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_X2H0_POS          4                                                 /** SPCAXI_CLK_CTRL1 X2H0-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_X2H0_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_X2H0_POS)             /** SPCAXI_CLK_CTRL1 X2H0-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_H2X_POS           3                                                 /** SPCAXI_CLK_CTRL1 H2X-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_H2X_MSK           (1<<AG903_SPC_AXI_CLK_CTRL1_H2X_POS)              /** SPCAXI_CLK_CTRL1 H2X-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_DMAC_POS          2                                                 /** SPCAXI_CLK_CTRL1 DMAC-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_DMAC_MSK          (1<<AG903_SPC_AXI_CLK_CTRL1_DMAC_POS)             /** SPCAXI_CLK_CTRL1 DMAC-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_IFW_POS           1                                                 /** SPCAXI_CLK_CTRL1 IFW-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_IFW_MSK           (1<<AG903_SPC_AXI_CLK_CTRL1_IFW_POS)              /** SPCAXI_CLK_CTRL1 IFW-bit mask */
#define AG903_SPC_AXI_CLK_CTRL1_IWM_POS           0                                                 /** SPCAXI_CLK_CTRL1 IWM-bit position */
#define AG903_SPC_AXI_CLK_CTRL1_IWM_MSK           (1<<AG903_SPC_AXI_CLK_CTRL1_IWM_POS)              /** SPCAXI_CLK_CTRL1 IWM-bit mask */

#define AG903_SPC_AXI_CLK_CTRL2_GFXC3_POS         12                                                /** SPCAXI_CLK_CTRL2 GFXC3-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_GFXC3_MSK         (1<<AG903_SPC_AXI_CLK_CTRL2_GFXC3_POS)            /** SPCAXI_CLK_CTRL2 GFXC3-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_GFXC2_POS         11                                                /** SPCAXI_CLK_CTRL2 GFXC2-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_GFXC2_MSK         (1<<AG903_SPC_AXI_CLK_CTRL2_GFXC2_POS)            /** SPCAXI_CLK_CTRL2 GFXC2-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_GFXC1_POS         10                                                /** SPCAXI_CLK_CTRL2 GFXC1-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_GFXC1_MSK         (1<<AG903_SPC_AXI_CLK_CTRL2_GFXC1_POS)            /** SPCAXI_CLK_CTRL2 GFXC1-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_GVDC_POS          9                                                 /** SPCAXI_CLK_CTRL2 GVDC-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_GVDC_MSK          (1<<AG903_SPC_AXI_CLK_CTRL2_GVDC_POS)             /** SPCAXI_CLK_CTRL2 GVDC-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_VID_POS           8                                                 /** SPCAXI_CLK_CTRL2 VID-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_VID_MSK           (1<<AG903_SPC_AXI_CLK_CTRL2_VID_POS)              /** SPCAXI_CLK_CTRL2 VID-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_PGP_POS           7                                                 /** SPCAXI_CLK_CTRL2 PGP-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_PGP_MSK           (1<<AG903_SPC_AXI_CLK_CTRL2_PGP_POS)              /** SPCAXI_CLK_CTRL2 PGP-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_GVDB_POS          6                                                 /** SPCAXI_CLK_CTRL2 GVDB-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_GVDB_MSK          (1<<AG903_SPC_AXI_CLK_CTRL2_GVDB_POS)             /** SPCAXI_CLK_CTRL2 GVDB-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_HDA_POS           5                                                 /** SPCAXI_CLK_CTRL2 HDA-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_HDA_MSK           (1<<AG903_SPC_AXI_CLK_CTRL2_HDA_POS)              /** SPCAXI_CLK_CTRL2 HDA-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_JPG_POS           4                                                 /** SPCAXI_CLK_CTRL2 JPG-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_JPG_MSK           (1<<AG903_SPC_AXI_CLK_CTRL2_JPG_POS)              /** SPCAXI_CLK_CTRL2 JPG-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_GFX_POS           3                                                 /** SPCAXI_CLK_CTRL2 GFX-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_GFX_MSK           (1<<AG903_SPC_AXI_CLK_CTRL2_GFX_POS)              /** SPCAXI_CLK_CTRL2 GFX-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_EQS_POS           2                                                 /** SPCAXI_CLK_CTRL2 EQS-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_EQS_MSK           (1<<AG903_SPC_AXI_CLK_CTRL2_EQS_POS)              /** SPCAXI_CLK_CTRL2 EQS-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_DSP_POS           1                                                 /** SPCAXI_CLK_CTRL2 DSP-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_DSP_MSK           (1<<AG903_SPC_AXI_CLK_CTRL2_DSP_POS)              /** SPCAXI_CLK_CTRL2 DSP-bit mask */
#define AG903_SPC_AXI_CLK_CTRL2_DTA_POS           0                                                 /** SPCAXI_CLK_CTRL2 DTA-bit position */
#define AG903_SPC_AXI_CLK_CTRL2_DTA_MSK           (1<<AG903_SPC_AXI_CLK_CTRL2_DTA_POS)              /** SPCAXI_CLK_CTRL2 DTA-bit mask */

#define AG903_SPC_APB_SDMC_CLK_CTRL_X2H4_POS      2                                                 /** SPCAPB_SDMC_CLK_CTRL X2H4-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_X2H4_MSK      (1<<AG903_SPC_APB_SDMC_CLK_CTRL_X2H4_POS)         /** SPCAPB_SDMC_CLK_CTRL X2H4-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_X2H2_POS      1                                                 /** SPCAPB_SDMC_CLK_CTRL X2H2-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_X2H2_MSK      (1<<AG903_SPC_APB_SDMC_CLK_CTRL_X2H2_POS)         /** SPCAPB_SDMC_CLK_CTRL X2H2-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_SDMC_POS      0                                                 /** SPCAPB_SDMC_CLK_CTRL SDMC-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_SDMC_MSK      (1<<AG903_SPC_APB_SDMC_CLK_CTRL_SDMC_POS)         /** SPCAPB_SDMC_CLK_CTRL SDMC-bit mask */

#define AG903_SPC_APB_SDMC_CLK_CTRL_CFC_POS       17                                                /** SPCAPB_SDMC_CLK_CTRL CFC-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_CFC_MSK       (1<<AG903_SPC_APB_SDMC_CLK_CTRL_CFC_POS)          /** SPCAPB_SDMC_CLK_CTRL CFC-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_H2P_POS       16                                                /** SPCAPB_SDMC_CLK_CTRL H2P-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_H2P_MSK       (1<<AG903_SPC_APB_SDMC_CLK_CTRL_H2P_POS)          /** SPCAPB_SDMC_CLK_CTRL H2P-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GFXC_POS      14                                                /** SPCAPB_SDMC_CLK_CTRL GFXC-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GFXC_MSK      (1<<AG903_SPC_APB_SDMC_CLK_CTRL_GFXC_POS)         /** SPCAPB_SDMC_CLK_CTRL GFXC-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GVD_POS       12                                                /** SPCAPB_SDMC_CLK_CTRL GVD-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GVD_MSK       (1<<AG903_SPC_APB_SDMC_CLK_CTRL_GVD_POS)          /** SPCAPB_SDMC_CLK_CTRL GVD-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_PGP_POS       11                                                /** SPCAPB_SDMC_CLK_CTRL PGP-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_PGP_MSK       (1<<AG903_SPC_APB_SDMC_CLK_CTRL_PGP_POS)          /** SPCAPB_SDMC_CLK_CTRL PGP-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_VID_POS       10                                                /** SPCAPB_SDMC_CLK_CTRL VID-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_VID_MSK       (1<<AG903_SPC_APB_SDMC_CLK_CTRL_VID_POS)          /** SPCAPB_SDMC_CLK_CTRL VID-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_TIM_POS       9                                                 /** SPCAPB_SDMC_CLK_CTRL TIM-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_TIM_MSK       (1<<AG903_SPC_APB_SDMC_CLK_CTRL_TIM_POS)          /** SPCAPB_SDMC_CLK_CTRL TIM-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GPIO3_POS     8                                                 /** SPCAPB_SDMC_CLK_CTRL GPIO3-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GPIO3_MSK     (1<<AG903_SPC_APB_SDMC_CLK_CTRL_GPIO3_POS)        /** SPCAPB_SDMC_CLK_CTRL GPIO3-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GPIO2_POS     7                                                 /** SPCAPB_SDMC_CLK_CTRL GPIO2-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GPIO2_MSK     (1<<AG903_SPC_APB_SDMC_CLK_CTRL_GPIO2_POS)        /** SPCAPB_SDMC_CLK_CTRL GPIO2-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GPIO1_POS     6                                                 /** SPCAPB_SDMC_CLK_CTRL GPIO1-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GPIO1_MSK     (1<<AG903_SPC_APB_SDMC_CLK_CTRL_GPIO1_POS)        /** SPCAPB_SDMC_CLK_CTRL GPIO1-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GPIO0_POS     5                                                 /** SPCAPB_SDMC_CLK_CTRL GPIO0-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GPIO0_MSK     (1<<AG903_SPC_APB_SDMC_CLK_CTRL_GPIO0_POS)        /** SPCAPB_SDMC_CLK_CTRL GPIO0-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_BMU_POS       3                                                 /** SPCAPB_SDMC_CLK_CTRL BMU-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_BMU_MSK       (1<<AG903_SPC_APB_SDMC_CLK_CTRL_BMU_POS)          /** SPCAPB_SDMC_CLK_CTRL BMU-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_SSC_POS       2                                                 /** SPCAPB_SDMC_CLK_CTRL SSC-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_SSC_MSK       (1<<AG903_SPC_APB_SDMC_CLK_CTRL_SSC_POS)          /** SPCAPB_SDMC_CLK_CTRL SSC-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GFXR_POS      1                                                 /** SPCAPB_SDMC_CLK_CTRL GFXR-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_GFXR_MSK      (1<<AG903_SPC_APB_SDMC_CLK_CTRL_GFXR_POS)         /** SPCAPB_SDMC_CLK_CTRL GFXR-bit mask */
#define AG903_SPC_APB_SDMC_CLK_CTRL_X2PM_POS      0                                                 /** SPCAPB_SDMC_CLK_CTRL X2PM-bit position */
#define AG903_SPC_APB_SDMC_CLK_CTRL_X2PM_MSK      (1<<AG903_SPC_APB_SDMC_CLK_CTRL_X2PM_POS)         /** SPCAPB_SDMC_CLK_CTRL X2PM-bit mask */

#define AG903_SPC_MISC_CLK_CTRL_HDA_POS           28                                                /** SPCMISC_CLK_CTRL HDA-bit position */
#define AG903_SPC_MISC_CLK_CTRL_HDA_MSK           (1<<AG903_SPC_MISC_CLK_CTRL_HDA_POS)              /** SPCMISC_CLK_CTRL HDA-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_SSP3_POS          27                                                /** SPCMISC_CLK_CTRL SSP3-bit position */
#define AG903_SPC_MISC_CLK_CTRL_SSP3_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_SSP3_POS)             /** SPCMISC_CLK_CTRL SSP3-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_SSP2_POS          26                                                /** SPCMISC_CLK_CTRL SSP2-bit position */
#define AG903_SPC_MISC_CLK_CTRL_SSP2_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_SSP2_POS)             /** SPCMISC_CLK_CTRL SSP2-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_SSP1_POS          25                                                /** SPCMISC_CLK_CTRL SSP1-bit position */
#define AG903_SPC_MISC_CLK_CTRL_SSP1_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_SSP1_POS)             /** SPCMISC_CLK_CTRL SSP1-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_SSP0_POS          24                                                /** SPCMISC_CLK_CTRL SSP0-bit position */
#define AG903_SPC_MISC_CLK_CTRL_SSP0_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_SSP0_POS)             /** SPCMISC_CLK_CTRL SSP0-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_PGPA3_POS         23                                                /** SPCMISC_CLK_CTRL PGPA3-bit position */
#define AG903_SPC_MISC_CLK_CTRL_PGPA3_MSK         (1<<AG903_SPC_MISC_CLK_CTRL_PGPA3_POS)            /** SPCMISC_CLK_CTRL PGPA3-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_PGPA2_POS         22                                                /** SPCMISC_CLK_CTRL PGPA2-bit position */
#define AG903_SPC_MISC_CLK_CTRL_PGPA2_MSK         (1<<AG903_SPC_MISC_CLK_CTRL_PGPA2_POS)            /** SPCMISC_CLK_CTRL PGPA2-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_PGPA1_POS         21                                                /** SPCMISC_CLK_CTRL PGPA1-bit position */
#define AG903_SPC_MISC_CLK_CTRL_PGPA1_MSK         (1<<AG903_SPC_MISC_CLK_CTRL_PGPA1_POS)            /** SPCMISC_CLK_CTRL PGPA1-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_PGPA0_POS         20                                                /** SPCMISC_CLK_CTRL PGPA0-bit position */
#define AG903_SPC_MISC_CLK_CTRL_PGPA0_MSK         (1<<AG903_SPC_MISC_CLK_CTRL_PGPA0_POS)            /** SPCMISC_CLK_CTRL PGPA0-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_PGPD1_POS         19                                                /** SPCMISC_CLK_CTRL PGPD1-bit position */
#define AG903_SPC_MISC_CLK_CTRL_PGPD1_MSK         (1<<AG903_SPC_MISC_CLK_CTRL_PGPD1_POS)            /** SPCMISC_CLK_CTRL PGPD1-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_PGPD0_POS         18                                                /** SPCMISC_CLK_CTRL PGPD0-bit position */
#define AG903_SPC_MISC_CLK_CTRL_PGPD0_MSK         (1<<AG903_SPC_MISC_CLK_CTRL_PGPD0_POS)            /** SPCMISC_CLK_CTRL PGPD0-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_VID1_POS          17                                                /** SPCMISC_CLK_CTRL VID1-bit position */
#define AG903_SPC_MISC_CLK_CTRL_VID1_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_VID1_POS)             /** SPCMISC_CLK_CTRL VID1-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_VID0_POS          16                                                /** SPCMISC_CLK_CTRL VID0-bit position */
#define AG903_SPC_MISC_CLK_CTRL_VID0_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_VID0_POS)             /** SPCMISC_CLK_CTRL VID0-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_ATA_POS           12                                                /** SPCMISC_CLK_CTRL ATA-bit position */
#define AG903_SPC_MISC_CLK_CTRL_ATA_MSK           (1<<AG903_SPC_MISC_CLK_CTRL_ATA_POS)              /** SPCMISC_CLK_CTRL ATA-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_VIA3_POS          7                                                 /** SPCMISC_CLK_CTRL VIA3-bit position */
#define AG903_SPC_MISC_CLK_CTRL_VIA3_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_VIA3_POS)             /** SPCMISC_CLK_CTRL VIA3-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_VIA2_POS          6                                                 /** SPCMISC_CLK_CTRL VIA2-bit position */
#define AG903_SPC_MISC_CLK_CTRL_VIA2_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_VIA2_POS)             /** SPCMISC_CLK_CTRL VIA2-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_VIA1_POS          5                                                 /** SPCMISC_CLK_CTRL VIA1-bit position */
#define AG903_SPC_MISC_CLK_CTRL_VIA1_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_VIA1_POS)             /** SPCMISC_CLK_CTRL VIA1-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_VIA0_POS          4                                                 /** SPCMISC_CLK_CTRL VIA0-bit position */
#define AG903_SPC_MISC_CLK_CTRL_VIA0_MSK          (1<<AG903_SPC_MISC_CLK_CTRL_VIA0_POS)             /** SPCMISC_CLK_CTRL VIA0-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_TICK1_POS         3                                                 /** SPCMISC_CLK_CTRL TICK1-bit position */
#define AG903_SPC_MISC_CLK_CTRL_TICK1_MSK         (1<<AG903_SPC_MISC_CLK_CTRL_TICK1_POS)            /** SPCMISC_CLK_CTRL TICK1-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_TICK0_POS         2                                                 /** SPCMISC_CLK_CTRL TICK0-bit position */
#define AG903_SPC_MISC_CLK_CTRL_TICK0_MSK         (1<<AG903_SPC_MISC_CLK_CTRL_TICK0_POS)            /** SPCMISC_CLK_CTRL TICK0-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_SPI_POS           1                                                 /** SPCMISC_CLK_CTRL SPI-bit position */
#define AG903_SPC_MISC_CLK_CTRL_SPI_MSK           (1<<AG903_SPC_MISC_CLK_CTRL_SPI_POS)              /** SPCMISC_CLK_CTRL SPI-bit mask */
#define AG903_SPC_MISC_CLK_CTRL_SDC_POS           0                                                 /** SPCMISC_CLK_CTRL SDC-bit position */
#define AG903_SPC_MISC_CLK_CTRL_SDC_MSK           (1<<AG903_SPC_MISC_CLK_CTRL_SDC_POS)              /** SPCMISC_CLK_CTRL SDC-bit mask */

/* Software reset */
#define AG903_SPC_SOFTRESET_MASK1_DDR6_POS        30                                                /** SPCSOFTRESET_MASK1 DDR6-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DDR6_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_DDR6_POS)           /** SPCSOFTRESET_MASK1 DDR6-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DDR5_POS        29                                                /** SPCSOFTRESET_MASK1 DDR5-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DDR5_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_DDR5_POS)           /** SPCSOFTRESET_MASK1 DDR5-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DDR4_POS        28                                                /** SPCSOFTRESET_MASK1 DDR4-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DDR4_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_DDR4_POS)           /** SPCSOFTRESET_MASK1 DDR4-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DDR3_POS        27                                                /** SPCSOFTRESET_MASK1 DDR3-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DDR3_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_DDR3_POS)           /** SPCSOFTRESET_MASK1 DDR3-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DDR2_POS        26                                                /** SPCSOFTRESET_MASK1 DDR2-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DDR2_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_DDR2_POS)           /** SPCSOFTRESET_MASK1 DDR2-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DDR1_POS        25                                                /** SPCSOFTRESET_MASK1 DDR1-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DDR1_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_DDR1_POS)           /** SPCSOFTRESET_MASK1 DDR1-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DDR0_POS        24                                                /** SPCSOFTRESET_MASK1 DDR0-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DDR0_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_DDR0_POS)           /** SPCSOFTRESET_MASK1 DDR0-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_AXIC_POS        23                                                /** SPCSOFTRESET_MASK1 AXIC-bit position */
#define AG903_SPC_SOFTRESET_MASK1_AXIC_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_AXIC_POS)           /** SPCSOFTRESET_MASK1 AXIC-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_VID_POS         22                                                /** SPCSOFTRESET_MASK1 VID-bit position */
#define AG903_SPC_SOFTRESET_MASK1_VID_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_VID_POS)            /** SPCSOFTRESET_MASK1 VID-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_GVD_POS         21                                                /** SPCSOFTRESET_MASK1 GVD-bit position */
#define AG903_SPC_SOFTRESET_MASK1_GVD_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_GVD_POS)            /** SPCSOFTRESET_MASK1 GVD-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_ACP_POS         20                                                /** SPCSOFTRESET_MASK1 ACP-bit position */
#define AG903_SPC_SOFTRESET_MASK1_ACP_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_ACP_POS)            /** SPCSOFTRESET_MASK1 ACP-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_PGP_POS         19                                                /** SPCSOFTRESET_MASK1 PGP-bit position */
#define AG903_SPC_SOFTRESET_MASK1_PGP_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_PGP_POS)            /** SPCSOFTRESET_MASK1 PGP-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_HDA_POS         18                                                /** SPCSOFTRESET_MASK1 HDA-bit position */
#define AG903_SPC_SOFTRESET_MASK1_HDA_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_HDA_POS)            /** SPCSOFTRESET_MASK1 HDA-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_JPG_POS         17                                                /** SPCSOFTRESET_MASK1 JPG-bit position */
#define AG903_SPC_SOFTRESET_MASK1_JPG_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_JPG_POS)            /** SPCSOFTRESET_MASK1 JPG-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_PBD_POS         16                                                /** SPCSOFTRESET_MASK1 PBD-bit position */
#define AG903_SPC_SOFTRESET_MASK1_PBD_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_PBD_POS)            /** SPCSOFTRESET_MASK1 PBD-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_GFX_POS         15                                                /** SPCSOFTRESET_MASK1 GFX-bit position */
#define AG903_SPC_SOFTRESET_MASK1_GFX_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_GFX_POS)            /** SPCSOFTRESET_MASK1 GFX-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_EQS_POS         14                                                /** SPCSOFTRESET_MASK1 EQS-bit position */
#define AG903_SPC_SOFTRESET_MASK1_EQS_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_EQS_POS)            /** SPCSOFTRESET_MASK1 EQS-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DSP_POS         13                                                /** SPCSOFTRESET_MASK1 DSP-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DSP_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_DSP_POS)            /** SPCSOFTRESET_MASK1 DSP-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DTA_POS         12                                                /** SPCSOFTRESET_MASK1 DTA-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DTA_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_DTA_POS)            /** SPCSOFTRESET_MASK1 DTA-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_SPC_POS         11                                                /** SPCSOFTRESET_MASK1 SPC-bit position */
#define AG903_SPC_SOFTRESET_MASK1_SPC_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_SPC_POS)            /** SPCSOFTRESET_MASK1 SPC-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_X2PM_POS        10                                                /** SPCSOFTRESET_MASK1 X2PM-bit position */
#define AG903_SPC_SOFTRESET_MASK1_X2PM_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_X2PM_POS)           /** SPCSOFTRESET_MASK1 X2PM-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_X2PP_POS        9                                                 /** SPCSOFTRESET_MASK1 X2PP-bit position */
#define AG903_SPC_SOFTRESET_MASK1_X2PP_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_X2PP_POS)           /** SPCSOFTRESET_MASK1 X2PP-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_X2H4_POS        8                                                 /** SPCSOFTRESET_MASK1 X2H4-bit position */
#define AG903_SPC_SOFTRESET_MASK1_X2H4_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_X2H4_POS)           /** SPCSOFTRESET_MASK1 X2H4-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_X2H3_POS        7                                                 /** SPCSOFTRESET_MASK1 X2H3-bit position */
#define AG903_SPC_SOFTRESET_MASK1_X2H3_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_X2H3_POS)           /** SPCSOFTRESET_MASK1 X2H3-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_X2H2_POS        6                                                 /** SPCSOFTRESET_MASK1 X2H2-bit position */
#define AG903_SPC_SOFTRESET_MASK1_X2H2_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_X2H2_POS)           /** SPCSOFTRESET_MASK1 X2H2-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_X2H1_POS        5                                                 /** SPCSOFTRESET_MASK1 X2H1-bit position */
#define AG903_SPC_SOFTRESET_MASK1_X2H1_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_X2H1_POS)           /** SPCSOFTRESET_MASK1 X2H1-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_X2H0_POS        4                                                 /** SPCSOFTRESET_MASK1 X2H0-bit position */
#define AG903_SPC_SOFTRESET_MASK1_X2H0_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_X2H0_POS)           /** SPCSOFTRESET_MASK1 X2H0-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_H2X_POS         3                                                 /** SPCSOFTRESET_MASK1 H2X-bit position */
#define AG903_SPC_SOFTRESET_MASK1_H2X_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_H2X_POS)            /** SPCSOFTRESET_MASK1 H2X-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_DMAC_POS        2                                                 /** SPCSOFTRESET_MASK1 DMAC-bit position */
#define AG903_SPC_SOFTRESET_MASK1_DMAC_MSK        (1<<AG903_SPC_SOFTRESET_MASK1_DMAC_POS)           /** SPCSOFTRESET_MASK1 DMAC-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_IFW_POS         1                                                 /** SPCSOFTRESET_MASK1 IFW-bit position */
#define AG903_SPC_SOFTRESET_MASK1_IFW_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_IFW_POS)            /** SPCSOFTRESET_MASK1 IFW-bit mask */
#define AG903_SPC_SOFTRESET_MASK1_IWM_POS         0                                                 /** SPCSOFTRESET_MASK1 IWM-bit position */
#define AG903_SPC_SOFTRESET_MASK1_IWM_MSK         (1<<AG903_SPC_SOFTRESET_MASK1_IWM_POS)            /** SPCSOFTRESET_MASK1 IWM-bit mask */

#define AG903_SPC_SOFTRESET_MASK2_ATA_POS         25                                                /** SPCSOFTRESET_MASK2 ATA-bit position */
#define AG903_SPC_SOFTRESET_MASK2_ATA_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_ATA_POS)            /** SPCSOFTRESET_MASK2 ATA-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_SMC_POS         24                                                /** SPCSOFTRESET_MASK2 SMC-bit position */
#define AG903_SPC_SOFTRESET_MASK2_SMC_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_SMC_POS)            /** SPCSOFTRESET_MASK2 SMC-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_H2P_POS         23                                                /** SPCSOFTRESET_MASK2 H2P-bit position */
#define AG903_SPC_SOFTRESET_MASK2_H2P_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_H2P_POS)            /** SPCSOFTRESET_MASK2 H2P-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_SPI_POS         22                                                /** SPCSOFTRESET_MASK2 SPI-bit position */
#define AG903_SPC_SOFTRESET_MASK2_SPI_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_SPI_POS)            /** SPCSOFTRESET_MASK2 SPI-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_EBI_POS         21                                                /** SPCSOFTRESET_MASK2 EBI-bit position */
#define AG903_SPC_SOFTRESET_MASK2_EBI_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_EBI_POS)            /** SPCSOFTRESET_MASK2 EBI-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_BSC_POS         20                                                /** SPCSOFTRESET_MASK2 BSC-bit position */
#define AG903_SPC_SOFTRESET_MASK2_BSC_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_BSC_POS)            /** SPCSOFTRESET_MASK2 BSC-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_X2H3_POS        19                                                /** SPCSOFTRESET_MASK2 X2H3-bit position */
#define AG903_SPC_SOFTRESET_MASK2_X2H3_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_X2H3_POS)           /** SPCSOFTRESET_MASK2 X2H3-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_X2H1_POS        18                                                /** SPCSOFTRESET_MASK2 X2H1-bit position */
#define AG903_SPC_SOFTRESET_MASK2_X2H1_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_X2H1_POS)           /** SPCSOFTRESET_MASK2 X2H1-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_HBCB_POS        17                                                /** SPCSOFTRESET_MASK2 HBCB-bit position */
#define AG903_SPC_SOFTRESET_MASK2_HBCB_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_HBCB_POS)           /** SPCSOFTRESET_MASK2 HBCB-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_HBCP_POS        16                                                /** SPCSOFTRESET_MASK2 HBCP-bit position */
#define AG903_SPC_SOFTRESET_MASK2_HBCP_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_HBCP_POS)           /** SPCSOFTRESET_MASK2 HBCP-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_USBP_POS        13                                                /** SPCSOFTRESET_MASK2 USBP-bit position */
#define AG903_SPC_SOFTRESET_MASK2_USBP_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_USBP_POS)           /** SPCSOFTRESET_MASK2 USBP-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_SPC_POS         12                                                /** SPCSOFTRESET_MASK2 SPC-bit position */
#define AG903_SPC_SOFTRESET_MASK2_SPC_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_SPC_POS)            /** SPCSOFTRESET_MASK2 SPC-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_DDR7_POS        11                                                /** SPCSOFTRESET_MASK2 DDR7-bit position */
#define AG903_SPC_SOFTRESET_MASK2_DDR7_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_DDR7_POS)           /** SPCSOFTRESET_MASK2 DDR7-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_USBC_POS        10                                                /** SPCSOFTRESET_MASK2 USBC-bit position */
#define AG903_SPC_SOFTRESET_MASK2_USBC_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_USBC_POS)           /** SPCSOFTRESET_MASK2 USBC-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_SDC_POS         9                                                 /** SPCSOFTRESET_MASK2 SDC-bit position */
#define AG903_SPC_SOFTRESET_MASK2_SDC_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_SDC_POS)            /** SPCSOFTRESET_MASK2 SDC-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_ETH_POS         8                                                 /** SPCSOFTRESET_MASK2 ETH-bit position */
#define AG903_SPC_SOFTRESET_MASK2_ETH_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_ETH_POS)            /** SPCSOFTRESET_MASK2 ETH-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_H2X_POS         6                                                 /** SPCSOFTRESET_MASK2 H2X-bit position */
#define AG903_SPC_SOFTRESET_MASK2_H2X_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_H2X_POS)            /** SPCSOFTRESET_MASK2 H2X-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_X2H0_POS        5                                                 /** SPCSOFTRESET_MASK2 X2H0-bit position */
#define AG903_SPC_SOFTRESET_MASK2_X2H0_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_X2H0_POS)           /** SPCSOFTRESET_MASK2 X2H0-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_ALS_POS         4                                                 /** SPCSOFTRESET_MASK2 ALS-bit position */
#define AG903_SPC_SOFTRESET_MASK2_ALS_MSK         (1<<AG903_SPC_SOFTRESET_MASK2_ALS_POS)            /** SPCSOFTRESET_MASK2 ALS-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_CA5H_POS        3                                                 /** SPCSOFTRESET_MASK2 CA5H-bit position */
#define AG903_SPC_SOFTRESET_MASK2_CA5H_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_CA5H_POS)           /** SPCSOFTRESET_MASK2 CA5H-bit mask */
#define AG903_SPC_SOFTRESET_MASK2_HBCM_POS        1                                                 /** SPCSOFTRESET_MASK2 HBCM-bit position */
#define AG903_SPC_SOFTRESET_MASK2_HBCM_MSK        (1<<AG903_SPC_SOFTRESET_MASK2_HBCM_POS)           /** SPCSOFTRESET_MASK2 HBCM-bit mask */

#define AG903_SPC_SOFTRESET_MASK3_CA5PORT_POS     31                                                /** SPCSOFTRESET_MASK3 CA5PORT-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5PORT_MSK     (1<<AG903_SPC_SOFTRESET_MASK3_CA5PORT_POS)        /** SPCSOFTRESET_MASK3 CA5PORT-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_CA5T_POS        30                                                /** SPCSOFTRESET_MASK3 CA5T-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5T_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_CA5T_POS)           /** SPCSOFTRESET_MASK3 CA5T-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_CA5PERI_POS     29                                                /** SPCSOFTRESET_MASK3 CA5PERI-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5PERI_MSK     (1<<AG903_SPC_SOFTRESET_MASK3_CA5PERI_POS)        /** SPCSOFTRESET_MASK3 CA5PERI-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_CA5SOCD_POS     28                                                /** SPCSOFTRESET_MASK3 CA5SOCD-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5SOCD_MSK     (1<<AG903_SPC_SOFTRESET_MASK3_CA5SOCD_POS)        /** SPCSOFTRESET_MASK3 CA5SOCD-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_CA5SCU_POS      27                                                /** SPCSOFTRESET_MASK3 CA5SCU-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5SCU_MSK      (1<<AG903_SPC_SOFTRESET_MASK3_CA5SCU_POS)         /** SPCSOFTRESET_MASK3 CA5SCU-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_CA5DBG_POS      26                                                /** SPCSOFTRESET_MASK3 CA5DBG-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5DBG_MSK      (1<<AG903_SPC_SOFTRESET_MASK3_CA5DBG_POS)         /** SPCSOFTRESET_MASK3 CA5DBG-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_CA5CPU_POS      25                                                /** SPCSOFTRESET_MASK3 CA5CPU-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5CPU_MSK      (1<<AG903_SPC_SOFTRESET_MASK3_CA5CPU_POS)         /** SPCSOFTRESET_MASK3 CA5CPU-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_CA5ETM_POS      24                                                /** SPCSOFTRESET_MASK3 CA5ETM-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5ETM_MSK      (1<<AG903_SPC_SOFTRESET_MASK3_CA5ETM_POS)         /** SPCSOFTRESET_MASK3 CA5ETM-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_CA5PSYS_POS     23                                                /** SPCSOFTRESET_MASK3 CA5PSYS-bit position */
#define AG903_SPC_SOFTRESET_MASK3_CA5PSYS_MSK     (1<<AG903_SPC_SOFTRESET_MASK3_CA5PSYS_POS)        /** SPCSOFTRESET_MASK3 CA5PSYS-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_H2X_POS         22                                                /** SPCSOFTRESET_MASK3 H2X-bit position */
#define AG903_SPC_SOFTRESET_MASK3_H2X_MSK         (1<<AG903_SPC_SOFTRESET_MASK3_H2X_POS)            /** SPCSOFTRESET_MASK3 H2X-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_IFW_POS         21                                                /** SPCSOFTRESET_MASK3 IFW-bit position */
#define AG903_SPC_SOFTRESET_MASK3_IFW_MSK         (1<<AG903_SPC_SOFTRESET_MASK3_IFW_POS)            /** SPCSOFTRESET_MASK3 IFW-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_IWM_POS         20                                                /** SPCSOFTRESET_MASK3 IWM-bit position */
#define AG903_SPC_SOFTRESET_MASK3_IWM_MSK         (1<<AG903_SPC_SOFTRESET_MASK3_IWM_POS)            /** SPCSOFTRESET_MASK3 IWM-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_X2H4_POS        19                                                /** SPCSOFTRESET_MASK3 X2H4-bit position */
#define AG903_SPC_SOFTRESET_MASK3_X2H4_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_X2H4_POS)           /** SPCSOFTRESET_MASK3 X2H4-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_X2H3_POS        18                                                /** SPCSOFTRESET_MASK3 X2H3-bit position */
#define AG903_SPC_SOFTRESET_MASK3_X2H3_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_X2H3_POS)           /** SPCSOFTRESET_MASK3 X2H3-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_X2H2_POS        17                                                /** SPCSOFTRESET_MASK3 X2H2-bit position */
#define AG903_SPC_SOFTRESET_MASK3_X2H2_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_X2H2_POS)           /** SPCSOFTRESET_MASK3 X2H2-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_X2H1_POS        16                                                /** SPCSOFTRESET_MASK3 X2H1-bit position */
#define AG903_SPC_SOFTRESET_MASK3_X2H1_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_X2H1_POS)           /** SPCSOFTRESET_MASK3 X2H1-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_X2H0_POS        15                                                /** SPCSOFTRESET_MASK3 X2H0-bit position */
#define AG903_SPC_SOFTRESET_MASK3_X2H0_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_X2H0_POS)           /** SPCSOFTRESET_MASK3 X2H0-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_AXIC_POS        14                                                /** SPCSOFTRESET_MASK3 AXIC-bit position */
#define AG903_SPC_SOFTRESET_MASK3_AXIC_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_AXIC_POS)           /** SPCSOFTRESET_MASK3 AXIC-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_DDR_POS         13                                                /** SPCSOFTRESET_MASK3 DDR-bit position */
#define AG903_SPC_SOFTRESET_MASK3_DDR_MSK         (1<<AG903_SPC_SOFTRESET_MASK3_DDR_POS)            /** SPCSOFTRESET_MASK3 DDR-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_DMAC_POS        12                                                /** SPCSOFTRESET_MASK3 DMAC-bit position */
#define AG903_SPC_SOFTRESET_MASK3_DMAC_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_DMAC_POS)           /** SPCSOFTRESET_MASK3 DMAC-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_WDT_POS         11                                                /** SPCSOFTRESET_MASK3 WDT-bit position */
#define AG903_SPC_SOFTRESET_MASK3_WDT_MSK         (1<<AG903_SPC_SOFTRESET_MASK3_WDT_POS)            /** SPCSOFTRESET_MASK3 WDT-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_SSP3_POS        10                                                /** SPCSOFTRESET_MASK3 SSP3-bit position */
#define AG903_SPC_SOFTRESET_MASK3_SSP3_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_SSP3_POS)           /** SPCSOFTRESET_MASK3 SSP3-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_SSP2_POS        9                                                 /** SPCSOFTRESET_MASK3 SSP2-bit position */
#define AG903_SPC_SOFTRESET_MASK3_SSP2_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_SSP2_POS)           /** SPCSOFTRESET_MASK3 SSP2-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_SSP1_POS        8                                                 /** SPCSOFTRESET_MASK3 SSP1-bit position */
#define AG903_SPC_SOFTRESET_MASK3_SSP1_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_SSP1_POS)           /** SPCSOFTRESET_MASK3 SSP1-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_SSP0_POS        7                                                 /** SPCSOFTRESET_MASK3 SSP0-bit position */
#define AG903_SPC_SOFTRESET_MASK3_SSP0_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_SSP0_POS)           /** SPCSOFTRESET_MASK3 SSP0-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_UART3_POS       6                                                 /** SPCSOFTRESET_MASK3 UART3-bit position */
#define AG903_SPC_SOFTRESET_MASK3_UART3_MSK       (1<<AG903_SPC_SOFTRESET_MASK3_UART3_POS)          /** SPCSOFTRESET_MASK3 UART3-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_UART2_POS       5                                                 /** SPCSOFTRESET_MASK3 UART2-bit position */
#define AG903_SPC_SOFTRESET_MASK3_UART2_MSK       (1<<AG903_SPC_SOFTRESET_MASK3_UART2_POS)          /** SPCSOFTRESET_MASK3 UART2-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_UART1_POS       4                                                 /** SPCSOFTRESET_MASK3 UART1-bit position */
#define AG903_SPC_SOFTRESET_MASK3_UART1_MSK       (1<<AG903_SPC_SOFTRESET_MASK3_UART1_POS)          /** SPCSOFTRESET_MASK3 UART1-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_UART0_POS       3                                                 /** SPCSOFTRESET_MASK3 UART0-bit position */
#define AG903_SPC_SOFTRESET_MASK3_UART0_MSK       (1<<AG903_SPC_SOFTRESET_MASK3_UART0_POS)          /** SPCSOFTRESET_MASK3 UART0-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_IIC1_POS        2                                                 /** SPCSOFTRESET_MASK3 IIC1-bit position */
#define AG903_SPC_SOFTRESET_MASK3_IIC1_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_IIC1_POS)           /** SPCSOFTRESET_MASK3 IIC1-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_IIC0_POS        1                                                 /** SPCSOFTRESET_MASK3 IIC0-bit position */
#define AG903_SPC_SOFTRESET_MASK3_IIC0_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_IIC0_POS)           /** SPCSOFTRESET_MASK3 IIC0-bit mask */
#define AG903_SPC_SOFTRESET_MASK3_X2PP_POS        0                                                 /** SPCSOFTRESET_MASK3 X2PP-bit position */
#define AG903_SPC_SOFTRESET_MASK3_X2PP_MSK        (1<<AG903_SPC_SOFTRESET_MASK3_X2PP_POS)           /** SPCSOFTRESET_MASK3 X2PP-bit mask */

#define AG903_SPC_SOFTRESET_MASK4_CFC_POS         25                                                /** SPCSOFTRESET_MASK4 CFC-bit position */
#define AG903_SPC_SOFTRESET_MASK4_CFC_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_CFC_POS)            /** SPCSOFTRESET_MASK4 CFC-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_H2P_POS         24                                                /** SPCSOFTRESET_MASK4 H2P-bit position */
#define AG903_SPC_SOFTRESET_MASK4_H2P_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_H2P_POS)            /** SPCSOFTRESET_MASK4 H2P-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_X2H4_POS        18                                                /** SPCSOFTRESET_MASK4 X2H4-bit position */
#define AG903_SPC_SOFTRESET_MASK4_X2H4_MSK        (1<<AG903_SPC_SOFTRESET_MASK4_X2H4_POS)           /** SPCSOFTRESET_MASK4 X2H4-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_X2H2_POS        17                                                /** SPCSOFTRESET_MASK4 X2H2-bit position */
#define AG903_SPC_SOFTRESET_MASK4_X2H2_MSK        (1<<AG903_SPC_SOFTRESET_MASK4_X2H2_POS)           /** SPCSOFTRESET_MASK4 X2H2-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_SDMC_POS        16                                                /** SPCSOFTRESET_MASK4 SDMC-bit position */
#define AG903_SPC_SOFTRESET_MASK4_SDMC_MSK        (1<<AG903_SPC_SOFTRESET_MASK4_SDMC_POS)           /** SPCSOFTRESET_MASK4 SDMC-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_BMU_POS         12                                                /** SPCSOFTRESET_MASK4 BMU-bit position */
#define AG903_SPC_SOFTRESET_MASK4_BMU_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_BMU_POS)            /** SPCSOFTRESET_MASK4 BMU-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_GVD_POS         11                                                /** SPCSOFTRESET_MASK4 GVD-bit position */
#define AG903_SPC_SOFTRESET_MASK4_GVD_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_GVD_POS)            /** SPCSOFTRESET_MASK4 GVD-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_PGP_POS         10                                                /** SPCSOFTRESET_MASK4 PGP-bit position */
#define AG903_SPC_SOFTRESET_MASK4_PGP_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_PGP_POS)            /** SPCSOFTRESET_MASK4 PGP-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_SSC_POS         9                                                 /** SPCSOFTRESET_MASK4 SSC-bit position */
#define AG903_SPC_SOFTRESET_MASK4_SSC_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_SSC_POS)            /** SPCSOFTRESET_MASK4 SSC-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_VID_POS         8                                                 /** SPCSOFTRESET_MASK4 VID-bit position */
#define AG903_SPC_SOFTRESET_MASK4_VID_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_VID_POS)            /** SPCSOFTRESET_MASK4 VID-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_TIM_POS         7                                                 /** SPCSOFTRESET_MASK4 TIM-bit position */
#define AG903_SPC_SOFTRESET_MASK4_TIM_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_TIM_POS)            /** SPCSOFTRESET_MASK4 TIM-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_GPIO3_POS       6                                                 /** SPCSOFTRESET_MASK4 GPIO3-bit position */
#define AG903_SPC_SOFTRESET_MASK4_GPIO3_MSK       (1<<AG903_SPC_SOFTRESET_MASK4_GPIO3_POS)          /** SPCSOFTRESET_MASK4 GPIO3-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_GPIO2_POS       5                                                 /** SPCSOFTRESET_MASK4 GPIO2-bit position */
#define AG903_SPC_SOFTRESET_MASK4_GPIO2_MSK       (1<<AG903_SPC_SOFTRESET_MASK4_GPIO2_POS)          /** SPCSOFTRESET_MASK4 GPIO2-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_GPIO1_POS       4                                                 /** SPCSOFTRESET_MASK4 GPIO1-bit position */
#define AG903_SPC_SOFTRESET_MASK4_GPIO1_MSK       (1<<AG903_SPC_SOFTRESET_MASK4_GPIO1_POS)          /** SPCSOFTRESET_MASK4 GPIO1-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_GPIO0_POS       3                                                 /** SPCSOFTRESET_MASK4 GPIO0-bit position */
#define AG903_SPC_SOFTRESET_MASK4_GPIO0_MSK       (1<<AG903_SPC_SOFTRESET_MASK4_GPIO0_POS)          /** SPCSOFTRESET_MASK4 GPIO0-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_GFX_POS         2                                                 /** SPCSOFTRESET_MASK4 GFX-bit position */
#define AG903_SPC_SOFTRESET_MASK4_GFX_MSK         (1<<AG903_SPC_SOFTRESET_MASK4_GFX_POS)            /** SPCSOFTRESET_MASK4 GFX-bit mask */
#define AG903_SPC_SOFTRESET_MASK4_X2PM_POS        0                                                 /** SPCSOFTRESET_MASK4 X2PM-bit position */
#define AG903_SPC_SOFTRESET_MASK4_X2PM_MSK        (1<<AG903_SPC_SOFTRESET_MASK4_X2PM_POS)           /** SPCSOFTRESET_MASK4 X2PM-bit mask */

#define AG903_SPC_SOFTRESET_MASK5_VIA3_POS        28                                                /** SPCSOFTRESET_MASK5 VIA3-bit position */
#define AG903_SPC_SOFTRESET_MASK5_VIA3_MSK        (1<<AG903_SPC_SOFTRESET_MASK5_VIA3_POS)           /** SPCSOFTRESET_MASK5 VIA3-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_VIA2_POS        27                                                /** SPCSOFTRESET_MASK5 VIA2-bit position */
#define AG903_SPC_SOFTRESET_MASK5_VIA2_MSK        (1<<AG903_SPC_SOFTRESET_MASK5_VIA2_POS)           /** SPCSOFTRESET_MASK5 VIA2-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_VIA1_POS        26                                                /** SPCSOFTRESET_MASK5 VIA1-bit position */
#define AG903_SPC_SOFTRESET_MASK5_VIA1_MSK        (1<<AG903_SPC_SOFTRESET_MASK5_VIA1_POS)           /** SPCSOFTRESET_MASK5 VIA1-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_VIA0_POS        25                                                /** SPCSOFTRESET_MASK5 VIA0-bit position */
#define AG903_SPC_SOFTRESET_MASK5_VIA0_MSK        (1<<AG903_SPC_SOFTRESET_MASK5_VIA0_POS)           /** SPCSOFTRESET_MASK5 VIA0-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_TICK1_POS       24                                                /** SPCSOFTRESET_MASK5 TICK1-bit position */
#define AG903_SPC_SOFTRESET_MASK5_TICK1_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_TICK1_POS)          /** SPCSOFTRESET_MASK5 TICK1-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_TICK0_POS       23                                                /** SPCSOFTRESET_MASK5 TICK0-bit position */
#define AG903_SPC_SOFTRESET_MASK5_TICK0_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_TICK0_POS)          /** SPCSOFTRESET_MASK5 TICK0-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_DSPC1_POS       22                                                /** SPCSOFTRESET_MASK5 DSPC1-bit position */
#define AG903_SPC_SOFTRESET_MASK5_DSPC1_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_DSPC1_POS)          /** SPCSOFTRESET_MASK5 DSPC1-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_DSPC0_POS       21                                                /** SPCSOFTRESET_MASK5 DSPC0-bit position */
#define AG903_SPC_SOFTRESET_MASK5_DSPC0_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_DSPC0_POS)          /** SPCSOFTRESET_MASK5 DSPC0-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_TDM3_POS        20                                                /** SPCSOFTRESET_MASK5 TDM3-bit position */
#define AG903_SPC_SOFTRESET_MASK5_TDM3_MSK        (1<<AG903_SPC_SOFTRESET_MASK5_TDM3_POS)           /** SPCSOFTRESET_MASK5 TDM3-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_TDM2_POS        19                                                /** SPCSOFTRESET_MASK5 TDM2-bit position */
#define AG903_SPC_SOFTRESET_MASK5_TDM2_MSK        (1<<AG903_SPC_SOFTRESET_MASK5_TDM2_POS)           /** SPCSOFTRESET_MASK5 TDM2-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_TDM1_POS        18                                                /** SPCSOFTRESET_MASK5 TDM1-bit position */
#define AG903_SPC_SOFTRESET_MASK5_TDM1_MSK        (1<<AG903_SPC_SOFTRESET_MASK5_TDM1_POS)           /** SPCSOFTRESET_MASK5 TDM1-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_TDM0_POS        17                                                /** SPCSOFTRESET_MASK5 TDM0-bit position */
#define AG903_SPC_SOFTRESET_MASK5_TDM0_MSK        (1<<AG903_SPC_SOFTRESET_MASK5_TDM0_POS)           /** SPCSOFTRESET_MASK5 TDM0-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_VIDC1_POS       16                                                /** SPCSOFTRESET_MASK5 VIDC1-bit position */
#define AG903_SPC_SOFTRESET_MASK5_VIDC1_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_VIDC1_POS)          /** SPCSOFTRESET_MASK5 VIDC1-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_VIDC0_POS       15                                                /** SPCSOFTRESET_MASK5 VIDC0-bit position */
#define AG903_SPC_SOFTRESET_MASK5_VIDC0_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_VIDC0_POS)          /** SPCSOFTRESET_MASK5 VIDC0-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_PGPC1_POS       14                                                /** SPCSOFTRESET_MASK5 PGPC1-bit position */
#define AG903_SPC_SOFTRESET_MASK5_PGPC1_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_PGPC1_POS)          /** SPCSOFTRESET_MASK5 PGPC1-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_PGPC0_POS       13                                                /** SPCSOFTRESET_MASK5 PGPC0-bit position */
#define AG903_SPC_SOFTRESET_MASK5_PGPC0_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_PGPC0_POS)          /** SPCSOFTRESET_MASK5 PGPC0-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_PGPA3_POS       12                                                /** SPCSOFTRESET_MASK5 PGPA3-bit position */
#define AG903_SPC_SOFTRESET_MASK5_PGPA3_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_PGPA3_POS)          /** SPCSOFTRESET_MASK5 PGPA3-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_PGPA2_POS       11                                                /** SPCSOFTRESET_MASK5 PGPA2-bit position */
#define AG903_SPC_SOFTRESET_MASK5_PGPA2_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_PGPA2_POS)          /** SPCSOFTRESET_MASK5 PGPA2-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_PGPA1_POS       10                                                /** SPCSOFTRESET_MASK5 PGPA1-bit position */
#define AG903_SPC_SOFTRESET_MASK5_PGPA1_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_PGPA1_POS)          /** SPCSOFTRESET_MASK5 PGPA1-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_PGPA0_POS       9                                                 /** SPCSOFTRESET_MASK5 PGPA0-bit position */
#define AG903_SPC_SOFTRESET_MASK5_PGPA0_MSK       (1<<AG903_SPC_SOFTRESET_MASK5_PGPA0_POS)          /** SPCSOFTRESET_MASK5 PGPA0-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_HDA_POS         8                                                 /** SPCSOFTRESET_MASK5 HDA-bit position */
#define AG903_SPC_SOFTRESET_MASK5_HDA_MSK         (1<<AG903_SPC_SOFTRESET_MASK5_HDA_POS)            /** SPCSOFTRESET_MASK5 HDA-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_USBPPOR_POS     7                                                 /** SPCSOFTRESET_MASK5 USBPPOR-bit position */
#define AG903_SPC_SOFTRESET_MASK5_USBPPOR_MSK     (1<<AG903_SPC_SOFTRESET_MASK5_USBPPOR_POS)        /** SPCSOFTRESET_MASK5 USBPPOR-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_USBPHY_POS      6                                                 /** SPCSOFTRESET_MASK5 USBPHY-bit position */
#define AG903_SPC_SOFTRESET_MASK5_USBPHY_MSK      (1<<AG903_SPC_SOFTRESET_MASK5_USBPHY_POS)         /** SPCSOFTRESET_MASK5 USBPHY-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_DDRPPLL_POS     4                                                 /** SPCSOFTRESET_MASK5 DDRPPLL-bit position */
#define AG903_SPC_SOFTRESET_MASK5_DDRPPLL_MSK     (1<<AG903_SPC_SOFTRESET_MASK5_DDRPPLL_POS)        /** SPCSOFTRESET_MASK5 DDRPPLL-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_DDRPUB_POS      3                                                 /** SPCSOFTRESET_MASK5 DDRPUB-bit position */
#define AG903_SPC_SOFTRESET_MASK5_DDRPUB_MSK      (1<<AG903_SPC_SOFTRESET_MASK5_DDRPUB_POS)         /** SPCSOFTRESET_MASK5 DDRPUB-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_DDRPLB_POS      2                                                 /** SPCSOFTRESET_MASK5 DDRPLB-bit position */
#define AG903_SPC_SOFTRESET_MASK5_DDRPLB_MSK      (1<<AG903_SPC_SOFTRESET_MASK5_DDRPLB_POS)         /** SPCSOFTRESET_MASK5 DDRPLB-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_DDRPCA_POS      1                                                 /** SPCSOFTRESET_MASK5 DDRPCA-bit position */
#define AG903_SPC_SOFTRESET_MASK5_DDRPCA_MSK      (1<<AG903_SPC_SOFTRESET_MASK5_DDRPCA_POS)         /** SPCSOFTRESET_MASK5 DDRPCA-bit mask */
#define AG903_SPC_SOFTRESET_MASK5_DDRPCMP_POS     0                                                 /** SPCSOFTRESET_MASK5 DDRPCMP-bit position */
#define AG903_SPC_SOFTRESET_MASK5_DDRPCMP_MSK     (1<<AG903_SPC_SOFTRESET_MASK5_DDRPCMP_POS)        /** SPCSOFTRESET_MASK5 DDRPCMP-bit mask */

#endif /* _SPCDEF_H_ */
