#ifndef _MPS_COMMON_H_
#define _MPS_COMMON_H_

#include <stdarg.h>
#include "sys/spcprm.h"
#include "sys/sscprm.h"
#include "dsp/dspmgr.h"
#include "../dsp/dsp_common.h"

extern AG903_SPCPrmPllnParam DSP_SAMPLE_PLL[];
extern AG903_DSPMgrSyncParam DSP_SAMPLE_SYNCPARAM[];

/*----------------------------
           }N
----------------------------*/

#if 1
#define ERRCHK(chk,syntax) if(chk!=syntax)MPS_ErrPrintf("ERROR: %s():L%u\n",__func__,__LINE__)
#else
#define ERRCHK(chk,syntax) syntax
#endif

/* ACg n2̗ݏ̂ */
#define MPS_ALIGNn(n,x) ((x+(n-1))&~(n-1))

void* MPS_Memalign(size_t size, uint32_t align);
void* MPS_Malloc(size_t size);
int32_t MPS_Free(void *blk);
int32_t MPS_Stdout(int32_t cond, const char *fmt, va_list arg);
int32_t MPS_Printf(const char *fmt, ...);
int32_t MPS_ErrPrintf(const char *fmt, ...);

#endif /* _MPS_COMMON_H_ */
