/*
* This program was created by AXELL CORPORATION.
* Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#ifndef _SAMPLE_COMMON_H_
#define _SAMPLE_COMMON_H_

#include "AG903_common.h"
#include "board.h"

#ifdef __cplusplus
extern "C" {
#endif

#define AG903_SAMPLE_SYSCLK				(198000000)		/* VXeNbNg [Hz] */
#define AG903_SAMPLE_TICK				(1)				/* `bNԂ̒`i~bPʁj */

#define AG903_SAMPLE_VRAM_ADDR			(0x80500000)	/* VRAMAhX */
#define AG903_SAMPLE_VRAM_SIZE			(0x03A00000)	/* VRAMTCY */
#define AG903_SAMPLE_VRAM_ALLOC_SIZE	(AG903_SAMPLE_VRAM_SIZE-0x10000)	/* VRAMgp\TCY */
#define AG903_SAMPLE_USBH_APLMEM		(0x83E00000)	/* USBHTvAvpJnAhX */
/** 0x83E00000`USBHgpB[֘AFUSBH_NONCACHE_MEM_TOP_WRAPP, MPL_FS_ADDR] **/
#define AG903_SAMPLE_SD_WORKMEM			(0x83EE0000)	/* CFG_SD_BUF_AREAƓlݒ */
/** 0x83F00000`GVDgpB[firmware ram for GVD] **/

#define AG903_SAMPLE_SYSMEM_SIZE		(0x010000)		/* VXepTCY */
#define AG903_SAMPLE_STKMEM_SIZE		(0x040000)		/* X^bNpTCY */
#define AG903_SAMPLE_MPLMEM_SIZE		(0x040000)		/* v[pTCY */
#define AG903_SAMPLE_TSKPRI_MAX			(15)			/* ^XNDx̍ől */
#define AG903_SAMPLE_TSKID_MAX			(15)			/* ^XNID̍ől   [֘AFUSBH_RSC_NUM_TSK_ID] */
#define AG903_SAMPLE_SEMID_MAX			(31)			/* Z}tHID̍ől [֘AFUSBH_RSC_NUM_SEM_ID] */
#define AG903_SAMPLE_FLGID_MAX			(31)			/* CxgtOID̍ől [֘AFUSBH_RSC_NUM_EVFLG_ID] */
#define AG903_SAMPLE_DTQID_MAX			(31)			/* f[^L[ID̍ől   [֘AFUSBH_RSC_NUM_DTQ_ID] */
#define AG903_SAMPLE_MBXID_MAX			(31)			/* [{bNXID̍ől [֘AFUSBH_RSC_NUM_MBOX_ID] */
#define AG903_SAMPLE_MTXID_MAX			(31)			/* ~[ebNXID̍ől */
#define AG903_SAMPLE_MBFID_MAX			(31)			/* bZ[Wobt@ID̍ől */
#define AG903_SAMPLE_PORID_MAX			(31)			/* fu|[gID̍ől */
#define AG903_SAMPLE_MPFID_MAX			(31)			/* Œ蒷v[ID̍ől */
#define AG903_SAMPLE_MPLID_MAX			(31)			/* ϒv[ID̍ől [֘AFUSBH_RSC_NUM_MPL_ID] */
#define AG903_SAMPLE_ALMID_MAX			(31)			/* A[nhID̍ől */
#define AG903_SAMPLE_CYCID_MAX			(31)			/* nhID̍ől [֘AFUSBH_RSC_NUM_CYC_ID] */
#define AG903_SAMPLE_ISRID_MAX			(31)			/* ݃T[rX[`ID̍ől */
#define AG903_SAMPLE_DEVID_MAX			(31)			/* foCXhCoID̍ől */
#define AG903_SAMPLE_SSB_NUM			(31)			/* VXeT[rXubŇ */

#define AG903_SAMPLE_DID_UART0   		(1)				/* R\[pUARTfoCXIDFUART0 */

#define AG903_SAMPLE_SYS_PRINT_MAX		(82)			/* sys_print */
#define AG903_SAMPLE_SYS_MALLOC_MAX		(512)			/* sys_malloc񐔏 */
#define AG903_SAMPLE_DLY_ERROUT			(100)			/* G[o͑҂(ms) */

/*-- System Memory --*/
typedef enum _SysMemType {
	SYSMEM_NORMAL_CACHE_OFF=0,
	SYSMEM_NORMAL_CACHE_ON,
	SYSMEM_STRONGLY_ORDERED,
	SYSMEM_TYPE_NUM,
} SysMemType;
int32_t sys_meminit(uint32_t mplsz, void *mpl, SysMemType type);
void sys_memfinal(void);
void* sys_malloc(size_t size);
void* sys_memalign(size_t size, uint32_t align);
int32_t sys_free(void *blk);
void sys_memspace(size_t *size);

/*-- FileSystem I/F --*/
enum _FsifDevice {
	FSIF_DEV_SD=0,
	FSIF_DEV_CF,
	FSIF_DEV_USB0,
	FSIF_DEV_USB1,
};
int32_t Fsif_GetDevid(uint8_t device);

/*-- utility --*/
void sys_print(int32_t cond, char *pFormat, ...);
void sys_delayus(uint32_t us);
void sys_dlytsk(uint32_t msec);
void sys_memset(void *d, int32_t chr, uint32_t len);
void* sys_memcpy(void *str1, const void *str2, uint32_t len);
void* sys_memchr(const void *s, uint8_t c, uint32_t n);
char* sys_strstr(char *str1, char *str2);
uint32_t sys_rand(void);
uint32_t sys_strtoul(const char * restrict nptr, char ** restrict endptr, int32_t base);
uint8_t ASCtoBIN(uint8_t chr);

enum _PortFunction {
	PORT_FUNCTION_1=0,
	PORT_FUNCTION_2,
	PORT_FUNCTION_3,
	PORT_FUNCTION_4,
};

void Port_SetFunction(uint8_t group, uint8_t function);
void Port_DisableGpio(uint8_t gpio, uint8_t num);
void Port_EnableGpio(uint8_t gpio, uint8_t num);
void Sys_SetDmaInterface(uint8_t interface, uint8_t req);

#ifdef __cplusplus
}
#endif
#endif /* _SAMPLE_COMMON_H_ */

