/** 
 * @brief           USBH HID Common Header
 * @author          AXELL CORPORATION
 * @description     USBH HID Common Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_HID_COMMON_H__
#define __USB_HID_COMMON_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_hid_coreinclude.h"
#include "usb_hid_type.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
/* Pipe ֘A */
extern PHID_PIPE Usbh_Hid_CreateHidPipe(struct usbd_usb_deviceinfo *pParentDev, uhs_ubit8_t u8EpNum, uhs_ubit8_t u8EpDir, uhs_ubit8_t u8EpType, uhs_ubit8_t u8Interval );
extern uhs_boolean_t Usbh_Hid_DeleteHidPipe(PHID_PIPE pPipe);
extern uhs_boolean_t Usbh_Hid_OpenHidPipe(PHID_PIPE pPipe);
extern uhs_boolean_t Usbh_Hid_CloseHidPipe(PHID_PIPE pPipe);
extern HID_FUNC_STATUS Usbh_Hid_HidPipe_ClearHalt(PHID_PIPE pPipe, PHID_DEVICE pHidDevice);
extern uhs_boolean_t Usbh_Hid_HidDevice_GetPipeInfo( struct usbd_usb_deviceinfo* usbdev, udi_ubit8_t TransferType, uhs_ubit8_t * out_epnum, uhs_ubit8_t * in_epnum ,uhs_ubit8_t * out_interval, uhs_ubit8_t * in_interval);

extern PHID_DEVICE Usbh_Hid_SearchHidDevice(PHID_DEVICE pContext);
extern HID_FUNC_STATUS Usbh_Hid_ForCommand(PHID_DEVICE pHidDevice, usb_device_request_t* pdevice_request, uhs_ubit8_t* pBuff, uhs_ubit32_t* pActualLength);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define CMN_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define CMN_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#else
#define CMN_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportDummy(err)
#define CMN_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportDummy(err)
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_HID_COMMON_H__ */
