# μC3/CompactとFeliCaリーダ(RC-S620S)で、ICカードの識別情報を読み取る - サンプルアプリケーション

## 本アプリケーションの概要

本サンプルプログラムは、eForceのWebサイトで公開している[エンジニア・コラム](https://www.eforce.co.jp/knowledge/)
「μC3/CompactとFeliCaリーダ(RC-S620S)で、ICカードの識別情報を読み取る」で紹介しているサンプルアプリケーションです。

## フォルダ構成

```
STM32L496G-DISCO_RC-S620S
│  readme.md
│
├─build
│  └─EWARM ... EWARMのプロジェクト
│          sample.ewd
│          sample.ewp
│          sample.eww
│
└─src
    ├─app  ... アプリケーション（タスクと、デバッグログライブラリ）
    │      log.c
    │      log.h
    │      sample.c
    │
    ├─driver  ... RC-S620Sのドライバ
    │      RCS620S_UC3.c
    │      RCS620S_UC3.h
    │
    └─uc3  ... uC3/Compactコンフィグレータの設定ファイルと出力ファイル
            Cortex-M4.h
            DDR_COM.c
            DDR_COM.h
            DDR_M_SysTick.c
            DDR_M_SysTick.h
            DDR_M_SysTick_cfg.h
            DDR_STM32L4_USART0.c
            DDR_STM32L4_USART0.h
            DDR_STM32L4_USART0_cfg.h
            devdrv.c
            device_id.h
            excp.s79
            hw_dep.h
            hw_init.c
            itron.h
            kernel.h
            kernel_cfg.c
            kernel_id.h
            prst.s79
            sample.3cf
            STM32L4xx_UC3.h
            STM32L4_flash.icf
            STM32L4_ram.icf
            uC3cortexm4fl.a
            vect.s79
```

## 実行手順

本アプリケーションの実行手順を記載します。
使用するハードウェアやソフトウェアの詳細は、コラムを参照ください。

1. コラム内の「開発環境」を参照し、ハードウェアのセットアップをしてください。
2. EWARMプロジェクト（build\EWARM\sample.eww）を起動します。
3. EWARMのメニュー[プロジェクト]→[メイク]を選択して、ビルドを行います。
4. EWARMのメニュー[プロジェクト]→[ダウンロードしてデバッグ]で、デバッグを開始し
ます。  
   デバッグを開始すると、ビルドしたロードモジュールがダウンロードされ、PC がリセットハンドラのアドレスにセットされます。
5. EWARMのメニュー[プロジェクト]→[実行]を選択すると、ダウンロードされたプログラムが実行されます。  
   正常にプログラムが実行されると、ホストPC のターミナルソフト（TeraTerm）にメッセージが出力します。
6. Felicaリーダ（RC-S620S）にICカードをかざすと、読み取った識別情報（IDm、PMm）をターミナルソフトに出力します。

## プログラムを変更して実行する場合

本アプリケーションは、無償評価版[「μC3/Compact Cortex-M4 STM32L4/L4+シリーズ EWARM評価版」](https://www.eforce.co.jp/processors/#st)で作成しています。  
μC3コンフィグレータの設定ファイル（*.3cf）を同梱しているので、μC3コンフィグレータを利用し、タスクの設定情報などを変更することが可能です。

## 変更履歴

2021/12/27 eForce 作成  
Copyright (c) 2021, eForce Co., Ltd. All rights reserved.

