/***********************************************************************
    Device Driver Manager
 ***********************************************************************/

#include "kernel.h"
#include "device_id.h"
#include "DDR_COM.h"
#include "DDR_STM32L4_USART0.h"

ER ctr_dev(ID DevID, ID FuncID, VP_INT pk_ControlData);

extern ER _ddr_stm32l4_usart0drv(ID FuncID, VP_INT pk_ControlData, T_STM32L4_USART0_MNG const *pk_UARTmng);
extern T_STM32L4_USART0_MNG const _ddr_stm32l4_usart0_mng1;
extern T_STM32L4_USART0_MNG const _ddr_stm32l4_usart0_mng2;

ER ctr_dev(ID DevID, ID FuncID, VP_INT pk_ControlData)
{
    ER ercd;

    switch (DevID) {
        case ID_USART_NFC:
            ercd = _ddr_stm32l4_usart0drv(FuncID, pk_ControlData, &_ddr_stm32l4_usart0_mng1);
            break;
        case ID_USART_LOG:
            ercd = _ddr_stm32l4_usart0drv(FuncID, pk_ControlData, &_ddr_stm32l4_usart0_mng2);
            break;
        default:
            ercd = E_NOSPT;
            break;
    }
    return ercd;
}

/* end */
