/***********************************************************************
    Initialization of the hardware-dependent
 ***********************************************************************/

#include "kernel.h"
#include "Cortex-M4.h"
#include "STM32L4xx_UC3.h"

extern void _ddr_m_systick_init(void);
extern void _ddr_stm32l4_usart0_init(void);

/***********************************************
  Initialize Cortex-M peripherals
 ***********************************************/
extern UW __vector_table[];
void cortex_m_init_peripheral(void)
{
    UW inttype;
    UW i;

    inttype = REG_ICNTTYPE + 1UL;
    for (i = 0UL; i < inttype; i++) {
        REG_ANVIC.CLRENA[i] = 0xFFFFFFFFUL;
        REG_ANVIC.CLRPEND[i] = 0xFFFFFFFFUL;
    }

    for (i = 0UL; i < (inttype * 8UL); i++) {
        REG_ANVIC.IRQPRI[i] = 0xFFFFFFFFUL;
    }
    REG_SNVIC.APPIRCTR = 0x05FA0000UL + 0x0300UL;   /* 4bit pre-emption priority */
    REG_SNVIC.VECTTBL = __vector_table;
    REG_SNVIC.SYSPRI[0] = 0x00000000UL;
    REG_SNVIC.SYSPRI[1] = 0x00000000UL;
    REG_SNVIC.SYSPRI[2] = 0x00000000UL;
    REG_SNVIC.CFGCTR |= 0x00000200UL;
}

/***********************************************
        Initialize STM32L4xx's peripherals
 ***********************************************/
void init_peripheral(void)
{

}

/***********************************************
  Device driver Initialize entry
 ***********************************************/
void _ddr_init(void)
{
    _ddr_m_systick_init();
    _ddr_stm32l4_usart0_init();
}

/* end */
