/***************************************************************************
    MICRO C CUBE / COMPACT, KERNEL
    ITRON macro definitions for eForce operating system (Compact)
    Cortex-M4 core version
    Copyright (c)  2011-2018, eForce Co., Ltd. All rights reserved.

    Version Information
            2011.11.16: Created.
            2012.05.10: Modified for Cortex-M4.
            2012.09.03: Added type of long long.
            2012.10.09: Modified _kernel_ALIGN_SIZE macro.
            2014.09.02: Modified _kernel_xxxx function to suit argument of the C standard library.
                        Added endian definition for GCC.
            2015.07.03: TID size is modified to 16bit. 
                        Changed version number.
            2017.01.16: Fixed the IPA warnings.
            2018.03.22: Changed TKERNEL_PRVER v2.11.0.
 ***************************************************************************/

#ifndef ITRON_H_
#define ITRON_H_

#ifndef TRUE
#define TRUE    1
#endif
#ifndef FALSE
#define FALSE   0
#endif

#define E_OK    0

#define _kernel_INT_SIZE    4
#define _kernel_ALIGN_SIZE  8
#define _kernel_INT_BIT     (_kernel_INT_SIZE*8)

#define TKERNEL_PRID    0x0146U
#define TKERNEL_PRVER   0x2110U

#ifndef _kernel_LARGE
#define _kernel_LARGE   1
#endif


/************************************
    Byte Order Type
 ************************************/

#if defined (__CC_ARM)      /* for ARM Compiler */
#if defined (__BIG_ENDIAN)
#define _UC3_ENDIAN_BIG
#undef _UC3_ENDIAN_LITTLE
#else
#define _UC3_ENDIAN_LITTLE
#undef _UC3_ENDIAN_BIG
#endif
#elif defined (__ICCARM__)  /* for IAR Compiler */
#if (__LITTLE_ENDIAN__ == 1)
#define _UC3_ENDIAN_LITTLE
#undef _UC3_ENDIAN_BIG
#else
#define _UC3_ENDIAN_BIG
#undef _UC3_ENDIAN_LITTLE
#endif
#elif defined (__TMS470__)  /* for CCS Compiler */
#if defined (__little_endian__)
#define _UC3_ENDIAN_LITTLE
#undef _UC3_ENDIAN_BIG
#else
#define _UC3_ENDIAN_BIG
#undef _UC3_ENDIAN_LITTLE
#endif
#elif defined(__GNUC__)     /* for GNU C */
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define _UC3_ENDIAN_LITTLE
#undef _UC3_ENDIAN_BIG
#else
#define _UC3_ENDIAN_BIG
#undef _UC3_ENDIAN_LITTLE
#endif
#endif


/************************************
    Data Types
 ************************************/

typedef signed char B;
typedef signed short H;
typedef signed long W;
typedef signed long long D;
typedef unsigned char UB;
typedef unsigned short UH;
typedef unsigned long UW;
typedef unsigned long long UD;
typedef char VB;
typedef short VH;
typedef long VW;
typedef long long VD;
typedef void *VP;
typedef void (*FP)(void);

typedef unsigned long SIZE;
typedef unsigned long ADDR;

typedef int INT;
typedef unsigned int UINT;

typedef VP VP_INT;

typedef INT BOOL;
typedef INT FN;
typedef INT ER;
typedef INT ID;
typedef INT PRI;
typedef INT BOOL_ID;
typedef INT ER_ID;
typedef INT ER_UINT;
typedef UINT FLGPTN;
typedef UINT INTNO;
typedef UINT IMASK;

typedef UINT ATR;
typedef UINT STAT;
typedef UINT MODE;

#ifdef _kernel_LARGE
typedef UH TID;
#else
typedef UB TID;
#endif

typedef struct t_systim {
    UW utime;
    UW ltime;
} SYSTIM;

typedef W TMO;

typedef UW RELTIM;

typedef UW T_REG;

typedef struct t_par {
    T_REG   fill[8];
    T_REG   control;
    T_REG   exe_return;
    ER_UINT ercd;
    FLGPTN  flgptn;
    union {
        VP      ptr;
        VP_INT  dtq;
    } p2;
} T_PAR;

typedef struct t_cnsdep {
    FP          svchdr;
} T_CNSDEP;

#define CNSTBL_DEPENDEND T_CNSDEP cnsdep;
#define TCB_DEPENDEND

#define _KERNEL_MEMSET_
extern void* _kernel_memset(void *d, INT c, SIZE n);
#define _KERNEL_MEMCPY_
extern void* _kernel_memcpy(void *d, const void *s, SIZE n);
#define _KERNEL_MEMCMP_
extern int _kernel_memcmp(const void *d, const void *s, SIZE n);

extern UW _kernel_vector_atr[];
extern ER _kernel_change_level(UW level);
extern UW vget_ctx(void);

#endif /* ITRON_H_ */
