/***********************************************************************
    Kernel configuration

 ***********************************************************************/

#include "kernel.h"
#include "Cortex-M4.h"

extern void _ddr_init(void);

/*******************************
  Inner initialize function
 *******************************/
void _kernel_initial(void)
{
    (void)_kernel_change_level(0U);
    _ddr_init();
}

/*******************************
  Various management table
 *******************************/

UB const _kernel_atrtbl[] = {
0x00U, 0x10U, 0x10U, 0x10U, 0x10U, 0x10U, 0x10U, 0x10U, 0x42U, 0x42U, 
0x42U, 0x50U, 0x50U, 0x50U, 0x50U, 0x90U, 0xa0U, };

extern void TaskNfc(VP_INT exinf);
long long _kernel_task1_stk[0x400UL/sizeof(long long)];
T_CTSK const _kernel_task1 = {0,
            (FP)TaskNfc, 0x400UL, (VP)_kernel_task1_stk, 0, 1};

extern void TaskLog(VP_INT exinf);
long long _kernel_task2_stk[0x400UL/sizeof(long long)];
T_CTSK const _kernel_task2 = {0,
            (FP)TaskLog, 0x400UL, (VP)_kernel_task2_stk, 0, 2};

extern void TaskLed(VP_INT exinf);
long long _kernel_task3_stk[0x400UL/sizeof(long long)];
T_CTSK const _kernel_task3 = {0,
            (FP)TaskLed, 0x400UL, (VP)_kernel_task3_stk, 0, 3};

T_CSEM const _kernel_sem1 = {0U, 1U};

T_CSEM const _kernel_sem2 = {0U, 1U};

T_CSEM const _kernel_sem3 = {0U, 1U};

T_CSEM const _kernel_sem4 = {0U, 1U};

long long _kernel_mpf1_buf[(16U*64U)/sizeof(long long)];
T_CMPF const _kernel_mpf1 = {16U, 64U, (VP)_kernel_mpf1_buf};

void const * const _kernel_inftbl[] = {
(void const *)&_kernel_task1,
(void const *)&_kernel_task2,
(void const *)&_kernel_task3,
(void const *)&_kernel_sem1,
(void const *)&_kernel_sem2,
(void const *)&_kernel_sem3,
(void const *)&_kernel_sem4,
0,
(void const *)&_kernel_mpf1,
};

T_TCB _kernel_tcb[3];
UB _kernel_sem[4];
T_MBX _kernel_mbx[1];
T_MPF _kernel_mpf[1];
T_WTID _kernel_waique[17];

__root const UB _kernel_nm_right = 1U;
VB const * const _kernel_objname[] = {
(VB const *)0,
(VB const *)0,
(VB const *)0,
(VB const *)0,
(VB const *)0,
(VB const *)0,
(VB const *)0,
(VB const *)0,
"ID_TASK_NFC",
"ID_TASK_LOG",
"ID_TASK_LED",
"ID_USART2_TSEM",
"ID_USART2_RSEM",
"ID_USART1_TSEM",
"ID_USART1_RSEM",
"ID_MBX_LOG",
"ID_MPF_LOG",
};

VP const _kernel_ctrtbl[] = {
(VP)&_kernel_tcb[0],
(VP)&_kernel_tcb[1],
(VP)&_kernel_tcb[2],
(VP)&_kernel_sem[0],
(VP)&_kernel_sem[1],
(VP)&_kernel_sem[2],
(VP)&_kernel_sem[3],
(VP)&_kernel_mbx[0],
(VP)&_kernel_mpf[0],
};

T_CNSTBL const _kernel_cnstbl = {
_kernel_atrtbl,
_kernel_inftbl-8,
0,
0,
_kernel_waique,
_kernel_ctrtbl-8,
_kernel_objname,
TKERNEL_PRID,
TKERNEL_PRVER,
1,
7,
16
};

/* end */
