/***********************************************************************
    Serial driver configuration
 ***********************************************************************/

#ifndef DDR_STM32L4_USART0_CFG_H_
#define DDR_STM32L4_USART0_CFG_H_

#include "kernel_id.h"
#include "STM32L4xx_UC3.h"

#ifdef __cplusplus
extern "C" {
#endif

/* UART settings */

#define PCLK1       80000000UL
#define PCLK2       80000000UL
#define SYSCLK      80000000UL
#define HSI16       16000000UL

#define USART_1
#define USART1SEL   0U
#define USART1_CLK  (PCLK2)
#define TXBUF_SZ1   256
#define RXBUF_SZ1   256
#define XOFF_SZ1    192
#define XON_SZ1     64
#define TXSEM1      (ID_USART1_TSEM)
#define RXSEM1      (ID_USART1_RSEM)
#define PROPRITY1   240U
#define FIFO_EN1    0
#define FIFO_TXFT1  -1
#define FIFO_RXFT1  -1
#define CTSRTS_1    0
#define CTSPORT1    (*(volatile UW *)0)
#define CTSBIT1     0

#define USART_2
#define USART2SEL   0U
#define USART2_CLK  (PCLK1)
#define TXBUF_SZ2   256
#define RXBUF_SZ2   256
#define XOFF_SZ2    192
#define XON_SZ2     64
#define TXSEM2      (ID_USART2_TSEM)
#define RXSEM2      (ID_USART2_RSEM)
#define PROPRITY2   240U
#define FIFO_EN2    0
#define FIFO_TXFT2  -1
#define FIFO_RXFT2  -1
#define CTSRTS_2    0
#define CTSPORT2    (*(volatile UW *)0)
#define CTSBIT2     0


#ifdef __cplusplus
}
#endif
#endif /* DDR_STM32L4_USART0_CFG_H_ */

/* end */
